/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.FCallNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.types.INameNode;
import org.jruby.util.ByteList;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.IndexDocument;
import org.netbeans.modules.gsf.api.IndexDocumentFactory;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.NbUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyIndexerHelper;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.StructureAnalyzer;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.ClassElement;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.ModuleElement;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyIndexer
implements Indexer {
    private static final boolean INDEX_UNDOCUMENTED = true;
    public static final boolean PREINDEXING = Boolean.getBoolean("gsf.preindexing");
    static final String FIELD_EXTENDS_NAME = "extends";
    static final String FIELD_FQN_NAME = "fqn";
    static final String FIELD_IN = "in";
    static final String FIELD_CLASS_NAME = "class";
    static final String FIELD_CASE_INSENSITIVE_CLASS_NAME = "class-ig";
    static final String FIELD_REQUIRE = "require";
    static final String FIELD_REQUIRES = "requires";
    static final String FIELD_INCLUDES = "includes";
    static final String FIELD_EXTEND_WITH = "extendWith";
    private static final String[] FIXED_COLUMN_TYPES = new String[]{"binary", "boolean", "date", "datetime", "decimal", "float", "integer", "string", "text", "time", "timestamp"};
    static final String FIELD_METHOD_NAME = "method";
    static final String FIELD_FIELD_NAME = "field";
    static final String FIELD_ATTRIBUTE_NAME = "attribute";
    static final String FIELD_CONSTANT_NAME = "constant";
    static final String FIELD_CLASS_ATTRS = "attrs";
    static final String FIELD_DB_TABLE = "dbtable";
    static final String FIELD_DB_VERSION = "dbversion";
    static final String FIELD_DB_COLUMN = "dbcolumn";
    static final String SCHEMA_INDEX_VERSION = "schema";
    private static FileObject preindexedDb;

    public String getIndexVersion() {
        return "6.103";
    }

    public String getIndexerName() {
        return "ruby";
    }

    public String getPersistentUrl(File file) {
        try {
            String string = file.toURI().toURL().toExternalForm();
            return RubyIndex.getPreindexUrl(string);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return file.getPath();
        }
    }

    public List<IndexDocument> index(ParserResult parserResult, IndexDocumentFactory indexDocumentFactory) throws IOException {
        Node node = AstUtilities.getRoot(parserResult);
        RubyParseResult rubyParseResult = (RubyParseResult)parserResult;
        if (node == null) {
            return null;
        }
        TreeAnalyzer treeAnalyzer = new TreeAnalyzer(rubyParseResult, indexDocumentFactory);
        treeAnalyzer.analyze();
        return treeAnalyzer.getDocuments();
    }

    public boolean isIndexable(ParserFile parserFile) {
        return parserFile.getNameExt().endsWith(".rb");
    }

    public boolean acceptQueryPath(String string) {
        return string.indexOf("jsstubs") == -1;
    }

    private static int getModifiersFlag(Set<Modifier> set) {
        int n;
        int n2 = n = set.contains(Modifier.STATIC) ? 16 : 0;
        if (set.contains(Modifier.PRIVATE)) {
            n |= 4;
        } else if (set.contains(Modifier.PROTECTED)) {
            n |= 2;
        }
        return n;
    }

    public static void setPreindexedDb(FileObject fileObject) {
        preindexedDb = fileObject;
    }

    public FileObject getPreindexedDb() {
        if (preindexedDb == null) {
            File file = InstalledFileLocator.getDefault().locate("preindexed", "org.netbeans.modules.ruby", false);
            if (file == null || !file.isDirectory()) {
                throw new RuntimeException("Can't locate preindexed directory. Installation might be damaged");
            }
            preindexedDb = FileUtil.toFileObject((File)file);
        }
        return preindexedDb;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeAnalyzer {
        private final ParserFile file;
        private String url;
        private String requires;
        private final RubyParseResult result;
        private BaseDocument doc;
        private int docMode;
        private IndexDocumentFactory factory;
        private List<IndexDocument> documents = new ArrayList<IndexDocument>();

        private TreeAnalyzer(RubyParseResult rubyParseResult, IndexDocumentFactory indexDocumentFactory) {
            this.result = rubyParseResult;
            this.file = rubyParseResult.getFile();
            this.factory = indexDocumentFactory;
        }

        private String getRequireString(Set<String> set) {
            if (set != null && set.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder(20 * set.size());
                for (String string : set) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(string);
                }
                return stringBuilder.toString();
            }
            return null;
        }

        private String getIncludedString(Set<String> set) {
            if (set != null && set.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder(20 * set.size());
                for (String string : set) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(string);
                }
                return stringBuilder.toString();
            }
            return null;
        }

        List<IndexDocument> getDocuments() {
            return this.documents;
        }

        public void analyze() throws IOException {
            FileObject fileObject = this.file.getFileObject();
            if (fileObject != null) {
                if (fileObject.getSize() > 0x100000L) {
                    return;
                }
                this.doc = NbUtilities.getBaseDocument(fileObject, true);
            } else {
                this.doc = null;
            }
            try {
                this.url = this.file.getFileObject().getURL().toExternalForm();
                this.url = RubyIndex.getPreindexUrl(this.url);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            String string = this.file.getNameExt();
            if (Character.isDigit(string.charAt(0)) && (string.matches("^\\d\\d\\d_.*") || string.matches("^\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d_.*"))) {
                if (fileObject != null && fileObject.getParent() != null && fileObject.getParent().getName().equals("migrate")) {
                    this.handleMigration();
                }
            } else if ("schema.rb".equals(string) && fileObject != null && fileObject.getParent() != null && fileObject.getParent().getName().equals("db")) {
                this.handleMigration();
            }
            StructureAnalyzer.AnalysisResult analysisResult = this.result.getStructure();
            this.requires = this.getRequireString(analysisResult.getRequires());
            List<? extends AstElement> list = analysisResult.getElements();
            if (string.startsWith("acti")) {
                if ("action_controller.rb".equals(string)) {
                    this.handleRailsBase("ActionController");
                    return;
                }
                if ("active_record.rb".equals(string)) {
                    this.handleRailsBase("ActiveRecord");
                    this.handleMigrations();
                    return;
                }
                if ("action_mailer.rb".equals(string)) {
                    this.handleRailsBase("ActionMailer");
                    return;
                }
                if ("action_view.rb".equals(string)) {
                    this.handleRailsBase("ActionView");
                    this.handleActionViewHelpers();
                    return;
                }
            } else {
                if (string.equals("assertions.rb") && this.url.endsWith("lib/action_controller/assertions.rb")) {
                    this.handleRailsClass("Test::Unit", "Test::Unit::TestCase", "TestCase", "TestCase");
                    return;
                }
                if (string.equals("schema_definitions.rb")) {
                    this.handleSchemaDefinitions();
                }
            }
            if (list == null || list.size() == 0) {
                if (this.requires != null) {
                    IndexDocument indexDocument = this.factory.createDocument(3);
                    this.documents.add(indexDocument);
                    if (this.requires != null) {
                        indexDocument.addPair(RubyIndexer.FIELD_REQUIRES, this.requires, false);
                    }
                    this.addRequire(indexDocument);
                }
                return;
            }
            this.analyze(list);
        }

        private void handleSchemaDefinitions() {
            if (this.url.indexOf("activerecord-2") == -1) {
                return;
            }
            Node node = AstUtilities.getRoot(this.result);
            if (node == null) {
                return;
            }
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            this.scan(node, hashSet, hashSet2);
            IndexDocument indexDocument = this.factory.createDocument(40);
            this.documents.add(indexDocument);
            String string = this.getRequireString(hashSet2);
            if (string != null) {
                indexDocument.addPair(RubyIndexer.FIELD_REQUIRES, string, false);
            }
            this.addRequire(indexDocument);
            String string2 = this.getIncludedString(hashSet);
            if (string2 != null) {
                indexDocument.addPair(RubyIndexer.FIELD_INCLUDES, string2, false);
            }
            int n = 0;
            indexDocument.addPair(RubyIndexer.FIELD_CLASS_ATTRS, IndexedElement.flagToString(n), false);
            String string3 = "TableDefinition";
            String string4 = "ActiveRecord::ConnectionAdapters";
            String string5 = string4 + "::" + string3;
            String string6 = string3.toLowerCase();
            indexDocument.addPair(RubyIndexer.FIELD_FQN_NAME, string5, true);
            indexDocument.addPair(RubyIndexer.FIELD_CASE_INSENSITIVE_CLASS_NAME, string6, true);
            indexDocument.addPair(RubyIndexer.FIELD_CLASS_NAME, string3, true);
            indexDocument.addPair(RubyIndexer.FIELD_IN, string4, false);
            for (String string7 : new String[]{"string", "text", "integer", "float", "decimal", "datetime", "timestamp", "time", "date", "binary", "boolean"}) {
                EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PUBLIC);
                int n2 = RubyIndexer.getModifiersFlag(enumSet);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string7);
                stringBuilder.append("(names,options);");
                stringBuilder.append(IndexedElement.flagToFirstChar(n2));
                stringBuilder.append(IndexedElement.flagToSecondChar(n2));
                stringBuilder.append(";;;options(=>limit|default:nil|null:bool|precision|scale)");
                String string8 = stringBuilder.toString();
                indexDocument.addPair(RubyIndexer.FIELD_METHOD_NAME, string8, true);
            }
        }

        private void handleRailsBase(String string) {
            this.handleRailsClass(string, string + "::Base", "Base", "base");
        }

        private void handleRailsClass(String string, String string2, String string3, String string4) {
            Node node = AstUtilities.getRoot(this.result);
            if (node == null) {
                return;
            }
            IndexDocument indexDocument = this.factory.createDocument(40);
            this.documents.add(indexDocument);
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            this.scan(node, hashSet, hashSet2);
            String string5 = this.getRequireString(hashSet2);
            if (string5 != null) {
                indexDocument.addPair(RubyIndexer.FIELD_REQUIRES, string5, false);
            }
            this.addRequire(indexDocument);
            String string6 = this.getIncludedString(hashSet);
            if (string6 != null) {
                indexDocument.addPair(RubyIndexer.FIELD_INCLUDES, string6, false);
            }
            int n = 0;
            indexDocument.addPair(RubyIndexer.FIELD_CLASS_ATTRS, IndexedElement.flagToString(n), false);
            indexDocument.addPair(RubyIndexer.FIELD_FQN_NAME, string2, true);
            indexDocument.addPair(RubyIndexer.FIELD_CASE_INSENSITIVE_CLASS_NAME, string4, true);
            indexDocument.addPair(RubyIndexer.FIELD_CLASS_NAME, string3, true);
            indexDocument.addPair(RubyIndexer.FIELD_IN, string, false);
        }

        private void addClassIncludes(String string, String string2, String string3, int n, String string4) {
            IndexDocument indexDocument = this.factory.createDocument(10);
            this.documents.add(indexDocument);
            if (string4 != null) {
                indexDocument.addPair(RubyIndexer.FIELD_INCLUDES, string4, false);
            }
            indexDocument.addPair(RubyIndexer.FIELD_CLASS_ATTRS, IndexedElement.flagToString(n), false);
            indexDocument.addPair(RubyIndexer.FIELD_FQN_NAME, string2, true);
            indexDocument.addPair(RubyIndexer.FIELD_CASE_INSENSITIVE_CLASS_NAME, string.toLowerCase(), true);
            indexDocument.addPair(RubyIndexer.FIELD_CLASS_NAME, string, true);
            if (string3 != null) {
                indexDocument.addPair(RubyIndexer.FIELD_IN, string3, false);
            }
        }

        private void handleMigrations() {
            int n = 0;
            this.addClassIncludes("Migration", "ActiveRecord::Migration", "ActiveRecord", n, "ActiveRecord::ConnectionAdapters::SchemaStatements");
        }

        private void handleMigration() {
            Object object;
            String string;
            Node node = AstUtilities.getRoot(this.result);
            if (node == null) {
                return;
            }
            String string2 = this.file.getFileObject().getName();
            Node object2 = null;
            if (RubyIndexer.SCHEMA_INDEX_VERSION.equals(string2)) {
                object2 = node;
                string = RubyIndexer.SCHEMA_INDEX_VERSION;
            } else {
                if (string2.charAt(3) == '_') {
                    string = string2.substring(0, 3);
                    object = RubyUtils.underlinedNameToCamel(string2.substring(4));
                } else {
                    string = string2.substring(0, 14);
                    object = RubyUtils.underlinedNameToCamel(string2.substring(15));
                }
                String string3 = (String)object + "#up";
                Node entry = AstUtilities.findBySignature(node, string3);
                if (entry == null) {
                    return;
                }
                object2 = entry;
            }
            object = new HashMap<String, List<String>>();
            this.scanMigration(object2, (Map<String, List<String>>)object, null);
            if (object.size() > 0) {
                for (Map.Entry entry : object.entrySet()) {
                    IndexDocument indexDocument = this.factory.createDocument(40);
                    this.documents.add(indexDocument);
                    String string3 = (String)entry.getKey();
                    indexDocument.addPair(RubyIndexer.FIELD_DB_TABLE, string3, true);
                    indexDocument.addPair(RubyIndexer.FIELD_DB_VERSION, string, false);
                    List list = (List)entry.getValue();
                    for (String string4 : list) {
                        indexDocument.addPair(RubyIndexer.FIELD_DB_COLUMN, string4, false);
                    }
                }
            }
        }

        private void scanMigration(Node node, Map<String, List<String>> map, String string) {
            List<String> list;
            Node node2;
            Object object;
            if (node.nodeId == NodeType.FCALLNODE) {
                object = AstUtilities.getCallName(node);
                if ("create_table".equals(object)) {
                    List list2 = node.childNodes();
                    if (list2.size() > 0) {
                        node2 = (Node)list2.get(0);
                        if (node2.nodeId == NodeType.ARRAYNODE && (list = node2.childNodes()).size() > 0) {
                            Node node3 = (Node)list.get(0);
                            if (node3.nodeId == NodeType.SYMBOLNODE || node3.nodeId == NodeType.STRNODE) {
                                String string2 = this.getString(node3);
                                map.put(string2, new ArrayList());
                                if (list2.size() > 1) {
                                    Node node4 = (Node)list2.get(1);
                                    if (node4.nodeId == NodeType.ITERNODE) {
                                        this.scanMigration(node4, map, string2);
                                    }
                                }
                                return;
                            }
                        }
                    }
                } else {
                    if ("add_column".equals(object) || "remove_column".equals(object)) {
                        ArrayList<Node> arrayList = new ArrayList<Node>();
                        AstUtilities.addNodesByType(node, new NodeType[]{NodeType.SYMBOLNODE, NodeType.STRNODE}, arrayList);
                        if (arrayList.size() >= 2) {
                            List<String> list3;
                            String string3 = this.getString((Node)arrayList.get(0));
                            String string4 = this.getString((Node)arrayList.get(1));
                            String string5 = null;
                            boolean bl = "add_column".equals(object);
                            if (bl && arrayList.size() >= 3) {
                                string5 = this.getString((Node)arrayList.get(2));
                            }
                            if ((list3 = map.get(string3)) == null) {
                                list3 = new ArrayList<String>();
                                map.put(string3, list3);
                            }
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(string4);
                            stringBuilder.append(';');
                            if (bl) {
                                if (string5 != null) {
                                    stringBuilder.append(string5);
                                }
                            } else {
                                stringBuilder.append("-");
                            }
                            list3.add(stringBuilder.toString());
                        }
                        return;
                    }
                    if ("rename_column".equals(object)) {
                        ArrayList<Node> arrayList = new ArrayList<Node>();
                        AstUtilities.addNodesByType(node, new NodeType[]{NodeType.SYMBOLNODE, NodeType.STRNODE}, arrayList);
                        if (arrayList.size() >= 3) {
                            String string6 = this.getString((Node)arrayList.get(0));
                            String string7 = this.getString((Node)arrayList.get(1));
                            String string8 = this.getString((Node)arrayList.get(2));
                            List<String> list4 = map.get(string6);
                            if (list4 == null) {
                                list4 = new ArrayList<String>();
                                map.put(string6, list4);
                            }
                            list4.add(string7 + ";-");
                            list4.add(string8);
                        }
                        return;
                    }
                }
            } else if (node.nodeId == NodeType.CALLNODE && string != null) {
                object = AstUtilities.getCallName(node);
                if ("column".equals(object)) {
                    List list5 = node.childNodes();
                    if (list5.size() >= 2) {
                        Node node5 = (Node)list5.get(0);
                        if (node5.nodeId != NodeType.DVARNODE) {
                            return;
                        }
                        node5 = (Node)list5.get(1);
                        ArrayList<Node> arrayList = new ArrayList<Node>();
                        AstUtilities.addNodesByType(node5, new NodeType[]{NodeType.SYMBOLNODE, NodeType.STRNODE}, arrayList);
                        if (arrayList.size() >= 2) {
                            String string9 = this.getString((Node)arrayList.get(0));
                            String string10 = this.getString((Node)arrayList.get(1));
                            List<String> list6 = map.get(string);
                            if (list6 == null) {
                                list6 = new ArrayList<String>();
                                map.put(string, list6);
                            }
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(string9);
                            stringBuilder.append(';');
                            stringBuilder.append(string10);
                            list6.add(stringBuilder.toString());
                        }
                    }
                    return;
                }
                if ("timestamps".equals(object)) {
                    List list7 = node.childNodes();
                    if (list7.size() >= 1) {
                        node2 = (Node)list7.get(0);
                        if (node2.nodeId != NodeType.DVARNODE) {
                            return;
                        }
                        list = map.get(string);
                        if (list == null) {
                            list = new ArrayList<String>();
                            map.put(string, list);
                        }
                        list.add("created_at;datetime");
                        list.add("updated_at;datetime");
                    }
                } else {
                    int n = Arrays.binarySearch(FIXED_COLUMN_TYPES, object);
                    if (n >= 0 && n < FIXED_COLUMN_TYPES.length) {
                        String string11 = FIXED_COLUMN_TYPES[n];
                        List list8 = node.childNodes();
                        if (list8.size() >= 2) {
                            Node node6 = (Node)list8.get(0);
                            if (node6.nodeId != NodeType.DVARNODE) {
                                return;
                            }
                            node6 = (Node)list8.get(1);
                            List list9 = node6.childNodes();
                            for (Node node7 : list9) {
                                if (node7.nodeId != NodeType.SYMBOLNODE && node7.nodeId != NodeType.STRNODE) continue;
                                String string12 = this.getString(node7);
                                List<String> list10 = map.get(string);
                                if (list10 == null) {
                                    list10 = new ArrayList<String>();
                                    map.put(string, list10);
                                }
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append(string12);
                                stringBuilder.append(';');
                                stringBuilder.append(string11);
                                list10.add(stringBuilder.toString());
                            }
                        }
                        return;
                    }
                }
            }
            object = node.childNodes();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                node2 = (Node)iterator.next();
                this.scanMigration(node2, map, string);
            }
        }

        private String getString(Node node) {
            if (node.nodeId == NodeType.STRNODE) {
                return ((StrNode)node).getValue().toString();
            }
            return ((INameNode)node).getName();
        }

        private void handleActionViewHelpers() {
            FileObject fileObject = this.file.getFileObject();
            if (fileObject == null || fileObject.getParent() == null) {
                return;
            }
            assert (fileObject.getName().equals("action_view"));
            FileObject fileObject2 = fileObject.getParent().getFileObject("action_view/helpers");
            if (fileObject2 == null) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (FileObject fileObject3 : fileObject2.getChildren()) {
                String string = fileObject3.getName();
                if (!string.endsWith("_helper")) continue;
                String string2 = RubyUtils.underlinedNameToCamel(string);
                String string3 = "ActionView::Helpers::" + string2;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string3);
            }
            if (stringBuilder.length() > 0) {
                int n = 0;
                this.addClassIncludes("Base", "ActionView::Base", "ActionView", n, stringBuilder.toString());
            }
        }

        private boolean scan(Node node, Set<String> set, Set<String> set2) {
            Node node2;
            Node node3;
            Object object;
            boolean bl = false;
            if (node instanceof FCallNode) {
                Node node4;
                object = ((INameNode)node).getName();
                if (((String)object).equals(RubyIndexer.FIELD_REQUIRE)) {
                    ByteList byteList;
                    node3 = ((FCallNode)node).getArgsNode();
                    if (node3 instanceof ListNode && (node2 = (ListNode)node3).size() > 0 && (node4 = node2.get(0)) instanceof StrNode && (byteList = ((StrNode)node4).getValue()) != null && byteList.length() > 0) {
                        set2.add(byteList.toString());
                    }
                } else if (set != null && ((String)object).equals("include") && (node3 = ((FCallNode)node).getArgsNode()) instanceof ListNode && (node2 = (ListNode)node3).size() > 0) {
                    node4 = node2.get(0);
                    if (node4 instanceof Colon2Node) {
                        set.add(AstUtilities.getFqn((Colon2Node)node4));
                    } else if (node4 instanceof INameNode) {
                        set.add(((INameNode)node4).getName());
                    }
                }
            } else if (node instanceof CallNode && (object = (CallNode)node).getName().equals("class_eval")) {
                bl = true;
            }
            object = node.childNodes();
            node3 = object.iterator();
            while (node3.hasNext()) {
                node2 = (Node)node3.next();
                if (!this.scan(node2, set, set2)) continue;
                bl = true;
            }
            return bl;
        }

        private void analyze(List<? extends AstElement> list) {
            ArrayList<AstElement> arrayList = null;
            Iterator<? extends AstElement> iterator = list.iterator();
            while (iterator.hasNext()) {
                AstElement astElement;
                AstElement astElement2 = astElement = iterator.next();
                switch (astElement2.getKind()) {
                    case MODULE: 
                    case CLASS: {
                        this.analyzeClassOrModule(astElement2);
                        break;
                    }
                    case METHOD: {
                        if (!this.shouldIndexTopLevel()) break;
                        if (arrayList == null) {
                            arrayList = new ArrayList<AstElement>();
                        }
                        arrayList.add(astElement2);
                        break;
                    }
                }
            }
            if (arrayList != null) {
                this.analyzeTopLevelMethods(arrayList);
            }
        }

        private boolean shouldIndexTopLevel() {
            String string;
            return !this.file.isPlatform() && !PREINDEXING && !(string = this.file.getNameExt()).endsWith("_spec.rb") && !string.endsWith("_test.rb") && (this.url == null || this.url.indexOf("/vendor/") == -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void analyzeClassOrModule(AstElement astElement) {
            int n = this.docMode;
            try {
                String string;
                String string2;
                Object object;
                int n2 = 0;
                boolean bl = false;
                if (this.file.isPlatform() || PREINDEXING) {
                    int n3 = RubyIndexerHelper.isNodocClass(astElement, this.doc);
                    if (n3 == 2) {
                        this.docMode = 0;
                    } else if (n3 == 3) {
                        n2 |= 0x20;
                        bl = true;
                        this.docMode = 3;
                    } else if (n3 == 1 || this.docMode == 3) {
                        n2 |= 0x20;
                        bl = true;
                    }
                }
                IndexDocument indexDocument = this.factory.createDocument(40);
                Node node = astElement.getNode();
                if (astElement.getKind() == ElementKind.CLASS) {
                    object = (ClassElement)((Object)astElement);
                    string2 = object.getFqn();
                    if (node instanceof SClassNode) {
                        string = ((SClassNode)node).getReceiverNode();
                        if (string instanceof Colon2Node) {
                            string2 = AstUtilities.getFqn((Colon2Node)string);
                        } else {
                            if (!(string instanceof INameNode)) return;
                            string2 = ((INameNode)string).getName();
                        }
                    } else {
                        string = (ClassNode)node;
                        Node node2 = string.getSuperNode();
                        String string3 = null;
                        if (node2 != null) {
                            string3 = AstUtilities.getSuperclass((ClassNode)string);
                        }
                        if (string3 != null) {
                            indexDocument.addPair(RubyIndexer.FIELD_EXTENDS_NAME, string3, true);
                        }
                    }
                    string = this.getIncludedString(object.getIncludes());
                    if (string != null) {
                        indexDocument.addPair(RubyIndexer.FIELD_INCLUDES, string, false);
                    }
                } else {
                    assert (astElement.getKind() == ElementKind.MODULE);
                    object = (ModuleElement)((Object)astElement);
                    string2 = object.getFqn();
                    string = object.getExtendWith();
                    if (string != null) {
                        indexDocument.addPair(RubyIndexer.FIELD_EXTEND_WITH, string, false);
                    }
                    n2 |= 0x40;
                }
                object = astElement.getName();
                int n4 = string2.lastIndexOf("::");
                string = n4 != -1 ? string2.substring(0, n4) : null;
                boolean bl2 = this.isDocumented(node);
                int n5 = this.getDocumentSize(node);
                if (n5 > 0) {
                    n2 |= 1;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(IndexedElement.flagToFirstChar(n2));
                stringBuilder.append(IndexedElement.flagToSecondChar(n2));
                if (n5 > 0) {
                    stringBuilder.append(";");
                    stringBuilder.append(Integer.toString(n5));
                }
                indexDocument.addPair(RubyIndexer.FIELD_CLASS_ATTRS, stringBuilder.toString(), false);
                if (!this.file.isPlatform() || astElement.getKind() == ElementKind.CLASS) {
                    // empty if block
                }
                indexDocument.addPair(RubyIndexer.FIELD_FQN_NAME, string2, true);
                indexDocument.addPair(RubyIndexer.FIELD_CASE_INSENSITIVE_CLASS_NAME, ((String)object).toLowerCase(), true);
                indexDocument.addPair(RubyIndexer.FIELD_CLASS_NAME, (String)object, true);
                if (string != null) {
                    indexDocument.addPair(RubyIndexer.FIELD_IN, string, false);
                }
                this.addRequire(indexDocument);
                if (this.requires != null) {
                    indexDocument.addPair(RubyIndexer.FIELD_REQUIRES, this.requires, false);
                }
                block18: for (AstElement astElement2 : astElement.getChildren()) {
                    switch (astElement2.getKind()) {
                        case MODULE: 
                        case CLASS: {
                            if (astElement2.getNode() instanceof SClassNode && ((SClassNode)astElement2.getNode()).getReceiverNode() instanceof SelfNode) {
                                for (AstElement astElement3 : astElement2.getChildren()) {
                                    switch (astElement3.getKind()) {
                                        case METHOD: 
                                        case CONSTRUCTOR: {
                                            this.indexMethod(astElement3, indexDocument, false, bl);
                                            break;
                                        }
                                        case MODULE: 
                                        case CLASS: {
                                            this.analyzeClassOrModule(astElement3);
                                            break;
                                        }
                                        case FIELD: {
                                            this.indexField(astElement3, indexDocument, bl);
                                            break;
                                        }
                                        case ATTRIBUTE: {
                                            this.indexAttribute(astElement3, indexDocument, bl);
                                            break;
                                        }
                                        case CONSTANT: {
                                            this.indexConstant(astElement3, indexDocument, bl);
                                        }
                                    }
                                }
                                continue block18;
                            }
                            this.analyzeClassOrModule(astElement2);
                            break;
                        }
                        case METHOD: 
                        case CONSTRUCTOR: {
                            this.indexMethod(astElement2, indexDocument, false, bl);
                            break;
                        }
                        case FIELD: {
                            this.indexField(astElement2, indexDocument, bl);
                            break;
                        }
                        case ATTRIBUTE: {
                            this.indexAttribute(astElement2, indexDocument, bl);
                            break;
                        }
                        case CONSTANT: {
                            this.indexConstant(astElement2, indexDocument, bl);
                        }
                    }
                }
                this.documents.add(indexDocument);
                return;
            }
            finally {
                this.docMode = n;
            }
        }

        private void analyzeTopLevelMethods(List<? extends AstElement> list) {
            IndexDocument indexDocument = this.factory.createDocument(40);
            this.documents.add(indexDocument);
            String string = "Object";
            Object var4_4 = null;
            String string2 = "Object";
            int n = 0;
            indexDocument.addPair(RubyIndexer.FIELD_CLASS_ATTRS, IndexedElement.flagToString(n), false);
            indexDocument.addPair(RubyIndexer.FIELD_FQN_NAME, string2, true);
            indexDocument.addPair(RubyIndexer.FIELD_CASE_INSENSITIVE_CLASS_NAME, string.toLowerCase(), true);
            indexDocument.addPair(RubyIndexer.FIELD_CLASS_NAME, string, true);
            this.addRequire(indexDocument);
            if (this.requires != null) {
                indexDocument.addPair(RubyIndexer.FIELD_REQUIRES, this.requires, false);
            }
            for (AstElement astElement : list) {
                assert (astElement.getKind() == ElementKind.CONSTRUCTOR || astElement.getKind() == ElementKind.METHOD);
                this.indexMethod(astElement, indexDocument, true, false);
            }
        }

        private void indexMethod(AstElement astElement, IndexDocument indexDocument, boolean bl, boolean bl2) {
            StringBuilder stringBuilder;
            boolean bl3;
            MethodDefNode methodDefNode = (MethodDefNode)astElement.getNode();
            String string = AstUtilities.getDefSignature(methodDefNode);
            Set<Modifier> set = astElement.getModifiers();
            int n = RubyIndexer.getModifiersFlag(set);
            if (bl2) {
                n |= 0x20;
            }
            if (bl) {
                n |= 8;
            }
            if (bl3 = this.isDocumented((Node)methodDefNode)) {
                n |= 1;
            }
            if (n != 0) {
                stringBuilder = new StringBuilder(string);
                stringBuilder.append(';');
                stringBuilder.append(IndexedElement.flagToFirstChar(n));
                stringBuilder.append(IndexedElement.flagToSecondChar(n));
                string = stringBuilder.toString();
            }
            if ((this.file.isPlatform() || PREINDEXING) && (string = RubyIndexerHelper.getMethodSignature(astElement, (Node)(stringBuilder = AstUtilities.getRoot(this.result)), n, string, this.file.getFileObject(), this.doc)) == null) {
                return;
            }
            indexDocument.addPair(RubyIndexer.FIELD_METHOD_NAME, string, true);
            if (astElement.getName().equals("initialize")) {
                string = string.replaceFirst("initialize", "new");
                if ((n & 0x10) == 0) {
                    char c = IndexedElement.flagToFirstChar(n |= 0x10);
                    char c2 = IndexedElement.flagToSecondChar(n);
                    int n2 = string.indexOf(59);
                    string = n2 == -1 ? string + ";" + c + c2 : string.substring(0, n2 + 1) + c + c2 + string.substring(n2 + 3);
                }
                indexDocument.addPair(RubyIndexer.FIELD_METHOD_NAME, string, true);
            }
        }

        private void indexAttribute(AstElement astElement, IndexDocument indexDocument, boolean bl) {
            int n;
            String string = astElement.getName();
            boolean bl2 = this.isDocumented(astElement.getNode());
            int n2 = n = bl2 ? 1 : 0;
            if (bl) {
                n |= 0x20;
            }
            char c = IndexedElement.flagToFirstChar(n);
            char c2 = IndexedElement.flagToSecondChar(n);
            if (bl2) {
                string = string + ";" + c + c2;
            }
            indexDocument.addPair(RubyIndexer.FIELD_ATTRIBUTE_NAME, string, true);
        }

        private void indexConstant(AstElement astElement, IndexDocument indexDocument, boolean bl) {
            int n = 0;
            if (bl) {
                n |= 0x20;
            }
            indexDocument.addPair(RubyIndexer.FIELD_CONSTANT_NAME, astElement.getName(), true);
        }

        private void indexField(AstElement astElement, IndexDocument indexDocument, boolean bl) {
            String string = astElement.getName();
            int n = RubyIndexer.getModifiersFlag(astElement.getModifiers());
            if (bl) {
                n |= 0x20;
            }
            if (n != 0) {
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.append(';');
                stringBuilder.append(IndexedElement.flagToFirstChar(n));
                stringBuilder.append(IndexedElement.flagToSecondChar(n));
                string = stringBuilder.toString();
            }
            indexDocument.addPair(RubyIndexer.FIELD_FIELD_NAME, string, true);
        }

        private int getDocumentSize(Node node) {
            List<String> list;
            if (this.doc != null && (list = AstUtilities.gatherDocumentation(null, this.doc, node)) != null && list.size() > 0) {
                int n = 0;
                for (String string : list) {
                    n += string.length();
                }
                return n;
            }
            return 0;
        }

        private boolean isDocumented(Node node) {
            List<String> list;
            return this.doc != null && (list = AstUtilities.gatherDocumentation(null, this.doc, node)) != null && list.size() > 0;
        }

        private void addRequire(IndexDocument indexDocument) {
            String string;
            FileObject fileObject = this.file.getFileObject();
            String string2 = string = fileObject.getParent() != null && fileObject.getParent().getParent() != null ? fileObject.getParent().getParent().getNameExt() : "";
            if (string.equals("rubystubs") && fileObject.getName().startsWith("stub_")) {
                return;
            }
            String string3 = this.file.getRelativePath();
            if (string3 != null && string3.endsWith(".rb")) {
                string3 = string3.substring(0, string3.length() - 3);
                indexDocument.addPair(RubyIndexer.FIELD_REQUIRE, string3, true);
            }
        }
    }
}

