/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.InstantRenamer;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameHandler
implements InstantRenamer {
    public boolean isRenameAllowed(CompilationInfo compilationInfo, int n, String[] stringArray) {
        Node node;
        Node node2 = AstUtilities.getRoot(compilationInfo);
        if (node2 == null) {
            stringArray[0] = NbBundle.getMessage(RenameHandler.class, (String)"NoRenameWithErrors");
            return false;
        }
        int n2 = AstUtilities.getAstOffset(compilationInfo, n);
        if (n2 == -1) {
            return false;
        }
        AstPath astPath = new AstPath(node2, n2);
        Node node3 = astPath.leaf();
        if (node3.nodeId == NodeType.LOCALVARNODE || node3.nodeId == NodeType.LOCALASGNNODE || node3.nodeId == NodeType.DVARNODE || node3.nodeId == NodeType.DASGNNODE || node3.nodeId == NodeType.BLOCKARGNODE) {
            return true;
        }
        if (node3.nodeId == NodeType.ARGUMENTNODE && (node = astPath.leafParent()) != null && !(node instanceof MethodDefNode)) {
            return true;
        }
        switch (node3.nodeId) {
            case INSTASGNNODE: 
            case INSTVARNODE: 
            case CLASSVARDECLNODE: 
            case CLASSVARNODE: 
            case CLASSVARASGNNODE: 
            case GLOBALASGNNODE: 
            case GLOBALVARNODE: 
            case CONSTDECLNODE: 
            case CONSTNODE: 
            case DEFNNODE: 
            case DEFSNODE: 
            case FCALLNODE: 
            case CALLNODE: 
            case VCALLNODE: 
            case ARGUMENTNODE: 
            case COLON2NODE: 
            case COLON3NODE: 
            case ALIASNODE: 
            case SYMBOLNODE: {
                return true;
            }
        }
        return false;
    }

    public Set<OffsetRange> getRenameRegions(CompilationInfo compilationInfo, int n) {
        Node node = AstUtilities.getRoot(compilationInfo);
        if (node == null) {
            return Collections.emptySet();
        }
        HashSet<OffsetRange> hashSet = new HashSet<OffsetRange>();
        int n2 = AstUtilities.getAstOffset(compilationInfo, n);
        if (n2 == -1) {
            return Collections.emptySet();
        }
        AstPath astPath = new AstPath(node, n2);
        Node node2 = astPath.leaf();
        if (node2 instanceof LocalVarNode || node2 instanceof LocalAsgnNode) {
            String string = ((INameNode)node2).getName();
            MethodDefNode methodDefNode = AstUtilities.findMethod(astPath);
            if (methodDefNode == null) {
                methodDefNode = AstUtilities.findBlock(astPath);
            }
            if (methodDefNode == null) {
                methodDefNode = astPath.leafParent();
                if (methodDefNode.nodeId == NodeType.NEWLINENODE) {
                    methodDefNode = astPath.leafGrandParent();
                }
                if (methodDefNode == null) {
                    methodDefNode = node2;
                }
            }
            this.addLocals(compilationInfo, (Node)methodDefNode, string, hashSet);
        } else if (node2.nodeId == NodeType.DVARNODE || node2.nodeId == NodeType.DASGNNODE) {
            String string = ((INameNode)node2).getName();
            List<Node> list = AstUtilities.getApplicableBlocks(astPath, true);
            for (Node node3 : list) {
                this.addDynamicVars(compilationInfo, node3, string, hashSet);
            }
        } else if (node2.nodeId == NodeType.ARGUMENTNODE || node2.nodeId == NodeType.BLOCKARGNODE) {
            String string = ((INameNode)node2).getName();
            Node node4 = astPath.leafParent();
            if (node4 != null && !(node4 instanceof MethodDefNode)) {
                MethodDefNode methodDefNode = AstUtilities.findMethod(astPath);
                if (methodDefNode == null) {
                    methodDefNode = AstUtilities.findBlock(astPath);
                }
                if (methodDefNode == null) {
                    methodDefNode = astPath.leafParent();
                    if (methodDefNode.nodeId == NodeType.NEWLINENODE) {
                        methodDefNode = astPath.leafGrandParent();
                    }
                    if (methodDefNode == null) {
                        methodDefNode = node2;
                    }
                }
                this.addLocals(compilationInfo, (Node)methodDefNode, string, hashSet);
            }
        }
        return hashSet;
    }

    private void addLocals(CompilationInfo compilationInfo, Node node, String string, Set<OffsetRange> set) {
        Object object;
        Object object2;
        Object object3;
        if (node.nodeId == NodeType.LOCALVARNODE) {
            if (((INameNode)node).getName().equals(string)) {
                object3 = AstUtilities.getRange(node);
                if ((object3 = LexUtilities.getLexerOffsets(compilationInfo, (OffsetRange)object3)) != OffsetRange.NONE) {
                    set.add((OffsetRange)object3);
                }
            }
        } else if (node.nodeId == NodeType.LOCALASGNNODE) {
            if (((INameNode)node).getName().equals(string)) {
                object3 = AstUtilities.getRange(node);
                object3 = new OffsetRange(object3.getStart(), object3.getStart() + string.length());
                if ((object3 = LexUtilities.getLexerOffsets(compilationInfo, (OffsetRange)object3)) != OffsetRange.NONE) {
                    set.add((OffsetRange)object3);
                }
            }
        } else if (node.nodeId == NodeType.ARGSNODE) {
            Node node2;
            object3 = (ArgsNode)node;
            if (object3.getRequiredArgsCount() > 0) {
                object2 = object3.childNodes();
                object = object2.iterator();
                while (object.hasNext()) {
                    node2 = (Node)object.next();
                    if (!(node2 instanceof ListNode)) continue;
                    List list = node2.childNodes();
                    for (Node node3 : list) {
                        OffsetRange offsetRange;
                        if (node3.nodeId == NodeType.ARGUMENTNODE) {
                            if (!((ArgumentNode)node3).getName().equals(string)) continue;
                            offsetRange = AstUtilities.getRange(node3);
                            if ((offsetRange = LexUtilities.getLexerOffsets(compilationInfo, offsetRange)) == OffsetRange.NONE) continue;
                            set.add(offsetRange);
                            continue;
                        }
                        if (node3.nodeId != NodeType.LOCALASGNNODE || !((LocalAsgnNode)node3).getName().equals(string)) continue;
                        offsetRange = AstUtilities.getRange(node3);
                        if ((offsetRange = LexUtilities.getLexerOffsets(compilationInfo, offsetRange)) == OffsetRange.NONE) continue;
                        set.add(offsetRange);
                    }
                }
            }
            if (object3.getRestArgNode() != null && (object2 = object3.getRestArgNode()).getName().equals(string)) {
                object = object2.getPosition();
                node2 = new OffsetRange(object.getStartOffset() + 1, object.getEndOffset());
                if ((node2 = LexUtilities.getLexerOffsets(compilationInfo, (OffsetRange)node2)) != OffsetRange.NONE) {
                    set.add((OffsetRange)node2);
                }
            }
            if (object3.getBlockArgNode() != null && (object2 = object3.getBlockArgNode()).getName().equals(string)) {
                object = object2.getPosition();
                node2 = new OffsetRange(object.getStartOffset() + 1, object.getEndOffset());
                if ((node2 = LexUtilities.getLexerOffsets(compilationInfo, (OffsetRange)node2)) != OffsetRange.NONE) {
                    set.add((OffsetRange)node2);
                }
            }
        }
        object3 = node.childNodes();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (Node)object2.next();
            this.addLocals(compilationInfo, (Node)object, string, set);
        }
    }

    private void addDynamicVars(CompilationInfo compilationInfo, Node node, String string, Set<OffsetRange> set) {
        List list;
        switch (node.nodeId) {
            case DVARNODE: {
                if (!((INameNode)node).getName().equals(string)) break;
                list = AstUtilities.getRange(node);
                if ((list = LexUtilities.getLexerOffsets(compilationInfo, (OffsetRange)list)) == OffsetRange.NONE) break;
                set.add((OffsetRange)list);
                break;
            }
            case DASGNNODE: {
                if (!((INameNode)node).getName().equals(string)) break;
                list = AstUtilities.getRange(node);
                list = new OffsetRange(list.getStart(), list.getStart() + string.length());
                if ((list = LexUtilities.getLexerOffsets(compilationInfo, (OffsetRange)list)) == OffsetRange.NONE) break;
                set.add((OffsetRange)list);
            }
        }
        list = node.childNodes();
        block7: for (Node node2 : list) {
            switch (node2.nodeId) {
                case DEFNNODE: 
                case DEFSNODE: 
                case ITERNODE: 
                case CLASSNODE: 
                case SCLASSNODE: 
                case MODULENODE: {
                    continue block7;
                }
            }
            this.addDynamicVars(compilationInfo, node2, string, set);
        }
    }
}

