/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jruby.ast.AliasNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.StrNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.types.INameNode;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.TypeAnalyzer;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedField;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.lexer.Call;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyCommentTokenId;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarationFinder
implements org.netbeans.modules.gsf.api.DeclarationFinder {
    private static final boolean CHOOSE_ONE_DECLARATION = Boolean.getBoolean("ruby.choose_one_decl");
    private static int methodSelector = 0;
    private boolean ignoreAlias;

    public OffsetRange getReferenceSpan(Document document, int n) {
        Object object;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        BaseDocument baseDocument = (BaseDocument)document;
        if (RubyUtils.isRhtmlDocument((Document)baseDocument) && (object = this.findRailsTarget(baseDocument, (TokenHierarchy<Document>)tokenHierarchy, n)) != null) {
            return object.range;
        }
        object = LexUtilities.getRubyTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n);
        if (object == null) {
            return OffsetRange.NONE;
        }
        object.move(n);
        if (!object.moveNext() && !object.movePrevious()) {
            return OffsetRange.NONE;
        }
        boolean bl = n == object.offset();
        OffsetRange offsetRange = this.getReferenceSpan((TokenSequence<?>)object, (TokenHierarchy<Document>)tokenHierarchy, n);
        if (offsetRange == OffsetRange.NONE && bl && object.movePrevious()) {
            offsetRange = this.getReferenceSpan((TokenSequence<?>)object, (TokenHierarchy<Document>)tokenHierarchy, n);
        }
        return offsetRange;
    }

    private OffsetRange getReferenceSpan(TokenSequence<?> tokenSequence, TokenHierarchy<Document> tokenHierarchy, int n) {
        int n2;
        String string;
        Token token = tokenSequence.token();
        TokenId tokenId = token.id();
        if (tokenId == RubyTokenId.IDENTIFIER && token.length() == 1 && tokenId == RubyTokenId.IDENTIFIER && ((Object)token.text()).toString().equals(",")) {
            return OffsetRange.NONE;
        }
        if (tokenId == RubyTokenId.IDENTIFIER || tokenId == RubyTokenId.CLASS_VAR || tokenId == RubyTokenId.GLOBAL_VAR || tokenId == RubyTokenId.CONSTANT || tokenId == RubyTokenId.TYPE_SYMBOL || tokenId == RubyTokenId.INSTANCE_VAR) {
            return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
        }
        TokenSequence tokenSequence2 = tokenSequence.embedded();
        if (tokenSequence2 != null) {
            tokenSequence = tokenSequence2;
            tokenSequence2.move(n);
            if (tokenSequence2.moveNext()) {
                Token token2 = tokenSequence2.token();
                if (token2.id() == RubyCommentTokenId.COMMENT_LINK) {
                    return new OffsetRange(tokenSequence2.offset(), tokenSequence2.offset() + token2.length());
                }
                string = this.getReferenceSpan(tokenSequence2, tokenHierarchy, n);
                if (string != OffsetRange.NONE) {
                    return string;
                }
            }
        }
        if ((tokenId == RubyTokenId.QUOTED_STRING_LITERAL || tokenId == RubyTokenId.STRING_LITERAL) && (n2 = LexUtilities.getRequireStringOffset(n, tokenHierarchy)) != -1 && (string = LexUtilities.getStringAt(n, tokenHierarchy)) != null) {
            return new OffsetRange(n2, n2 + string.length());
        }
        return OffsetRange.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeclarationFinder.DeclarationLocation findDeclaration(CompilationInfo compilationInfo, int n) {
        try {
            int n2;
            OffsetRange offsetRange;
            Document document = compilationInfo.getDocument();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            BaseDocument baseDocument = (BaseDocument)document;
            int n3 = AstUtilities.getAstOffset(compilationInfo, n);
            if (n3 == -1) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            if (RubyUtils.isRhtmlFile(compilationInfo.getFileObject()) && (offsetRange = this.findRailsFile(compilationInfo, baseDocument, (TokenHierarchy<Document>)tokenHierarchy, n, n3)) != DeclarationFinder.DeclarationLocation.NONE) {
                return offsetRange;
            }
            offsetRange = this.getReferenceSpan((Document)baseDocument, n);
            if (offsetRange == OffsetRange.NONE) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            boolean bl = offsetRange.getEnd() <= n;
            Node node = AstUtilities.getRoot(compilationInfo);
            if (node == null) {
                DeclarationFinder.DeclarationLocation declarationLocation;
                String string = baseDocument.getText(offsetRange.getStart(), offsetRange.getLength());
                RubyIndex rubyIndex = RubyIndex.get(compilationInfo.getIndex("text/x-ruby"));
                if (rubyIndex == null) return DeclarationFinder.DeclarationLocation.NONE;
                if (string.length() == 0) {
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                if (Character.isUpperCase(string.charAt(0))) {
                    Set<IndexedClass> set = rubyIndex.getClasses(string, NameKind.EXACT_NAME, true, false, false);
                    if (set.size() == 0) {
                        return DeclarationFinder.DeclarationLocation.NONE;
                    }
                    DeclarationFinder.DeclarationLocation declarationLocation2 = this.getClassDeclaration(compilationInfo, set, null, null, rubyIndex);
                    if (declarationLocation2 == null) return DeclarationFinder.DeclarationLocation.NONE;
                    return declarationLocation2;
                }
                Set<IndexedMethod> set = rubyIndex.getMethods(string, null, NameKind.EXACT_NAME, RubyIndex.ALL_SCOPE);
                if (set.size() == 0) {
                    set = rubyIndex.getMethods(string, null, NameKind.EXACT_NAME);
                }
                if ((declarationLocation = this.getMethodDeclaration(compilationInfo, string, set, null, null, rubyIndex, n3, n)) == null) return DeclarationFinder.DeclarationLocation.NONE;
                return declarationLocation;
            }
            RubyIndex rubyIndex = RubyIndex.get(compilationInfo.getIndex("text/x-ruby"));
            int n4 = n;
            if (bl && n4 > 0) {
                --n4;
            }
            if ((n2 = LexUtilities.getRequireStringOffset(n4, (TokenHierarchy<Document>)tokenHierarchy)) != -1) {
                String string = LexUtilities.getStringAt(n4, (TokenHierarchy<Document>)tokenHierarchy);
                if (string == null) return DeclarationFinder.DeclarationLocation.NONE;
                String string2 = rubyIndex.getRequiredFileUrl(string);
                if (string2 == null) return DeclarationFinder.DeclarationLocation.NONE;
                FileObject fileObject = RubyIndex.getFileObject(string2);
                return new DeclarationFinder.DeclarationLocation(fileObject, 0);
            }
            AstPath astPath = new AstPath(node, n3);
            Node node2 = astPath.leaf();
            DeclarationFinder.DeclarationLocation declarationLocation = this.findRDocMethod(compilationInfo, (Document)baseDocument, n3, n, node, astPath, node2, rubyIndex);
            if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE) {
                return this.fix(declarationLocation, compilationInfo);
            }
            if (node2 instanceof LocalVarNode || node2 instanceof LocalAsgnNode) {
                String string = ((INameNode)node2).getName();
                Node node3 = AstUtilities.findLocalScope(node2, astPath);
                return this.fix(this.findLocal(compilationInfo, node3, string), compilationInfo);
            }
            if (node2 instanceof DVarNode) {
                String string = ((DVarNode)node2).getName();
                Node node4 = AstUtilities.findDynamicScope(node2, astPath);
                return this.fix(this.findDynamic(compilationInfo, node4, string), compilationInfo);
            }
            if (node2 instanceof DAsgnNode) {
                String string = ((INameNode)node2).getName();
                Node node5 = AstUtilities.findDynamicScope(node2, astPath);
                return this.fix(this.findDynamic(compilationInfo, node5, string), compilationInfo);
            }
            if (node2 instanceof InstVarNode) {
                String string = ((INameNode)node2).getName();
                return this.findInstanceFromIndex(compilationInfo, string, astPath, rubyIndex);
            }
            if (node2 instanceof ClassVarNode) {
                String string = ((INameNode)node2).getName();
                return this.findInstanceFromIndex(compilationInfo, string, astPath, rubyIndex);
            }
            if (node2 instanceof GlobalVarNode) {
                String string = ((GlobalVarNode)node2).getName();
                return this.fix(this.findGlobal(compilationInfo, node, string), compilationInfo);
            }
            if (node2 instanceof FCallNode || node2 instanceof VCallNode || node2 instanceof CallNode) {
                Object object;
                Object object2;
                String string = ((INameNode)node2).getName();
                Call call = Call.getCallType(baseDocument, (TokenHierarchy<Document>)tokenHierarchy, n);
                String string3 = call.getType();
                String string4 = call.getLhs();
                if (string3 == null && string4 != null && node2 != null && call.isSimpleIdentifier() && (object2 = AstUtilities.findLocalScope(node2, astPath)) != null) {
                    object = new TypeAnalyzer(rubyIndex, (Node)object2, node2, n3, n, baseDocument, compilationInfo.getFileObject());
                    string3 = ((TypeAnalyzer)object).getType(string4);
                }
                if (string3 == null) {
                    if (string.equals("new")) {
                        string = "initialize";
                    }
                    if ((object = this.fix(this.findMethod(compilationInfo, node, string, (Arity)(object2 = Arity.getCallArity(node2))), compilationInfo)) != DeclarationFinder.DeclarationLocation.NONE) {
                        return object;
                    }
                }
                object2 = AstUtilities.getFqnName(astPath);
                if (call != Call.LOCAL) return this.findMethod(string, (String)object2, string3, call, compilationInfo, n3, n, astPath, node2, rubyIndex);
                if (object2 == null) return this.findMethod(string, (String)object2, string3, call, compilationInfo, n3, n, astPath, node2, rubyIndex);
                if (((String)object2).length() != 0) return this.findMethod(string, (String)object2, string3, call, compilationInfo, n3, n, astPath, node2, rubyIndex);
                object2 = "Object";
                return this.findMethod(string, (String)object2, string3, call, compilationInfo, n3, n, astPath, node2, rubyIndex);
            }
            if (node2 instanceof ConstNode || node2 instanceof Colon2Node) {
                Object object;
                String string = ((INameNode)node2).getName();
                Node node6 = null;
                if (node6 != null) {
                    if (!(node2 instanceof Colon2Node)) return this.fix(this.getLocation(compilationInfo, node6), compilationInfo);
                    object = new AstPath(node, node6);
                    if (((AstPath)object).leaf() != null) {
                        String string5;
                        String string6 = AstUtilities.getFqn((Colon2Node)node2);
                        if (string6.equals(string5 = AstUtilities.getFqnName((AstPath)object))) {
                            return this.fix(this.getLocation(compilationInfo, node6), compilationInfo);
                        }
                    } else assert (false) : node6.toString();
                }
                if (node2 instanceof Colon2Node) {
                    string = AstUtilities.getFqn((Colon2Node)node2);
                }
                object = AstUtilities.getFqnName(astPath);
                return this.findClass(string, (String)object, compilationInfo, astPath, node2, rubyIndex);
            }
            if (node2 instanceof SymbolNode) {
                Arity arity;
                String string = ((SymbolNode)node2).getName();
                DeclarationFinder.DeclarationLocation declarationLocation3 = this.findMethod(compilationInfo, node, string, arity = Arity.UNKNOWN);
                if (declarationLocation3 == DeclarationFinder.DeclarationLocation.NONE) {
                    declarationLocation3 = this.findInstance(compilationInfo, node, string);
                }
                if (declarationLocation3 == DeclarationFinder.DeclarationLocation.NONE) {
                    declarationLocation3 = this.findClassVar(compilationInfo, node, string);
                }
                if (declarationLocation3 == DeclarationFinder.DeclarationLocation.NONE) {
                    declarationLocation3 = this.findGlobal(compilationInfo, node, string);
                }
                if (declarationLocation3 != DeclarationFinder.DeclarationLocation.NONE) return this.fix(declarationLocation3, compilationInfo);
                Node node7 = this.findClass(node, ((INameNode)node2).getName());
                if (node7 == null) return this.fix(declarationLocation3, compilationInfo);
                declarationLocation3 = this.getLocation(compilationInfo, node7);
                return this.fix(declarationLocation3, compilationInfo);
            }
            if (node2 instanceof AliasNode) {
                AliasNode aliasNode = (AliasNode)node2;
                String string = aliasNode.getNewName();
                int n5 = string.length();
                int n6 = aliasNode.getPosition().getStartOffset();
                if (n3 <= n6 + 6) return DeclarationFinder.DeclarationLocation.NONE;
                if (n3 <= n6 + 6 + n5) return new DeclarationFinder.DeclarationLocation(compilationInfo.getFileObject(), n6 + 4);
                String string7 = aliasNode.getOldName();
                this.ignoreAlias = true;
                try {
                    Node node8;
                    DeclarationFinder.DeclarationLocation declarationLocation4 = this.findLocal(compilationInfo, AstUtilities.findLocalScope(node2, astPath), string7);
                    if (declarationLocation4 == DeclarationFinder.DeclarationLocation.NONE) {
                        declarationLocation4 = this.findDynamic(compilationInfo, AstUtilities.findDynamicScope(node2, astPath), string7);
                    }
                    if (declarationLocation4 == DeclarationFinder.DeclarationLocation.NONE) {
                        declarationLocation4 = this.findMethod(compilationInfo, node, string7, Arity.UNKNOWN);
                    }
                    if (declarationLocation4 == DeclarationFinder.DeclarationLocation.NONE) {
                        declarationLocation4 = this.findInstance(compilationInfo, node, string7);
                    }
                    if (declarationLocation4 == DeclarationFinder.DeclarationLocation.NONE) {
                        declarationLocation4 = this.findClassVar(compilationInfo, node, string7);
                    }
                    if (declarationLocation4 == DeclarationFinder.DeclarationLocation.NONE) {
                        declarationLocation4 = this.findGlobal(compilationInfo, node, string7);
                    }
                    if (declarationLocation4 == DeclarationFinder.DeclarationLocation.NONE && (node8 = this.findClass(node, string7)) != null) {
                        declarationLocation4 = this.getLocation(compilationInfo, node8);
                    }
                    if (declarationLocation4 == DeclarationFinder.DeclarationLocation.NONE) {
                        node8 = declarationLocation4;
                        return node8;
                    }
                    node8 = this.fix(declarationLocation4, compilationInfo);
                    return node8;
                }
                finally {
                    this.ignoreAlias = false;
                }
            }
            if (!(node2 instanceof ArgumentNode)) return DeclarationFinder.DeclarationLocation.NONE;
            String string = ((ArgumentNode)node2).getName();
            Node node9 = astPath.leafParent();
            if (node9 == null) return DeclarationFinder.DeclarationLocation.NONE;
            if (node9 instanceof MethodDefNode) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            Node node10 = AstUtilities.findLocalScope(node2, astPath);
            return this.fix(this.findLocal(compilationInfo, node10, string), compilationInfo);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findRailsFile(CompilationInfo compilationInfo, BaseDocument baseDocument, TokenHierarchy<Document> tokenHierarchy, int n, int n2) {
        RailsTarget railsTarget = this.findRailsTarget(baseDocument, tokenHierarchy, n);
        if (railsTarget != null) {
            String string = railsTarget.type;
            if (string.indexOf("partial") != -1) {
                String string2;
                FileObject fileObject;
                String string3;
                String[] stringArray;
                int n3 = railsTarget.name.lastIndexOf(47);
                if (n3 != -1) {
                    for (stringArray = compilationInfo.getFileObject().getParent(); stringArray != null; stringArray = stringArray.getParent()) {
                        if (!stringArray.getName().equals("views") || stringArray.getParent() != null && !stringArray.getParent().getName().equals("app")) continue;
                        stringArray = stringArray.getParent();
                        break;
                    }
                    if (stringArray == null) {
                        return DeclarationFinder.DeclarationLocation.NONE;
                    }
                    string3 = railsTarget.name.substring(0, n3);
                    fileObject = stringArray.getFileObject("views/" + string3);
                    if (fileObject == null) {
                        return DeclarationFinder.DeclarationLocation.NONE;
                    }
                    string2 = "_" + railsTarget.name.substring(n3 + 1);
                } else {
                    fileObject = compilationInfo.getFileObject().getParent();
                    string2 = "_" + railsTarget.name;
                }
                stringArray = new String[]{".rhtml", ".erb", ".html.erb"};
                string3 = null;
                for (String string4 : stringArray) {
                    string3 = fileObject.getFileObject(string2 + string4);
                    if (string3 != null) break;
                }
                if (string3 == null) {
                    for (String string4 : fileObject.getChildren()) {
                        if (!string4.isValid() || string4.isFolder() || !string4.getName().equals(string2)) continue;
                        string3 = string4;
                        break;
                    }
                }
                if (string3 != null) {
                    return new DeclarationFinder.DeclarationLocation((FileObject)string3, 0);
                }
            } else if (string.indexOf("controller") != -1 || string.indexOf("action") != -1) {
                FileObject fileObject;
                FileObject fileObject2;
                FileObject fileObject3 = compilationInfo.getFileObject();
                fileObject3 = fileObject3.getParent();
                String string5 = null;
                String string6 = fileObject3.getName();
                boolean bl = string.indexOf("controller") != -1;
                String string7 = "";
                if (bl) {
                    string7 = railsTarget.name;
                } else if (!string6.startsWith("_")) {
                    string7 = string6;
                    string5 = compilationInfo.getFileObject().getName();
                }
                int n4 = railsTarget.range.getStart() - n;
                String[] stringArray = this.findControllerAction(compilationInfo, n + n4, n2 + n4);
                if (stringArray[0] != null) {
                    string7 = stringArray[0];
                }
                if (stringArray[1] != null) {
                    string5 = stringArray[1];
                }
                for (fileObject2 = fileObject3.getParent(); fileObject2 != null; fileObject2 = fileObject2.getParent()) {
                    if (fileObject2.getName().equals("views") && (fileObject2.getParent() == null || fileObject2.getParent().getName().equals("app"))) {
                        fileObject2 = fileObject2.getParent();
                        break;
                    }
                    string7 = fileObject2.getNameExt() + "/" + string7;
                }
                if (fileObject2 != null && (fileObject = fileObject2.getFileObject("controllers/" + string7 + "_controller.rb")) != null) {
                    int n3 = 0;
                    if (string5 != null && (n3 = AstUtilities.findOffset(fileObject, string5)) < 0) {
                        n3 = 0;
                    }
                    return new DeclarationFinder.DeclarationLocation(fileObject, n3);
                }
            }
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private String[] findControllerAction(CompilationInfo compilationInfo, int n, int n2) {
        String[] stringArray = new String[2];
        Node node = AstUtilities.getRoot(compilationInfo);
        AstPath astPath = new AstPath(node, n2);
        ListIterator<Node> listIterator = astPath.leafToRoot();
        Node node2 = null;
        while (listIterator.hasNext()) {
            Node node3 = (Node)listIterator.next();
            if (node3 instanceof HashNode && node2 instanceof ListNode) {
                List list = node2.childNodes();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Node node4;
                    String string = null;
                    String string2 = null;
                    Node node5 = (Node)iterator.next();
                    if (node5 instanceof SymbolNode) {
                        string = ((SymbolNode)node5).getName();
                    }
                    if (iterator.hasNext() && (node4 = (Node)iterator.next()) instanceof StrNode) {
                        string2 = ((StrNode)node4).getValue().toString();
                    }
                    if ("controller".equals(string)) {
                        stringArray[0] = string2;
                        continue;
                    }
                    if (!"action".equals(string)) continue;
                    stringArray[1] = string2;
                }
                break;
            }
            node2 = node3;
        }
        return stringArray;
    }

    private RailsTarget findRailsTarget(BaseDocument baseDocument, TokenHierarchy<Document> tokenHierarchy, int n) {
        try {
            int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            if (n2 != -1) {
                String[] stringArray;
                int n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                String string = baseDocument.getText(n2, n3 - n2);
                for (String string2 : stringArray = new String[]{":partial => ", ":controller => ", ":action => "}) {
                    String string3;
                    int n4 = string.indexOf(string2);
                    if (n4 == -1) continue;
                    int n5 = n2 + n4 + string2.length();
                    TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(tokenHierarchy, n5);
                    if (tokenSequence == null) {
                        return null;
                    }
                    tokenSequence.move(n5);
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl = false;
                    while (tokenSequence.moveNext() && tokenSequence.offset() < n3) {
                        bl = true;
                        Token token = tokenSequence.token();
                        string3 = token.id();
                        if (string3 == RubyTokenId.STRING_LITERAL || string3 == RubyTokenId.QUOTED_STRING_LITERAL) {
                            stringBuilder.append(((Object)token.text()).toString());
                        }
                        if ("string".equals(string3.primaryCategory())) continue;
                        break;
                    }
                    if (!bl) {
                        return null;
                    }
                    int n6 = tokenSequence.offset();
                    string3 = stringBuilder.toString();
                    if (n > n6 || n < n2 + n4) continue;
                    OffsetRange offsetRange = new OffsetRange(n2 + n4, n6);
                    return new RailsTarget(string2, string3, offsetRange);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return null;
    }

    private DeclarationFinder.DeclarationLocation findMethod(String string, String string2, String string3, Call call, CompilationInfo compilationInfo, int n, int n2, AstPath astPath, Node node, RubyIndex rubyIndex) {
        Set<IndexedMethod> set = this.getApplicableMethods(string, string2, string3, call, rubyIndex);
        int n3 = n;
        DeclarationFinder.DeclarationLocation declarationLocation = this.getMethodDeclaration(compilationInfo, string, set, astPath, node, rubyIndex, n3, n2);
        return declarationLocation;
    }

    private Set<IndexedMethod> getApplicableMethods(String string, String string2, String string3, Call call, RubyIndex rubyIndex) {
        int n;
        Set<IndexedMethod> set = new HashSet<IndexedMethod>();
        String string4 = string2;
        if (string3 == null && string2 != null && call.getLhs() == null && call != Call.UNKNOWN) {
            string4 = string2;
            while (set.size() == 0 && string4.length() > 0) {
                set = rubyIndex.getInheritedMethods(string4, string, NameKind.EXACT_NAME);
                n = string4.lastIndexOf("::");
                if (n == -1) break;
                string4 = string4.substring(0, n);
            }
        }
        if (string3 != null && set.size() == 0) {
            for (string4 = string2; set.size() == 0 && string4 != null && string4.length() > 0; string4 = string4.substring(0, n)) {
                set = rubyIndex.getInheritedMethods(string4 + "::" + string3, string, NameKind.EXACT_NAME);
                n = string4.lastIndexOf("::");
                if (n == -1) break;
            }
            if (set.size() == 0 && (set = rubyIndex.getInheritedMethods(string3, string, NameKind.EXACT_NAME)).size() == 0 && string3.indexOf("::") == -1) {
                Set<IndexedClass> set2 = rubyIndex.getClasses(string3, NameKind.EXACT_NAME, false, false, false);
                HashSet<String> hashSet = new HashSet<String>();
                for (IndexedClass object : set2) {
                    String string5 = object.getFqn();
                    if (string5 == null) continue;
                    hashSet.add(string5);
                }
                for (String string6 : hashSet) {
                    if (string6.equals(string3)) continue;
                    set.addAll(rubyIndex.getInheritedMethods(string6, string, NameKind.EXACT_NAME));
                }
            }
            if (set.size() == 0) {
                int n2;
                for (string4 = string2; set.size() == 0 && string4 != null && string4.length() > 0; string4 = string4.substring(0, n2)) {
                    set = rubyIndex.getMethods(string, string4 + "::" + string3, NameKind.EXACT_NAME);
                    n2 = string4.lastIndexOf("::");
                    if (n2 == -1) break;
                }
            }
        }
        if (set.size() == 0 && (set = rubyIndex.getMethods(string, string3, NameKind.EXACT_NAME)).size() == 0 && string3 != null) {
            set = rubyIndex.getMethods(string, null, NameKind.EXACT_NAME);
        }
        return set;
    }

    private DeclarationFinder.DeclarationLocation findClass(String string, String string2, CompilationInfo compilationInfo, AstPath astPath, Node node, RubyIndex rubyIndex) {
        int n;
        Set<IndexedClass> set = Collections.emptySet();
        String string3 = string2;
        HashSet<String> hashSet = new HashSet<String>();
        while (set.size() == 0 && string3.length() > 0) {
            set = rubyIndex.getClasses(string3 + "::" + string, NameKind.EXACT_NAME, true, false, false, RubyIndex.ALL_SCOPE, hashSet);
            n = string3.lastIndexOf("::");
            if (n == -1) break;
            string3 = string3.substring(0, n);
        }
        if (set.size() == 0) {
            set = rubyIndex.getClasses(string, NameKind.EXACT_NAME, true, false, false, RubyIndex.ALL_SCOPE, hashSet);
        }
        if (set.size() == 0) {
            string3 = string2;
            while (set.size() == 0 && string3.length() > 0) {
                set = rubyIndex.getClasses(string3 + "::" + string, NameKind.EXACT_NAME, true, false, false);
                n = string3.lastIndexOf("::");
                if (n == -1) break;
                string3 = string3.substring(0, n);
            }
            if (set.size() == 0) {
                set = rubyIndex.getClasses(string, NameKind.EXACT_NAME, true, false, false);
            }
        }
        return this.getClassDeclaration(compilationInfo, set, astPath, node, rubyIndex);
    }

    private DeclarationFinder.DeclarationLocation getClassDeclaration(CompilationInfo compilationInfo, Set<IndexedClass> set, AstPath astPath, Node node, RubyIndex rubyIndex) {
        try {
            IndexedClass indexedClass = this.findBestClassMatch(set, (BaseDocument)compilationInfo.getDocument(), astPath, node, rubyIndex);
            if (indexedClass != null) {
                IndexedClass indexedClass2 = indexedClass;
                Node node2 = AstUtilities.getForeignNode(indexedClass2, null);
                DeclarationFinder.DeclarationLocation declarationLocation = new DeclarationFinder.DeclarationLocation(indexedClass2.getFile().getFileObject(), node2.getPosition().getStartOffset(), (ElementHandle)indexedClass2);
                if (!CHOOSE_ONE_DECLARATION && set.size() > 1) {
                    int n = 0;
                    for (IndexedClass indexedClass3 : set) {
                        if (indexedClass3.isNoDoc()) continue;
                        ++n;
                    }
                    if (n >= 2) {
                        for (IndexedClass indexedClass3 : set) {
                            declarationLocation.addAlternative((DeclarationFinder.AlternativeLocation)new RubyAltLocation(indexedClass3, indexedClass3 == indexedClass));
                        }
                    }
                }
                return declarationLocation;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation getMethodDeclaration(CompilationInfo compilationInfo, String string, Set<IndexedMethod> set, AstPath astPath, Node node, RubyIndex rubyIndex, int n, int n2) {
        try {
            IndexedMethod indexedMethod = this.findBestMethodMatch(string, set, (BaseDocument)compilationInfo.getDocument(), n, n2, astPath, node, rubyIndex);
            if (indexedMethod != null) {
                FileObject fileObject = indexedMethod.getFile().getFileObject();
                if (fileObject == null) {
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                Node node2 = AstUtilities.getForeignNode(indexedMethod, null);
                int n3 = node2 != null ? node2.getPosition().getStartOffset() : 0;
                DeclarationFinder.DeclarationLocation declarationLocation = new DeclarationFinder.DeclarationLocation(fileObject, n3, (ElementHandle)indexedMethod);
                if (!CHOOSE_ONE_DECLARATION && set.size() > 1) {
                    int n4 = 0;
                    for (IndexedMethod indexedMethod2 : set) {
                        if (indexedMethod2.isNoDoc()) continue;
                        ++n4;
                    }
                    if (n4 >= 2) {
                        for (IndexedMethod indexedMethod2 : set) {
                            declarationLocation.addAlternative((DeclarationFinder.AlternativeLocation)new RubyAltLocation(indexedMethod2, indexedMethod2 == indexedMethod));
                        }
                    }
                }
                return declarationLocation;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public IndexedMethod findMethodDeclaration(CompilationInfo compilationInfo, Node node, AstPath astPath, Set<IndexedMethod>[] setArray) {
        int n = AstUtilities.getCallRange(node).getStart();
        try {
            Object object;
            Object object2;
            Document document = compilationInfo.getDocument();
            int n2 = LexUtilities.getLexerOffset(compilationInfo, n);
            if (n2 == -1) {
                return null;
            }
            OffsetRange offsetRange = this.getReferenceSpan(document, n2);
            if (offsetRange == OffsetRange.NONE) {
                return null;
            }
            boolean bl = offsetRange.getEnd() <= n;
            Node node2 = AstUtilities.getRoot(compilationInfo);
            if (node2 == null) {
                String string = document.getText(offsetRange.getStart(), offsetRange.getLength());
                RubyIndex rubyIndex = RubyIndex.get(compilationInfo.getIndex("text/x-ruby"));
                if (rubyIndex == null || string.length() == 0) {
                    return null;
                }
                if (Character.isUpperCase(string.charAt(0))) {
                    return null;
                }
                Set<IndexedMethod> set = rubyIndex.getMethods(string, null, NameKind.EXACT_NAME);
                try {
                    IndexedMethod indexedMethod = this.findBestMethodMatch(string, set, (BaseDocument)compilationInfo.getDocument(), n, n2, null, null, rubyIndex);
                    return indexedMethod;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    return null;
                }
            }
            RubyIndex rubyIndex = RubyIndex.get(compilationInfo.getIndex("text/x-ruby"));
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            int n3 = n;
            if (bl && n3 > 0) {
                --n3;
            }
            String string = ((INameNode)node).getName();
            String string2 = AstUtilities.getFqnName(astPath);
            if (string2 == null || string2.length() == 0) {
                string2 = "Object";
            }
            Call call = Call.getCallType((BaseDocument)document, (TokenHierarchy<Document>)tokenHierarchy, n2);
            boolean bl2 = true;
            boolean bl3 = call.isMethodExpected();
            boolean bl4 = call.isStatic();
            String string3 = call.getType();
            String string4 = call.getLhs();
            NameKind nameKind = NameKind.EXACT_NAME;
            Node node3 = node;
            if (string3 == null && string4 != null && node3 != null && call.isSimpleIdentifier() && (object2 = AstUtilities.findLocalScope(node3, astPath)) != null) {
                object = new TypeAnalyzer(rubyIndex, (Node)object2, node3, n, n2, (BaseDocument)document, compilationInfo.getFileObject());
                string3 = ((TypeAnalyzer)object).getType(string4);
            }
            if (string3 != null && string3.length() > 0) {
                if ("self".equals(string4)) {
                    string3 = string2;
                    bl2 = false;
                } else if ("super".equals(string4)) {
                    bl2 = false;
                    object2 = rubyIndex.getSuperclass(string2);
                    if (object2 != null) {
                        string3 = ((IndexedElement)object2).getFqn();
                    } else {
                        object = AstUtilities.findClass(astPath);
                        if (object != null) {
                            string3 = AstUtilities.getSuperclass((ClassNode)object);
                        }
                    }
                    if (string3 == null) {
                        string3 = "Object";
                    }
                }
            }
            if (call == Call.LOCAL && string2 != null && string2.length() == 0) {
                string2 = "Object";
            }
            object2 = this.getApplicableMethods(string, string2, string3, call, rubyIndex);
            if (string.equals("new")) {
                object = this.getApplicableMethods("initialize", string2, string3, call, rubyIndex);
                object2.addAll(object);
            }
            try {
                object = this.findBestMethodMatch(string, (Set<IndexedMethod>)object2, (BaseDocument)compilationInfo.getDocument(), n, n2, astPath, node, rubyIndex);
                if (setArray != null) {
                    setArray[0] = object2;
                }
                return object;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return null;
    }

    private DeclarationFinder.DeclarationLocation fix(DeclarationFinder.DeclarationLocation declarationLocation, CompilationInfo compilationInfo) {
        if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE && declarationLocation.getFileObject() == null && declarationLocation.getUrl() == null) {
            return new DeclarationFinder.DeclarationLocation(compilationInfo.getFileObject(), declarationLocation.getOffset(), declarationLocation.getElement());
        }
        return declarationLocation;
    }

    private DeclarationFinder.DeclarationLocation getLocation(CompilationInfo compilationInfo, Node node) {
        AstElement astElement = AstElement.create(compilationInfo, node);
        return new DeclarationFinder.DeclarationLocation(null, LexUtilities.getLexerOffset(compilationInfo, node.getPosition().getStartOffset()), (ElementHandle)astElement);
    }

    private DeclarationFinder.DeclarationLocation findRDocMethod(CompilationInfo compilationInfo, Document document, int n, int n2, Node node, AstPath astPath, Node node2, RubyIndex rubyIndex) {
        block9: {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            TokenSequence tokenSequence = LexUtilities.getRubyTokenSequence((BaseDocument)document, n2);
            if (tokenSequence == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            tokenSequence.move(n2);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            Token token = tokenSequence.token();
            TokenSequence tokenSequence2 = tokenSequence.embedded();
            if (tokenSequence2 != null) {
                tokenSequence = tokenSequence2;
                tokenSequence2.move(n2);
                if (!tokenSequence2.moveNext() && !tokenSequence2.movePrevious()) {
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                token = tokenSequence2.token();
            }
            if (token != null && token.id() == RubyCommentTokenId.COMMENT_LINK) {
                String string = ((Object)token.text()).toString();
                if (string.startsWith("#")) {
                    DeclarationFinder.DeclarationLocation declarationLocation = this.findMethod(compilationInfo, node, string = string.substring(1), Arity.UNKNOWN);
                    if (declarationLocation == DeclarationFinder.DeclarationLocation.NONE) {
                        declarationLocation = this.findInstance(compilationInfo, node, "@" + string);
                    }
                    return declarationLocation;
                }
                try {
                    URL uRL = new URL(string);
                    return new DeclarationFinder.DeclarationLocation(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    int n3 = string.indexOf("#");
                    if (n3 == -1 || n3 >= string.length() - 1) break block9;
                    String string2 = string.substring(0, n3);
                    string = string.substring(n3 + 1);
                    return this.findMethod(string, null, string2, Call.UNKNOWN, compilationInfo, n, n2, astPath, node2, rubyIndex);
                }
            }
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    DeclarationFinder.DeclarationLocation findLinkedMethod(CompilationInfo compilationInfo, String string) {
        Node node = AstUtilities.getRoot(compilationInfo);
        AstPath astPath = new AstPath();
        astPath.descend(node);
        Node node2 = node;
        int n = 0;
        int n2 = 0;
        RubyIndex rubyIndex = RubyIndex.get(compilationInfo.getIndex("text/x-ruby"));
        if (node == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        if (string.startsWith("#")) {
            DeclarationFinder.DeclarationLocation declarationLocation = this.findMethod(compilationInfo, node, string = string.substring(1), Arity.UNKNOWN);
            if (declarationLocation == DeclarationFinder.DeclarationLocation.NONE) {
                declarationLocation = this.findInstance(compilationInfo, node, "@" + string);
            }
            return declarationLocation;
        }
        try {
            URL uRL = new URL(string);
            return new DeclarationFinder.DeclarationLocation(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            int n3 = string.indexOf("#");
            if (n3 != -1 && n3 < string.length() - 1) {
                String string2 = string.substring(0, n3);
                string = string.substring(n3 + 1);
                return this.findMethod(string, null, string2, Call.UNKNOWN, compilationInfo, n, n2, astPath, node2, rubyIndex);
            }
            return DeclarationFinder.DeclarationLocation.NONE;
        }
    }

    IndexedClass findBestClassMatch(Set<IndexedClass> set, BaseDocument baseDocument, AstPath astPath, Node node, RubyIndex rubyIndex) {
        HashSet<IndexedClass> hashSet = new HashSet<IndexedClass>(set);
        while (!hashSet.isEmpty()) {
            IndexedClass indexedClass = this.findBestClassMatchHelper(hashSet, baseDocument, astPath, node, rubyIndex);
            Node node2 = AstUtilities.getForeignNode(indexedClass, null);
            if (node2 != null) {
                return indexedClass;
            }
            if (!hashSet.contains(indexedClass)) {
                hashSet.remove(hashSet.iterator().next());
                continue;
            }
            hashSet.remove(indexedClass);
        }
        return null;
    }

    private IndexedClass findBestClassMatchHelper(Set<IndexedClass> set, BaseDocument baseDocument, AstPath astPath, Node node, RubyIndex rubyIndex) {
        Object object2;
        HashSet<IndexedClass> hashSet = new HashSet<IndexedClass>();
        if (node instanceof Colon2Node) {
            object2 = AstUtilities.getFqn((Colon2Node)node);
            while (object2 != null && ((String)object2).length() > 0) {
                for (IndexedClass object3 : set) {
                    if (!((String)object2).equals(object3.getSignature())) continue;
                    hashSet.add(object3);
                }
                IndexedClass indexedClass = rubyIndex.getSuperclass((String)object2);
                if (indexedClass == null) break;
                object2 = indexedClass.getSignature();
            }
        }
        if (hashSet.size() == 1) {
            return (IndexedClass)hashSet.iterator().next();
        }
        if (!hashSet.isEmpty()) {
            set = hashSet;
        }
        object2 = null;
        if (astPath != null) {
            hashSet = new HashSet();
            object2 = AstUtilities.getRequires(astPath.root());
            for (IndexedClass indexedClass : set) {
                String string = indexedClass.getRequire();
                if (!object2.contains(string)) continue;
                hashSet.add(indexedClass);
            }
            if (hashSet.size() == 1) {
                return (IndexedClass)hashSet.iterator().next();
            }
            if (!hashSet.isEmpty()) {
                set = hashSet;
            }
        }
        hashSet = new HashSet();
        for (IndexedClass indexedClass : set) {
            String string = indexedClass.getFileUrl();
            if (string == null || string.indexOf("rubystubs") == -1) continue;
            hashSet.add(indexedClass);
        }
        if (hashSet.size() == 1) {
            return (IndexedClass)hashSet.iterator().next();
        }
        if (!hashSet.isEmpty()) {
            set = hashSet;
        }
        hashSet = new HashSet();
        int n = 0;
        for (IndexedClass indexedClass : set) {
            int n2 = indexedClass.getDocumentationLength();
            if (n2 > n) {
                hashSet.clear();
                hashSet.add(indexedClass);
                n = n2;
                continue;
            }
            if (n2 <= 0 || n2 != n) continue;
            hashSet.add(indexedClass);
        }
        if (hashSet.size() == 1) {
            return (IndexedClass)hashSet.iterator().next();
        }
        if (!hashSet.isEmpty()) {
            set = hashSet;
        }
        if (rubyIndex != null && object2 != null) {
            hashSet = new HashSet();
            Set<String> set2 = rubyIndex.getRequiresTransitively((Set<String>)object2);
            for (IndexedClass indexedClass : set) {
                String string = indexedClass.getRequire();
                if (!set2.contains(string)) continue;
                hashSet.add(indexedClass);
            }
            if (hashSet.size() == 1) {
                return (IndexedClass)hashSet.iterator().next();
            }
            if (!hashSet.isEmpty()) {
                set = hashSet;
            }
        }
        hashSet = new HashSet();
        if (set.size() > 0) {
            return set.iterator().next();
        }
        return null;
    }

    IndexedMethod findBestMethodMatch(String string, Set<IndexedMethod> set, BaseDocument baseDocument, int n, int n2, AstPath astPath, Node node, RubyIndex rubyIndex) {
        HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>(set);
        while (!hashSet.isEmpty()) {
            IndexedMethod indexedMethod = this.findBestMethodMatchHelper(string, hashSet, baseDocument, n, n2, astPath, node, rubyIndex);
            Node node2 = AstUtilities.getForeignNode(indexedMethod, null);
            if (node2 != null) {
                return indexedMethod;
            }
            if (!hashSet.contains(indexedMethod)) {
                hashSet.remove(hashSet.iterator().next());
                continue;
            }
            hashSet.remove(indexedMethod);
        }
        if (set.size() > 0) {
            return set.iterator().next();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private IndexedMethod findBestMethodMatchHelper(String string, Set<IndexedMethod> set, BaseDocument baseDocument, int n, int n2, AstPath astPath, Node node, RubyIndex rubyIndex) {
        Object object;
        Object object4;
        Node node2;
        Set<IndexedMethod> set2 = new HashSet<IndexedMethod>();
        if (node instanceof CallNode) {
            node2 = ((CallNode)node).getReceiverNode();
            object4 = null;
            if (node2 instanceof Colon2Node) {
                object4 = AstUtilities.getFqn((Colon2Node)node2);
            } else if (node2 instanceof ConstNode) {
                object4 = ((ConstNode)node2).getName();
            }
            if (object4 != null) {
                while (object4 != null && ((String)object4).length() > 0) {
                    for (IndexedMethod indexedMethod : set) {
                        if (!((String)object4).equals(indexedMethod.getClz())) continue;
                        set2.add(indexedMethod);
                    }
                    IndexedClass indexedClass = rubyIndex.getSuperclass((String)object4);
                    if (indexedClass == null) break;
                    object4 = indexedClass.getSignature();
                }
            }
        }
        if (set2.size() == 1) {
            return (IndexedMethod)set2.iterator().next();
        }
        if (!set2.isEmpty()) {
            set = set2;
        }
        node2 = TokenHierarchy.get((Document)baseDocument);
        object4 = Call.getCallType(baseDocument, (TokenHierarchy<Document>)node2, n2);
        boolean bl = true;
        if (astPath != null && node != null && object4 != Call.LOCAL && object4 != Call.NONE) {
            void var14_21;
            boolean bl2 = ((Call)object4).isStatic();
            set2 = new HashSet();
            String object5 = ((Call)object4).getType();
            if (object5 != null && object5.length() > 0) {
                String string2 = ((Call)object4).getLhs();
                String string3 = AstUtilities.getFqnName(astPath);
                if ("self".equals(string2)) {
                    String n4 = string3;
                    bl = false;
                } else if ("super".equals(string2)) {
                    bl = false;
                    IndexedClass indexedClass = rubyIndex.getSuperclass(string3);
                    if (indexedClass != null) {
                        String string4 = indexedClass.getFqn();
                    } else {
                        object = AstUtilities.findClass(astPath);
                        if (object != null) {
                            String string5 = AstUtilities.getSuperclass(object);
                        }
                    }
                }
                if (var14_21 != null && var14_21.length() > 0) {
                    while (set2.size() == 0) {
                        void var16_43;
                        set2 = rubyIndex.getInheritedMethods((String)var16_43 + "::" + (String)var14_21, string, NameKind.EXACT_NAME);
                        int n3 = var16_43.lastIndexOf("::");
                        if (n3 == -1) break;
                        String string6 = var16_43.substring(0, n3);
                    }
                    if (set2.size() == 0) {
                        set2 = rubyIndex.getInheritedMethods((String)var14_21, string, NameKind.EXACT_NAME);
                    }
                }
            }
            if (bl || bl2) {
                HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>();
                for (IndexedMethod indexedMethod : set2) {
                    if (bl && indexedMethod.isPrivate() && !"new".equals(indexedMethod.getName()) || bl2 && !indexedMethod.isStatic()) continue;
                    hashSet.add(indexedMethod);
                }
                set2 = hashSet;
            }
            if (var14_21 != null) {
                HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>();
                for (IndexedMethod indexedMethod : set2) {
                    if (indexedMethod.getIn() == null || !indexedMethod.getIn().endsWith((String)var14_21)) continue;
                    hashSet.add(indexedMethod);
                }
                if (hashSet.size() < set2.size()) {
                    set2 = hashSet;
                }
            }
        }
        if (set2.size() == 1) {
            return (IndexedMethod)set2.iterator().next();
        }
        if (!set2.isEmpty()) {
            set = set2;
        }
        set2 = new HashSet();
        for (IndexedMethod indexedMethod : set) {
            String string7 = indexedMethod.getEncodedAttributes();
            if (string7 == null || string7.length() <= 3) continue;
            set2.add(indexedMethod);
        }
        if (set2.size() == 1) {
            return (IndexedMethod)set2.iterator().next();
        }
        if (!set2.isEmpty()) {
            set = set2;
        }
        Object object6 = null;
        if (astPath != null) {
            set2 = new HashSet();
            object6 = AstUtilities.getRequires(astPath.root());
            for (IndexedMethod indexedMethod : set) {
                String string8 = indexedMethod.getRequire();
                if (!object6.contains(string8)) continue;
                set2.add(indexedMethod);
            }
            if (set2.size() == 1) {
                return (IndexedMethod)set2.iterator().next();
            }
            if (!set2.isEmpty()) {
                set = set2;
            }
        }
        set2 = new HashSet();
        for (IndexedMethod indexedMethod : set) {
            String string9 = indexedMethod.getFileUrl();
            if (string9 == null || string9.indexOf("rubystubs") == -1) continue;
            set2.add(indexedMethod);
        }
        if (set2.size() == 1) {
            return (IndexedMethod)set2.iterator().next();
        }
        if (!set2.isEmpty()) {
            set = set2;
        }
        set2 = new HashSet();
        boolean bl2 = false;
        for (IndexedMethod indexedMethod : set) {
            int n4;
            int n5 = indexedMethod.getDocumentationLength();
            if (n5 > n4) {
                set2.clear();
                set2.add(indexedMethod);
                n4 = n5;
                continue;
            }
            if (n5 <= 0 || n5 != n4) continue;
            set2.add(indexedMethod);
        }
        if (set2.size() == 1) {
            return set2.iterator().next();
        }
        if (!set2.isEmpty()) {
            set = set2;
        }
        if (rubyIndex != null && object6 != null) {
            set2 = new HashSet();
            Set<String> set3 = rubyIndex.getRequiresTransitively((Set<String>)object6);
            for (IndexedMethod indexedMethod : set) {
                object = indexedMethod.getRequire();
                if (!set3.contains(object)) continue;
                set2.add(indexedMethod);
            }
            if (set2.size() == 1) {
                return set2.iterator().next();
            }
            if (!set2.isEmpty()) {
                set = set2;
            }
        }
        if (set.size() > 0) {
            return set.iterator().next();
        }
        return null;
    }

    private DeclarationFinder.DeclarationLocation findLocal(CompilationInfo compilationInfo, Node node, String string) {
        DeclarationFinder.DeclarationLocation declarationLocation;
        List list;
        if (node instanceof LocalAsgnNode) {
            if (((INameNode)node).getName().equals(string)) {
                return this.getLocation(compilationInfo, node);
            }
        } else if (!this.ignoreAlias && node instanceof AliasNode) {
            if (((AliasNode)node).getNewName().equals(string)) {
                return this.getLocation(compilationInfo, node);
            }
        } else if (node instanceof ArgsNode) {
            Object object;
            list = (ArgsNode)node;
            if (list.getRequiredArgsCount() > 0) {
                object = list.childNodes();
                Node node2 = object.iterator();
                while (node2.hasNext()) {
                    declarationLocation = (Node)node2.next();
                    if (!(declarationLocation instanceof ListNode)) continue;
                    List list2 = declarationLocation.childNodes();
                    for (Node node3 : list2) {
                        if (!(node3 instanceof ArgumentNode ? ((ArgumentNode)node3).getName().equals(string) : node3 instanceof LocalAsgnNode && ((LocalAsgnNode)node3).getName().equals(string))) continue;
                        return this.getLocation(compilationInfo, node3);
                    }
                }
            }
            if (list.getRestArgNode() != null && (object = list.getRestArgNode()).getName().equals(string)) {
                return this.getLocation(compilationInfo, (Node)object);
            }
            if (list.getBlockArgNode() != null && (object = list.getBlockArgNode()).getName().equals(string)) {
                return this.getLocation(compilationInfo, (Node)object);
            }
        }
        list = node.childNodes();
        for (Node node2 : list) {
            declarationLocation = this.findLocal(compilationInfo, node2, string);
            if (declarationLocation == DeclarationFinder.DeclarationLocation.NONE) continue;
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findDynamic(CompilationInfo compilationInfo, Node node, String string) {
        if (node instanceof DAsgnNode ? ((INameNode)node).getName().equals(string) : !this.ignoreAlias && node instanceof AliasNode && ((AliasNode)node).getNewName().equals(string)) {
            return this.getLocation(compilationInfo, node);
        }
        List list = node.childNodes();
        for (Node node2 : list) {
            DeclarationFinder.DeclarationLocation declarationLocation = this.findDynamic(compilationInfo, node2, string);
            if (declarationLocation == DeclarationFinder.DeclarationLocation.NONE) continue;
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findInstance(CompilationInfo compilationInfo, Node node, String string) {
        SymbolNode[] symbolNodeArray;
        if (node instanceof InstAsgnNode) {
            if (((INameNode)node).getName().equals(string)) {
                return this.getLocation(compilationInfo, node);
            }
        } else if (!this.ignoreAlias && node instanceof AliasNode) {
            if (((AliasNode)node).getNewName().equals(string)) {
                return this.getLocation(compilationInfo, node);
            }
        } else if (AstUtilities.isAttr(node)) {
            symbolNodeArray = AstUtilities.getAttrSymbols(node);
            for (int i = 0; i < symbolNodeArray.length; ++i) {
                if (!string.equals("@" + symbolNodeArray[i].getName())) continue;
                return this.getLocation(compilationInfo, (Node)symbolNodeArray[i]);
            }
        }
        symbolNodeArray = node.childNodes();
        for (Node node2 : symbolNodeArray) {
            DeclarationFinder.DeclarationLocation declarationLocation = this.findInstance(compilationInfo, node2, string);
            if (declarationLocation == DeclarationFinder.DeclarationLocation.NONE) continue;
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findClassVar(CompilationInfo compilationInfo, Node node, String string) {
        if (node instanceof ClassVarDeclNode ? ((INameNode)node).getName().equals(string) : !this.ignoreAlias && node instanceof AliasNode && ((AliasNode)node).getNewName().equals(string)) {
            return this.getLocation(compilationInfo, node);
        }
        List list = node.childNodes();
        for (Node node2 : list) {
            DeclarationFinder.DeclarationLocation declarationLocation = this.findClassVar(compilationInfo, node2, string);
            if (declarationLocation == DeclarationFinder.DeclarationLocation.NONE) continue;
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findInstanceFromIndex(CompilationInfo compilationInfo, String string, AstPath astPath, RubyIndex rubyIndex) {
        String string2 = AstUtilities.getFqnName(astPath);
        Set<IndexedField> set = rubyIndex.getInheritedFields(string2, string, NameKind.EXACT_NAME, false);
        for (IndexedField indexedField : set) {
            Node node = AstUtilities.getForeignNode(indexedField, null);
            if (node == null) continue;
            return new DeclarationFinder.DeclarationLocation(indexedField.getFile().getFileObject(), node.getPosition().getStartOffset(), (ElementHandle)indexedField);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findGlobal(CompilationInfo compilationInfo, Node node, String string) {
        if (node instanceof GlobalAsgnNode ? ((INameNode)node).getName().equals(string) : !this.ignoreAlias && node instanceof AliasNode && ((AliasNode)node).getNewName().equals(string)) {
            return this.getLocation(compilationInfo, node);
        }
        List list = node.childNodes();
        for (Node node2 : list) {
            DeclarationFinder.DeclarationLocation declarationLocation = this.findGlobal(compilationInfo, node2, string);
            if (declarationLocation == DeclarationFinder.DeclarationLocation.NONE) continue;
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findMethod(CompilationInfo compilationInfo, Node node, String string, Arity arity) {
        if (node instanceof MethodDefNode ? ((MethodDefNode)node).getName().equals(string) && Arity.matches(arity, Arity.getDefArity(node)) : !this.ignoreAlias && node instanceof AliasNode && ((AliasNode)node).getNewName().equals(string)) {
            return this.getLocation(compilationInfo, node);
        }
        List list = node.childNodes();
        for (Node node2 : list) {
            DeclarationFinder.DeclarationLocation declarationLocation = this.findMethod(compilationInfo, node2, string, arity);
            if (declarationLocation == DeclarationFinder.DeclarationLocation.NONE) continue;
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private Node findClass(Node node, String string) {
        Object object;
        if (node instanceof ClassNode ? ((String)(object = AstUtilities.getClassOrModuleName((IScopingNode)((ClassNode)node)))).equals(string) : (node instanceof ConstDeclNode ? ((INameNode)node).getName().equals(string) : !this.ignoreAlias && node instanceof AliasNode && ((AliasNode)node).getNewName().equals(string))) {
            return node;
        }
        object = node.childNodes();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            Node node3 = this.findClass(node2, string);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    private class RubyAltLocation
    implements DeclarationFinder.AlternativeLocation {
        private IndexedElement element;
        private boolean isPreferred;
        private String cachedDisplayItem;

        RubyAltLocation(IndexedElement indexedElement, boolean bl) {
            this.element = indexedElement;
            this.isPreferred = bl;
        }

        public String getDisplayHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.setMaxLength(120);
            if (this.cachedDisplayItem == null) {
                Object object;
                Object object2;
                Object object3;
                htmlFormatter.reset();
                boolean bl = this.element.isNoDoc();
                boolean bl2 = this.element.isDocumented();
                if (this.isPreferred) {
                    htmlFormatter.emphasis(true);
                } else if (bl) {
                    htmlFormatter.deprecated(true);
                }
                if (this.element instanceof IndexedMethod) {
                    if (this.element.getFqn() != null) {
                        htmlFormatter.appendText(this.element.getFqn());
                        htmlFormatter.appendText(".");
                    }
                    htmlFormatter.appendText(this.element.getName());
                    object3 = (IndexedMethod)this.element;
                    object2 = ((IndexedMethod)object3).getParameters();
                    if (object2 != null && object2.size() > 0) {
                        htmlFormatter.appendText("(");
                        object = object2.iterator();
                        while (object.hasNext()) {
                            htmlFormatter.parameters(true);
                            htmlFormatter.appendText((String)object.next());
                            htmlFormatter.parameters(false);
                            if (!object.hasNext()) continue;
                            htmlFormatter.appendText(", ");
                        }
                        htmlFormatter.appendText(")");
                    }
                } else {
                    htmlFormatter.appendText(this.element.getFqn());
                }
                object3 = null;
                object2 = this.element.getFilenameUrl();
                if (object2 != null) {
                    if (((String)object2).indexOf("rubystubs") != -1) {
                        int n;
                        object3 = NbBundle.getMessage(DeclarationFinder.class, (String)"RubyLib");
                        if (((String)object2).indexOf("/stub_") == -1 && (n = ((String)object2).indexOf((String)(object = "rubystubs/1.8.6-p110/"))) != -1) {
                            object3 = (String)object3 + ": " + ((String)object2).substring(n);
                        }
                    } else {
                        int n;
                        int n2;
                        Object object4;
                        object = this.element.getFileObject();
                        if (object != null) {
                            object3 = object.getNameExt();
                        } else {
                            int n3 = ((String)object2).lastIndexOf(47);
                            if (n3 != -1) {
                                object4 = ((String)object2).substring(0, n3);
                                n2 = ((String)object4).lastIndexOf(47);
                                if (n2 != -1 && ((String)object2).length() - n2 < 40) {
                                    object3 = ((String)object2).substring(n2 + 1);
                                    if (((String)object3).indexOf(58) != -1) {
                                        object3 = ((String)object2).substring(n3 + 1);
                                    }
                                } else {
                                    object3 = ((String)object2).substring(n3 + 1);
                                }
                            }
                        }
                        Pattern pattern = Pattern.compile("lib/ruby/gems/\\d+\\.\\d+/gems/");
                        object4 = pattern.matcher((CharSequence)object2);
                        if (((Matcher)object4).find() && (n = ((String)object2).indexOf(47, n2 = ((Matcher)object4).end())) != -1) {
                            object3 = ((String)object2).substring(n2, n) + ": " + (String)object3;
                        }
                    }
                }
                if (object3 != null) {
                    htmlFormatter.appendText(" ");
                    htmlFormatter.appendText(NbBundle.getMessage(DeclarationFinder.class, (String)"In"));
                    htmlFormatter.appendText(" ");
                    htmlFormatter.appendText((String)object3);
                }
                if (bl2) {
                    htmlFormatter.appendText(" ");
                    htmlFormatter.appendText(NbBundle.getMessage(DeclarationFinder.class, (String)"Documented"));
                } else if (bl) {
                    htmlFormatter.appendText(" ");
                    htmlFormatter.appendText(NbBundle.getMessage(DeclarationFinder.class, (String)"NoDoced"));
                }
                if (this.isPreferred) {
                    htmlFormatter.emphasis(false);
                } else if (bl) {
                    htmlFormatter.deprecated(false);
                }
                this.cachedDisplayItem = htmlFormatter.getText();
            }
            return this.cachedDisplayItem;
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            Node node = AstUtilities.getForeignNode(this.element, null);
            int n = node != null ? node.getPosition().getStartOffset() : -1;
            DeclarationFinder.DeclarationLocation declarationLocation = new DeclarationFinder.DeclarationLocation(this.element.getFileObject(), n, (ElementHandle)this.element);
            return declarationLocation;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation alternativeLocation) {
            String string;
            RubyAltLocation rubyAltLocation = (RubyAltLocation)alternativeLocation;
            if (this.isPreferred) {
                return -1;
            }
            if (rubyAltLocation.isPreferred) {
                return 1;
            }
            if (this.element.isNoDoc() != rubyAltLocation.element.isNoDoc()) {
                return this.element.isNoDoc() ? 1 : -1;
            }
            if (this.element.isDocumented() != rubyAltLocation.element.isDocumented()) {
                return this.element.isDocumented() ? -1 : 1;
            }
            String string2 = this.element.getIn() != null ? this.element.getIn() : "";
            int n = string2.compareTo(string = rubyAltLocation.element.getIn() != null ? rubyAltLocation.element.getIn() : "");
            if (n != 0) {
                return n;
            }
            String string3 = this.element.getFileObject() != null ? this.element.getFileObject().getNameExt() : "";
            String string4 = rubyAltLocation.element.getFileObject() != null ? rubyAltLocation.element.getFileObject().getNameExt() : "";
            n = string3.compareTo(string4);
            return n;
        }
    }

    private static class RailsTarget {
        String name;
        OffsetRange range;
        String type;

        RailsTarget(String string, String string2, OffsetRange offsetRange) {
            this.type = string;
            this.range = offsetRange;
            this.name = string2;
        }

        public String toString() {
            return "RailsTarget(" + this.type + ", " + this.name + ", " + this.range + ")";
        }
    }
}

