/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.Rule;
import org.apache.batik.css.engine.StyleRule;
import org.apache.batik.css.engine.sac.CSSAndCondition;
import org.apache.batik.css.engine.sac.CSSAttributeCondition;
import org.apache.batik.css.engine.sac.CSSChildSelector;
import org.apache.batik.css.engine.sac.CSSClassCondition;
import org.apache.batik.css.engine.sac.CSSConditionalSelector;
import org.apache.batik.css.engine.sac.CSSDescendantSelector;
import org.apache.batik.css.engine.sac.CSSDirectAdjacentSelector;
import org.apache.batik.css.engine.sac.CSSElementSelector;
import org.apache.batik.css.engine.sac.CSSIdCondition;
import org.apache.batik.css.engine.sac.CSSOneOfAttributeCondition;
import org.apache.batik.css.engine.sac.CSSPseudoElementSelector;
import org.apache.batik.css.engine.sac.ExtendedSelector;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SimpleSelector;

public class StyleSheet {
    protected Rule[] rules = new Rule[16];
    protected int size;
    protected StyleSheet parent;
    protected boolean alternate;
    protected SACMediaList media;
    protected String title;
    private HashMap tagMap;
    private HashMap classMap;
    private HashMap idMap;
    private Rule[] remainingRules;

    public void setMedia(SACMediaList m) {
        this.media = m;
    }

    public SACMediaList getMedia() {
        return this.media;
    }

    public StyleSheet getParent() {
        return this.parent;
    }

    public void setParent(StyleSheet ss) {
        this.parent = ss;
    }

    public void setAlternate(boolean b) {
        this.alternate = b;
    }

    public boolean isAlternate() {
        return this.alternate;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSize() {
        return this.size;
    }

    public Rule getRule(int i) {
        return this.rules[i];
    }

    public void clear() {
        this.size = 0;
        this.rules = new Rule[10];
    }

    public void append(Rule r) {
        if (this.size == this.rules.length) {
            Rule[] t = new Rule[this.size * 2];
            for (int i = 0; i < this.size; ++i) {
                t[i] = this.rules[i];
            }
            this.rules = t;
        }
        this.rules[this.size++] = r;
    }

    public String toString(CSSEngine eng) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.rules[i].toString(eng));
        }
        return sb.toString();
    }

    public String toString() {
        return super.toString() + "[" + this.getTitle() + "]";
    }

    public HashMap getTagMap() {
        return this.tagMap;
    }

    public HashMap getClassMap() {
        return this.classMap;
    }

    public HashMap getIdMap() {
        return this.idMap;
    }

    public Rule[] getRemainingRules() {
        return this.remainingRules;
    }

    private boolean addCondition(Condition condition, Map tagMap, Map classMap, Map idMap, List otherList, Rule rule, ExtendedSelector extSelector) {
        switch (condition.getConditionType()) {
            case 0: {
                Condition first = ((CSSAndCondition)condition).getFirstCondition();
                Condition second = ((CSSAndCondition)condition).getSecondCondition();
                return this.addCondition(first, tagMap, classMap, idMap, otherList, rule, extSelector) || this.addCondition(second, tagMap, classMap, idMap, otherList, rule, extSelector);
            }
            case 9: {
                String styleClass = ((CSSClassCondition)condition).getValue();
                ArrayList<ExtendedSelector> list = (ArrayList<ExtendedSelector>)classMap.get(styleClass);
                if (list == null) {
                    list = new ArrayList<ExtendedSelector>(30);
                    classMap.put(styleClass, list);
                }
                list.add(extSelector);
                return true;
            }
            case 4: {
                String localName = ((CSSAttributeCondition)condition).getLocalName();
                if (localName.equals("class")) {
                    String styleClass = ((CSSAttributeCondition)condition).getValue();
                    ArrayList<ExtendedSelector> list = (ArrayList<ExtendedSelector>)classMap.get(styleClass);
                    if (list == null) {
                        list = new ArrayList<ExtendedSelector>(30);
                        classMap.put(styleClass, list);
                    }
                    list.add(extSelector);
                    return true;
                }
                otherList.add(rule);
                return false;
            }
            case 5: {
                String id = ((CSSIdCondition)condition).getValue();
                ArrayList<ExtendedSelector> list = (ArrayList<ExtendedSelector>)idMap.get(id);
                if (list == null) {
                    list = new ArrayList<ExtendedSelector>(30);
                    idMap.put(id, list);
                }
                list.add(extSelector);
                return true;
            }
            case 7: {
                String localName = ((CSSOneOfAttributeCondition)condition).getLocalName();
                if (localName.equals("class")) {
                    String styleClass = ((CSSOneOfAttributeCondition)condition).getValue();
                    ArrayList<ExtendedSelector> list = (ArrayList<ExtendedSelector>)classMap.get(styleClass);
                    if (list == null) {
                        list = new ArrayList<ExtendedSelector>(30);
                        classMap.put(styleClass, list);
                    }
                    list.add(extSelector);
                    return true;
                }
                otherList.add(rule);
                return false;
            }
        }
        otherList.add(rule);
        return false;
    }

    private boolean addSelector(Selector selector, Map tagMap, Map classMap, Map idMap, List otherList, Rule rule, ExtendedSelector extSelector) {
        switch (selector.getSelectorType()) {
            case 0: {
                Condition condition = ((CSSConditionalSelector)selector).getCondition();
                boolean added = this.addCondition(condition, tagMap, classMap, idMap, otherList, rule, extSelector);
                if (added) {
                    return true;
                }
                SimpleSelector simple = ((CSSConditionalSelector)selector).getSimpleSelector();
                added = this.addSelector(simple, tagMap, classMap, idMap, otherList, rule, extSelector);
                if (added) {
                    return true;
                }
                otherList.add(rule);
                return false;
            }
            case 1: {
                otherList.add(rule);
                return false;
            }
            case 2: {
                otherList.add(rule);
                return false;
            }
            case 3: {
                SimpleSelector simple = ((NegativeSelector)selector).getSimpleSelector();
                this.addSelector(simple, tagMap, classMap, idMap, otherList, rule, extSelector);
                return false;
            }
            case 4: {
                String tag = ((CSSElementSelector)selector).getLocalName();
                if (tag != null) {
                    ArrayList<ExtendedSelector> list = (ArrayList<ExtendedSelector>)tagMap.get(tag = tag.toLowerCase());
                    if (list == null) {
                        list = new ArrayList<ExtendedSelector>(30);
                        tagMap.put(tag, list);
                    }
                    list.add(extSelector);
                }
                return true;
            }
            case 5: {
                otherList.add(rule);
                return false;
            }
            case 6: {
                otherList.add(rule);
                return false;
            }
            case 7: {
                otherList.add(rule);
                return false;
            }
            case 8: {
                otherList.add(rule);
                return false;
            }
            case 9: {
                String tag = ((CSSPseudoElementSelector)selector).getLocalName();
                if (tag != null) {
                    ArrayList<ExtendedSelector> list = (ArrayList<ExtendedSelector>)tagMap.get(tag = tag.toLowerCase());
                    if (list == null) {
                        list = new ArrayList<ExtendedSelector>(30);
                        tagMap.put(tag, list);
                    }
                    list.add(extSelector);
                }
                return true;
            }
            case 10: {
                SimpleSelector simple = ((CSSDescendantSelector)selector).getSimpleSelector();
                return this.addSelector(simple, tagMap, classMap, idMap, otherList, rule, extSelector);
            }
            case 11: {
                SimpleSelector simple = ((CSSChildSelector)selector).getSimpleSelector();
                return this.addSelector(simple, tagMap, classMap, idMap, otherList, rule, extSelector);
            }
            case 12: {
                SimpleSelector simple = ((CSSDirectAdjacentSelector)selector).getSiblingSelector();
                return this.addSelector(simple, tagMap, classMap, idMap, otherList, rule, extSelector);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void setupFilters() {
        ExtendedSelector[] array;
        List list;
        if (!CSSEngine.RULE_FILTERING) {
            return;
        }
        int len = this.getSize();
        this.tagMap = new HashMap(2 * len);
        this.classMap = new HashMap(2 * len);
        this.idMap = new HashMap(2 * len);
        ArrayList<Rule> otherList = new ArrayList<Rule>(100);
        block4: for (int i = 0; i < len; ++i) {
            Rule rule = this.getRule(i);
            switch (rule.getType()) {
                case 0: {
                    StyleRule style = (StyleRule)rule;
                    style.setPosition(i);
                    SelectorList sl = style.getSelectorList();
                    int slen = sl.getLength();
                    for (int j = 0; j < slen; ++j) {
                        ExtendedSelector s = (ExtendedSelector)sl.item(j);
                        this.addSelector(s, this.tagMap, this.classMap, this.idMap, otherList, rule, s);
                        s.setRule(rule);
                    }
                    continue block4;
                }
                case 1: 
                case 2: {
                    otherList.add(rule);
                }
            }
        }
        for (Map.Entry entry : this.tagMap.entrySet()) {
            list = (List)entry.getValue();
            array = list.toArray(new ExtendedSelector[list.size()]);
            entry.setValue(array);
        }
        for (Map.Entry entry : this.classMap.entrySet()) {
            list = (List)entry.getValue();
            array = list.toArray(new ExtendedSelector[list.size()]);
            entry.setValue(array);
        }
        for (Map.Entry entry : this.idMap.entrySet()) {
            list = (List)entry.getValue();
            array = list.toArray(new ExtendedSelector[list.size()]);
            entry.setValue(array);
        }
        Object var4_12 = null;
        int unique = 0;
        int n = otherList.size();
        for (int i = 0; i < n; ++i) {
            void var4_13;
            Object next = otherList.get(i);
            if (next == var4_13) continue;
            ++unique;
            Object e = next;
        }
        if (unique != otherList.size()) {
            this.remainingRules = new Rule[unique];
            Object var4_15 = null;
            int index = 0;
            int n2 = otherList.size();
            for (int i = 0; i < n2; ++i) {
                void var4_16;
                Object next = otherList.get(i);
                if (next == var4_16) continue;
                this.remainingRules[index] = (Rule)next;
                assert (index == 0 || !(this.remainingRules[index] instanceof StyleRule) || !(this.remainingRules[index - 1] instanceof StyleRule) || ((StyleRule)this.remainingRules[index]).getPosition() > ((StyleRule)this.remainingRules[index - 1]).getPosition());
                Object e = next;
                ++index;
            }
            assert (index == unique);
        } else {
            this.remainingRules = otherList.toArray(new Rule[otherList.size()]);
        }
    }
}

