/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.refactoring.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringCustomUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.netbeans.modules.xml.nbprefuse.AnalysisViewer;
import org.netbeans.modules.xml.nbprefuse.View;
import org.netbeans.modules.xml.refactoring.XMLRefactoringTransaction;
import org.netbeans.modules.xml.refactoring.ui.GraphHelper;
import org.netbeans.modules.xml.refactoring.ui.RenamePanel;
import org.netbeans.modules.xml.refactoring.ui.WhereUsedQueryUI;
import org.netbeans.modules.xml.refactoring.ui.views.WhereUsedView;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import prefuse.data.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameRefactoringUI
implements RefactoringUI,
RefactoringCustomUI {
    private WhereUsedQuery query;
    private WhereUsedView view;
    private String newName = "";
    private String oldName = "";
    private String displayName = "";
    private RenamePanel panel;
    private Nameable target;
    private boolean editable;
    private RenameRefactoring refactoring;

    public RenameRefactoringUI(Nameable nameable) {
        this.target = nameable;
        this.displayName = this.oldName = nameable.getName();
        this.editable = true;
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)nameable));
        XMLRefactoringTransaction xMLRefactoringTransaction = new XMLRefactoringTransaction((Referenceable)nameable, (AbstractRefactoring)this.refactoring);
        this.refactoring.getContext().add((Object)xMLRefactoringTransaction);
        this.refactoring.getContext().add((Object)this.oldName);
    }

    public RenameRefactoringUI(Nameable nameable, String string) {
        this.target = nameable;
        this.oldName = nameable.getName();
        this.displayName = this.displayName != null ? string : this.oldName;
        this.editable = true;
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)nameable));
        XMLRefactoringTransaction xMLRefactoringTransaction = new XMLRefactoringTransaction((Referenceable)nameable, (AbstractRefactoring)this.refactoring);
        this.refactoring.getContext().add((Object)xMLRefactoringTransaction);
        this.refactoring.getContext().add((Object)this.oldName);
    }

    public RenameRefactoringUI(WhereUsedView whereUsedView, Nameable nameable, String string, boolean bl) {
        this.view = whereUsedView;
        this.target = nameable;
        this.oldName = string;
        this.editable = bl;
        assert (nameable instanceof NamedReferenceable);
        this.query = new WhereUsedQuery(Lookups.singleton((Object)((NamedReferenceable)nameable)));
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            String string = this.oldName;
            this.panel = new RenamePanel(this.displayName, changeListener, NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename"), this.editable, false);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            this.refactoring.setNewName(this.newName);
        }
        return this.refactoring.checkParameters();
    }

    public boolean isQuery() {
        return false;
    }

    public boolean hasParameters() {
        return true;
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getName() {
        return new MessageFormat(NbBundle.getMessage(RenameRefactoringUI.class, (String)"LBL_Rename")).format(new Object[]{this.oldName});
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RenameRefactoringUI.class);
    }

    public String getDescription() {
        return new MessageFormat(NbBundle.getMessage(RenameRefactoringUI.class, (String)"DSC_Rename")).format(new Object[]{this.oldName, this.newName});
    }

    public Problem checkParameters() {
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            this.refactoring.setNewName(this.newName);
        }
        return this.refactoring.fastCheckParameters();
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = (WhereUsedView)WhereUsedView.class.cast(view);
    }

    public String getNewName() {
        if (this.panel != null) {
            this.newName = this.panel.getNameValue();
        }
        return this.newName == null ? "" : this.newName;
    }

    public void setNameableTarget(Nameable nameable) {
        this.target = nameable;
    }

    public Nameable getNameableTarget() {
        return this.target;
    }

    public Referenceable getTarget() {
        assert (this.target instanceof Referenceable);
        return (Referenceable)this.target;
    }

    public Component getCustomComponent(Collection<RefactoringElement> collection) {
        RefactoringElement refactoringElement2;
        WhereUsedView whereUsedView = new WhereUsedView((Referenceable)this.target);
        GraphHelper graphHelper = new GraphHelper((Referenceable)this.target);
        ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>();
        for (RefactoringElement refactoringElement2 : collection) {
            TreeElement treeElement = TreeElementFactory.getTreeElement((Object)refactoringElement2);
            if (treeElement == null) continue;
            arrayList.add(treeElement);
        }
        Graph graph = graphHelper.loadGraph(arrayList);
        whereUsedView.setGraph(graph);
        refactoringElement2 = new AnalysisViewer();
        refactoringElement2.setCurrentView((View)whereUsedView);
        refactoringElement2.getPanel().setMinimumSize(new Dimension(10, 10));
        refactoringElement2.getPanel().setPreferredSize(new Dimension(10, 10));
        whereUsedView.showView((AnalysisViewer)refactoringElement2);
        return refactoringElement2.getPanel();
    }

    public Icon getCustomIcon() {
        return new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/xml/refactoring/resources/graphical_view_refactoring.png"));
    }

    public String getCustomToolTip() {
        return NbBundle.getMessage(WhereUsedQueryUI.class, (String)"LBL_ShowGraph");
    }
}

