/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.util.StringTokenizer;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.j2ee.dd.api.common.RunAs;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.Method;
import org.netbeans.modules.j2ee.dd.api.ejb.MethodPermission;
import org.netbeans.modules.j2ee.dd.api.ejb.SecurityIdentity;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.TextItemEditorModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.ui.SecurityForm;
import org.netbeans.modules.xml.multiview.ItemEditorHelper;
import org.netbeans.modules.xml.multiview.ItemOptionHelper;
import org.netbeans.modules.xml.multiview.Refreshable;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;

public class EjbSecurityPanel
extends SecurityForm {
    private static String ALL_METHODS = "*";
    private MethodPermission methodPermission;
    private EjbJar ejbJar;
    private AssemblyDescriptor assemblyDesc;

    public EjbSecurityPanel(SectionNodeView sectionNodeView, final Ejb ejb) {
        super(sectionNodeView);
        EjbJarMultiViewDataObject ejbJarMultiViewDataObject = (EjbJarMultiViewDataObject)sectionNodeView.getDataObject();
        this.ejbJar = ejbJarMultiViewDataObject.getEjbJar();
        this.assemblyDesc = this.ejbJar.getSingleAssemblyDescriptor();
        XmlMultiViewDataSynchronizer xmlMultiViewDataSynchronizer = ejbJarMultiViewDataObject.getModelSynchronizer();
        this.addRefreshable((Refreshable)new ItemOptionHelper(xmlMultiViewDataSynchronizer, this.getSecurityIDButtonGroup()){

            public String getItemValue() {
                SecurityIdentity securityIdentity = ejb.getSecurityIdentity();
                if (securityIdentity != null) {
                    if (securityIdentity.isUseCallerIdentity()) {
                        return SecurityForm.USE_CALLER_ID;
                    }
                    if (securityIdentity.getRunAs() != null) {
                        return SecurityForm.RUN_AS;
                    }
                }
                return SecurityForm.NO_SECURITY_ID;
            }

            public void setItemValue(String string) {
                EjbSecurityPanel.this.updateSecurityIdentity(ejb);
                EjbSecurityPanel.this.updateVisualState();
            }
        });
        this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)this.getRunAsRoleNameTF(), (ItemEditorHelper.ItemEditorModel)new TextItemEditorModel(xmlMultiViewDataSynchronizer, true, true){

            protected String getValue() {
                RunAs runAs = EjbSecurityPanel.this.getRunAs(ejb);
                if (runAs != null) {
                    return runAs.getRoleName();
                }
                return EjbSecurityPanel.this.getRunAsRoleNameTF().getText();
            }

            protected void setValue(String string) {
                RunAs runAs = EjbSecurityPanel.this.getRunAs(ejb);
                if (runAs != null) {
                    EjbSecurityPanel.this.updateRunAs(runAs);
                }
            }
        }));
        this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)this.getRunAsDescriptionTF(), (ItemEditorHelper.ItemEditorModel)new TextItemEditorModel(xmlMultiViewDataSynchronizer, true, true){

            protected String getValue() {
                RunAs runAs = EjbSecurityPanel.this.getRunAs(ejb);
                if (runAs != null) {
                    return runAs.getDefaultDescription();
                }
                return EjbSecurityPanel.this.getRunAsDescriptionTF().getText();
            }

            protected void setValue(String string) {
                RunAs runAs = EjbSecurityPanel.this.getRunAs(ejb);
                if (runAs != null) {
                    EjbSecurityPanel.this.updateRunAs(runAs);
                }
            }
        }));
        this.addRefreshable((Refreshable)new ItemOptionHelper(xmlMultiViewDataSynchronizer, this.getGlobalMethodPermissionButtonGroup()){

            public String getItemValue() {
                MethodPermission methodPermission = EjbSecurityPanel.this.getGlobalMethodPermission(ejb);
                if (methodPermission != null) {
                    try {
                        if (methodPermission.isUnchecked()) {
                            return SecurityForm.ALL_METHOD_PERMISSION;
                        }
                        return SecurityForm.SET_ROLE_METHOD_PERMISSION;
                    }
                    catch (Exception exception) {
                        return SecurityForm.SET_ROLE_METHOD_PERMISSION;
                    }
                }
                return SecurityForm.NO_METHOD_PERMISSION;
            }

            public void setItemValue(String string) {
                EjbSecurityPanel.this.updateMethodPermission(EjbSecurityPanel.this.assemblyDesc, ejb);
                EjbSecurityPanel.this.updateVisualState();
            }
        });
        this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)this.getSetRoleRoleNamesTF(), (ItemEditorHelper.ItemEditorModel)new TextItemEditorModel(xmlMultiViewDataSynchronizer, true, true){
            boolean endsWithComma;
            {
                super(xmlMultiViewDataSynchronizer, bl, bl2);
                this.endsWithComma = false;
            }

            protected String getValue() {
                MethodPermission methodPermission = EjbSecurityPanel.this.getGlobalMethodPermission(ejb);
                try {
                    if (methodPermission != null && !methodPermission.isUnchecked()) {
                        String string = EjbSecurityPanel.this.getCommaSeparatedString(methodPermission.getRoleName());
                        if (this.endsWithComma) {
                            string = string + ",";
                        }
                        return string;
                    }
                    return EjbSecurityPanel.this.getSetRoleRoleNamesTF().getText();
                }
                catch (VersionNotSupportedException versionNotSupportedException) {
                    return "";
                }
            }

            protected void setValue(String string) {
                this.endsWithComma = string != null && string.trim().endsWith(",");
                EjbSecurityPanel.this.updateMethodPermission(EjbSecurityPanel.this.assemblyDesc, ejb);
            }
        }));
        this.updateVisualState();
    }

    public void dataModelPropertyChange(Object object, String string, Object object2, Object object3) {
        this.scheduleRefreshView();
    }

    private void updateSecurityIdentity(Ejb ejb) {
        JRadioButton jRadioButton = this.getNoSecurityIDRB();
        JRadioButton jRadioButton2 = this.getUseCallerIDRB();
        JRadioButton jRadioButton3 = this.getRunAsRB();
        if (jRadioButton.isSelected()) {
            this.removeSecurityIdentity(ejb);
        } else {
            SecurityIdentity securityIdentity = ejb.getSecurityIdentity();
            if (securityIdentity == null) {
                securityIdentity = ejb.newSecurityIdentity();
                ejb.setSecurityIdentity(securityIdentity);
            }
            if (jRadioButton3.isSelected()) {
                RunAs runAs = securityIdentity.getRunAs();
                if (runAs == null) {
                    runAs = securityIdentity.newRunAs();
                    securityIdentity.setRunAs(runAs);
                    this.updateRunAs(runAs);
                }
            } else {
                this.removeRunAs(securityIdentity);
            }
            if (jRadioButton2.isSelected()) {
                securityIdentity.setUseCallerIdentity(true);
            } else {
                securityIdentity.setUseCallerIdentity(false);
            }
        }
    }

    private void removeSecurityIdentity(Ejb ejb) {
        ejb.setSecurityIdentity(null);
    }

    private RunAs getRunAs(Ejb ejb) {
        SecurityIdentity securityIdentity = ejb.getSecurityIdentity();
        if (securityIdentity != null) {
            return securityIdentity.getRunAs();
        }
        return null;
    }

    private void updateRunAs(RunAs runAs) {
        String string = runAs.getRoleName();
        String string2 = this.getRunAsRoleNameTF().getText();
        runAs.setRoleName(string2);
        runAs.setDescription(this.getRunAsDescriptionTF().getText());
    }

    private void removeRunAs(SecurityIdentity securityIdentity) {
        RunAs runAs = securityIdentity.getRunAs();
        if (runAs != null) {
            securityIdentity.setRunAs(null);
        }
    }

    private MethodPermission getGlobalMethodPermission(Ejb ejb) {
        if (this.assemblyDesc == null) {
            return null;
        }
        MethodPermission methodPermission = null;
        MethodPermission[] methodPermissionArray = this.assemblyDesc.getMethodPermission();
        String string = ejb.getEjbName();
        for (int i = 0; i < methodPermissionArray.length; ++i) {
            MethodPermission methodPermission2 = methodPermissionArray[i];
            Method method = methodPermission2.getMethod(0);
            if (method == null) continue;
            String string2 = method.getEjbName();
            String string3 = method.getMethodName();
            if (string2 == null || !string2.equals(string) || string3 == null || !string3.equals(ALL_METHODS)) continue;
            methodPermission = methodPermission2;
            break;
        }
        return methodPermission;
    }

    private MethodPermission createGlobalMethodPermission(Ejb ejb) {
        if (this.assemblyDesc == null) {
            this.assemblyDesc = this.getAssemblyDesc();
        }
        this.methodPermission = this.assemblyDesc.newMethodPermission();
        Method method = this.methodPermission.newMethod();
        method.setEjbName(ejb.getEjbName());
        method.setMethodName(ALL_METHODS);
        this.methodPermission.addMethod(method);
        this.assemblyDesc.addMethodPermission(this.methodPermission);
        return this.methodPermission;
    }

    private void removeGlobalMethodPermission() {
        if (this.methodPermission != null) {
            this.assemblyDesc.removeMethodPermission(this.methodPermission);
            this.methodPermission = null;
        }
    }

    private void updateMethodPermission(AssemblyDescriptor assemblyDescriptor, Ejb ejb) {
        if (this.getNoPermissionRB().isSelected()) {
            this.removeGlobalMethodPermission();
        } else {
            MethodPermission methodPermission = this.getGlobalMethodPermission(ejb);
            if (methodPermission == null) {
                methodPermission = this.createGlobalMethodPermission(ejb);
            }
            if (this.getAllMethodPermissionRB().isSelected()) {
                methodPermission.setRoleName(null);
                try {
                    methodPermission.setUnchecked(true);
                }
                catch (VersionNotSupportedException versionNotSupportedException) {
                    versionNotSupportedException.printStackTrace();
                }
            } else if (this.getSetRolePermissionRB().isSelected()) {
                try {
                    methodPermission.setUnchecked(false);
                }
                catch (VersionNotSupportedException versionNotSupportedException) {
                    versionNotSupportedException.printStackTrace();
                }
                String string = this.getSetRoleRoleNamesTF().getText();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                methodPermission.setRoleName(null);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    if (string2.length() <= 0) continue;
                    methodPermission.addRoleName(string2);
                }
            }
        }
    }

    private String getCommaSeparatedString(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + stringArray[i];
        }
        return string;
    }

    private AssemblyDescriptor getAssemblyDesc() {
        AssemblyDescriptor assemblyDescriptor = this.ejbJar.getSingleAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            assemblyDescriptor = this.ejbJar.newAssemblyDescriptor();
            this.ejbJar.setAssemblyDescriptor(assemblyDescriptor);
        }
        return assemblyDescriptor;
    }
}

