/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;

public class FileCollection {
    private static final char FLAT_FOLDER_MARKER = '*';
    private final Set<File> storage = new HashSet<File>(1);

    public synchronized void load(Preferences preferences, String string) {
        List<String> list = Utils.getStringList(preferences, string);
        this.storage.clear();
        for (String string2 : list) {
            if (string2.charAt(0) == '*') {
                this.storage.add(VersioningSupport.getFlat((String)string2.substring(1)));
                continue;
            }
            this.storage.add(new File(string2));
        }
    }

    public synchronized void save(Preferences preferences, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(this.storage.size());
        for (File file : this.storage) {
            if (VersioningSupport.isFlat((File)file)) {
                arrayList.add('*' + file.getAbsolutePath());
                continue;
            }
            arrayList.add(file.getAbsolutePath());
        }
        Utils.put(preferences, string, arrayList);
    }

    public synchronized boolean contains(File file) {
        for (File file2 : this.storage) {
            if (!Utils.isAncestorOrEqual(file2, file)) continue;
            return true;
        }
        return false;
    }

    public synchronized void add(File file) {
        Iterator<File> iterator = this.storage.iterator();
        while (iterator.hasNext()) {
            File file2 = iterator.next();
            if (Utils.isAncestorOrEqual(file2, file)) {
                return;
            }
            if (!Utils.isAncestorOrEqual(file, file2)) continue;
            iterator.remove();
        }
        this.storage.add(file);
    }

    public synchronized void remove(File file) {
        Iterator<File> iterator = this.storage.iterator();
        while (iterator.hasNext()) {
            File file2 = iterator.next();
            if (!Utils.isAncestorOrEqual(file2, file) && !Utils.isAncestorOrEqual(file, file2)) continue;
            iterator.remove();
        }
    }
}

