/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.openide.awt.UndoRedo;

public class DelegatingUndoRedo
implements UndoRedo,
ChangeListener {
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>(2);
    private UndoRedo delegate = UndoRedo.NONE;

    public void setDiffView(JComponent jComponent) {
        if (jComponent == null) {
            this.setDelegate(UndoRedo.NONE);
        } else {
            UndoRedo undoRedo = (UndoRedo)jComponent.getClientProperty(UndoRedo.class);
            if (undoRedo == null) {
                undoRedo = UndoRedo.NONE;
            }
            this.setDelegate(undoRedo);
        }
    }

    private void setDelegate(UndoRedo undoRedo) {
        if (undoRedo == this.delegate) {
            return;
        }
        this.delegate.removeChangeListener((ChangeListener)this);
        this.delegate = undoRedo;
        this.stateChanged(new ChangeEvent(this));
        this.delegate.addChangeListener((ChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(ChangeEvent changeEvent) {
        List<ChangeListener> list;
        DelegatingUndoRedo delegatingUndoRedo = this;
        synchronized (delegatingUndoRedo) {
            list = this.listeners;
        }
        for (ChangeListener changeListener : list) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public boolean canUndo() {
        return this.delegate.canUndo();
    }

    public boolean canRedo() {
        return this.delegate.canRedo();
    }

    public void undo() throws CannotUndoException {
        this.delegate.undo();
    }

    public void redo() throws CannotRedoException {
        this.delegate.redo();
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>(this.listeners);
        arrayList.add(changeListener);
        this.listeners = arrayList;
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>(this.listeners);
        arrayList.remove(changeListener);
        this.listeners = arrayList;
    }

    public String getUndoPresentationName() {
        return this.delegate.getUndoPresentationName();
    }

    public String getRedoPresentationName() {
        return this.delegate.getRedoPresentationName();
    }
}

