/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.proxy;

public class ConnectivitySettings {
    public static final int CONNECTION_DIRECT = 0;
    public static final int CONNECTION_VIA_SOCKS = 1;
    public static final int CONNECTION_VIA_HTTPS = 2;
    private static final int CONNECTION_TYPE_MIN = 0;
    private static final int CONNECTION_TYPE_MAX = 2;
    private int mConnectionType = 0;
    private String mProxyHost;
    private int mProxyPort;
    private String mProxyUsername;
    private char[] mProxyPassword;
    private int mKeepAliveIntervalSeconds = 60;

    public String toString() {
        return "Type: " + this.mConnectionType + " Proxy: " + this.mProxyUsername + "@" + this.mProxyHost + ":" + this.mProxyPort;
    }

    public void setProxy(int n, String string, int n2, String string2, char[] cArray) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Illegal connection type");
        }
        if (n != 0) {
            if (n2 < 1 || n2 > 65535) {
                throw new IllegalArgumentException("Illegal proxy port number: " + n2);
            }
            if (string == null || (string = string.trim()).length() == 0) {
                throw new IllegalArgumentException("A proxy host must be specified");
            }
        }
        this.mConnectionType = n;
        this.mProxyHost = string;
        this.mProxyPort = n2;
        this.mProxyUsername = string2;
        this.mProxyPassword = cArray;
    }

    public int getKeepAliveIntervalSeconds() {
        return this.mKeepAliveIntervalSeconds;
    }

    public void setKeepAliveIntervalSeconds(int n) {
        this.mKeepAliveIntervalSeconds = n;
    }

    public int getConnectionType() {
        return this.mConnectionType;
    }

    public void setConnectionType(int n) {
        this.mConnectionType = n;
    }

    public String getProxyHost() {
        return this.mProxyHost;
    }

    public void setProxyHost(String string) {
        this.mProxyHost = string;
    }

    public int getProxyPort() {
        return this.mProxyPort;
    }

    public void setProxyPort(int n) {
        this.mProxyPort = n;
    }

    public String getProxyUsername() {
        return this.mProxyUsername;
    }

    public void setProxyUsername(String string) {
        this.mProxyUsername = string;
    }

    public char[] getProxyPassword() {
        return this.mProxyPassword;
    }

    public void setProxyPassword(char[] cArray) {
        this.mProxyPassword = cArray;
    }
}

