/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.options.colors.CategoryComparator;
import org.netbeans.modules.options.colors.CategoryRenderer;
import org.netbeans.modules.options.colors.ColorComboBox;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.ColorValue;
import org.netbeans.modules.options.colors.spi.FontsColorsController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxColoringPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
FontsColorsController {
    private ColorModel.Preview preview;
    private RequestProcessor.Task selectTask;
    private ColorModel colorModel = null;
    private String currentLanguage;
    private String currentProfile;
    private Map<String, Map<String, Vector<AttributeSet>>> profiles = new HashMap<String, Map<String, Vector<AttributeSet>>>();
    private Map<String, Set<String>> toBeSaved = new HashMap<String, Set<String>>();
    private boolean listen = false;
    private JButton bFont;
    private JComboBox cbBackground;
    private JComboBox cbEffectColor;
    private JComboBox cbEffects;
    private JComboBox cbForeground;
    private JComboBox cbLanguage;
    private JLabel lBackground;
    private JList lCategories;
    private JLabel lCategory;
    private JLabel lEffectColor;
    private JLabel lEffects;
    private JLabel lFont;
    private JLabel lForeground;
    private JLabel lLanguage;
    private JLabel lPreview;
    private JPanel pPreview;
    private JScrollPane spCategories;
    private JScrollPane spPreview;
    private JTextField tfFont;
    private boolean blink = true;
    private int blinkSequence = 0;
    private RequestProcessor.Task task = new RequestProcessor("SyntaxColoringPanel").create(new Runnable(){

        public void run() {
            SyntaxColoringPanel.this.updatePreview();
            if (SyntaxColoringPanel.this.blinkSequence == 0) {
                return;
            }
            SyntaxColoringPanel.this.blinkSequence--;
            SyntaxColoringPanel.this.task.schedule(250);
        }
    });
    private Map<String, Map<String, Vector<AttributeSet>>> defaults = new HashMap<String, Map<String, Vector<AttributeSet>>>();
    private static Map<String, String> convertALC = new HashMap<String, String>();
    private static Integer defaultFontSize;

    public SyntaxColoringPanel() {
        this.initComponents();
        this.setName(SyntaxColoringPanel.loc("Syntax_coloring_tab"));
        this.cbLanguage.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Languages"));
        this.cbLanguage.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Languages"));
        this.lCategories.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Categories"));
        this.lCategories.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Categories"));
        this.bFont.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Font"));
        this.bFont.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Font"));
        this.cbForeground.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Foreground_Chooser"));
        this.cbForeground.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Foreground_Chooser"));
        this.cbBackground.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Background_Chooser"));
        this.cbBackground.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Background_Chooser"));
        this.cbEffects.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Efects_Color_Chooser"));
        this.cbEffects.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Efects_Color_Chooser"));
        this.cbEffectColor.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Efects_Color"));
        this.cbEffectColor.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Efects_Color"));
        ColorComboBox.init(this.cbBackground);
        ColorComboBox.init(this.cbForeground);
        ColorComboBox.init(this.cbEffectColor);
        this.cbLanguage.addActionListener(this);
        this.lCategories.setSelectionMode(0);
        this.lCategories.setVisibleRowCount(3);
        this.lCategories.setCellRenderer(new CategoryRenderer());
        this.lCategories.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!SyntaxColoringPanel.this.listen) {
                    return;
                }
                SyntaxColoringPanel.this.selectTask.schedule(200);
            }
        });
        this.tfFont.setEditable(false);
        this.bFont.addActionListener(this);
        this.bFont.setMargin(new Insets(0, 0, 0, 0));
        this.cbForeground.addActionListener(this);
        ((JComponent)((Object)this.cbForeground.getEditor())).addPropertyChangeListener(this);
        this.cbBackground.addActionListener(this);
        ((JComponent)((Object)this.cbBackground.getEditor())).addPropertyChangeListener(this);
        this.cbEffects.addItem(SyntaxColoringPanel.loc("CTL_Effects_None"));
        this.cbEffects.addItem(SyntaxColoringPanel.loc("CTL_Effects_Underlined"));
        this.cbEffects.addItem(SyntaxColoringPanel.loc("CTL_Effects_Wave_Underlined"));
        this.cbEffects.addItem(SyntaxColoringPanel.loc("CTL_Effects_Strike_Through"));
        this.cbEffects.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Effects"));
        this.cbEffects.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Effects"));
        this.cbEffects.addActionListener(this);
        this.cbEffectColor.addActionListener(this);
        SyntaxColoringPanel.loc(this.bFont, "CTL_Font_button");
        SyntaxColoringPanel.loc(this.lBackground, "CTL_Background_label");
        SyntaxColoringPanel.loc(this.lCategory, "CTL_Category");
        SyntaxColoringPanel.loc(this.lEffectColor, "CTL_Effects_color");
        SyntaxColoringPanel.loc(this.lEffects, "CTL_Effects_label");
        SyntaxColoringPanel.loc(this.lFont, "CTL_Font");
        SyntaxColoringPanel.loc(this.lForeground, "CTL_Foreground_label");
        SyntaxColoringPanel.loc(this.lLanguage, "CTL_Languages");
        SyntaxColoringPanel.loc(this.lPreview, "CTL_Preview");
        this.selectTask = new RequestProcessor("SyntaxColoringPanel1").create(new Runnable(){

            public void run() {
                SyntaxColoringPanel.this.refreshUI();
                if (!SyntaxColoringPanel.this.blink) {
                    return;
                }
                SyntaxColoringPanel.this.startBlinking();
            }
        });
    }

    private void initComponents() {
        this.lLanguage = new JLabel();
        this.cbLanguage = new JComboBox();
        this.lCategory = new JLabel();
        this.spCategories = new JScrollPane();
        this.lCategories = new JList();
        this.lPreview = new JLabel();
        this.spPreview = new JScrollPane();
        this.pPreview = new JPanel();
        this.lFont = new JLabel();
        this.lForeground = new JLabel();
        this.lBackground = new JLabel();
        this.lEffects = new JLabel();
        this.lEffectColor = new JLabel();
        this.cbForeground = new JComboBox();
        this.cbBackground = new JComboBox();
        this.cbEffects = new JComboBox();
        this.cbEffectColor = new JComboBox();
        this.tfFont = new JTextField();
        this.bFont = new JButton();
        this.lLanguage.setLabelFor(this.cbLanguage);
        this.lLanguage.setText("Language:");
        this.lCategory.setLabelFor(this.lCategories);
        this.lCategory.setText("Category:");
        this.spCategories.setViewportView(this.lCategories);
        this.lPreview.setText("Preview:");
        this.spPreview.setBorder(BorderFactory.createEtchedBorder());
        this.spPreview.setAutoscrolls(true);
        this.pPreview.setAutoscrolls(true);
        this.pPreview.setLayout(new BorderLayout());
        this.spPreview.setViewportView(this.pPreview);
        this.lFont.setLabelFor(this.bFont);
        this.lFont.setText("Font:");
        this.lForeground.setLabelFor(this.cbForeground);
        this.lForeground.setText("Foreground:");
        this.lBackground.setLabelFor(this.cbBackground);
        this.lBackground.setText("Background:");
        this.lEffects.setLabelFor(this.cbEffects);
        this.lEffects.setText("Effects:");
        this.lEffectColor.setLabelFor(this.cbEffectColor);
        this.lEffectColor.setText("Effect Color:");
        this.bFont.setText("...");
        this.bFont.setMargin(new Insets(2, 2, 2, 2));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.spPreview, -1, 340, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lLanguage).addPreferredGap(0).add((Component)this.cbLanguage, -2, -1, -2)).add((Component)this.lCategory).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.spCategories, -1, 201, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lEffectColor).add((Component)this.lForeground).add((Component)this.lFont).add((Component)this.lEffects).add((Component)this.lBackground)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.tfFont, -1, 13, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.bFont)).add((Component)this.cbForeground, 0, 38, Short.MAX_VALUE).add((Component)this.cbBackground, 0, 38, Short.MAX_VALUE).add((Component)this.cbEffects, 0, 38, Short.MAX_VALUE).add((Component)this.cbEffectColor, 0, 38, Short.MAX_VALUE)).addPreferredGap(0)).add((Component)this.lPreview)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lLanguage).add((Component)this.cbLanguage, -2, -1, -2)).addPreferredGap(0).add((Component)this.lCategory).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.spCategories, -2, 130, -2).addPreferredGap(0).add((Component)this.lPreview)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lFont).add((Component)this.tfFont, -2, -1, -2).add((Component)this.bFont)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lForeground).add((Component)this.cbForeground, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lBackground).add((Component)this.cbBackground, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lEffects).add((Component)this.cbEffects, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lEffectColor).add((Component)this.cbEffectColor, -2, -1, -2)))).addPreferredGap(0).add((Component)this.spPreview, -1, 153, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        if (actionEvent.getSource() == this.cbEffects) {
            this.cbEffectColor.setEnabled(this.cbEffects.getSelectedIndex() > 0);
            if (this.cbEffects.getSelectedIndex() == 0) {
                ColorComboBox.setColor(this.cbEffectColor, null);
            }
            this.updateData();
        } else if (actionEvent.getSource() == this.cbLanguage) {
            this.setCurrentLanguage((String)this.cbLanguage.getSelectedItem());
        } else if (actionEvent.getSource() == this.bFont) {
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(Font.class);
            AttributeSet attributeSet = this.getCurrentCategory();
            Font font = this.getFont(attributeSet);
            propertyEditor.setValue(font);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertyEditor.getCustomEditor(), SyntaxColoringPanel.loc("CTL_Font_Chooser"));
            dialogDescriptor.setOptions(new Object[]{DialogDescriptor.OK_OPTION, SyntaxColoringPanel.loc("CTL_Font_Inherited"), DialogDescriptor.CANCEL_OPTION});
            DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                font = (Font)propertyEditor.getValue();
                attributeSet = this.modifyFont(attributeSet, font);
                this.replaceCurrrentCategory(attributeSet);
                this.setToBeSaved(this.currentProfile, this.currentLanguage);
                this.refreshUI();
            } else if (dialogDescriptor.getValue().equals(SyntaxColoringPanel.loc("CTL_Font_Inherited"))) {
                Integer n;
                String string = (String)this.getDefault(this.currentLanguage, attributeSet, StyleConstants.FontFamily);
                int n2 = 0;
                if (Boolean.TRUE.equals(this.getDefault(this.currentLanguage, attributeSet, StyleConstants.Bold))) {
                    ++n2;
                }
                if (Boolean.TRUE.equals(this.getDefault(this.currentLanguage, attributeSet, StyleConstants.Italic))) {
                    n2 += 2;
                }
                font = new Font(string, n2, (n = (Integer)this.getDefault(this.currentLanguage, attributeSet, StyleConstants.FontSize)) == null ? SyntaxColoringPanel.getDefaultFontSize() : n);
                attributeSet = this.modifyFont(attributeSet, font);
                this.replaceCurrrentCategory(attributeSet);
                this.setToBeSaved(this.currentProfile, this.currentLanguage);
                this.refreshUI();
            }
        } else if (actionEvent.getSource() instanceof JComboBox) {
            this.updateData();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.listen || propertyChangeEvent.getPropertyName() == null) {
            return;
        }
        if ("currentAElement".equals(propertyChangeEvent.getPropertyName())) {
            String string;
            String string2 = (String)propertyChangeEvent.getNewValue();
            Vector<AttributeSet> vector = this.getCategories(this.currentProfile, this.currentLanguage);
            if (this.currentLanguage.equals(ColorModel.ALL_LANGUAGES) && (string = convertALC.get(string2)) != null) {
                string2 = string;
            }
            for (int i = 0; i < vector.size(); ++i) {
                AttributeSet attributeSet = vector.get(i);
                if (!string2.equals(attributeSet.getAttribute(StyleConstants.NameAttribute))) continue;
                this.blink = false;
                this.lCategories.setSelectedIndex(i);
                this.lCategories.ensureIndexIsVisible(i);
                this.blink = true;
                break;
            }
        } else if ("color".equals(propertyChangeEvent.getPropertyName())) {
            this.updateData();
        }
    }

    @Override
    public void update(ColorModel colorModel) {
        this.colorModel = colorModel;
        this.currentProfile = colorModel.getCurrentProfile();
        this.currentLanguage = ColorModel.ALL_LANGUAGES;
        if (this.preview != null) {
            this.preview.removePropertyChangeListener("currentAElement", this);
        }
        Component component = colorModel.getSyntaxColoringPreviewComponent(this.currentLanguage);
        this.preview = (ColorModel.Preview)component;
        this.pPreview.removeAll();
        this.pPreview.add("Center", component);
        this.preview.addPropertyChangeListener("currentAElement", this);
        this.listen = false;
        ArrayList<String> arrayList = new ArrayList<String>(colorModel.getLanguages());
        Collections.sort(arrayList, new LanguagesComparator());
        Iterator iterator = arrayList.iterator();
        Object object = this.cbLanguage.getSelectedItem();
        this.cbLanguage.removeAllItems();
        while (iterator.hasNext()) {
            this.cbLanguage.addItem(iterator.next());
        }
        this.listen = true;
        if (object != null) {
            this.cbLanguage.setSelectedItem(object);
        } else {
            this.cbLanguage.setSelectedIndex(0);
        }
    }

    @Override
    public void cancel() {
        this.toBeSaved = new HashMap<String, Set<String>>();
        this.profiles = new HashMap<String, Map<String, Vector<AttributeSet>>>();
    }

    @Override
    public void applyChanges() {
        if (this.colorModel == null) {
            return;
        }
        for (String string : this.toBeSaved.keySet()) {
            Set<String> set = this.toBeSaved.get(string);
            Map<String, Vector<AttributeSet>> map = this.profiles.get(string);
            for (String string2 : set) {
                this.colorModel.setCategories(string, string2, (Collection<AttributeSet>)map.get(string2));
            }
        }
        this.toBeSaved = new HashMap<String, Set<String>>();
        this.profiles = new HashMap<String, Map<String, Vector<AttributeSet>>>();
    }

    @Override
    public boolean isChanged() {
        return !this.toBeSaved.isEmpty();
    }

    @Override
    public void setCurrentProfile(String string) {
        String string2 = this.currentProfile;
        this.currentProfile = string;
        if (!this.colorModel.getProfiles().contains(string) && !this.profiles.containsKey(string)) {
            this.cloneScheme(string2, string);
        }
        Vector<AttributeSet> vector = this.getCategories(string, this.currentLanguage);
        this.lCategories.setListData(vector);
        this.blink = false;
        this.lCategories.setSelectedIndex(0);
        this.blink = true;
        this.refreshUI();
    }

    @Override
    public void deleteProfile(String string) {
        HashMap<String, Vector<AttributeSet>> hashMap = new HashMap<String, Vector<AttributeSet>>();
        boolean bl = this.colorModel.isCustomProfile(string);
        for (String string2 : this.colorModel.getLanguages()) {
            if (bl) {
                hashMap.put(string2, null);
                continue;
            }
            hashMap.put(string2, this.getDefaults(string, string2));
        }
        this.profiles.put(string, hashMap);
        this.toBeSaved.put(string, new HashSet<String>(this.colorModel.getLanguages()));
        if (!bl) {
            this.refreshUI();
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    private void cloneScheme(String string, String string2) {
        HashMap hashMap = new HashMap();
        for (String string3 : this.colorModel.getLanguages()) {
            Vector<AttributeSet> vector = this.getCategories(string, string3);
            Vector<SimpleAttributeSet> vector2 = new Vector<SimpleAttributeSet>();
            for (AttributeSet attributeSet : vector) {
                vector2.add(new SimpleAttributeSet(attributeSet));
            }
            hashMap.put(string3, new Vector(vector2));
            this.setToBeSaved(string2, string3);
        }
        this.profiles.put(string2, hashMap);
    }

    Collection<AttributeSet> getAllLanguages() {
        return this.getCategories(this.currentProfile, ColorModel.ALL_LANGUAGES);
    }

    Collection<AttributeSet> getSyntaxColorings() {
        return this.getCategories(this.currentProfile, this.currentLanguage);
    }

    private void setCurrentLanguage(String string) {
        this.currentLanguage = string;
        this.blink = false;
        this.lCategories.setListData(this.getCategories(this.currentProfile, this.currentLanguage));
        this.lCategories.setSelectedIndex(0);
        this.blink = true;
        this.refreshUI();
    }

    private static String loc(String string) {
        return NbBundle.getMessage(SyntaxColoringPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)SyntaxColoringPanel.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)SyntaxColoringPanel.loc(string));
        }
    }

    private void updateData() {
        int n = this.lCategories.getSelectedIndex();
        if (n < 0) {
            return;
        }
        AttributeSet attributeSet = this.getCurrentCategory();
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        if (this.cbEffects.getSelectedIndex() == 1) {
            color = ColorComboBox.getColor(this.cbEffectColor);
        }
        if (this.cbEffects.getSelectedIndex() == 2) {
            color2 = ColorComboBox.getColor(this.cbEffectColor);
        }
        if (this.cbEffects.getSelectedIndex() == 3) {
            color3 = ColorComboBox.getColor(this.cbEffectColor);
        }
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
        Color color4 = ColorComboBox.getColor(this.cbBackground);
        if (color4 != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Background, color4);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Background);
        }
        color4 = ColorComboBox.getColor(this.cbForeground);
        if (color4 != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Foreground, color4);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Foreground);
        }
        if (color != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Underline, color);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Underline);
        }
        if (color3 != null) {
            simpleAttributeSet.addAttribute(StyleConstants.StrikeThrough, color3);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.StrikeThrough);
        }
        if (color2 != null) {
            simpleAttributeSet.addAttribute(EditorStyleConstants.WaveUnderlineColor, color2);
        } else {
            simpleAttributeSet.removeAttribute(EditorStyleConstants.WaveUnderlineColor);
        }
        this.replaceCurrrentCategory(simpleAttributeSet);
        this.setToBeSaved(this.currentProfile, this.currentLanguage);
        this.updatePreview();
    }

    private void startBlinking() {
        this.blinkSequence = 5;
        this.task.schedule(0);
    }

    private void updatePreview() {
        Collection<AttributeSet> collection = this.getSyntaxColorings();
        Collection<AttributeSet> collection2 = this.getAllLanguages();
        if (this.blinkSequence % 2 == 1) {
            if (ColorModel.ALL_LANGUAGES.equals(this.currentLanguage)) {
                collection2 = this.invertCategory(collection2, this.getCurrentCategory());
            } else {
                collection = this.invertCategory(collection, this.getCurrentCategory());
            }
        }
        this.preview.setParameters(this.currentLanguage, collection2, Collections.<AttributeSet>emptySet(), collection);
    }

    private Collection<AttributeSet> invertCategory(Collection<AttributeSet> collection, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return collection;
        }
        ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>(collection);
        int n = arrayList.indexOf(attributeSet);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
        Color color = (Color)this.getValue(this.currentLanguage, attributeSet, StyleConstants.Background);
        if (color == null) {
            return arrayList;
        }
        Color color2 = new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
        simpleAttributeSet.addAttribute(StyleConstants.Underline, color2);
        arrayList.set(n, simpleAttributeSet);
        return arrayList;
    }

    private void refreshUI() {
        this.listen = false;
        AttributeSet attributeSet = this.getCurrentCategory();
        if (attributeSet == null) {
            this.tfFont.setText("");
            this.bFont.setEnabled(false);
            this.cbEffects.setEnabled(false);
            this.cbForeground.setEnabled(false);
            this.cbForeground.setSelectedItem(new ColorValue(null, null));
            this.cbBackground.setEnabled(false);
            this.cbBackground.setSelectedItem(new ColorValue(null, null));
            this.cbEffectColor.setEnabled(false);
            this.cbEffectColor.setSelectedItem(new ColorValue(null, null));
            this.updatePreview();
            return;
        }
        this.bFont.setEnabled(true);
        this.cbEffects.setEnabled(true);
        this.cbForeground.setEnabled(true);
        this.cbBackground.setEnabled(true);
        Color color = (Color)this.getDefault(this.currentLanguage, attributeSet, StyleConstants.Foreground);
        if (color == null) {
            color = Color.black;
        }
        ColorComboBox.setInheritedColor(this.cbForeground, color);
        Color color2 = (Color)this.getDefault(this.currentLanguage, attributeSet, StyleConstants.Background);
        if (color2 == null) {
            color2 = Color.white;
        }
        ColorComboBox.setInheritedColor(this.cbBackground, color2);
        String string = this.fontToString(attributeSet);
        this.tfFont.setText(string);
        ColorComboBox.setColor(this.cbForeground, (Color)attributeSet.getAttribute(StyleConstants.Foreground));
        ColorComboBox.setColor(this.cbBackground, (Color)attributeSet.getAttribute(StyleConstants.Background));
        if (attributeSet.getAttribute(StyleConstants.Underline) != null) {
            this.cbEffects.setSelectedIndex(1);
            this.cbEffectColor.setEnabled(true);
            ColorComboBox.setColor(this.cbEffectColor, (Color)attributeSet.getAttribute(StyleConstants.Underline));
        } else if (attributeSet.getAttribute(EditorStyleConstants.WaveUnderlineColor) != null) {
            this.cbEffects.setSelectedIndex(2);
            this.cbEffectColor.setEnabled(true);
            ColorComboBox.setColor(this.cbEffectColor, (Color)attributeSet.getAttribute(EditorStyleConstants.WaveUnderlineColor));
        } else if (attributeSet.getAttribute(StyleConstants.StrikeThrough) != null) {
            this.cbEffects.setSelectedIndex(3);
            this.cbEffectColor.setEnabled(true);
            ColorComboBox.setColor(this.cbEffectColor, (Color)attributeSet.getAttribute(StyleConstants.StrikeThrough));
        } else {
            this.cbEffects.setSelectedIndex(0);
            this.cbEffectColor.setEnabled(false);
            this.cbEffectColor.setSelectedItem(new ColorValue(null, null));
        }
        this.updatePreview();
        this.listen = true;
    }

    private void setToBeSaved(String string, String string2) {
        Set<String> set = this.toBeSaved.get(string);
        if (set == null) {
            set = new HashSet<String>();
            this.toBeSaved.put(string, set);
        }
        set.add(string2);
    }

    private Vector<AttributeSet> getCategories(String string, String string2) {
        Vector<AttributeSet> vector;
        if (this.colorModel == null) {
            return null;
        }
        Map<String, Vector<AttributeSet>> map = this.profiles.get(string);
        if (map == null) {
            map = new HashMap<String, Vector<AttributeSet>>();
            this.profiles.put(string, map);
        }
        if ((vector = map.get(string2)) == null) {
            Collection<AttributeSet> collection = this.colorModel.getCategories(string, string2);
            if (collection == null) {
                collection = Collections.emptySet();
            }
            ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>(collection);
            Collections.sort(arrayList, new CategoryComparator());
            vector = new Vector<AttributeSet>(arrayList);
            map.put(string2, vector);
        }
        return vector;
    }

    private Vector<AttributeSet> getDefaults(String string, String string2) {
        Vector<AttributeSet> vector;
        Map<String, Vector<AttributeSet>> map = this.defaults.get(string);
        if (map == null) {
            map = new HashMap<String, Vector<AttributeSet>>();
            this.defaults.put(string, map);
        }
        if ((vector = map.get(string2)) == null) {
            Collection<AttributeSet> collection = this.colorModel.getDefaults(string, string2);
            ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>(collection);
            Collections.sort(arrayList, new CategoryComparator());
            vector = new Vector<AttributeSet>(arrayList);
            map.put(string2, vector);
        }
        return new Vector<AttributeSet>(vector);
    }

    private AttributeSet getCurrentCategory() {
        int n = this.lCategories.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.getCategories(this.currentProfile, this.currentLanguage).get(n);
    }

    private void replaceCurrrentCategory(AttributeSet attributeSet) {
        int n = this.lCategories.getSelectedIndex();
        this.getCategories(this.currentProfile, this.currentLanguage).set(n, attributeSet);
    }

    private AttributeSet getCategory(String string, String string2, String string3) {
        Vector<AttributeSet> vector = this.getCategories(string, string2);
        for (AttributeSet attributeSet : vector) {
            if (!attributeSet.getAttribute(StyleConstants.NameAttribute).equals(string3)) continue;
            return attributeSet;
        }
        return null;
    }

    private Object getValue(String string, AttributeSet attributeSet, Object object) {
        if (attributeSet.isDefined(object)) {
            return attributeSet.getAttribute(object);
        }
        return this.getDefault(string, attributeSet, object);
    }

    private Object getDefault(String string, AttributeSet attributeSet, Object object) {
        AttributeSet attributeSet2;
        String string2 = (String)attributeSet.getAttribute(EditorStyleConstants.Default);
        if (string2 == null) {
            string2 = "default";
        }
        if (!string2.equals(attributeSet.getAttribute(StyleConstants.NameAttribute)) && (attributeSet2 = this.getCategory(this.currentProfile, string, string2)) != null) {
            return this.getValue(string, attributeSet2, object);
        }
        if (!string.equals(ColorModel.ALL_LANGUAGES) && (attributeSet2 = this.getCategory(this.currentProfile, ColorModel.ALL_LANGUAGES, string2)) != null) {
            return this.getValue(ColorModel.ALL_LANGUAGES, attributeSet2, object);
        }
        if (object == StyleConstants.FontFamily) {
            return "Monospaced";
        }
        if (object == StyleConstants.FontSize) {
            return SyntaxColoringPanel.getDefaultFontSize();
        }
        return null;
    }

    private Font getFont(AttributeSet attributeSet) {
        int n;
        Boolean bl;
        Boolean bl2;
        Integer n2;
        String string = (String)this.getValue(this.currentLanguage, attributeSet, StyleConstants.FontFamily);
        if (string == null) {
            string = "Monospaced";
        }
        if ((n2 = (Integer)this.getValue(this.currentLanguage, attributeSet, StyleConstants.FontSize)) == null) {
            n2 = SyntaxColoringPanel.getDefaultFontSize();
        }
        if ((bl2 = (Boolean)this.getValue(this.currentLanguage, attributeSet, StyleConstants.Bold)) == null) {
            bl2 = Boolean.FALSE;
        }
        if ((bl = (Boolean)this.getValue(this.currentLanguage, attributeSet, StyleConstants.Italic)) == null) {
            bl = Boolean.FALSE;
        }
        int n3 = n = bl2 != false ? 1 : 0;
        if (bl.booleanValue()) {
            n += 2;
        }
        return new Font(string, n, n2);
    }

    private AttributeSet modifyFont(AttributeSet attributeSet, Font font) {
        String string = font.getName();
        Integer n = new Integer(font.getSize());
        Boolean bl = font.isBold();
        Boolean bl2 = font.isItalic();
        boolean bl3 = "default".equals(attributeSet.getAttribute(StyleConstants.NameAttribute));
        if (string.equals(this.getDefault(this.currentLanguage, attributeSet, StyleConstants.FontFamily)) && !bl3) {
            string = null;
        }
        if (n.equals(this.getDefault(this.currentLanguage, attributeSet, StyleConstants.FontSize)) && !bl3) {
            n = null;
        }
        if (bl.equals(this.getDefault(this.currentLanguage, attributeSet, StyleConstants.Bold))) {
            bl = null;
        } else if (bl.equals(Boolean.FALSE) && this.getDefault(this.currentLanguage, attributeSet, StyleConstants.Bold) == null) {
            bl = null;
        }
        if (bl2.equals(this.getDefault(this.currentLanguage, attributeSet, StyleConstants.Italic))) {
            bl2 = null;
        } else if (bl2.equals(Boolean.FALSE) && this.getDefault(this.currentLanguage, attributeSet, StyleConstants.Italic) == null) {
            bl2 = null;
        }
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
        if (string != null) {
            simpleAttributeSet.addAttribute(StyleConstants.FontFamily, string);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.FontFamily);
        }
        if (n != null) {
            simpleAttributeSet.addAttribute(StyleConstants.FontSize, n);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.FontSize);
        }
        if (bl != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Bold, bl);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Bold);
        }
        if (bl2 != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Italic, bl2);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Italic);
        }
        return simpleAttributeSet;
    }

    private String fontToString(AttributeSet attributeSet) {
        if ("default".equals(attributeSet.getAttribute(StyleConstants.NameAttribute))) {
            Boolean bl;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getValue(this.currentLanguage, attributeSet, StyleConstants.FontFamily));
            stringBuffer.append(' ');
            stringBuffer.append(this.getValue(this.currentLanguage, attributeSet, StyleConstants.FontSize));
            Boolean bl2 = (Boolean)this.getValue(this.currentLanguage, attributeSet, StyleConstants.Bold);
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append(' ').append(SyntaxColoringPanel.loc("CTL_Bold"));
            }
            if ((bl = (Boolean)this.getValue(this.currentLanguage, attributeSet, StyleConstants.Italic)) != null && bl.booleanValue()) {
                stringBuffer.append(' ').append(SyntaxColoringPanel.loc("CTL_Italic"));
            }
            return stringBuffer.toString();
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (attributeSet.getAttribute(StyleConstants.FontFamily) != null) {
            stringBuffer.append('+').append(attributeSet.getAttribute(StyleConstants.FontFamily));
        } else {
            bl = true;
        }
        if (attributeSet.getAttribute(StyleConstants.FontSize) != null) {
            stringBuffer.append('+').append(attributeSet.getAttribute(StyleConstants.FontSize));
        } else {
            bl = true;
        }
        if (Boolean.TRUE.equals(attributeSet.getAttribute(StyleConstants.Bold))) {
            stringBuffer.append('+').append(SyntaxColoringPanel.loc("CTL_Bold"));
        }
        if (Boolean.FALSE.equals(attributeSet.getAttribute(StyleConstants.Bold))) {
            stringBuffer.append('-').append(SyntaxColoringPanel.loc("CTL_Bold"));
        }
        if (Boolean.TRUE.equals(attributeSet.getAttribute(StyleConstants.Italic))) {
            stringBuffer.append('+').append(SyntaxColoringPanel.loc("CTL_Italic"));
        }
        if (Boolean.FALSE.equals(attributeSet.getAttribute(StyleConstants.Italic))) {
            stringBuffer.append('-').append(SyntaxColoringPanel.loc("CTL_Italic"));
        }
        if (bl) {
            stringBuffer.insert(0, SyntaxColoringPanel.loc("CTL_Inherited"));
            return stringBuffer.toString();
        }
        String string = stringBuffer.toString();
        return string.replace('+', ' ');
    }

    private static Integer getDefaultFontSize() {
        if (defaultFontSize == null && (defaultFontSize = (Integer)UIManager.get("customFontSize")) == null) {
            int n = UIManager.getFont("TextField.font").getSize();
            if (n < 12) {
                n = 12;
            }
            defaultFontSize = new Integer(n);
        }
        return defaultFontSize;
    }

    static {
        convertALC.put("character", "char");
        convertALC.put("errors", "error");
        convertALC.put("literal", "keyword");
        convertALC.put("keyword-directive", "keyword");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LanguagesComparator
    implements Comparator<String> {
        private LanguagesComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            if (string.equals(ColorModel.ALL_LANGUAGES)) {
                return string2.equals(ColorModel.ALL_LANGUAGES) ? 0 : -1;
            }
            if (string2.equals(ColorModel.ALL_LANGUAGES)) {
                return 1;
            }
            return string.compareTo(string2);
        }
    }
}

