/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.CodeTemplateDescription;
import org.netbeans.api.editor.settings.CodeTemplateSettings;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.WeakEventListenerList;
import org.netbeans.modules.editor.lib.KitsTracker;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Settings {
    private static final Logger LOG = Logger.getLogger(Settings.class.getName());
    private static final boolean LOG_STACTRACES = Boolean.getBoolean(Settings.class.getName() + ".stacktraces");
    public static final int CORE_LEVEL = 0;
    public static final int SYSTEM_LEVEL = 1;
    public static final int EXTENSION_LEVEL = 2;
    public static final int OPTION_LEVEL = 3;
    public static final int USER_LEVEL = 4;
    private static final ArrayList initializerLists = new ArrayList();
    private static long initializerListsVersion = 0L;
    private static List[] listsOfInitializers = null;
    private static long listsOfInitializersVersion = -1L;
    private static InitializerSorter currentInitializerSorter;
    private static final Filter[] NULL_FILTERS;
    private static final String FILTERS_LOCK;
    private static volatile Filter[] filters;
    private static final Map kit2Maps;
    private static final WeakEventListenerList listenerList;
    private static volatile int firingEnabled;
    private static final HashMap emptyMaps;
    private static final RequestProcessor PROCESSOR;
    private static final RequestProcessor.Task RESET_TASK;
    private static final Map<MimePath, ChangesTrackingLookupResult<FontColorSettings>> FCS_CACHE;
    private static final Set<String> HIGHLIGHT_COLOR_NAMES;
    private static final Set<String> HIGHLIGHT_COLORING_NAMES;
    private static final Map<MimePath, ChangesTrackingLookupResult<KeyBindingSettings>> KBS_CACHE;
    private static final Map<MimePath, ChangesTrackingLookupResult<CodeTemplateSettings>> CTS_CACHE;
    private static final Map<MimePath, PreferenceChangesTracker> PREFS_CACHE;
    private static final String METHOD_VALUE = "methodvalue";
    private static final String JAVATYPE_KEY_PREFIX = "nbeditor-javaType-for-legacy-setting_";

    private Settings() {
    }

    public static void addInitializer(Initializer initializer) {
        Settings.addInitializer(initializer, 1);
        Settings.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInitializer(Initializer initializer, int n) {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            int n2;
            for (int i = n2 = initializerLists.size(); i <= n; ++i) {
                initializerLists.add(new ArrayList());
            }
            ((List)initializerLists.get(n)).add(initializer);
            if (currentInitializerSorter != null) {
                currentInitializerSorter.sort(initializerLists);
            }
            ++initializerListsVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInitializer(String string) {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            Iterator iterator = initializerLists.iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = ((List)iterator.next()).iterator();
                while (iterator2.hasNext()) {
                    if (!string.equals(((Initializer)iterator2.next()).getName())) continue;
                    iterator2.remove();
                }
            }
            if (currentInitializerSorter != null) {
                currentInitializerSorter.sort(initializerLists);
            }
            ++initializerListsVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InitializerSorter getInitializerSorter() {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            return currentInitializerSorter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInitializerSorter(InitializerSorter initializerSorter) {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            currentInitializerSorter = initializerSorter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List[] getListsOfInitializers() {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            if (listsOfInitializersVersion != initializerListsVersion) {
                List[] listArray = initializerLists.toArray(new List[initializerLists.size()]);
                for (int i = 0; i < listArray.length; ++i) {
                    listArray[i] = Collections.unmodifiableList(new ArrayList(listArray[i]));
                }
                listsOfInitializers = listArray;
                listsOfInitializersVersion = initializerListsVersion;
            }
            return listsOfInitializers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFilter(Filter filter) {
        String string = FILTERS_LOCK;
        synchronized (string) {
            if (filters.length == 0) {
                filters = new Filter[]{filter};
            } else {
                Filter[] filterArray = new Filter[filters.length + 1];
                System.arraycopy(filters, 0, filterArray, 0, filters.length);
                filterArray[Settings.filters.length] = filter;
                filters = filterArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFilter(Filter filter) {
        String string = FILTERS_LOCK;
        synchronized (string) {
            if (filters.length == 0) {
                return;
            }
            if (filters.length == 1 && filters[0] == filter) {
                filters = NULL_FILTERS;
            } else {
                int n = -1;
                for (int i = 0; i < filters.length; ++i) {
                    if (filters[i] != filter) continue;
                    n = i;
                    break;
                }
                if (n != -1) {
                    Filter[] filterArray = new Filter[filters.length - 1];
                    System.arraycopy(filters, 0, filterArray, 0, n);
                    if (n < filterArray.length) {
                        System.arraycopy(filters, n + 1, filterArray, n, filterArray.length - n);
                    }
                    filters = filterArray;
                }
            }
        }
    }

    public static Object getValue(Class clazz, String string) {
        return Settings.getValue(clazz, string, true);
    }

    public static Object getValue(Class clazz, String string, boolean bl) {
        String string2 = KitsTracker.getInstance().findMimeType(clazz);
        MimePath mimePath = string2 == null ? MimePath.EMPTY : MimePath.parse((String)string2);
        Object object = Settings.getValueEx(mimePath, clazz, string, bl);
        Filter[] filterArray = filters;
        for (int i = 0; i < filterArray.length; ++i) {
            object = filterArray[i].filterValue(clazz, string, object);
        }
        return object;
    }

    private static Object getValueEx(MimePath mimePath, Class clazz, String string, boolean bl) {
        Object object = null;
        boolean bl2 = false;
        if (string != null && "abbrev-map".equals(string)) {
            Object object2 = Settings.getValueOld(clazz, "abbrev-map", true);
            Map<String, String> map = Settings.findCodeTemplates(mimePath);
            if (object2 instanceof Map) {
                object = new HashMap((Map)object2);
                ((Map)object).putAll(map);
            } else {
                object = map;
            }
            bl2 = true;
        } else if (string != null && "key-bindings".equals(string)) {
            Object object3 = Settings.getValueOld(clazz, "key-bindings", true);
            List<MultiKeyBinding> list = Settings.findKeyBindings(mimePath);
            if (object3 instanceof List) {
                object = new ArrayList((List)object3);
                ((List)object).addAll(list);
            } else {
                object = list;
            }
            bl2 = true;
        } else if (string != null && "macro-map".equals(string)) {
            Object object4 = Settings.getValueOld(clazz, "macro-map", true);
            Map<String, String> map = Settings.findMacros(mimePath);
            if (object4 instanceof Map) {
                object = new HashMap((Map)object4);
                ((Map)object).putAll(map);
            } else {
                object = map;
            }
            bl2 = true;
        } else {
            Object object5;
            if (string != null && HIGHLIGHT_COLOR_NAMES.contains(string)) {
                object = Settings.findColor(string, mimePath);
                bl2 = true;
            } else if (string != null && HIGHLIGHT_COLORING_NAMES.contains(string)) {
                object = Settings.findColoring(string, mimePath, false, true);
                bl2 = true;
            } else {
                object5 = Settings.translateOldTokenColoringName(string);
                if (object5 != null) {
                    object = Settings.findColoring((String)object5, mimePath, true, true);
                    bl2 = true;
                }
            }
            if (!bl2 && (object5 = Settings.findPreferences(mimePath)) != null && null != ((Preferences)object5).get(string, null)) {
                Class clazz2 = null;
                String string2 = ((Preferences)object5).get(JAVATYPE_KEY_PREFIX + string, null);
                if (string2 != null) {
                    if (string2.equals(METHOD_VALUE)) {
                        object = Settings.methodFactory(((Preferences)object5).get(string, null), mimePath);
                        bl2 = true;
                    } else {
                        clazz2 = Settings.typeFromString(string2);
                    }
                }
                if (!bl2) {
                    if (clazz2 != null) {
                        if (clazz2.equals(Boolean.class)) {
                            object = ((Preferences)object5).getBoolean(string, false);
                            bl2 = true;
                        } else if (clazz2.equals(Integer.class)) {
                            object = ((Preferences)object5).getInt(string, 0);
                            bl2 = true;
                        } else if (clazz2.equals(Long.class)) {
                            object = ((Preferences)object5).getLong(string, 0L);
                            bl2 = true;
                        } else if (clazz2.equals(Float.class)) {
                            object = Float.valueOf(((Preferences)object5).getFloat(string, 0.0f));
                            bl2 = true;
                        } else if (clazz2.equals(Double.class)) {
                            object = ((Preferences)object5).getDouble(string, 0.0);
                            bl2 = true;
                        } else if (clazz2.equals(Insets.class)) {
                            object = Settings.parseInsets(((Preferences)object5).get(string, null));
                            bl2 = true;
                        } else if (clazz2.equals(Dimension.class)) {
                            object = Settings.parseDimension(((Preferences)object5).get(string, null));
                            bl2 = true;
                        } else if (clazz2.equals(Color.class)) {
                            object = Settings.parseColor(((Preferences)object5).get(string, null));
                            bl2 = true;
                        } else if (clazz2.equals(String.class)) {
                            object = ((Preferences)object5).get(string, null);
                            bl2 = true;
                        } else {
                            LOG.log(Level.WARNING, "Can't load setting '" + string + "' with value '" + ((Preferences)object5).get(string, null) + "' through org.netbeans.editor.Settings! Unsupported value conversion to " + clazz2, new Throwable("Stacktrace"));
                        }
                    } else {
                        LOG.warning("Can't determine type of '" + string + "' editor setting. If you supplied this setting" + " through the editor implementation of java.util.prefs.Preferences you should use the 'javaType'" + " attribute and specify the class representing values of this setting. There seem to be legacy" + " clients accessing your setting through the old org.netbeans.editor.Settings.");
                    }
                }
            }
        }
        if (!bl2) {
            object = Settings.getValueOld(clazz, string, bl);
        }
        return object;
    }

    private static Object getValueOld(Class clazz, String string, boolean bl) {
        Object object = null;
        List list = Settings.getAllKitMaps(clazz);
        assert (list.size() % 2 == 0) : "allKitMaps should contain pairs of [kitClass, settingsMap].";
        for (int i = 0; i < list.size() / 2; ++i) {
            Class clazz2 = (Class)list.get(2 * i);
            Map map = (Map)list.get(2 * i + 1);
            object = map.get(string);
            if (bl && object instanceof Evaluator) {
                object = ((Evaluator)object).getValue(clazz2, string);
            }
            if (object != null) break;
        }
        return object;
    }

    public static KitAndValue[] getValueHierarchy(Class clazz, String string) {
        return Settings.getValueHierarchy(clazz, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KitAndValue[] getValueHierarchy(Class kitAndValueArray, String string, boolean bl) {
        Filter[] filterArray;
        Object object;
        ArrayList<KitAndValue> arrayList = new ArrayList<KitAndValue>();
        boolean bl2 = false;
        try {
            for (object = kitAndValueArray; object != null; object = object.getSuperclass()) {
                filterArray = KitsTracker.getInstance().findMimeType((Class)object);
                MimePath mimePath = filterArray == null ? MimePath.EMPTY : MimePath.parse((String)filterArray);
                Object object2 = Settings.getValueEx(mimePath, (Class)object, string, bl);
                if (object2 != null) {
                    arrayList.add(new KitAndValue((Class)object, object2));
                }
                if (mimePath == MimePath.EMPTY) {
                    break;
                }
                if (bl2) continue;
                bl2 = true;
                KitsTracker.getInstance().setContextMimeType("");
            }
        }
        finally {
            if (bl2) {
                KitsTracker.getInstance().setContextMimeType(null);
            }
        }
        object = arrayList.toArray(new KitAndValue[arrayList.size()]);
        filterArray = filters;
        for (int i = 0; i < filterArray.length; ++i) {
            object = filterArray[i].filterValueHierarchy((Class)kitAndValueArray, string, (KitAndValue[])object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void setValue(Class clazz, String string, Object object) {
        block17: {
            boolean bl;
            block15: {
                block21: {
                    Preferences preferences;
                    block22: {
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        block25: {
                                            block24: {
                                                block23: {
                                                    block20: {
                                                        block19: {
                                                            block18: {
                                                                block16: {
                                                                    if (string == null || !"abbrev-map".equals(string)) break block16;
                                                                    LOG.log(Level.WARNING, "Can't save 'SettingsNames.ABBREV_MAP' setting through org.netbeans.editor.Settings!", new Throwable("Stacktrace"));
                                                                    break block17;
                                                                }
                                                                if (string == null || !"key-bindings".equals(string)) break block18;
                                                                LOG.log(Level.WARNING, "Can't save 'SettingsNames.KEY_BINDING_LIST' setting through org.netbeans.editor.Settings!", new Throwable("Stacktrace"));
                                                                break block17;
                                                            }
                                                            if (string == null || !"macro-map".equals(string)) break block19;
                                                            LOG.log(Level.WARNING, "Can't save 'SettingsNames.MACRO_MAP' setting through org.netbeans.editor.Settings!", new Throwable("Stacktrace"));
                                                            break block17;
                                                        }
                                                        boolean bl2 = false;
                                                        if (string != null && HIGHLIGHT_COLOR_NAMES.contains(string)) {
                                                            bl2 = true;
                                                        } else if (string != null && HIGHLIGHT_COLORING_NAMES.contains(string)) {
                                                            bl2 = true;
                                                        } else {
                                                            String string2 = Settings.translateOldTokenColoringName(string);
                                                            if (string2 != null) {
                                                                bl2 = true;
                                                            }
                                                        }
                                                        if (!bl2) break block20;
                                                        LOG.log(Level.WARNING, "Can't save coloring '" + string + "' through org.netbeans.editor.Settings!", new Throwable("Stacktrace"));
                                                        break block17;
                                                    }
                                                    bl = false;
                                                    String string3 = KitsTracker.getInstance().findMimeType(clazz);
                                                    MimePath mimePath = string3 == null ? MimePath.EMPTY : MimePath.parse((String)string3);
                                                    preferences = Settings.findPreferences(mimePath);
                                                    if (preferences == null) break block21;
                                                    if (object == null) break block22;
                                                    if (!(object instanceof Boolean)) break block23;
                                                    preferences.putBoolean(string, (Boolean)object);
                                                    break block15;
                                                }
                                                if (!(object instanceof Integer)) break block24;
                                                preferences.putInt(string, (Integer)object);
                                                break block15;
                                            }
                                            if (!(object instanceof Long)) break block25;
                                            preferences.putLong(string, (Long)object);
                                            break block15;
                                        }
                                        if (!(object instanceof Float)) break block26;
                                        preferences.putFloat(string, ((Float)object).floatValue());
                                        break block15;
                                    }
                                    if (!(object instanceof Double)) break block27;
                                    preferences.putDouble(string, (Double)object);
                                    break block15;
                                }
                                if (!(object instanceof Insets)) break block28;
                                preferences.put(string, Settings.insetsToString((Insets)object));
                                preferences.put(JAVATYPE_KEY_PREFIX + string, Insets.class.getName());
                                break block15;
                            }
                            if (!(object instanceof Dimension)) break block29;
                            preferences.put(string, Settings.dimensionToString((Dimension)object));
                            preferences.put(JAVATYPE_KEY_PREFIX + string, Dimension.class.getName());
                            break block15;
                        }
                        if (object instanceof Color) {
                            preferences.put(string, Settings.color2String((Color)object));
                            preferences.put(JAVATYPE_KEY_PREFIX + string, Color.class.getName());
                            break block15;
                        } else if (object instanceof String) {
                            preferences.put(string, (String)object);
                            break block15;
                        } else {
                            LOG.log(Level.FINE, "Can't save setting '" + string + "' with value '" + object + "' through org.netbeans.editor.Settings; unsupported value conversion!", new Throwable("Stacktrace"));
                            bl = true;
                        }
                        break block15;
                    }
                    preferences.remove(string);
                    break block15;
                }
                bl = true;
            }
            if (bl) {
                Class<Settings> clazz2 = Settings.class;
                // MONITORENTER : org.netbeans.editor.Settings.class
                Map map = Settings.getKitMap(clazz, true);
                Object v = map.get(string);
                if (v == null && object == null || v != null && v.equals(object)) {
                    // MONITOREXIT : clazz2
                    return;
                }
                if (object != null) {
                    map.put(string, object);
                } else {
                    map.remove(string);
                }
                // MONITOREXIT : clazz2
            }
        }
        Settings.fireSettingsChange(clazz, string, null, object);
    }

    public static void touchValue(Class clazz, String string) {
        Settings.fireSettingsChange(clazz, string, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void propagateValue(Class clazz, String string, Object object) {
        Class<Settings> clazz2 = Settings.class;
        synchronized (Settings.class) {
            Map map = Settings.getKitMap(clazz, true);
            if (object != null) {
                map.put(string, object);
            } else {
                map.remove(string);
            }
            for (Map.Entry entry : kit2Maps.entrySet()) {
                Class clazz3 = (Class)entry.getKey();
                if (clazz == clazz3 || clazz != null && !clazz.isAssignableFrom(clazz3)) continue;
                ((Map)entry.getValue()).remove(string);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            Settings.fireSettingsChange(null, string, null, null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void update(Runnable runnable) {
        if (Settings.isAsyncTask(runnable)) {
            PROCESSOR.post(runnable, Settings.getTaskDelay(runnable));
            return;
        }
        boolean bl = false;
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            boolean bl2;
            ++firingEnabled;
            try {
                runnable.run();
                if (--firingEnabled != 0) return;
                bl2 = true;
            }
            catch (Throwable throwable) {
                bl = --firingEnabled == 0;
                throw throwable;
            }
            bl = bl2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (!bl) return;
            Settings.fireSettingsChange(null, null, null, null);
            return;
        }
    }

    private static boolean isAsyncTask(Runnable runnable) {
        try {
            Method method = runnable.getClass().getDeclaredMethod("asynchronous", new Class[0]);
            method.setAccessible(true);
            return (Boolean)method.invoke((Object)runnable, new Object[0]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static int getTaskDelay(Runnable runnable) {
        try {
            Method method = runnable.getClass().getDeclaredMethod("delay", new Class[0]);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)runnable, new Object[0]);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void reset() {
        RESET_TASK.schedule(1);
    }

    public static String initializersToString() {
        StringBuffer stringBuffer = new StringBuffer();
        List[] listArray = Settings.getListsOfInitializers();
        for (int i = 0; i < listArray.length; ++i) {
            switch (i) {
                case 0: {
                    stringBuffer.append("CORE_LEVEL");
                    break;
                }
                case 1: {
                    stringBuffer.append("SYSTEM_LEVEL");
                    break;
                }
                case 2: {
                    stringBuffer.append("EXTENSION_LEVEL");
                    break;
                }
                case 3: {
                    stringBuffer.append("OPTION_LEVEL");
                    break;
                }
                case 4: {
                    stringBuffer.append("USER_LEVEL");
                    break;
                }
                default: {
                    stringBuffer.append("level " + i);
                }
            }
            stringBuffer.append(":\n");
            stringBuffer.append(EditorDebug.debugList(listArray[i]));
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public static void addSettingsChangeListener(SettingsChangeListener settingsChangeListener) {
        listenerList.add(SettingsChangeListener.class, settingsChangeListener);
    }

    public static void removeSettingsChangeListener(SettingsChangeListener settingsChangeListener) {
        listenerList.remove(SettingsChangeListener.class, settingsChangeListener);
    }

    private static void fireSettingsChange(Class clazz, String string, Object object, Object object2) {
        if (firingEnabled == 0) {
            SettingsChangeListener[] settingsChangeListenerArray = (SettingsChangeListener[])listenerList.getListeners(SettingsChangeListener.class);
            SettingsChangeEvent settingsChangeEvent = new SettingsChangeEvent(Settings.class, clazz, string, object, object2);
            for (int i = 0; i < settingsChangeListenerArray.length; ++i) {
                settingsChangeListenerArray[i].settingsChange(settingsChangeEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getKitMap(Class clazz, boolean bl) {
        ++firingEnabled;
        try {
            Map map = Settings.getKitMapWithEvent(clazz, bl);
            return map;
        }
        finally {
            --firingEnabled;
        }
    }

    private static Map getKitMapWithEvent(Class clazz, boolean bl) {
        Map map = (Map)kit2Maps.get(clazz);
        if (map == null) {
            LoggingMap loggingMap = (LoggingMap)emptyMaps.get(clazz);
            if (loggingMap != null) {
                return loggingMap;
            }
            if (loggingMap == null) {
                loggingMap = LOG.isLoggable(Level.FINE) ? new LoggingMap(clazz, Level.FINE) : new HashMap();
                emptyMaps.put(clazz, loggingMap);
            }
            List[] listArray = Settings.getListsOfInitializers();
            for (int i = 0; i < listArray.length; ++i) {
                for (Initializer initializer : listArray[i]) {
                    try {
                        initializer.updateSettingsMap(clazz, loggingMap);
                    }
                    catch (Throwable throwable) {
                        LOG.log(Level.WARNING, null, throwable);
                    }
                }
            }
            map = loggingMap;
            kit2Maps.put(clazz, map);
            emptyMaps.remove(clazz);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getAllKitMaps(Class clazz) {
        Class<Settings> clazz2 = Settings.class;
        synchronized (Settings.class) {
            Serializable serializable;
            ArrayList<Class> arrayList = new ArrayList<Class>();
            for (serializable = clazz; serializable != null; serializable = ((Class)serializable).getSuperclass()) {
                arrayList.add((Class)serializable);
            }
            serializable = new ArrayList();
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Class clazz3 = (Class)arrayList.get(i);
                Map map = Settings.getKitMap(clazz3, false);
                if (map == null) continue;
                serializable.add(map);
                serializable.add(clazz3);
            }
            Collections.reverse(serializable);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return serializable;
        }
    }

    private static Coloring findColoring(String string, MimePath mimePath, boolean bl, boolean bl2) {
        AttributeSet attributeSet = Settings.findAttribs(string, mimePath, bl, bl2);
        return attributeSet == null ? null : Coloring.fromAttributeSet(attributeSet);
    }

    private static Color findColor(String string, MimePath mimePath) {
        AttributeSet attributeSet = Settings.findAttribs(string, mimePath, false, true);
        return attributeSet == null ? null : (Color)attributeSet.getAttribute(StyleConstants.Foreground);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AttributeSet findAttribs(String string, MimePath mimePath, boolean bl, boolean bl2) {
        Map<MimePath, ChangesTrackingLookupResult<FontColorSettings>> map = FCS_CACHE;
        synchronized (map) {
            FontColorSettings fontColorSettings;
            Object object;
            ChangesTrackingLookupResult<Object> changesTrackingLookupResult = FCS_CACHE.get(mimePath);
            if (changesTrackingLookupResult == null) {
                object = MimeLookup.getLookup((MimePath)mimePath).lookupResult(FontColorSettings.class);
                changesTrackingLookupResult = new ChangesTrackingLookupResult(object, null);
                FCS_CACHE.put(mimePath, changesTrackingLookupResult);
            }
            object = null;
            Collection collection = changesTrackingLookupResult.getLookupResult().allInstances();
            FontColorSettings fontColorSettings2 = fontColorSettings = collection.isEmpty() ? null : (FontColorSettings)collection.iterator().next();
            if (fontColorSettings != null) {
                if (bl && !bl2) {
                    object = fontColorSettings.getTokenFontColors(string);
                } else if (!bl && bl2) {
                    object = fontColorSettings.getFontColors(string);
                } else {
                    object = fontColorSettings.getFontColors(string);
                    if (object == null) {
                        object = fontColorSettings.getTokenFontColors(string);
                    }
                }
            }
            return object;
        }
    }

    private static String translateOldTokenColoringName(String string) {
        String string2 = null;
        if (string != null && string.endsWith("-coloring")) {
            string2 = string.substring(0, string.length() - "-coloring".length());
        }
        if (string != null && string.endsWith("-print-coloring")) {
            string2 = string.substring(0, string.length() - "-print-coloring".length());
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MultiKeyBinding> findKeyBindings(MimePath mimePath) {
        Map<MimePath, ChangesTrackingLookupResult<KeyBindingSettings>> map = KBS_CACHE;
        synchronized (map) {
            ArrayList<MultiKeyBinding> arrayList;
            ChangesTrackingLookupResult<Object> changesTrackingLookupResult = KBS_CACHE.get(mimePath);
            if (changesTrackingLookupResult == null) {
                arrayList = MimeLookup.getLookup((MimePath)mimePath).lookupResult(KeyBindingSettings.class);
                changesTrackingLookupResult = new ChangesTrackingLookupResult(arrayList, "key-bindings");
                KBS_CACHE.put(mimePath, changesTrackingLookupResult);
            }
            if ((arrayList = (ArrayList<MultiKeyBinding>)changesTrackingLookupResult.getCustomData()) == null) {
                Collection collection = changesTrackingLookupResult.getLookupResult().allInstances();
                KeyBindingSettings keyBindingSettings = collection.isEmpty() ? null : (KeyBindingSettings)collection.iterator().next();
                arrayList = new ArrayList<MultiKeyBinding>();
                if (keyBindingSettings != null) {
                    for (org.netbeans.api.editor.settings.MultiKeyBinding multiKeyBinding : keyBindingSettings.getKeyBindings()) {
                        List list = multiKeyBinding.getKeyStrokeList();
                        arrayList.add(new MultiKeyBinding(list.toArray(new KeyStroke[list.size()]), multiKeyBinding.getActionName()));
                    }
                    changesTrackingLookupResult.setCustomData(arrayList);
                }
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> findCodeTemplates(MimePath mimePath) {
        Map<MimePath, ChangesTrackingLookupResult<CodeTemplateSettings>> map = CTS_CACHE;
        synchronized (map) {
            HashMap<String, String> hashMap;
            ChangesTrackingLookupResult<Object> changesTrackingLookupResult = CTS_CACHE.get(mimePath);
            if (changesTrackingLookupResult == null) {
                hashMap = MimeLookup.getLookup((MimePath)mimePath).lookupResult(CodeTemplateSettings.class);
                changesTrackingLookupResult = new ChangesTrackingLookupResult(hashMap, "abbrev-map");
                CTS_CACHE.put(mimePath, changesTrackingLookupResult);
            }
            if ((hashMap = (HashMap<String, String>)changesTrackingLookupResult.getCustomData()) == null) {
                Collection collection = changesTrackingLookupResult.getLookupResult().allInstances();
                CodeTemplateSettings codeTemplateSettings = collection.isEmpty() ? null : (CodeTemplateSettings)collection.iterator().next();
                hashMap = new HashMap<String, String>();
                if (codeTemplateSettings != null) {
                    for (CodeTemplateDescription codeTemplateDescription : codeTemplateSettings.getCodeTemplateDescriptions()) {
                        hashMap.put(codeTemplateDescription.getAbbreviation(), codeTemplateDescription.getParametrizedText());
                    }
                    changesTrackingLookupResult.setCustomData(hashMap);
                }
            }
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Preferences findPreferences(MimePath mimePath) {
        Map<MimePath, PreferenceChangesTracker> map = PREFS_CACHE;
        synchronized (map) {
            Preferences preferences;
            PreferenceChangesTracker preferenceChangesTracker = PREFS_CACHE.get(mimePath);
            if (preferenceChangesTracker == null && (preferences = (Preferences)MimeLookup.getLookup((MimePath)mimePath).lookup(Preferences.class)) != null) {
                preferenceChangesTracker = new PreferenceChangesTracker(preferences);
                PREFS_CACHE.put(mimePath, preferenceChangesTracker);
            }
            return preferenceChangesTracker == null ? null : preferenceChangesTracker.getPreferences();
        }
    }

    private static Map<String, String> findMacros(MimePath mimePath) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        try {
            Class<?> clazz = classLoader.loadClass("org.netbeans.modules.editor.settings.storage.api.EditorSettingsStorage");
            Method method = clazz.getDeclaredMethod("find", String.class);
            Object object = method.invoke(null, "Macros");
            if (object != null) {
                Class<?> clazz2 = classLoader.loadClass("org.netbeans.modules.editor.macros.storage.MacroDescription");
                Method method2 = clazz2.getDeclaredMethod("getCode", new Class[0]);
                Method method3 = clazz.getDeclaredMethod("load", MimePath.class, String.class, Boolean.TYPE);
                Map map = (Map)method3.invoke(object, mimePath, null, false);
                for (Object k : map.keySet()) {
                    String string = (String)k;
                    Object v = map.get(k);
                    String string2 = (String)method2.invoke(v, new Object[0]);
                    hashMap.put(string, string2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        hashMap.put((String)null, (String)((Object)Settings.findKeyBindings(mimePath)));
        return hashMap;
    }

    private static String insetsToString(Insets insets) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(insets.top);
        stringBuilder.append(',');
        stringBuilder.append(insets.left);
        stringBuilder.append(',');
        stringBuilder.append(insets.bottom);
        stringBuilder.append(',');
        stringBuilder.append(insets.right);
        return stringBuilder.toString();
    }

    private static Insets parseInsets(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[4];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            if (n > 3) {
                return null;
            }
            try {
                nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                LOG.log(Level.WARNING, null, numberFormatException);
                return null;
            }
            ++n;
        }
        if (n != 4) {
            return null;
        }
        return new Insets(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    private static String dimensionToString(Dimension dimension) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(dimension.width);
        stringBuilder.append(',');
        stringBuilder.append(dimension.height);
        return stringBuilder.toString();
    }

    private static Dimension parseDimension(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[2];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            if (n > 1) {
                return null;
            }
            try {
                nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                LOG.log(Level.WARNING, null, numberFormatException);
                return null;
            }
            ++n;
        }
        if (n != 2) {
            return null;
        }
        return new Dimension(nArray[0], nArray[1]);
    }

    private static String wrap(String string) {
        return string.length() == 1 ? "0" + string : string;
    }

    private static String color2String(Color color) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('#');
        stringBuilder.append(Settings.wrap(Integer.toHexString(color.getRed()).toUpperCase()));
        stringBuilder.append(Settings.wrap(Integer.toHexString(color.getGreen()).toUpperCase()));
        stringBuilder.append(Settings.wrap(Integer.toHexString(color.getBlue()).toUpperCase()));
        return stringBuilder.toString();
    }

    private static Color parseColor(String string) {
        try {
            return Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.log(Level.WARNING, null, numberFormatException);
            return null;
        }
    }

    private static Class typeFromString(String string) {
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            return classLoader == null ? null : classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.WARNING, null, classNotFoundException);
            return null;
        }
    }

    private static Object methodFactory(String string, MimePath mimePath) {
        int n = string.lastIndexOf(46);
        assert (n != -1) : "Need fully qualified name of class with the setting factory method.";
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        try {
            Class<?> clazz = classLoader == null ? Class.forName(string2) : classLoader.loadClass(string2);
            Method method = Settings.findDeclaredMethod(clazz, string3, MimePath.class);
            if (method == null) {
                method = Settings.findDeclaredMethod(clazz, string3, new Class[0]);
            }
            if (method == null) {
                throw new NoSuchMethodException(string);
            }
            method.setAccessible(true);
            if (method.getParameterTypes().length == 0) {
                return method.invoke(null, new Object[0]);
            }
            return method.invoke(null, mimePath);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, null, exception);
            return null;
        }
    }

    private static Method findDeclaredMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(string) || !Arrays.equals(method.getParameterTypes(), classArray)) continue;
            return method;
        }
        return null;
    }

    static {
        NULL_FILTERS = new Filter[0];
        FILTERS_LOCK = new String("Settings.FILTERS_LOCK");
        filters = NULL_FILTERS;
        kit2Maps = new HashMap();
        listenerList = new WeakEventListenerList();
        firingEnabled = 0;
        emptyMaps = new HashMap();
        PROCESSOR = new RequestProcessor("org.netbeans.editor.Settings.PROCESSOR");
        RESET_TASK = PROCESSOR.create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Class<Settings> clazz = Settings.class;
                synchronized (Settings.class) {
                    kit2Maps.clear();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    Settings.fireSettingsChange(null, null, null, null);
                    return;
                }
            }
        });
        FCS_CACHE = new WeakHashMap<MimePath, ChangesTrackingLookupResult<FontColorSettings>>();
        HIGHLIGHT_COLOR_NAMES = new HashSet<String>();
        HIGHLIGHT_COLORING_NAMES = new HashSet<String>();
        HIGHLIGHT_COLOR_NAMES.add("caret-color-insert-mode");
        HIGHLIGHT_COLOR_NAMES.add("caret-color-overwrite-mode");
        HIGHLIGHT_COLOR_NAMES.add("text-limit-line-color");
        HIGHLIGHT_COLORING_NAMES.add("line-number");
        HIGHLIGHT_COLORING_NAMES.add("guarded");
        HIGHLIGHT_COLORING_NAMES.add("code-folding");
        HIGHLIGHT_COLORING_NAMES.add("code-folding-bar");
        HIGHLIGHT_COLORING_NAMES.add("selection");
        HIGHLIGHT_COLORING_NAMES.add("highlight-search");
        HIGHLIGHT_COLORING_NAMES.add("inc-search");
        HIGHLIGHT_COLORING_NAMES.add("block-search");
        HIGHLIGHT_COLORING_NAMES.add("status-bar");
        HIGHLIGHT_COLORING_NAMES.add("status-bar-bold");
        KBS_CACHE = new WeakHashMap<MimePath, ChangesTrackingLookupResult<KeyBindingSettings>>();
        CTS_CACHE = new WeakHashMap<MimePath, ChangesTrackingLookupResult<CodeTemplateSettings>>();
        PREFS_CACHE = new WeakHashMap<MimePath, PreferenceChangesTracker>();
    }

    private static final class PreferenceChangesTracker
    implements PreferenceChangeListener {
        private final Preferences prefs;

        public PreferenceChangesTracker(Preferences preferences) {
            this.prefs = preferences;
            this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)this.prefs));
        }

        public Preferences getPreferences() {
            return this.prefs;
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            Settings.fireSettingsChange(null, preferenceChangeEvent.getKey(), null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChangesTrackingLookupResult<T>
    implements LookupListener {
        private final Lookup.Result<T> lookupResult;
        private final String settingName;
        private Object customData = null;

        public ChangesTrackingLookupResult(Lookup.Result<T> result, String string) {
            this.lookupResult = result;
            this.lookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.lookupResult));
            this.settingName = string;
        }

        public Lookup.Result<T> getLookupResult() {
            return this.lookupResult;
        }

        public Object getCustomData() {
            return this.customData;
        }

        public void setCustomData(Object object) {
            this.customData = object;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.customData = null;
            Settings.fireSettingsChange(null, this.settingName, null, null);
        }
    }

    private static final class LoggingMap
    extends HashMap {
        private Class kitClass;
        private Level logLevel;
        private static final Set<String> DEPRECATED_SETTINGS = Collections.synchronizedSet(Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("block-search", "caret-color-insert-mode", "caret-color-overwrite-mode", "code-folding", "coloring-name-list", "-print-coloring", "-coloring", "default", "guarded", "highlight-search", "inc-search", "line-number", "selection", "status-bar-bold", "status-bar", "text-limit-line-color", "key-bindings"))));

        public LoggingMap(Class clazz, Level level) {
            this.kitClass = clazz;
            this.logLevel = level;
        }

        public Object put(Object object, Object object2) {
            if (object != null && (object.equals("rendering-hints") || object.equals("textAntialiasing"))) {
                String string = "Settings map: put('" + object + "' to '" + object2 + "') for kitClass=" + this.kitClass;
                if (LOG_STACTRACES) {
                    LOG.log(this.logLevel, null, new Throwable(string));
                } else {
                    LOG.log(this.logLevel, string);
                }
            }
            this.logDeprecatedKey(object);
            return super.put(object, object2);
        }

        public Object get(Object object) {
            this.logDeprecatedKey(object);
            return super.get(object);
        }

        public boolean containsKey(Object object) {
            this.logDeprecatedKey(object);
            return super.containsKey(object);
        }

        public Object remove(Object object) {
            this.logDeprecatedKey(object);
            return super.remove(object);
        }

        private void logDeprecatedKey(Object object) {
            if (LOG.isLoggable(this.logLevel) && object != null && DEPRECATED_SETTINGS.contains(object)) {
                String string = "The editor setting '" + object + "' is deprecated. Please use Editor Settings API instead.";
                if (LOG_STACTRACES) {
                    LOG.log(this.logLevel, null, new Throwable(string));
                } else {
                    LOG.log(this.logLevel, string);
                }
            }
        }
    }

    public static interface Filter {
        public Object filterValue(Class var1, String var2, Object var3);

        public KitAndValue[] filterValueHierarchy(Class var1, String var2, KitAndValue[] var3);
    }

    public static interface Evaluator {
        public Object getValue(Class var1, String var2);
    }

    public static abstract class FilterInitializerSorter {
        private InitializerSorter delegate;

        public FilterInitializerSorter(InitializerSorter initializerSorter) {
            this.delegate = initializerSorter;
        }

        public void sort(List list) {
            if (this.delegate != null) {
                this.delegate.sort(list);
            }
        }
    }

    public static interface InitializerSorter {
        public void sort(List var1);
    }

    public static abstract class AbstractInitializer
    implements Initializer {
        private String name;

        public AbstractInitializer(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static interface Initializer {
        public String getName();

        public void updateSettingsMap(Class var1, Map var2);
    }

    public static class KitAndValue {
        public Class kitClass;
        public Object value;

        public KitAndValue(Class clazz, Object object) {
            this.kitClass = clazz;
            this.value = object;
        }
    }
}

