/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.View;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawEngineLineView;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.MarkVector;
import org.netbeans.editor.MultiMark;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;

final class DrawEngine {
    private static final Logger LOG = Logger.getLogger(DrawEngine.class.getName());
    private static DrawEngine drawEngine;
    private static final char[] SPACE;

    private DrawEngine() {
    }

    public static synchronized DrawEngine getDrawEngine() {
        if (drawEngine == null) {
            drawEngine = new DrawEngine();
        }
        return drawEngine;
    }

    private void initLineNumbering(DrawInfo drawInfo) {
        boolean bl = drawInfo.lineNumbering = drawInfo.editorUI.lineNumberVisible && drawInfo.drawGraphics.supportsLineNumbers();
        if (drawInfo.lineNumbering) {
            Color color;
            Color color2;
            try {
                drawInfo.startLineNumber = Utilities.getLineOffset(drawInfo.doc, drawInfo.startOffset) + 1;
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.WARNING, null, badLocationException);
            }
            drawInfo.lineNumberColoring = drawInfo.editorUI.getColoring("line-number");
            drawInfo.lineNumberColoring = drawInfo.lineNumberColoring == null ? drawInfo.defaultColoring : drawInfo.lineNumberColoring.apply(drawInfo.defaultColoring);
            Font font = drawInfo.lineNumberColoring.getFont();
            if (font == null) {
                font = drawInfo.defaultColoring.getFont();
            }
            if ((color2 = drawInfo.lineNumberColoring.getBackColor()) == null) {
                color2 = drawInfo.defaultColoring.getBackColor();
            }
            if ((color = drawInfo.lineNumberColoring.getForeColor()) == null) {
                color = drawInfo.defaultColoring.getForeColor();
            }
            drawInfo.lineNumberChars = new char[Math.max(drawInfo.editorUI.lineNumberMaxDigitCount, 1)];
            if (drawInfo.graphics == null) {
                drawInfo.syncedLineNumbering = true;
            } else {
                try {
                    int n = Utilities.getLineOffset(drawInfo.doc, drawInfo.endOffset) + 1;
                    drawInfo.lineStartOffsets = new int[n - drawInfo.startLineNumber + 2];
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.WARNING, null, badLocationException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initInfo(DrawInfo drawInfo) throws BadLocationException {
        MarkVector markVector;
        if (drawInfo.startOffset < drawInfo.lineStartOffset) {
            throw new BadLocationException("Invalid startOffset: " + drawInfo.startOffset + " < line start offset = " + drawInfo.lineStartOffset, drawInfo.startOffset);
        }
        if (drawInfo.endOffset > drawInfo.lineEndOffset) {
            throw new BadLocationException("Invalid endOffset: " + drawInfo.endOffset + " > line end offset = " + drawInfo.lineEndOffset, drawInfo.endOffset);
        }
        drawInfo.x = drawInfo.startX;
        drawInfo.y = drawInfo.startY;
        drawInfo.lineHeight = drawInfo.editorUI.getLineHeight();
        drawInfo.defaultColoring = drawInfo.editorUI.getDefaultColoring();
        drawInfo.tabSize = drawInfo.doc.getTabSize();
        drawInfo.fragmentOffset = drawInfo.startOffset;
        drawInfo.graphics = drawInfo.drawGraphics.getGraphics();
        if (drawInfo.graphics != null && drawInfo.editorUI.renderingHints != null) {
            ((Graphics2D)drawInfo.graphics).setRenderingHints(drawInfo.editorUI.renderingHints);
        }
        this.initLineNumbering(drawInfo);
        drawInfo.foreColor = drawInfo.defaultColoring.getForeColor();
        drawInfo.backColor = drawInfo.defaultColoring.getBackColor();
        drawInfo.font = drawInfo.defaultColoring.getFont();
        drawInfo.bol = drawInfo.lineStartOffset == drawInfo.startOffset;
        drawInfo.drawGraphics.init(drawInfo);
        drawInfo.drawGraphics.setDefaultBackColor(drawInfo.defaultColoring.getBackColor());
        drawInfo.drawGraphics.setLineHeight(drawInfo.lineHeight);
        drawInfo.drawGraphics.setLineAscent(drawInfo.editorUI.getLineAscent());
        drawInfo.drawGraphics.setX(drawInfo.x);
        drawInfo.drawGraphics.setY(drawInfo.y);
        drawInfo.layers = drawInfo.editorUI.getDrawLayerList().currentLayers();
        int n = drawInfo.layers.length;
        drawInfo.layerActives = new boolean[n];
        drawInfo.layerActivityChangeOffsets = new int[n];
        for (int i = 0; i < n; ++i) {
            drawInfo.layers[i].init(drawInfo);
        }
        drawInfo.drawMarkList = new ArrayList<MarkFactory.DrawMark>();
        MarkVector markVector2 = markVector = drawInfo.doc.marksStorage;
        synchronized (markVector2) {
            int n2 = drawInfo.startOffset;
            int n3 = 0;
            int n4 = markVector.getMarkCount();
            int n5 = n4 - 1;
            while (n3 <= n5) {
                int n6 = n3 + n5 >> 1;
                int n7 = markVector.getMarkOffsetInternal(n6) - n2;
                if (n7 < 0) {
                    n3 = n6 + 1;
                    continue;
                }
                if (n7 > 0) {
                    n5 = n6 - 1;
                    continue;
                }
                while (--n6 >= 0 && markVector.getMarkOffsetInternal(n6) == n2) {
                }
                n3 = n6 + 1;
                break;
            }
            n2 = drawInfo.endOffset;
            while (n3 < n4) {
                MultiMark multiMark = markVector.getMark(n3);
                if (multiMark.isValid()) {
                    if (multiMark.getOffset() > n2) break;
                    Mark mark = drawInfo.doc.marks.get(multiMark);
                    if (mark == null) {
                        throw new IllegalStateException("No mark for m=" + multiMark);
                    }
                    if (mark instanceof MarkFactory.DrawMark) {
                        drawInfo.drawMarkList.add((MarkFactory.DrawMark)mark);
                    }
                }
                ++n3;
            }
        }
        drawInfo.drawMarkUpdate = false;
        drawInfo.drawMarkOffset = Integer.MAX_VALUE;
        drawInfo.drawMarkIndex = 0;
        while (drawInfo.drawMarkIndex < drawInfo.drawMarkList.size()) {
            drawInfo.drawMark = drawInfo.drawMarkList.get(drawInfo.drawMarkIndex++);
            if (!drawInfo.drawMark.isValid()) continue;
            try {
                drawInfo.drawMarkOffset = drawInfo.drawMark.getOffset();
            }
            catch (InvalidMarkException invalidMarkException) {
                LOG.log(Level.FINE, null, invalidMarkException);
                continue;
            }
            if (drawInfo.drawMarkOffset >= drawInfo.updateOffset) break;
            drawInfo.updateOffset = drawInfo.drawMarkOffset;
            drawInfo.drawMarkUpdate = true;
            break;
        }
        drawInfo.text = new Segment();
        drawInfo.doc.getText(drawInfo.lineStartOffset, drawInfo.lineEndOffset - drawInfo.lineStartOffset, drawInfo.text);
        drawInfo.textArray = drawInfo.text.array;
        drawInfo.buffer = drawInfo.textArray;
        drawInfo.bufferStartOffset = drawInfo.lineStartOffset - drawInfo.text.offset;
        drawInfo.drawGraphics.setBuffer(drawInfo.textArray);
        if (drawInfo.drawGraphics instanceof DrawGraphics.GraphicsDG) {
            ((DrawGraphics.GraphicsDG)drawInfo.drawGraphics).setBufferStartOffset(drawInfo.bufferStartOffset);
        }
        drawInfo.continueDraw = true;
        drawInfo.visualColumn = drawInfo.bol ? 0 : Analyzer.getColumn(drawInfo.textArray, drawInfo.lineStartOffset - drawInfo.bufferStartOffset, drawInfo.startOffset - drawInfo.lineStartOffset, drawInfo.tabSize, 0);
    }

    private void handleBOL(DrawInfo drawInfo) {
        if (drawInfo.lineNumbering) {
            if (drawInfo.syncedLineNumbering) {
                int n;
                drawInfo.foreColor = drawInfo.lineNumberColoring.getForeColor();
                drawInfo.backColor = drawInfo.lineNumberColoring.getBackColor();
                drawInfo.font = drawInfo.lineNumberColoring.getFont();
                drawInfo.strikeThroughColor = null;
                drawInfo.underlineColor = null;
                drawInfo.waveUnderlineColor = null;
                drawInfo.topBorderLineColor = null;
                drawInfo.rightBorderLineColor = null;
                drawInfo.bottomBorderLineColor = null;
                drawInfo.leftBorderLineColor = null;
                int n2 = drawInfo.startLineNumber + drawInfo.lineIndex;
                int n3 = drawInfo.layers.length;
                for (n = 0; n < n3; ++n) {
                    n2 = drawInfo.layers[n].updateLineNumberContext(n2, drawInfo);
                }
                n = Math.max(drawInfo.lineNumberChars.length - 1, 0);
                do {
                    drawInfo.lineNumberChars[n--] = (char)(48 + n2 % 10);
                } while ((n2 /= 10) != 0 && n >= 0);
                while (n >= 0) {
                    drawInfo.lineNumberChars[n--] = 32;
                }
                int n4 = drawInfo.x - drawInfo.editorUI.lineNumberWidth;
                if (drawInfo.editorUI.getLineNumberMargin() != null) {
                    n4 += drawInfo.editorUI.getLineNumberMargin().left;
                }
                drawInfo.drawGraphics.setX(n4);
                drawInfo.drawGraphics.setBuffer(drawInfo.lineNumberChars);
                drawInfo.drawGraphics.setForeColor(drawInfo.foreColor);
                drawInfo.drawGraphics.setBackColor(drawInfo.backColor);
                drawInfo.drawGraphics.setStrikeThroughColor(drawInfo.strikeThroughColor);
                drawInfo.drawGraphics.setUnderlineColor(drawInfo.underlineColor);
                drawInfo.drawGraphics.setWaveUnderlineColor(drawInfo.waveUnderlineColor);
                drawInfo.drawGraphics.setTopBorderLineColor(drawInfo.topBorderLineColor);
                drawInfo.drawGraphics.setRightBorderLineColor(drawInfo.rightBorderLineColor);
                drawInfo.drawGraphics.setBottomBorderLineColor(drawInfo.bottomBorderLineColor);
                drawInfo.drawGraphics.setLeftBorderLineColor(drawInfo.leftBorderLineColor);
                drawInfo.drawGraphics.setFont(drawInfo.font);
                drawInfo.drawGraphics.drawChars(0, drawInfo.lineNumberChars.length, drawInfo.editorUI.lineNumberWidth);
                if (drawInfo.drawGraphics.getGraphics() == null) {
                    drawInfo.drawGraphics.setBuffer(SPACE);
                    drawInfo.drawGraphics.drawChars(0, 1, drawInfo.editorUI.lineNumberDigitWidth);
                }
                drawInfo.drawGraphics.setX(drawInfo.x);
                drawInfo.drawGraphics.setBuffer(drawInfo.textArray);
            } else {
                drawInfo.lineStartOffsets[drawInfo.lineIndex] = drawInfo.fragmentOffset;
            }
        }
        ++drawInfo.lineIndex;
    }

    private void handleEOL(DrawInfo drawInfo) {
        drawInfo.drawGraphics.setX(drawInfo.x);
        drawInfo.drawGraphics.setY(drawInfo.y);
        drawInfo.drawGraphics.eol();
        drawInfo.visualColumn = 0;
        drawInfo.x = drawInfo.startX;
        drawInfo.y += drawInfo.lineHeight;
    }

    private void updateOffsetReached(DrawInfo drawInfo) {
        if (drawInfo.drawMarkUpdate) {
            for (DrawLayer drawLayer : drawInfo.layers) {
                int n;
                if (!drawLayer.getName().equals(drawInfo.drawMark.layerName) || !drawInfo.drawMark.isDocumentMark() && drawInfo.editorUI != drawInfo.drawMark.getEditorUI()) continue;
                drawInfo.layerActives[var3_4] = drawLayer.isActive(drawInfo, drawInfo.drawMark);
                drawInfo.layerActivityChangeOffsets[var3_4] = n = drawLayer.getNextActivityChangeOffset(drawInfo);
                if (n <= drawInfo.fragmentOffset || n >= drawInfo.layerUpdateOffset) continue;
                drawInfo.layerUpdateOffset = n;
            }
            while (drawInfo.drawMarkIndex < drawInfo.drawMarkList.size()) {
                drawInfo.drawMark = drawInfo.drawMarkList.get(drawInfo.drawMarkIndex++);
                if (!drawInfo.drawMark.isValid()) continue;
                try {
                    drawInfo.drawMarkOffset = drawInfo.drawMark.getOffset();
                    break;
                }
                catch (InvalidMarkException invalidMarkException) {
                    LOG.log(Level.FINE, null, invalidMarkException);
                }
            }
            if (drawInfo.drawMarkIndex >= drawInfo.drawMarkList.size()) {
                drawInfo.drawMark = null;
                drawInfo.drawMarkOffset = Integer.MAX_VALUE;
            }
        } else {
            drawInfo.layerUpdateOffset = Integer.MAX_VALUE;
            int n = drawInfo.layers.length;
            for (int i = 0; i < n; ++i) {
                int n2 = drawInfo.layerActivityChangeOffsets[i];
                if (n2 == drawInfo.fragmentOffset) {
                    DrawLayer drawLayer = drawInfo.layers[i];
                    drawInfo.layerActives[i] = drawLayer.isActive(drawInfo, null);
                    drawInfo.layerActivityChangeOffsets[i] = n2 = drawLayer.getNextActivityChangeOffset(drawInfo);
                }
                if (n2 <= drawInfo.fragmentOffset || n2 >= drawInfo.layerUpdateOffset) continue;
                drawInfo.layerUpdateOffset = n2;
            }
        }
        if (drawInfo.drawMarkOffset < drawInfo.layerUpdateOffset) {
            drawInfo.drawMarkUpdate = true;
            drawInfo.updateOffset = drawInfo.drawMarkOffset;
        } else {
            drawInfo.drawMarkUpdate = false;
            drawInfo.updateOffset = drawInfo.layerUpdateOffset;
        }
    }

    private void computeFragmentLength(DrawInfo drawInfo) {
        drawInfo.fragmentStartIndex = drawInfo.fragmentOffset - drawInfo.bufferStartOffset;
        drawInfo.fragmentLength = Math.min(drawInfo.updateOffset - drawInfo.fragmentOffset, drawInfo.areaLength - drawInfo.drawnLength);
        int n = Analyzer.findFirstTabOrLF(drawInfo.textArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength);
        drawInfo.eol = drawInfo.fragmentOffset == drawInfo.docLen;
        drawInfo.tabsFragment = false;
        if (n >= 0) {
            if (n == drawInfo.fragmentStartIndex) {
                if (drawInfo.textArray[n] == '\t') {
                    drawInfo.tabsFragment = true;
                    int n2 = Analyzer.findFirstNonTab(drawInfo.textArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength);
                    if (n2 != -1) {
                        drawInfo.fragmentLength = n2 - drawInfo.fragmentStartIndex;
                    }
                } else {
                    drawInfo.eol = true;
                    drawInfo.fragmentLength = 1;
                }
            } else {
                drawInfo.fragmentLength = n - drawInfo.fragmentStartIndex;
            }
        }
    }

    private void computeFragmentDisplayWidth(DrawInfo drawInfo) {
        if (!drawInfo.eol) {
            int n = drawInfo.layers.length;
            for (int i = 0; i < n; ++i) {
                if (!drawInfo.layerActives[i]) continue;
                drawInfo.layers[i].updateContext(drawInfo);
            }
        }
        FontMetricsCache.Info info = FontMetricsCache.getInfo(drawInfo.font);
        drawInfo.spaceWidth = drawInfo.component != null ? info.getSpaceWidth(drawInfo.component) : drawInfo.editorUI.defaultSpaceWidth;
        drawInfo.fragmentCharCount = drawInfo.fragmentLength;
        if (drawInfo.tabsFragment) {
            drawInfo.fragmentCharCount = Analyzer.getColumn(drawInfo.textArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
            drawInfo.fragmentWidth = drawInfo.fragmentCharCount * drawInfo.spaceWidth;
        } else {
            drawInfo.fragmentWidth = drawInfo.eol ? drawInfo.spaceWidth : (drawInfo.fragmentLength > 0 ? (drawInfo.component != null ? FontMetricsCache.getFontMetrics(drawInfo.font, drawInfo.component).charsWidth(drawInfo.textArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength) : drawInfo.fragmentLength * drawInfo.spaceWidth) : 0);
        }
    }

    private void drawItNow(DrawInfo drawInfo) {
        if (drawInfo.eol) {
            int n = drawInfo.layers.length;
            boolean bl = false;
            int n2 = drawInfo.fragmentWidth;
            do {
                int n3;
                n2 = 0;
                if (drawInfo.bol) {
                    if (!bl) {
                        for (n3 = 0; n3 < n; ++n3) {
                            DrawLayer drawLayer;
                            if (!drawInfo.layerActives[n3] || !(drawLayer = drawInfo.layers[n3]).extendsEmptyLine()) continue;
                            bl = true;
                            drawLayer.updateContext(drawInfo);
                        }
                        if (bl) {
                            n2 = drawInfo.spaceWidth / 2;
                        }
                    } else {
                        bl = false;
                    }
                }
                if (!bl) {
                    n3 = 0;
                    for (int i = 0; i < n; ++i) {
                        DrawLayer drawLayer;
                        if (!drawInfo.layerActives[i] || !(drawLayer = drawInfo.layers[i]).extendsEOL()) continue;
                        n3 = 1;
                        drawLayer.updateContext(drawInfo);
                    }
                    if (n3 != 0 && drawInfo.component != null) {
                        drawInfo.drawGraphics.setStrikeThroughColor(null);
                        drawInfo.drawGraphics.setUnderlineColor(null);
                        drawInfo.drawGraphics.setWaveUnderlineColor(null);
                        drawInfo.drawGraphics.setTopBorderLineColor(null);
                        drawInfo.drawGraphics.setRightBorderLineColor(null);
                        drawInfo.drawGraphics.setBottomBorderLineColor(null);
                        drawInfo.drawGraphics.setLeftBorderLineColor(null);
                        n2 = drawInfo.component.getWidth();
                    }
                }
                if (n2 <= 0 || !(drawInfo.drawGraphics instanceof DrawGraphics.GraphicsDG)) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    DrawGraphics.GraphicsDG graphicsDG = (DrawGraphics.GraphicsDG)drawInfo.drawGraphics;
                    String string = "fillRect: bg = " + drawInfo.backColor + ", startOffset = " + drawInfo.startOffset + ", endOffset = " + drawInfo.endOffset + ", [" + graphicsDG.x + ", " + graphicsDG.y + ", " + n2 + ", " + graphicsDG.lineHeight + "]";
                    LOG.fine(string);
                }
                drawInfo.drawGraphics.setBackColor(drawInfo.backColor);
                drawInfo.drawGraphics.fillRect(n2);
                if (!bl || drawInfo.x > drawInfo.editorUI.getTextMargin().left) continue;
                drawInfo.x += n2;
            } while (bl);
        } else {
            drawInfo.drawGraphics.setBackColor(drawInfo.backColor);
            drawInfo.drawGraphics.setForeColor(drawInfo.foreColor);
            drawInfo.drawGraphics.setStrikeThroughColor(drawInfo.strikeThroughColor);
            drawInfo.drawGraphics.setUnderlineColor(drawInfo.underlineColor);
            drawInfo.drawGraphics.setWaveUnderlineColor(drawInfo.waveUnderlineColor);
            drawInfo.drawGraphics.setTopBorderLineColor(drawInfo.topBorderLineColor);
            drawInfo.drawGraphics.setRightBorderLineColor(drawInfo.rightBorderLineColor);
            drawInfo.drawGraphics.setBottomBorderLineColor(drawInfo.bottomBorderLineColor);
            drawInfo.drawGraphics.setLeftBorderLineColor(drawInfo.leftBorderLineColor);
            drawInfo.drawGraphics.setFont(drawInfo.font);
            if (drawInfo.tabsFragment) {
                drawInfo.drawGraphics.drawTabs(drawInfo.fragmentStartIndex, drawInfo.fragmentLength, drawInfo.fragmentCharCount, drawInfo.fragmentWidth);
            } else {
                drawInfo.drawGraphics.drawChars(drawInfo.fragmentStartIndex, drawInfo.fragmentLength, drawInfo.fragmentWidth);
            }
        }
    }

    private void checkTargetOffsetReached(DrawInfo drawInfo) {
        if (drawInfo.eol && (drawInfo.targetOffset == drawInfo.fragmentOffset || drawInfo.targetOffset == -1)) {
            char c = '\n';
            drawInfo.continueDraw = drawInfo.drawGraphics.targetOffsetReached(drawInfo.fragmentOffset, c, drawInfo.x, drawInfo.spaceWidth, drawInfo);
        } else if (drawInfo.targetOffset == -1 && drawInfo.fragmentLength > 0) {
            int n;
            int n2;
            int n3;
            int n4;
            FontMetrics fontMetrics = FontMetricsCache.getFontMetrics(drawInfo.font, drawInfo.component);
            int n5 = -1;
            int n6 = n4 = drawInfo.fragmentLength - 1;
            if (drawInfo.tabsFragment) {
                n3 = Analyzer.getColumn(drawInfo.textArray, drawInfo.fragmentStartIndex, n4, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                n2 = n3 * drawInfo.spaceWidth;
            } else {
                n2 = fontMetrics.charsWidth(drawInfo.textArray, drawInfo.fragmentStartIndex, n4);
            }
            if (drawInfo.tabsFragment) {
                n = Analyzer.getColumn(drawInfo.textArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                n3 = n * drawInfo.spaceWidth;
            } else {
                n3 = fontMetrics.charsWidth(drawInfo.textArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength);
            }
            drawInfo.continueDraw = drawInfo.drawGraphics.targetOffsetReached(drawInfo.fragmentOffset + n4, drawInfo.textArray[drawInfo.fragmentStartIndex + n4], drawInfo.x + n2, n3 - n2, drawInfo);
            if (!drawInfo.continueDraw) {
                while (n5 <= n4) {
                    int n7;
                    n = (n5 + n4) / 2;
                    int n8 = 0;
                    if (n == n6 + 1) {
                        n8 = n3;
                    } else if (drawInfo.tabsFragment) {
                        n7 = Analyzer.getColumn(drawInfo.textArray, drawInfo.fragmentStartIndex, n, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                        n8 = n7 * drawInfo.spaceWidth;
                    } else {
                        n8 = fontMetrics.charsWidth(drawInfo.textArray, drawInfo.fragmentStartIndex, n);
                    }
                    n7 = 0;
                    if (n == n6 - 1) {
                        n7 = n2;
                    } else if (drawInfo.tabsFragment) {
                        int n9 = Analyzer.getColumn(drawInfo.textArray, drawInfo.fragmentStartIndex, n + 1, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                        n7 = n9 * drawInfo.spaceWidth;
                    } else {
                        n7 = fontMetrics.charsWidth(drawInfo.textArray, drawInfo.fragmentStartIndex, n + 1);
                    }
                    n2 = n8;
                    n3 = n7;
                    n6 = n;
                    drawInfo.continueDraw = drawInfo.drawGraphics.targetOffsetReached(drawInfo.fragmentOffset + n, drawInfo.textArray[drawInfo.fragmentStartIndex + n], drawInfo.x + n8, n7 - n8, drawInfo);
                    if (drawInfo.continueDraw) {
                        n5 = n + 1;
                        continue;
                    }
                    if (n > n5 && n != n4) {
                        n4 = n;
                        continue;
                    }
                    break;
                }
            }
        } else if (drawInfo.targetOffset < drawInfo.fragmentOffset + drawInfo.fragmentLength && drawInfo.fragmentOffset <= drawInfo.targetOffset) {
            int n;
            int n10;
            int n11 = 0;
            int n12 = drawInfo.targetOffset - drawInfo.fragmentOffset;
            if (n12 > 0) {
                if (drawInfo.tabsFragment) {
                    n10 = Analyzer.getColumn(drawInfo.textArray, drawInfo.fragmentStartIndex, n12, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                    n11 = n10 * drawInfo.spaceWidth;
                } else {
                    n11 = FontMetricsCache.getFontMetrics(drawInfo.font, drawInfo.component).charsWidth(drawInfo.textArray, drawInfo.fragmentStartIndex, n12);
                }
            }
            if (drawInfo.tabsFragment) {
                n10 = Analyzer.getColumn(drawInfo.textArray, drawInfo.fragmentStartIndex, n12 + 1, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                n = n10 * drawInfo.spaceWidth;
            } else {
                n = FontMetricsCache.getFontMetrics(drawInfo.font, drawInfo.component).charsWidth(drawInfo.textArray, drawInfo.fragmentStartIndex, n12 + 1);
            }
            drawInfo.continueDraw = drawInfo.drawGraphics.targetOffsetReached(drawInfo.fragmentOffset + n12, drawInfo.textArray[drawInfo.fragmentStartIndex + n12], drawInfo.x + n11, n - n11, drawInfo);
        }
    }

    private void drawFragment(DrawInfo drawInfo) {
        Object object;
        drawInfo.foreColor = drawInfo.defaultColoring.getForeColor();
        drawInfo.backColor = drawInfo.defaultColoring.getBackColor();
        drawInfo.font = drawInfo.defaultColoring.getFont();
        drawInfo.strikeThroughColor = null;
        drawInfo.underlineColor = null;
        drawInfo.waveUnderlineColor = null;
        drawInfo.topBorderLineColor = null;
        drawInfo.rightBorderLineColor = null;
        drawInfo.bottomBorderLineColor = null;
        drawInfo.leftBorderLineColor = null;
        if (drawInfo.bol) {
            object = drawInfo.foreColor;
            Color color = drawInfo.backColor;
            this.handleBOL(drawInfo);
            drawInfo.foreColor = object;
            drawInfo.backColor = color;
        }
        while (drawInfo.fragmentOffset == drawInfo.updateOffset) {
            this.updateOffsetReached(drawInfo);
        }
        this.computeFragmentLength(drawInfo);
        this.computeFragmentDisplayWidth(drawInfo);
        this.drawItNow(drawInfo);
        if (LOG.isLoggable(Level.FINER)) {
            object = "   FRAGMENT='" + EditorDebug.debugChars(drawInfo.buffer, drawInfo.fragmentStartIndex, drawInfo.fragmentLength) + "', at offset=" + drawInfo.fragmentOffset + ", bol=" + drawInfo.bol + ", eol=" + drawInfo.eol;
            LOG.finer((String)object);
        }
        if (drawInfo.component != null) {
            this.checkTargetOffsetReached(drawInfo);
        }
        drawInfo.fragmentOffset += drawInfo.fragmentLength;
        drawInfo.drawnLength += drawInfo.fragmentLength;
        drawInfo.visualColumn += drawInfo.fragmentCharCount;
        drawInfo.x += drawInfo.fragmentWidth;
        drawInfo.bol = false;
        if (drawInfo.eol) {
            this.handleEOL(drawInfo);
            drawInfo.bol = true;
            drawInfo.eol = false;
        }
        if (drawInfo.fragmentOffset >= drawInfo.endOffset && drawInfo.endOffset <= drawInfo.docLen) {
            drawInfo.continueDraw = false;
        }
    }

    private void drawArea(DrawInfo drawInfo) {
        drawInfo.areaOffset = drawInfo.startOffset;
        drawInfo.areaLength = drawInfo.endOffset - drawInfo.startOffset;
        drawInfo.layerUpdateOffset = Integer.MAX_VALUE;
        for (DrawLayer drawLayer : drawInfo.layers) {
            int n;
            drawInfo.layerActives[var3_3] = drawLayer.isActive(drawInfo, null);
            drawInfo.layerActivityChangeOffsets[var3_3] = n = drawLayer.getNextActivityChangeOffset(drawInfo);
            if (n <= drawInfo.fragmentOffset || n >= drawInfo.layerUpdateOffset) continue;
            drawInfo.layerUpdateOffset = n;
        }
        drawInfo.updateOffset = Math.min(drawInfo.layerUpdateOffset, drawInfo.drawMarkOffset);
        drawInfo.drawnLength = 0;
        drawInfo.fragmentLength = 0;
        do {
            this.drawFragment(drawInfo);
        } while (drawInfo.continueDraw && drawInfo.drawnLength < drawInfo.areaLength);
        if (drawInfo.continueDraw) {
            drawInfo.areaOffset = drawInfo.fragmentOffset;
            drawInfo.areaLength = drawInfo.docLen - drawInfo.areaOffset;
            drawInfo.drawnLength = 0;
            this.drawFragment(drawInfo);
            drawInfo.continueDraw = false;
        }
    }

    private void drawTheRestOfTextLine(DrawInfo drawInfo) {
        this.handleEOL(drawInfo);
        if (drawInfo.editorUI.textLimitLineVisible) {
            int n = drawInfo.editorUI.getTextMargin().left + drawInfo.getEditorUI().textLimitWidth() * drawInfo.editorUI.defaultSpaceWidth;
            if (drawInfo.graphics != null) {
                drawInfo.graphics.setColor(drawInfo.editorUI.textLimitLineColor);
                Rectangle rectangle = drawInfo.graphics.getClipBounds();
                if (rectangle.height > drawInfo.editorUI.getLineHeight()) {
                    drawInfo.graphics.drawLine(n, drawInfo.y, n, drawInfo.y + rectangle.height);
                }
            }
        }
    }

    private void graphicsSpecificUpdates(DrawInfo drawInfo) {
        Rectangle rectangle = drawInfo.editorUI.getExtentBounds();
        Rectangle rectangle2 = drawInfo.graphics.getClipBounds();
        Insets insets = drawInfo.editorUI.getTextMargin();
        int n = insets.left - drawInfo.editorUI.lineNumberWidth - drawInfo.editorUI.textLeftMarginWidth;
        if (drawInfo.lineNumbering && !drawInfo.syncedLineNumbering) {
            Color color = drawInfo.lineNumberColoring.getBackColor();
            int n2 = drawInfo.startY;
            int n3 = rectangle.x + n;
            if (!color.equals(drawInfo.defaultColoring.getBackColor()) || rectangle.x > 0) {
                drawInfo.graphics.setColor(color);
                drawInfo.graphics.fillRect(n3, n2, drawInfo.editorUI.lineNumberWidth, drawInfo.lineIndex * drawInfo.lineHeight);
            }
            drawInfo.drawGraphics.setDefaultBackColor(color);
            int n4 = Math.max(drawInfo.lineNumberChars.length - 1, 0);
            int n5 = n3;
            if (drawInfo.editorUI.getLineNumberMargin() != null) {
                n5 += drawInfo.editorUI.getLineNumberMargin().left;
            }
            drawInfo.bol = true;
            for (int i = 0; i < drawInfo.lineIndex; ++i) {
                int n6;
                drawInfo.fragmentOffset = drawInfo.lineStartOffsets[i];
                drawInfo.foreColor = drawInfo.lineNumberColoring.getForeColor();
                drawInfo.backColor = color;
                drawInfo.font = drawInfo.lineNumberColoring.getFont();
                drawInfo.strikeThroughColor = null;
                drawInfo.underlineColor = null;
                drawInfo.waveUnderlineColor = null;
                drawInfo.topBorderLineColor = null;
                drawInfo.rightBorderLineColor = null;
                drawInfo.bottomBorderLineColor = null;
                drawInfo.leftBorderLineColor = null;
                int n7 = drawInfo.startLineNumber + i;
                int n8 = drawInfo.layers.length;
                for (n6 = 0; n6 < n8; ++n6) {
                    n7 = drawInfo.layers[n6].updateLineNumberContext(n7, drawInfo);
                }
                n6 = n4;
                do {
                    drawInfo.lineNumberChars[n6--] = (char)(48 + n7 % 10);
                } while ((n7 /= 10) != 0 && n6 >= 0);
                while (n6 >= 0) {
                    drawInfo.lineNumberChars[n6--] = 32;
                }
                drawInfo.drawGraphics.setY(n2);
                drawInfo.drawGraphics.setBuffer(drawInfo.lineNumberChars);
                drawInfo.drawGraphics.setForeColor(drawInfo.foreColor);
                drawInfo.drawGraphics.setBackColor(drawInfo.backColor);
                drawInfo.drawGraphics.setStrikeThroughColor(drawInfo.strikeThroughColor);
                drawInfo.drawGraphics.setUnderlineColor(drawInfo.underlineColor);
                drawInfo.drawGraphics.setWaveUnderlineColor(drawInfo.waveUnderlineColor);
                drawInfo.drawGraphics.setTopBorderLineColor(drawInfo.topBorderLineColor);
                drawInfo.drawGraphics.setRightBorderLineColor(drawInfo.rightBorderLineColor);
                drawInfo.drawGraphics.setBottomBorderLineColor(drawInfo.bottomBorderLineColor);
                drawInfo.drawGraphics.setLeftBorderLineColor(drawInfo.leftBorderLineColor);
                drawInfo.drawGraphics.setFont(drawInfo.font);
                drawInfo.drawGraphics.setX(n3);
                drawInfo.drawGraphics.fillRect(drawInfo.editorUI.lineNumberWidth);
                drawInfo.drawGraphics.setX(n5);
                drawInfo.drawGraphics.drawChars(0, drawInfo.lineNumberChars.length, drawInfo.lineNumberChars.length * drawInfo.editorUI.lineNumberDigitWidth);
                drawInfo.drawGraphics.setBuffer(null);
                n2 += drawInfo.lineHeight;
            }
        }
        drawInfo.graphics.setColor(drawInfo.defaultColoring.getBackColor());
    }

    public final void draw(DrawGraphics drawGraphics, EditorUI editorUI, int n, int n2, int n3, int n4, int n5) throws BadLocationException {
        this.draw(null, drawGraphics, editorUI, n, n2, n3, n4, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw(View view, DrawGraphics drawGraphics, EditorUI editorUI, int n, int n2, int n3, int n4, int n5) throws BadLocationException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("draw-start: [" + n3 + ", " + n4 + "] --------------------");
        }
        try {
            this.drawInternal(view, drawGraphics, editorUI, n, n2, n3, n4, n5);
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("draw-end: [" + n3 + ", " + n4 + "] --------------------");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void drawInternal(View view, DrawGraphics drawGraphics, EditorUI editorUI, int n, int n2, int n3, int n4, int n5) throws BadLocationException {
        Object object;
        Document document;
        assert (drawGraphics != null) : "The parameter 'drawGraphics' is null.";
        assert (editorUI != null) : "The parameter 'editorUI' is null.";
        Document document2 = document = view != null ? view.getDocument() : editorUI.getDocument();
        assert (document instanceof BaseDocument) : "No BaseDocument available, doc = " + document;
        if (n < 0 || n2 < 0 || n > n2 || n3 < 0 || n4 < 0 || n2 > document.getLength() + 1 || n5 != -1 && n5 != Integer.MAX_VALUE && (n5 < n || n5 > n2)) {
            String string = "Invalid parameters: startOffset = " + n + ", endOffset = " + n2 + ", targetOffset = " + n5 + ", startX = " + n3 + ", startY = " + n4 + ", docLen = " + document.getLength();
            throw new BadLocationException(string, Integer.MIN_VALUE);
        }
        if (LOG.isLoggable(Level.FINER)) {
            object = ((BaseDocument)document).getParagraphElement(0).getParentElement();
            int n6 = object.getElementIndex(n);
            int n7 = object.getElement(n6).getStartOffset();
            int n8 = object.getElementIndex(n2);
            int n9 = object.getElement(n8).getStartOffset();
            Graphics graphics = drawGraphics.getGraphics();
            String string = "---------- DRAWING startOffset=" + n + ", startLine=" + n6 + "(o=" + n7 + "), endOffset=" + n2 + ", endLine=" + n8 + "(o=" + n9 + "), targetOffset = " + n5 + ", clip=" + (graphics != null ? graphics.getClipBounds().toString() : "null") + "  ------------------";
            LOG.finer(string);
        }
        object = editorUI;
        synchronized (object) {
            DrawInfo drawInfo = new DrawInfo();
            drawInfo.doc = (BaseDocument)document;
            drawInfo.component = editorUI.getComponent();
            drawInfo.editorUI = editorUI;
            drawInfo.drawGraphics = drawGraphics;
            drawInfo.drawGraphics.setView(view);
            drawInfo.view = view;
            drawInfo.startX = n3;
            drawInfo.startY = n4;
            drawInfo.doc.readLock();
            try {
                drawInfo.docLen = drawInfo.doc.getLength();
                drawInfo.startOffset = n;
                drawInfo.endOffset = n2;
                drawInfo.targetOffset = n5;
                if (drawInfo.view != null) {
                    assert (drawInfo.view instanceof DrawEngineLineView) : "DrawEngine should only be accessed from DrawEngineLineView";
                    Element element = drawInfo.doc.getParagraphElement(drawInfo.startOffset);
                    drawInfo.lineStartOffset = element.getStartOffset();
                    drawInfo.lineEndOffset = element.getEndOffset();
                } else {
                    drawInfo.lineStartOffset = drawInfo.startOffset;
                    drawInfo.lineEndOffset = drawInfo.endOffset;
                }
                if (drawInfo.endOffset < drawInfo.lineEndOffset) {
                    ++drawInfo.endOffset;
                } else if (drawInfo.endOffset == drawInfo.docLen) {
                    ++drawInfo.endOffset;
                    ++drawInfo.lineEndOffset;
                }
                this.initInfo(drawInfo);
                this.drawArea(drawInfo);
                if (drawInfo.endOffset >= drawInfo.docLen) {
                    this.drawTheRestOfTextLine(drawInfo);
                }
                if (drawInfo.graphics != null) {
                    this.graphicsSpecificUpdates(drawInfo);
                }
            }
            finally {
                drawInfo.doc.readUnlock();
                drawInfo.drawGraphics.setBuffer(null);
                drawInfo.drawGraphics.finish();
            }
        }
    }

    static {
        SPACE = new char[]{' '};
    }

    static class DrawInfo
    implements DrawContext {
        Color foreColor;
        Color backColor;
        Color underlineColor;
        Color waveUnderlineColor;
        Color strikeThroughColor;
        Color topBorderLineColor;
        Color rightBorderLineColor;
        Color bottomBorderLineColor;
        Color leftBorderLineColor;
        Font font;
        int startOffset;
        int endOffset;
        int lineStartOffset;
        int lineEndOffset;
        boolean bol;
        boolean eol;
        EditorUI editorUI;
        char[] buffer;
        int bufferStartOffset;
        int fragmentOffset;
        int fragmentLength;
        int areaOffset;
        int areaLength;
        DrawGraphics drawGraphics;
        int targetOffset;
        Segment text;
        char[] textArray;
        View view;
        JTextComponent component;
        BaseDocument doc;
        int docLen;
        int visualColumn;
        int x;
        int y;
        int startX;
        int startY;
        int lineHeight;
        Coloring defaultColoring;
        int tabSize;
        boolean continueDraw;
        int startLineNumber;
        int lineIndex;
        int[] lineStartOffsets;
        char[] lineNumberChars;
        Coloring lineNumberColoring;
        Graphics graphics;
        boolean lineNumbering;
        boolean syncedLineNumbering;
        DrawLayer[] layers;
        boolean[] layerActives;
        int[] layerActivityChangeOffsets;
        int updateOffset;
        int layerUpdateOffset;
        boolean drawMarkUpdate;
        List<MarkFactory.DrawMark> drawMarkList;
        int drawMarkIndex;
        MarkFactory.DrawMark drawMark;
        int drawMarkOffset;
        int drawnLength;
        int fragmentStartIndex;
        boolean tabsFragment;
        int spaceWidth;
        int fragmentWidth;
        int fragmentCharCount;

        DrawInfo() {
        }

        public Color getForeColor() {
            return this.foreColor;
        }

        public void setForeColor(Color color) {
            this.foreColor = color;
        }

        public Color getBackColor() {
            return this.backColor;
        }

        public void setBackColor(Color color) {
            this.backColor = color;
        }

        public Color getUnderlineColor() {
            return this.underlineColor;
        }

        public void setUnderlineColor(Color color) {
            this.underlineColor = color;
        }

        public Color getWaveUnderlineColor() {
            return this.waveUnderlineColor;
        }

        public void setWaveUnderlineColor(Color color) {
            this.waveUnderlineColor = color;
        }

        public Color getStrikeThroughColor() {
            return this.strikeThroughColor;
        }

        public void setStrikeThroughColor(Color color) {
            this.strikeThroughColor = color;
        }

        public Color getTopBorderLineColor() {
            return this.topBorderLineColor;
        }

        public void setTopBorderLineColor(Color color) {
            this.topBorderLineColor = color;
        }

        public Color getRightBorderLineColor() {
            return this.rightBorderLineColor;
        }

        public void setRightBorderLineColor(Color color) {
            this.rightBorderLineColor = color;
        }

        public Color getBottomBorderLineColor() {
            return this.bottomBorderLineColor;
        }

        public void setBottomBorderLineColor(Color color) {
            this.bottomBorderLineColor = color;
        }

        public Color getLeftBorderLineColor() {
            return this.leftBorderLineColor;
        }

        public void setLeftBorderLineColor(Color color) {
            this.leftBorderLineColor = color;
        }

        public Font getFont() {
            return this.font;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public boolean isBOL() {
            return this.bol;
        }

        public boolean isEOL() {
            return this.eol;
        }

        public EditorUI getEditorUI() {
            return this.editorUI;
        }

        public char[] getBuffer() {
            return this.buffer;
        }

        public int getBufferStartOffset() {
            return this.bufferStartOffset;
        }

        public TokenID getTokenID() {
            return null;
        }

        public TokenContextPath getTokenContextPath() {
            return null;
        }

        public int getTokenOffset() {
            return this.areaOffset;
        }

        public int getTokenLength() {
            return this.areaLength;
        }

        public int getFragmentOffset() {
            return this.fragmentOffset;
        }

        public int getFragmentLength() {
            return this.fragmentLength;
        }
    }
}

