/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.AdjustFinder;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.AtomicLockDocument;
import org.netbeans.editor.AtomicLockEvent;
import org.netbeans.editor.AtomicLockListener;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.CharSeq;
import org.netbeans.editor.DocumentContent;
import org.netbeans.editor.DocumentUtilities;
import org.netbeans.editor.DrawEngine;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.DrawLayerList;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.FixLineSyntaxState;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GapStart;
import org.netbeans.editor.LineRootElement;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkVector;
import org.netbeans.editor.MultiMark;
import org.netbeans.editor.PrintContainer;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TextBatchProcessor;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.ListenerList;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.modules.editor.lib.FormatterOverride;
import org.openide.util.Lookup;

public class BaseDocument
extends AbstractDocument
implements SettingsChangeListener,
AtomicLockDocument {
    private static final Logger LOG = Logger.getLogger(BaseDocument.class.getName());
    private static final Logger LOG_LISTENER = Logger.getLogger(BaseDocument.class.getName() + ".listener");
    public static final String ID_PROP = "id";
    public static final String READ_LINE_SEPARATOR_PROP = "__EndOfLine__";
    public static final String WRITE_LINE_SEPARATOR_PROP = "write-line-separator";
    public static final String FILE_NAME_PROP = "file-name";
    public static final String WRAP_SEARCH_MARK_PROP = "wrap-search-mark";
    public static final String UNDO_MANAGER_PROP = "undo-manager";
    public static final String KIT_CLASS_PROP = "kit-class";
    public static final String STRING_FINDER_PROP = "string-finder";
    public static final String STRING_BWD_FINDER_PROP = "string-bwd-finder";
    public static final String BLOCKS_FINDER_PROP = "blocks-finder";
    public static final String LINE_LIMIT_PROP = "line-limit";
    public static final String LINE_BATCH_SIZE = "line-batch-size";
    public static final String LS_CR = "\r";
    public static final String LS_LF = "\n";
    public static final String LS_CRLF = "\r\n";
    public static final String FORMATTER = "formatter";
    private static final String BEFORE_MODIFICATION_LISTENER = "modificationListener";
    private static final int MAX_READ_THREADS = 10;
    private static final String WRITE_LOCK_MISSING = "extWriteUnlock() without extWriteLock()";
    private static final Object annotationsLock = new Object();
    private static final Object getVisColFromPosLock = new Object();
    private static final Object getOffsetFromVisColLock = new Object();
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.document");
    private static final boolean debugStack = Boolean.getBoolean("netbeans.debug.editor.document.stack");
    private static final boolean debugNoText = Boolean.getBoolean("netbeans.debug.editor.document.notext");
    private static final boolean debugRead = Boolean.getBoolean("netbeans.debug.editor.document.read");
    public static final ThreadLocal THREAD_LOCAL_LOCK_DEPTH = new ThreadLocal();
    private static final Integer[] lockIntegers = new Integer[]{null, new Integer(1), new Integer(2), new Integer(3)};
    private int tabSize = SettingsDefaults.defaultTabSize;
    private Integer shiftWidth;
    private int writeDepth;
    private int atomicDepth;
    protected boolean inited;
    protected boolean modified;
    PropertyChangeListener findSupportListener;
    protected Element defaultRootElem;
    private SyntaxSupport syntaxSupport;
    private DrawLayerList drawLayerList = new DrawLayerList();
    boolean undoMergeReset;
    Class kitClass;
    private AtomicCompoundEdit atomicEdits;
    private Acceptor identifierAcceptor;
    private Acceptor whitespaceAcceptor;
    private ArrayList syntaxList = new ArrayList();
    protected LineRootElement lineRootElement;
    UndoableEdit lastModifyUndoEdit;
    private Annotations annotations;
    private boolean composedText = false;
    final Map<MultiMark, Mark> marks = new HashMap<MultiMark, Mark>();
    final MarkVector marksStorage = new MarkVector();
    private FinderFactory.VisColPosFwdFinder visColPosFwdFinder;
    private FinderFactory.PosVisColFwdFinder posVisColFwdFinder;
    private AtomicLockEvent atomicLockEventInstance = new AtomicLockEvent(this);
    private FixLineSyntaxState fixLineSyntaxState;
    private UndoableEdit removeUpdateLineUndo;
    private Object[] atomicLockListenerList;
    private final ThreadLocal STATUS = new ThreadLocal();
    private boolean modsUndoneOrRedone;
    private DocumentListener postModificationDocumentListener;
    private ListenerList<DocumentListener> postModificationDocumentListenerList = new ListenerList();
    private Position lastPositionEditedByTyping = null;
    private Formatter formatter;

    public BaseDocument(Class clazz, boolean bl) {
        super(new DocumentContent());
        this.kitClass = clazz;
        this.setDocumentProperties(this.createDocumentProperties(this.getDocumentProperties()));
        super.addDocumentListener(org.netbeans.lib.editor.util.swing.DocumentUtilities.initPriorityListening((Document)this));
        this.putProperty(GapStart.class, this.getDocumentContent());
        this.putProperty(CharSequence.class, this.getDocumentContent().createCharSequenceView());
        this.putProperty("supportsModificationListener", Boolean.TRUE);
        this.lineRootElement = new LineRootElement(this);
        this.settingsChange(null);
        Settings.addSettingsChangeListener(this);
        this.putProperty(READ_LINE_SEPARATOR_PROP, Analyzer.getPlatformLS());
        BaseKit baseKit = BaseKit.getKit(clazz);
        if (baseKit != null) {
            baseKit.initDocument(this);
        }
        if (bl) {
            Registry.addDocument(this);
        }
        this.findSupportListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BaseDocument.this.findSupportChange(propertyChangeEvent);
            }
        };
        FindSupport.getFindSupport().addPropertyChangeListener(this.findSupportListener);
        this.findSupportChange(null);
    }

    private DocumentContent getDocumentContent() {
        return (DocumentContent)this.getContent();
    }

    public CharSeq getText() {
        return this.getDocumentContent();
    }

    private void findSupportChange(PropertyChangeEvent propertyChangeEvent) {
        this.putProperty(STRING_FINDER_PROP, null);
        this.putProperty(STRING_BWD_FINDER_PROP, null);
        this.putProperty(BLOCKS_FINDER_PROP, null);
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        Object object;
        String string;
        String string2 = string = settingsChangeEvent != null ? settingsChangeEvent.getSettingName() : null;
        if (string == null || "tab-size".equals(string)) {
            this.tabSize = SettingsUtil.getPositiveInteger(this.kitClass, "tab-size", SettingsDefaults.defaultTabSize);
        }
        if ((string == null || "indent-shift-width".equals(string)) && (object = Settings.getValue(this.kitClass, "indent-shift-width")) instanceof Integer) {
            this.shiftWidth = (Integer)object;
        }
        if (string == null || "read-buffer-size".equals(string)) {
            int n = SettingsUtil.getPositiveInteger(this.kitClass, "read-buffer-size", SettingsDefaults.defaultReadBufferSize);
            this.putProperty("read-buffer-size", new Integer(n));
        }
        if (string == null || "write-buffer-size".equals(string)) {
            int n = SettingsUtil.getPositiveInteger(this.kitClass, "write-buffer-size", SettingsDefaults.defaultWriteBufferSize);
            this.putProperty("write-buffer-size", new Integer(n));
        }
        if (string == null || "mark-distance".equals(string)) {
            int n = SettingsUtil.getPositiveInteger(this.kitClass, "mark-distance", SettingsDefaults.defaultMarkDistance);
            this.putProperty("mark-distance", new Integer(n));
        }
        if (string == null || "max-mark-distance".equals(string)) {
            int n = SettingsUtil.getPositiveInteger(this.kitClass, "max-mark-distance", SettingsDefaults.defaultMaxMarkDistance);
            this.putProperty("max-mark-distance", new Integer(n));
        }
        if (string == null || "min-mark-distance".equals(string)) {
            int n = SettingsUtil.getPositiveInteger(this.kitClass, "min-mark-distance", SettingsDefaults.defaultMinMarkDistance);
            this.putProperty("min-mark-distance", new Integer(n));
        }
        if (string == null || "read-mark-distance".equals(string)) {
            int n = SettingsUtil.getPositiveInteger(this.kitClass, "read-mark-distance", SettingsDefaults.defaultReadMarkDistance);
            this.putProperty("read-mark-distance", new Integer(n));
        }
        if (string == null || "syntax-update-batch-size".equals(string)) {
            int n = SettingsUtil.getPositiveInteger(this.kitClass, "syntax-update-batch-size", SettingsDefaults.defaultSyntaxUpdateBatchSize);
            this.putProperty("syntax-update-batch-size", new Integer(n));
        }
        if (string == null || LINE_BATCH_SIZE.equals(string)) {
            int n = SettingsUtil.getPositiveInteger(this.kitClass, LINE_BATCH_SIZE, SettingsDefaults.defaultLineBatchSize);
            this.putProperty(LINE_BATCH_SIZE, new Integer(n));
        }
        if (string == null || "identifier-acceptor".equals(string)) {
            this.identifierAcceptor = SettingsUtil.getAcceptor(this.kitClass, "identifier-acceptor", AcceptorFactory.LETTER_DIGIT);
        }
        if (string == null || "whitespace-acceptor".equals(string)) {
            this.whitespaceAcceptor = SettingsUtil.getAcceptor(this.kitClass, "whitespace-acceptor", AcceptorFactory.WHITESPACE);
        }
        boolean bl = SettingsUtil.getBoolean(this.kitClass, "word-move-newline-stop", true);
        if (string == null || "next-word-finder".equals(string)) {
            this.putProperty("next-word-finder", SettingsUtil.getValue(this.kitClass, "next-word-finder", new FinderFactory.NextWordFwdFinder(this, bl, false)));
        }
        if (string == null || "previous-word-finder".equals(string)) {
            this.putProperty("previous-word-finder", SettingsUtil.getValue(this.kitClass, "previous-word-finder", new FinderFactory.PreviousWordBwdFinder(this, bl, false)));
        }
        this.formatter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Syntax getFreeSyntax() {
        BaseKit baseKit = BaseKit.getKit(this.kitClass);
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            int n = this.syntaxList.size();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return n > 0 ? (Syntax)this.syntaxList.remove(n - 1) : baseKit.createSyntax(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseSyntax(Syntax syntax) {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            this.syntaxList.add(syntax);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Formatter getLegacyFormatter() {
        if (this.formatter == null) {
            this.formatter = (Formatter)Settings.getValue(this.getKitClass(), FORMATTER);
            if (this.formatter == null) {
                this.formatter = Formatter.getFormatter(this.kitClass);
            }
        }
        return this.formatter;
    }

    public Formatter getFormatter() {
        Formatter formatter = this.getLegacyFormatter();
        FormatterOverride formatterOverride = (FormatterOverride)Lookup.getDefault().lookup(FormatterOverride.class);
        return formatterOverride != null ? formatterOverride.getFormatter(this, formatter) : formatter;
    }

    public SyntaxSupport getSyntaxSupport() {
        if (this.syntaxSupport == null) {
            this.syntaxSupport = BaseKit.getKit(this.kitClass).createSyntaxSupport(this);
        }
        return this.syntaxSupport;
    }

    public int processText(TextBatchProcessor textBatchProcessor, int n, int n2) throws BadLocationException {
        if (n2 == -1) {
            n2 = this.getLength();
        }
        int n3 = (Integer)this.getProperty(LINE_BATCH_SIZE);
        int n4 = n;
        int n5 = -1;
        if (n < n2) {
            while (n5 < 0 && n4 < n2) {
                int n6 = Math.min(Utilities.getRowStart(this, n4, n3), n2);
                if (n6 == -1) {
                    n6 = n2;
                }
                n5 = textBatchProcessor.processTextBatch(this, n4, n6, n6 == n2);
                n3 *= 2;
                n4 = n6;
            }
        } else {
            while (n5 < 0 && n4 > n2) {
                int n7;
                n5 = textBatchProcessor.processTextBatch(this, n4, n7, (n7 = Math.max(Utilities.getRowStart(this, n4, -n3), n2)) == n2);
                n3 *= 2;
                n4 = n7;
            }
        }
        return n5;
    }

    public boolean isIdentifierPart(char c) {
        return this.identifierAcceptor.accept(c);
    }

    public boolean isWhitespace(char c) {
        return this.whitespaceAcceptor.accept(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        boolean bl;
        if (string == null || string.length() == 0) {
            return;
        }
        if (n < 0 || n > this.getLength()) {
            throw new BadLocationException("Wrong insert position " + n, n);
        }
        string = Analyzer.convertLSToLF(string);
        BaseDocumentEvent baseDocumentEvent = null;
        BaseDocument baseDocument = this;
        synchronized (baseDocument) {
            boolean bl2 = bl = this.postModificationDocumentListener != null || this.postModificationDocumentListenerList.getListenerCount() > 0;
            if (bl) {
                this.atomicLock();
            }
        }
        try {
            boolean bl3 = this.notifyModifyCheckStart(n, "insertString() vetoed");
            boolean bl4 = false;
            this.extWriteLock();
            try {
                boolean bl5;
                this.preInsertCheck(n, string, attributeSet);
                UndoableEdit undoableEdit = this.getContent().insertString(n, string);
                if (debug) {
                    System.err.println("BaseDocument.insertString(): doc=" + this + (this.modified ? "" : " - first modification") + ", offset=" + Utilities.offsetToLineColumnString(this, n) + (debugNoText ? "" : ", text='" + string + "'"));
                }
                if (debugStack) {
                    Thread.dumpStack();
                }
                BaseDocumentEvent baseDocumentEvent2 = this.getDocumentEvent(n, string.length(), DocumentEvent.EventType.INSERT, attributeSet);
                this.preInsertUpdate(baseDocumentEvent2, attributeSet);
                if (undoableEdit != null) {
                    baseDocumentEvent2.addEdit(undoableEdit);
                    this.lastModifyUndoEdit = undoableEdit;
                }
                this.modified = true;
                if (this.atomicDepth > 0) {
                    if (this.atomicEdits == null) {
                        this.atomicEdits = new AtomicCompoundEdit();
                    }
                    this.atomicEdits.addEdit(baseDocumentEvent2);
                }
                this.insertUpdate(baseDocumentEvent2, attributeSet);
                baseDocumentEvent2.end();
                this.fireInsertUpdate(baseDocumentEvent2);
                boolean bl6 = bl5 = attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute);
                if (this.composedText && !bl5) {
                    this.composedText = false;
                }
                if (!this.composedText && bl5) {
                    this.composedText = true;
                }
                if (this.atomicDepth == 0 && !bl5) {
                    this.fireUndoableEditUpdate(new UndoableEditEvent(this, baseDocumentEvent2));
                }
                bl4 = true;
                baseDocumentEvent = baseDocumentEvent2;
            }
            finally {
                this.extWriteUnlock();
                if (bl3) {
                    this.notifyModifyCheckEnd(bl4);
                }
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            try {
                if (baseDocumentEvent == null) throw throwable;
                if (this.postModificationDocumentListener != null) {
                    this.postModificationDocumentListener.insertUpdate(baseDocumentEvent);
                }
                for (DocumentListener documentListener : this.postModificationDocumentListenerList.getListeners()) {
                    documentListener.insertUpdate(baseDocumentEvent);
                }
                throw throwable;
            }
            finally {
                this.atomicUnlock();
            }
        }
        try {
            if (baseDocumentEvent == null) return;
            if (this.postModificationDocumentListener != null) {
                this.postModificationDocumentListener.insertUpdate(baseDocumentEvent);
            }
            for (DocumentListener bl4 : this.postModificationDocumentListenerList.getListeners()) {
                bl4.insertUpdate(baseDocumentEvent);
            }
            return;
        }
        finally {
            this.atomicUnlock();
        }
    }

    public void checkTrailingSpaces(int n) {
        try {
            int n2;
            int n3 = Utilities.getLineOffset(this, n);
            int n4 = n2 = this.lastPositionEditedByTyping != null ? Utilities.getLineOffset(this, this.lastPositionEditedByTyping.getOffset()) : -1;
            if (n2 != -1 && n2 != n3) {
                int n5;
                int n6;
                Element element = this.getDefaultRootElement();
                Element element2 = element.getElement(n2);
                int n7 = element2.getStartOffset();
                String string = this.getText(n7, (n6 = element2.getEndOffset()) - n7);
                int n8 = string.length() - 1;
                if (n8 >= 0 && string.charAt(n8) == '\n' && --n8 >= 0 && string.charAt(n8) == '\r') {
                    --n8;
                }
                for (n5 = n8; n5 >= 0 && Character.isWhitespace(string.charAt(n5)) && string.charAt(n5) != '\n' && string.charAt(n5) != '\r'; --n5) {
                }
                if (++n5 >= 0 && n5 <= n8) {
                    this.remove(n7 + n5, n8 - n5 + 1);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n, int n2) throws BadLocationException {
        block27: {
            if (n2 > 0) {
                block28: {
                    boolean bl;
                    if (n < 0) {
                        throw new BadLocationException("Wrong remove position " + n, n);
                    }
                    BaseDocumentEvent baseDocumentEvent = null;
                    BaseDocument baseDocument = this;
                    synchronized (baseDocument) {
                        boolean bl2 = bl = this.postModificationDocumentListener != null || this.postModificationDocumentListenerList.getListenerCount() > 0;
                        if (bl) {
                            this.atomicLock();
                        }
                    }
                    try {
                        boolean bl3 = this.notifyModifyCheckStart(n, "remove() vetoed");
                        boolean bl4 = false;
                        this.extWriteLock();
                        try {
                            int n3 = this.getLength();
                            if (n < 0 || n > n3) {
                                throw new BadLocationException("Wrong remove position " + n, n);
                            }
                            if (n + n2 > n3) {
                                throw new BadLocationException("End offset of removed text " + (n + n2) + " > getLength()=" + n3, n + n2);
                            }
                            this.preRemoveCheck(n, n2);
                            BaseDocumentEvent baseDocumentEvent2 = this.getDocumentEvent(n, n2, DocumentEvent.EventType.REMOVE, null);
                            this.removeUpdate(baseDocumentEvent2);
                            UndoableEdit undoableEdit = this.getContent().remove(n, n2);
                            if (undoableEdit != null) {
                                baseDocumentEvent2.addEdit(undoableEdit);
                                this.lastModifyUndoEdit = undoableEdit;
                            }
                            if (debug) {
                                System.err.println("BaseDocument.remove(): doc=" + this + ", origDocLen=" + n3 + ", offset=" + Utilities.offsetToLineColumnString(this, n) + ", len=" + n2 + (debugNoText ? "" : ", removedText='" + ((DocumentContent.Edit)undoableEdit).getUndoRedoText() + "'"));
                            }
                            if (debugStack) {
                                Thread.dumpStack();
                            }
                            if (this.atomicDepth > 0) {
                                if (this.atomicEdits == null) {
                                    this.atomicEdits = new AtomicCompoundEdit();
                                }
                                this.atomicEdits.addEdit(baseDocumentEvent2);
                            }
                            this.postRemoveUpdate(baseDocumentEvent2);
                            baseDocumentEvent2.end();
                            this.fireRemoveUpdate(baseDocumentEvent2);
                            if (this.atomicDepth == 0 && !this.composedText) {
                                this.fireUndoableEditUpdate(new UndoableEditEvent(this, baseDocumentEvent2));
                            }
                            bl4 = true;
                            baseDocumentEvent = baseDocumentEvent2;
                        }
                        finally {
                            this.extWriteUnlock();
                            if (bl3) {
                                this.notifyModifyCheckEnd(bl4);
                            }
                        }
                        if (!bl) break block27;
                        if (baseDocumentEvent == null) break block28;
                        if (this.postModificationDocumentListener != null) {
                            this.postModificationDocumentListener.removeUpdate(baseDocumentEvent);
                        }
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            if (baseDocumentEvent != null) {
                                if (this.postModificationDocumentListener != null) {
                                    this.postModificationDocumentListener.removeUpdate(baseDocumentEvent);
                                }
                                for (DocumentListener documentListener : this.postModificationDocumentListenerList.getListeners()) {
                                    documentListener.removeUpdate(baseDocumentEvent);
                                }
                            }
                            this.atomicUnlock();
                        }
                        throw throwable;
                    }
                    for (DocumentListener documentListener : this.postModificationDocumentListenerList.getListeners()) {
                        documentListener.removeUpdate(baseDocumentEvent);
                    }
                }
                this.atomicUnlock();
            }
        }
    }

    boolean notifyModifyCheckStart(int n, String string) throws BadLocationException {
        boolean bl;
        NotifyModifyStatus notifyModifyStatus = (NotifyModifyStatus)this.STATUS.get();
        if (notifyModifyStatus == null) {
            notifyModifyStatus = new NotifyModifyStatus(this);
            this.STATUS.set(notifyModifyStatus);
            this.notifyModify(notifyModifyStatus);
            bl = true;
        } else {
            bl = false;
        }
        if (notifyModifyStatus.isModificationVetoed()) {
            if (bl) {
                this.STATUS.set(null);
            }
            throw new BadLocationException(string, n);
        }
        return bl;
    }

    void notifyModifyCheckEnd(boolean bl) {
        NotifyModifyStatus notifyModifyStatus = (NotifyModifyStatus)this.STATUS.get();
        this.STATUS.set(null);
        if (!bl) {
            this.notifyUnmodify(notifyModifyStatus);
        }
    }

    protected void preInsertCheck(int n, String string, AttributeSet attributeSet) throws BadLocationException {
    }

    protected void preRemoveCheck(int n, int n2) throws BadLocationException {
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        super.insertUpdate(defaultDocumentEvent, attributeSet);
        org.netbeans.lib.editor.util.swing.DocumentUtilities.addEventPropertyStorage((DocumentEvent)defaultDocumentEvent);
        org.netbeans.lib.editor.util.swing.DocumentUtilities.putEventProperty((DocumentEvent)defaultDocumentEvent, String.class, (Object)((BaseDocumentEvent)defaultDocumentEvent).getText());
        MarksStorageUndo marksStorageUndo = new MarksStorageUndo(defaultDocumentEvent);
        marksStorageUndo.updateMarksStorage();
        defaultDocumentEvent.addEdit(marksStorageUndo);
        UndoableEdit undoableEdit = this.lineRootElement.insertUpdate(defaultDocumentEvent.getOffset(), defaultDocumentEvent.getLength());
        if (undoableEdit != null) {
            defaultDocumentEvent.addEdit(undoableEdit);
        }
        this.fixLineSyntaxState.update(false);
        defaultDocumentEvent.addEdit(this.fixLineSyntaxState.createAfterLineUndo());
        this.fixLineSyntaxState = null;
        org.netbeans.lib.editor.util.swing.DocumentUtilities.addEventPropertyStorage((DocumentEvent)defaultDocumentEvent);
        BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)defaultDocumentEvent;
        org.netbeans.lib.editor.util.swing.DocumentUtilities.putEventProperty((DocumentEvent)defaultDocumentEvent, String.class, (Object)baseDocumentEvent.getText());
    }

    protected void preInsertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        this.fixLineSyntaxState = new FixLineSyntaxState(defaultDocumentEvent);
        defaultDocumentEvent.addEdit(this.fixLineSyntaxState.createBeforeLineUndo());
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        String string;
        super.removeUpdate(defaultDocumentEvent);
        org.netbeans.lib.editor.util.swing.DocumentUtilities.addEventPropertyStorage((DocumentEvent)defaultDocumentEvent);
        try {
            string = this.getText(defaultDocumentEvent.getOffset(), defaultDocumentEvent.getLength());
        }
        catch (BadLocationException badLocationException) {
            string = null;
        }
        org.netbeans.lib.editor.util.swing.DocumentUtilities.putEventProperty((DocumentEvent)defaultDocumentEvent, String.class, (Object)string);
        this.removeUpdateLineUndo = this.lineRootElement.removeUpdate(defaultDocumentEvent.getOffset(), defaultDocumentEvent.getLength());
        this.fixLineSyntaxState = new FixLineSyntaxState(defaultDocumentEvent);
        defaultDocumentEvent.addEdit(this.fixLineSyntaxState.createBeforeLineUndo());
    }

    protected void postRemoveUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        super.postRemoveUpdate(defaultDocumentEvent);
        MarksStorageUndo marksStorageUndo = new MarksStorageUndo(defaultDocumentEvent);
        marksStorageUndo.updateMarksStorage();
        defaultDocumentEvent.addEdit(marksStorageUndo);
        if (this.removeUpdateLineUndo != null) {
            defaultDocumentEvent.addEdit(this.removeUpdateLineUndo);
            this.removeUpdateLineUndo = null;
        }
        this.fixLineSyntaxState.update(false);
        defaultDocumentEvent.addEdit(this.fixLineSyntaxState.createAfterLineUndo());
        this.fixLineSyntaxState = null;
        org.netbeans.lib.editor.util.swing.DocumentUtilities.addEventPropertyStorage((DocumentEvent)defaultDocumentEvent);
        BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)defaultDocumentEvent;
        org.netbeans.lib.editor.util.swing.DocumentUtilities.putEventProperty((DocumentEvent)defaultDocumentEvent, String.class, (Object)baseDocumentEvent.getText());
    }

    public String getText(int[] nArray) throws BadLocationException {
        return this.getText(nArray[0], nArray[1] - nArray[0]);
    }

    public char[] getChars(int n, int n2) throws BadLocationException {
        char[] cArray = new char[n2];
        this.getChars(n, cArray, 0, n2);
        return cArray;
    }

    public char[] getChars(int[] nArray) throws BadLocationException {
        return this.getChars(nArray[0], nArray[1] - nArray[0]);
    }

    public void getChars(int n, char[] cArray, int n2, int n3) throws BadLocationException {
        DocumentUtilities.copyText(this, n, n + n3, cArray, n2);
    }

    public int find(Finder finder, int n, int n2) throws BadLocationException {
        boolean bl;
        int n3;
        int n4 = this.getLength();
        if (n2 == -1) {
            n2 = n4;
        }
        if (n == -1) {
            n = n4;
        }
        if (finder instanceof AdjustFinder) {
            if (n == n2) {
                finder.reset();
                return -1;
            }
            boolean bl2 = n < n2;
            n = ((AdjustFinder)finder).adjustStartPos(this, n);
            n2 = ((AdjustFinder)finder).adjustLimitPos(this, n2);
            int n5 = bl2 ? (n >= n2 ? 1 : 0) : (n3 = n <= n2 ? 1 : 0);
            if (n3 != 0) {
                finder.reset();
                return -1;
            }
        }
        finder.reset();
        if (n == n2) {
            return -1;
        }
        Segment segment = new Segment();
        n3 = DocumentUtilities.getGapStart(this);
        if (n3 == -1) {
            throw new IllegalStateException("Cannot get gapStart");
        }
        int n6 = n;
        boolean bl3 = bl = n <= n2;
        if (bl) {
            while (n6 >= n && n6 < n2) {
                int n7;
                int n8;
                if (n6 < n3) {
                    n8 = n;
                    n7 = Math.min(n3, n2);
                } else {
                    n8 = Math.max(n3, n);
                    n7 = n2;
                }
                this.getText(n8, n7 - n8, segment);
                n6 = finder.find(n8 - segment.offset, segment.array, segment.offset, segment.offset + segment.count, n6, n2);
                if (!finder.isFound()) continue;
                return n6;
            }
        } else {
            --n6;
            while (n2 <= n6 && n6 <= n) {
                int n9;
                int n10;
                if (n6 < n3) {
                    n10 = n2;
                    n9 = Math.min(n3, n);
                } else {
                    n10 = Math.max(n3, n2);
                    n9 = n;
                }
                this.getText(n10, n9 - n10, segment);
                n6 = finder.find(n10 - segment.offset, segment.array, segment.offset, segment.offset + segment.count, n6, n2);
                if (!finder.isFound()) continue;
                return n6;
            }
        }
        return -1;
    }

    public void repaintBlock(int n, int n2) {
        BaseDocumentEvent baseDocumentEvent = this.getDocumentEvent(n, n2 - n, DocumentEvent.EventType.CHANGE, null);
        this.fireChangedUpdate(baseDocumentEvent);
    }

    public void print(PrintContainer printContainer) {
        this.print(printContainer, true, true, 0, this.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintContainer printContainer, boolean bl, boolean bl2, int n, int n2) {
        this.readLock();
        try {
            EditorUI editorUI = BaseKit.getKit(this.kitClass).createPrintEditorUI(this, bl, bl2);
            DrawGraphics.PrintDG printDG = new DrawGraphics.PrintDG(printContainer);
            DrawEngine.getDrawEngine().draw(printDG, editorUI, n, n2, 0, 0, Integer.MAX_VALUE);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintContainer printContainer, boolean bl, Boolean bl2, int n, int n2) {
        this.readLock();
        try {
            boolean bl3 = true;
            boolean bl4 = false;
            if (bl2 != null) {
                bl3 = bl2;
                bl4 = bl2;
            }
            EditorUI editorUI = BaseKit.getKit(this.kitClass).createPrintEditorUI(this, bl, bl3);
            if (bl4) {
                editorUI.setLineNumberVisibleSetting(true);
                editorUI.setLineNumberEnabled(true);
                editorUI.updateLineNumberWidth(0);
            }
            DrawGraphics.PrintDG printDG = new DrawGraphics.PrintDG(printContainer);
            DrawEngine.getDrawEngine().draw(printDG, editorUI, n, n2, 0, 0, Integer.MAX_VALUE);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        finally {
            this.readUnlock();
        }
    }

    public Position createPosition(int n, Position.Bias bias) throws BadLocationException {
        return this.getDocumentContent().createBiasPosition(n, bias);
    }

    MultiMark createMark(int n) throws BadLocationException {
        return this.getDocumentContent().createMark(n);
    }

    MultiMark createBiasMark(int n, Position.Bias bias) throws BadLocationException {
        return this.getDocumentContent().createBiasMark(n, bias);
    }

    public Element[] getRootElements() {
        Element[] elementArray = new Element[]{this.getDefaultRootElement()};
        return elementArray;
    }

    public Element getDefaultRootElement() {
        if (this.defaultRootElem == null) {
            this.defaultRootElem = this.getLineRootElement();
        }
        return this.defaultRootElem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Runnable runnable) {
        this.readLock();
        assert (this.incrementThreadLocalLockDepth());
        try {
            runnable.run();
        }
        finally {
            assert (this.decrementThreadLocalLockDepth());
            this.readUnlock();
        }
    }

    private boolean incrementThreadLocalLockDepth() {
        int n;
        Integer n2 = (Integer)THREAD_LOCAL_LOCK_DEPTH.get();
        n2 = n2 == null ? lockIntegers[1] : ((n = n2 + 1) < lockIntegers.length ? lockIntegers[n] : new Integer(n));
        THREAD_LOCAL_LOCK_DEPTH.set(n2);
        return true;
    }

    private boolean decrementThreadLocalLockDepth() {
        Integer n = (Integer)THREAD_LOCAL_LOCK_DEPTH.get();
        assert (n != null);
        int n2 = n - 1;
        assert (n2 >= 0);
        THREAD_LOCAL_LOCK_DEPTH.set(n2 < lockIntegers.length ? lockIntegers[n2] : new Integer(n2));
        return true;
    }

    public void runAtomic(Runnable runnable) {
        this.runAtomicAsUser(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAtomicAsUser(Runnable runnable) {
        boolean bl = false;
        this.atomicLock();
        try {
            runnable.run();
            bl = true;
        }
        finally {
            try {
                if (!bl) {
                    this.breakAtomicLock();
                }
            }
            finally {
                this.atomicUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Reader reader, int n) throws IOException, BadLocationException {
        this.extWriteLock();
        try {
            AbstractDocument.Content content;
            if (n < 0 || n > this.getLength()) {
                throw new BadLocationException("BaseDocument.read()", n);
            }
            if (this.inited || this.modified) {
                Analyzer.read(this, reader, n);
            } else {
                Analyzer.initialRead(this, reader, true);
                this.inited = true;
            }
            if (debugRead) {
                System.err.println("BaseDocument.read(): StreamDescriptionProperty: " + this.getProperty("stream"));
            }
            if ((content = this.getContent()) instanceof DocumentContent) {
                DocumentContent documentContent = (DocumentContent)content;
                if (!documentContent.isConservativeReallocation()) {
                    documentContent.compact();
                }
                documentContent.setConservativeReallocation(true);
            }
            this.lastModifyUndoEdit = null;
        }
        finally {
            this.extWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer writer, int n, int n2) throws IOException, BadLocationException {
        this.readLock();
        try {
            if (n < 0 || n + n2 > this.getLength()) {
                throw new BadLocationException("BaseDocument.write()", n);
            }
            Analyzer.write(this, writer, n, n2);
            writer.flush();
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateSyntaxMarks() {
        this.extWriteLock();
        try {
            FixLineSyntaxState.invalidateAllSyntaxStateInfos(this);
            BaseDocumentEvent baseDocumentEvent = this.getDocumentEvent(0, this.getLength(), DocumentEvent.EventType.CHANGE, null);
            this.fireChangedUpdate(baseDocumentEvent);
        }
        finally {
            this.extWriteUnlock();
        }
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public int getShiftWidth() {
        if (this.shiftWidth != null) {
            return this.shiftWidth;
        }
        return this.getFormatter().getSpacesPerTab();
    }

    public final Class getKitClass() {
        return this.kitClass;
    }

    public void resetUndoMerge() {
        this.undoMergeReset = true;
    }

    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        super.fireChangedUpdate(documentEvent);
    }

    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        super.fireInsertUpdate(documentEvent);
    }

    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        super.fireRemoveUpdate(documentEvent);
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent undoableEditEvent) {
        Object[] objectArray = this.atomicLockListenerList != null ? this.atomicLockListenerList : this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != UndoableEditListener.class) continue;
            ((UndoableEditListener)objectArray[i + 1]).undoableEditHappened(undoableEditEvent);
        }
    }

    public final synchronized void extWriteLock() {
        if (Thread.currentThread() != this.getCurrentWriter()) {
            super.writeLock();
            assert (this.incrementThreadLocalLockDepth());
        } else {
            ++this.writeDepth;
        }
    }

    public final synchronized void extWriteUnlock() {
        if (Thread.currentThread() != this.getCurrentWriter()) {
            throw new RuntimeException(WRITE_LOCK_MISSING);
        }
        if (this.writeDepth == 0) {
            assert (this.decrementThreadLocalLockDepth());
            super.writeUnlock();
        } else {
            --this.writeDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void atomicLock() {
        BaseDocument baseDocument = this;
        synchronized (baseDocument) {
            NotifyModifyStatus notifyModifyStatus = (NotifyModifyStatus)this.STATUS.get();
            if (notifyModifyStatus == null) {
                notifyModifyStatus = new NotifyModifyStatus(this);
                this.STATUS.set(notifyModifyStatus);
            }
            this.extWriteLock();
            ++this.atomicDepth;
            if (this.atomicDepth == 1) {
                this.fireAtomicLock(this.atomicLockEventInstance);
                this.atomicLockListenerList = this.listenerList.getListenerList();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void atomicUnlock() {
        boolean bl = false;
        boolean bl2 = false;
        Object object = this;
        synchronized (object) {
            this.extWriteUnlock();
            if (this.atomicDepth == 0) {
                throw new IllegalStateException("atomicUnlock() without atomicLock()");
            }
            if (--this.atomicDepth == 0) {
                bl2 = true;
                this.fireAtomicUnlock(this.atomicLockEventInstance);
                if (this.atomicEdits != null && this.atomicEdits.size() > 0) {
                    bl = true;
                    this.atomicEdits.end();
                    this.fireUndoableEditUpdate(new UndoableEditEvent(this, this.atomicEdits));
                    this.atomicEdits = null;
                }
                if (this.modsUndoneOrRedone) {
                    this.modsUndoneOrRedone = false;
                    bl = true;
                }
                this.atomicLockListenerList = null;
            }
        }
        if (bl) {
            object = (NotifyModifyStatus)this.STATUS.get();
            this.notifyModify((NotifyModifyStatus)object);
        }
        if (bl2) {
            this.STATUS.set(null);
        }
    }

    void markModsUndoneOrRedone() {
        this.modsUndoneOrRedone = true;
    }

    public final boolean isAtomicLock() {
        return this.atomicDepth > 0;
    }

    public final void breakAtomicLock() {
        if (this.atomicEdits != null && this.atomicEdits.size() > 0) {
            this.atomicEdits.end();
            this.atomicEdits.undo();
            this.atomicEdits = null;
        }
    }

    private void notifyModify(NotifyModifyStatus notifyModifyStatus) {
        notifyModifyStatus.setModificationVetoed(false);
        VetoableChangeListener vetoableChangeListener = notifyModifyStatus.getBeforeModificationListener();
        if (vetoableChangeListener != null) {
            try {
                vetoableChangeListener.vetoableChange(new PropertyChangeEvent(this, "modified", null, Boolean.TRUE));
            }
            catch (PropertyVetoException propertyVetoException) {
                notifyModifyStatus.setModificationVetoed(true);
            }
        }
    }

    private void notifyUnmodify(NotifyModifyStatus notifyModifyStatus) {
        VetoableChangeListener vetoableChangeListener = notifyModifyStatus.getBeforeModificationListener();
        if (vetoableChangeListener != null) {
            try {
                vetoableChangeListener.vetoableChange(new PropertyChangeEvent(this, "modified", null, Boolean.FALSE));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            notifyModifyStatus.setModificationVetoed(false);
        }
    }

    public void atomicUndo() {
        this.breakAtomicLock();
    }

    public void addAtomicLockListener(AtomicLockListener atomicLockListener) {
        this.listenerList.add(AtomicLockListener.class, atomicLockListener);
    }

    public void removeAtomicLockListener(AtomicLockListener atomicLockListener) {
        this.listenerList.remove(AtomicLockListener.class, atomicLockListener);
    }

    private void fireAtomicLock(AtomicLockEvent atomicLockEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(AtomicLockListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((AtomicLockListener)eventListenerArray[i]).atomicLock(atomicLockEvent);
        }
    }

    private void fireAtomicUnlock(AtomicLockEvent atomicLockEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(AtomicLockListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((AtomicLockListener)eventListenerArray[i]).atomicUnlock(atomicLockEvent);
        }
    }

    protected final int getAtomicDepth() {
        return this.atomicDepth;
    }

    public void addDocumentListener(DocumentListener documentListener) {
        if (LOG_LISTENER.isLoggable(Level.FINE)) {
            LOG_LISTENER.fine("ADD DocumentListener to " + org.netbeans.lib.editor.util.swing.DocumentUtilities.getDocumentListenerCount((Document)this) + " present: " + documentListener + '\n');
            if (LOG_LISTENER.isLoggable(Level.FINER)) {
                LOG_LISTENER.log(Level.FINER, "    StackTrace:\n", new Exception());
            }
        }
        if (!org.netbeans.lib.editor.util.swing.DocumentUtilities.addPriorityDocumentListener((Document)this, (DocumentListener)documentListener, (DocumentListenerPriority)DocumentListenerPriority.DEFAULT)) {
            super.addDocumentListener(documentListener);
        }
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        if (LOG_LISTENER.isLoggable(Level.FINE)) {
            LOG_LISTENER.fine("REMOVE DocumentListener from " + org.netbeans.lib.editor.util.swing.DocumentUtilities.getDocumentListenerCount((Document)this) + " present: " + documentListener + '\n');
            if (LOG_LISTENER.isLoggable(Level.FINER)) {
                LOG_LISTENER.log(Level.FINER, "    StackTrace:\n", new Exception());
            }
        }
        if (!org.netbeans.lib.editor.util.swing.DocumentUtilities.removePriorityDocumentListener((Document)this, (DocumentListener)documentListener, (DocumentListenerPriority)DocumentListenerPriority.DEFAULT)) {
            super.removeDocumentListener(documentListener);
        }
    }

    protected BaseDocumentEvent createDocumentEvent(int n, int n2, DocumentEvent.EventType eventType) {
        return new BaseDocumentEvent(this, n, n2, eventType);
    }

    final BaseDocumentEvent getDocumentEvent(int n, int n2, DocumentEvent.EventType eventType, AttributeSet attributeSet) {
        BaseDocumentEvent baseDocumentEvent = this.createDocumentEvent(n, n2, eventType);
        baseDocumentEvent.attachChangeAttribs(attributeSet);
        return baseDocumentEvent;
    }

    public void setPostModificationDocumentListener(DocumentListener documentListener) {
        this.postModificationDocumentListener = documentListener;
    }

    public void addPostModificationDocumentListener(DocumentListener documentListener) {
        this.postModificationDocumentListenerList.add((EventListener)documentListener);
    }

    public void removePostModificationDocumentListener(DocumentListener documentListener) {
        this.postModificationDocumentListenerList.remove((EventListener)documentListener);
    }

    public boolean isModified() {
        return this.modified;
    }

    public DrawLayer findLayer(String string) {
        return this.drawLayerList.findLayer(string);
    }

    public boolean addLayer(DrawLayer drawLayer, int n) {
        if (this.drawLayerList.add(drawLayer, n)) {
            BaseDocumentEvent baseDocumentEvent = this.getDocumentEvent(0, 0, DocumentEvent.EventType.CHANGE, null);
            baseDocumentEvent.addEdit(new BaseDocumentEvent.DrawLayerChange(drawLayer.getName(), n));
            this.fireChangedUpdate(baseDocumentEvent);
            return true;
        }
        return false;
    }

    final DrawLayerList getDrawLayerList() {
        return this.drawLayerList;
    }

    private LineRootElement getLineRootElement() {
        return this.lineRootElement;
    }

    public Element getParagraphElement(int n) {
        return this.getLineRootElement().getElement(this.getLineRootElement().getElementIndex(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotations getAnnotations() {
        Object object = annotationsLock;
        synchronized (object) {
            if (this.annotations == null) {
                this.annotations = new Annotations(this);
            }
            return this.annotations;
        }
    }

    void prepareSyntax(Segment segment, Syntax syntax, int n, int n2, boolean bl, boolean bl2) throws BadLocationException {
        FixLineSyntaxState.prepareSyntax(this, segment, syntax, n, n2, bl, bl2);
    }

    int getTokenSafeOffset(int n) {
        return FixLineSyntaxState.getTokenSafeOffset(this, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getOffsetFromVisCol(int n, int n2) throws BadLocationException {
        Object object = getOffsetFromVisColLock;
        synchronized (object) {
            if (n2 < 0 || n2 >= this.getLength()) {
                throw new BadLocationException("Invalid start line offset", n2);
            }
            if (n <= 0) {
                return n2;
            }
            if (this.visColPosFwdFinder == null) {
                this.visColPosFwdFinder = new FinderFactory.VisColPosFwdFinder();
            }
            this.visColPosFwdFinder.setVisCol(n);
            this.visColPosFwdFinder.setTabSize(this.getTabSize());
            int n3 = this.find(this.visColPosFwdFinder, n2, -1);
            return n3 != -1 ? n3 : Utilities.getRowEnd(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getVisColFromPos(int n) throws BadLocationException {
        Object object = getVisColFromPosLock;
        synchronized (object) {
            if (n < 0 || n > this.getLength()) {
                throw new BadLocationException("Invalid offset", n);
            }
            if (this.posVisColFwdFinder == null) {
                this.posVisColFwdFinder = new FinderFactory.PosVisColFwdFinder();
            }
            int n2 = Utilities.getRowStart(this, n);
            this.posVisColFwdFinder.setTabSize(this.getTabSize());
            this.find(this.posVisColFwdFinder, n2, n);
            return this.posVisColFwdFinder.getVisCol();
        }
    }

    protected Dictionary createDocumentProperties(Dictionary dictionary) {
        return new LazyPropertyMap(dictionary);
    }

    public String toString() {
        return super.toString() + ", kitClass=" + this.getKitClass() + ", docLen=" + this.getLength();
    }

    public String toStringDetail() {
        return this.toString();
    }

    private static final class NotifyModifyStatus {
        private final VetoableChangeListener beforeModificationListener;
        private boolean modificationVetoed;

        NotifyModifyStatus(BaseDocument baseDocument) {
            this.beforeModificationListener = (VetoableChangeListener)baseDocument.getProperty(BaseDocument.BEFORE_MODIFICATION_LISTENER);
        }

        public boolean isModificationVetoed() {
            return this.modificationVetoed;
        }

        public void setModificationVetoed(boolean bl) {
            this.modificationVetoed = bl;
        }

        public VetoableChangeListener getBeforeModificationListener() {
            return this.beforeModificationListener;
        }
    }

    private static final class MarksStorageUndo
    extends AbstractUndoableEdit {
        private DocumentEvent evt;

        MarksStorageUndo(DocumentEvent documentEvent) {
            this.evt = documentEvent;
        }

        private int getLength() {
            int n = this.evt.getLength();
            if (this.evt.getType() == DocumentEvent.EventType.REMOVE) {
                n = -n;
            }
            return n;
        }

        void updateMarksStorage() {
            BaseDocument baseDocument = (BaseDocument)this.evt.getDocument();
            baseDocument.marksStorage.update(this.evt.getOffset(), this.getLength(), null);
        }

        public void undo() throws CannotUndoException {
            BaseDocument baseDocument = (BaseDocument)this.evt.getDocument();
            baseDocument.marksStorage.update(this.evt.getOffset(), -this.getLength(), null);
            super.undo();
        }

        public void redo() throws CannotRedoException {
            this.updateMarksStorage();
            super.redo();
        }
    }

    protected static class LazyPropertyMap
    extends Hashtable {
        protected LazyPropertyMap(Dictionary dictionary) {
            super(5);
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                this.put(k, dictionary.get(k));
            }
        }

        public Object get(Object object) {
            Object object2 = super.get(object);
            if (object2 instanceof PropertyEvaluator) {
                object2 = ((PropertyEvaluator)object2).getValue();
            }
            return object2;
        }
    }

    public static interface PropertyEvaluator {
        public Object getValue();
    }

    class AtomicCompoundEdit
    extends CompoundEdit {
        private UndoableEdit previousEdit;

        AtomicCompoundEdit() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undo() throws CannotUndoException {
            BaseDocument.this.atomicLock();
            try {
                super.undo();
            }
            finally {
                BaseDocument.this.atomicUnlock();
            }
            if (this.previousEdit != null) {
                this.previousEdit.undo();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void redo() throws CannotRedoException {
            if (this.previousEdit != null) {
                this.previousEdit.redo();
            }
            BaseDocument.this.atomicLock();
            try {
                super.redo();
            }
            finally {
                BaseDocument.this.atomicUnlock();
            }
        }

        public void die() {
            super.die();
            if (this.previousEdit != null) {
                this.previousEdit.die();
                this.previousEdit = null;
            }
        }

        public int size() {
            return this.edits.size();
        }

        public boolean replaceEdit(UndoableEdit undoableEdit) {
            UndoableEdit undoableEdit2;
            if (this.size() == 1 && (undoableEdit2 = (UndoableEdit)this.getEdits().get(0)) instanceof BaseDocumentEvent) {
                BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)undoableEdit2;
                if (undoableEdit instanceof AtomicCompoundEdit) {
                    UndoableEdit undoableEdit3;
                    AtomicCompoundEdit atomicCompoundEdit = (AtomicCompoundEdit)undoableEdit;
                    if (!BaseDocument.this.undoMergeReset && atomicCompoundEdit.getEdits().size() == 1 && (undoableEdit3 = (UndoableEdit)atomicCompoundEdit.getEdits().get(0)) instanceof BaseDocumentEvent && baseDocumentEvent.canMerge((BaseDocumentEvent)undoableEdit3)) {
                        this.previousEdit = undoableEdit;
                        return true;
                    }
                } else if (undoableEdit instanceof BaseDocumentEvent) {
                    BaseDocumentEvent baseDocumentEvent2 = (BaseDocumentEvent)undoableEdit;
                    if (!BaseDocument.this.undoMergeReset && baseDocumentEvent.canMerge(baseDocumentEvent2)) {
                        this.previousEdit = undoableEdit;
                        return true;
                    }
                }
            }
            BaseDocument.this.undoMergeReset = false;
            return false;
        }

        Vector getEdits() {
            return this.edits;
        }
    }
}

