/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.netbeans.modules.xml.tax.parser.Util;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;

public final class ParserLoader
extends URLClassLoader {
    private static final String PARSER_PACKAGE = "org.apache.xerces";
    private static final String[] USER_PREFIXES = new String[]{"org.netbeans.tax.io.XNIBuilder", "org.netbeans.modules.xml.tools.action.XMLCompiler"};
    private static final String CODENAME_BASE = "org.netbeans.modules.xml.tax";
    private static final String XERCES_ARCHIVE = "modules/autoload/ext/xerces2.jar";
    private static final String MODULE_ARCHIVE = "modules/autoload/xml-tax.jar";
    private ClassLoader parentLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
    private static ParserLoader instance = null;

    private ParserLoader(URL[] uRLArray) {
        super(uRLArray);
    }

    public static synchronized ParserLoader getInstance() {
        block5: {
            if (instance != null) {
                return instance;
            }
            try {
                InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
                URL uRL = installedFileLocator.locate(XERCES_ARCHIVE, CODENAME_BASE, false).toURL();
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("Isolated library URL=" + uRL);
                }
                URL uRL2 = installedFileLocator.locate(MODULE_ARCHIVE, CODENAME_BASE, false).toURL();
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("Isolated module URL=" + uRL2);
                }
                instance = new ParserLoader(new URL[]{uRL, uRL2});
            }
            catch (MalformedURLException malformedURLException) {
                if (!Util.THIS.isLoggable()) break block5;
                Util.THIS.debug(malformedURLException);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (string.startsWith(PARSER_PACKAGE)) {
            clazz = super.findLoadedClass(string);
            if (clazz == null) {
                clazz = super.findClass(string);
            }
        } else {
            for (int i = 0; i < USER_PREFIXES.length; ++i) {
                if (!string.startsWith(USER_PREFIXES[i])) continue;
                ParserLoader parserLoader = this;
                synchronized (parserLoader) {
                    clazz = super.findLoadedClass(string);
                    if (clazz == null) {
                        clazz = super.findClass(string);
                    }
                    continue;
                }
            }
            if (clazz == null) {
                clazz = this.parentLoader.loadClass(string);
            }
        }
        return clazz;
    }

    public URL getResource(String string) {
        URL uRL = super.getResource(string);
        if (uRL == null) {
            uRL = this.parentLoader.getResource(string);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Resource: " + string + " =>" + uRL);
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        try {
            URL uRL = this.getResource(string);
            if (uRL == null) {
                return null;
            }
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Enumeration findResources(String string) throws IOException {
        Enumeration<URL> enumeration = super.findResources(string);
        Enumeration<URL> enumeration2 = this.parentLoader.getResources(string);
        return Enumerations.concat(enumeration, enumeration2);
    }

    public static void main(String[] stringArray) throws Exception {
        ParserLoader parserLoader = ParserLoader.getInstance();
        Class clazz = parserLoader.loadClass("org.apache.xerces.util.QName");
        Class clazz2 = parserLoader.loadClass("java.lang.String");
        Class clazz3 = parserLoader.loadClass("org.openide.util.Mutex");
        System.err.println("apache " + clazz.getClassLoader());
        System.err.println("netbeans " + clazz3.getClassLoader());
        System.err.println("java " + clazz2.getClassLoader());
    }
}

