/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.editor;

import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import org.netbeans.modules.xml.tax.beans.editor.NullStringCustomEditor;
import org.netbeans.modules.xml.tax.beans.editor.Util;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class NullStringEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    protected static final String DEFAULT_NULL = Util.THIS.getString("TEXT_DEFAULT");
    private boolean editable = true;

    public void setAsText(String string) throws IllegalArgumentException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("NullStringEditor::setAsText: text = " + string);
        }
        if (DEFAULT_NULL.equals(string)) {
            this.setValue(null);
        } else if (string.length() == 0) {
            this.setValue(null);
        } else {
            this.setValue(string);
        }
    }

    public String getAsText() {
        Object object = super.getValue();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("NullStringEditor::getAsText: value = " + object);
        }
        if (object == null) {
            return DEFAULT_NULL;
        }
        String string = object.toString();
        if (string.length() == 0) {
            return DEFAULT_NULL;
        }
        return string;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new NullStringCustomEditor(this);
    }

    public String getJavaInitializationString() {
        String string = (String)this.getValue();
        return "\"" + NullStringEditor.toAscii(string) + "\"";
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        if (featureDescriptor instanceof Node.Property) {
            Node.Property property = (Node.Property)featureDescriptor;
            this.editable = property.canWrite();
        }
    }

    public boolean hasInPlaceCustomEditor() {
        return false;
    }

    public Component getInPlaceCustomEditor() {
        return null;
    }

    public boolean supportsEditingTaggedValues() {
        return false;
    }

    public boolean isEditable() {
        return this.editable;
    }

    private static String toAscii(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 6);
        char[] cArray = string.toCharArray();
        block9: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c >= ' ' && c <= '\u007f') {
                        stringBuffer.append(c);
                        continue block9;
                    }
                    stringBuffer.append("\\u");
                    String string2 = Integer.toHexString(c);
                    for (int j = 0; j < 4 - string2.length(); ++j) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(string2);
                }
            }
        }
        return stringBuffer.toString();
    }
}

