/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.outline;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.visualweb.outline.OutlinePanel;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OutlineManagerListener
implements PropertyChangeListener {
    private final OutlinePanel outlinePanel;

    public OutlineManagerListener(OutlinePanel outlinePanel) {
        this.outlinePanel = outlinePanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            Node[] nodeArray;
            Node[] nodeArray2 = (Node[])propertyChangeEvent.getNewValue();
            Set<DesignContext> set = OutlineManagerListener.getDesignContextsForNodes(nodeArray2);
            if (set.isEmpty() && (nodeArray = this.outlinePanel.getExplorerManager().getRootContext().getChildren().getNodes()) != null && nodeArray.length > 0) {
                set = OutlineManagerListener.getDesignContextsForNodes(new Node[]{nodeArray[0]});
            }
            if (set.isEmpty()) {
                return;
            }
            nodeArray = TopComponent.getRegistry().getOpened();
            for (TopComponent topComponent : nodeArray) {
                Set<DesignContext> set2;
                TopComponent topComponent2;
                if (!OutlineManagerListener.isMultiViewTopComponent(topComponent) || !OutlineManagerListener.isDesignerTopComponent(topComponent2 = OutlineManagerListener.getSelectedMultiView(topComponent)) || !set.containsAll(set2 = OutlineManagerListener.getDesignContextsForNodes(topComponent2.getActivatedNodes()))) continue;
                topComponent2.setActivatedNodes(nodeArray2);
            }
        }
    }

    private static Set<DesignContext> getDesignContextsForNodes(Node[] nodeArray) {
        if (nodeArray == null) {
            return Collections.emptySet();
        }
        HashSet<DesignContext> hashSet = new HashSet<DesignContext>();
        for (Node node : nodeArray) {
            DesignContext designContext;
            DesignBean designBean;
            if (node == null || (designBean = (DesignBean)node.getLookup().lookup(DesignBean.class)) == null || (designContext = designBean.getDesignContext()) == null) continue;
            hashSet.add(designContext);
        }
        return hashSet;
    }

    private static boolean isDesignerTopComponent(TopComponent topComponent) {
        if (topComponent == null) {
            return false;
        }
        return "org.netbeans.modules.visualweb.designer.jsf.ui.JsfTopComponent".equals(topComponent.getClass().getName());
    }

    private static boolean isMultiViewTopComponent(TopComponent topComponent) {
        return topComponent != null && "org.netbeans.core.multiview.MultiViewCloneableTopComponent".equals(topComponent.getClass().getName());
    }

    private static TopComponent getSelectedMultiView(TopComponent topComponent) {
        TopComponent[] topComponentArray;
        for (TopComponent topComponent2 : topComponentArray = OutlineManagerListener.findDescendantsOfTopComponent((Container)topComponent)) {
            if (!topComponent2.isVisible()) continue;
            return topComponent2;
        }
        return null;
    }

    private static TopComponent[] findDescendantsOfTopComponent(Container container) {
        Component[] componentArray;
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
        for (Component component : componentArray = container.getComponents()) {
            if (component instanceof TopComponent) {
                arrayList.add((TopComponent)component);
                continue;
            }
            if (!(component instanceof Container)) continue;
            arrayList.addAll(Arrays.asList(OutlineManagerListener.findDescendantsOfTopComponent((Container)component)));
        }
        return arrayList.toArray(new TopComponent[0]);
    }
}

