/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.text.MessageFormat;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicHTML;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.options.WinSysPrefs;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.dnd.ZOrderManager;
import org.netbeans.core.windows.view.ui.AbstractModeContainer;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.netbeans.core.windows.view.ui.ModeComponent;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.WindowSnapper;
import org.netbeans.core.windows.view.ui.tabcontrol.TabbedAdapter;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class DefaultSeparateContainer
extends AbstractModeContainer {
    private final ModeFrame modeFrame;
    private final ModeDialog modeDialog;

    public DefaultSeparateContainer(ModeView modeView, WindowDnDManager windowDnDManager, Rectangle rectangle, int n) {
        super(modeView, windowDnDManager, n);
        if (n == 1) {
            this.modeFrame = new ModeFrame(this, modeView);
            MainWindow.initFrameIcons(this.modeFrame);
            this.modeDialog = null;
        } else {
            this.modeDialog = new ModeDialog(WindowManager.getDefault().getMainWindow(), this, modeView);
            this.modeFrame = null;
        }
        Window window = this.getModeUIWindow();
        ((RootPaneContainer)((Object)window)).getContentPane().add(this.tabbedHandler.getComponent());
        window.setBounds(rectangle);
    }

    public void requestAttention(TopComponent topComponent) {
    }

    public void cancelRequestAttention(TopComponent topComponent) {
    }

    protected Component getModeComponent() {
        return this.getModeUIWindow();
    }

    protected Tabbed createTabbed() {
        TabbedAdapter tabbedAdapter = this.getKind() == 1 ? new TabbedAdapter(1) : new TabbedAdapter(0);
        return tabbedAdapter;
    }

    protected void updateTitle(String string) {
        this.getModeUIBase().updateTitle(string);
    }

    protected void updateActive(boolean bl) {
        Window window = this.getModeUIWindow();
        if (bl && window.isVisible() && !window.isActive()) {
            window.toFront();
        }
    }

    public boolean isActive() {
        return this.getModeUIWindow().isActive();
    }

    protected boolean isAttachingPossible() {
        return false;
    }

    protected TopComponentDroppable getModeDroppable() {
        return this.getModeUIBase();
    }

    private Window getModeUIWindow() {
        return this.modeFrame != null ? this.modeFrame : this.modeDialog;
    }

    private ModeUIBase getModeUIBase() {
        return (ModeUIBase)((Object)this.getModeUIWindow());
    }

    private static class SharedModeUIBaseImpl
    implements SharedModeUIBase {
        private final AbstractModeContainer abstractModeContainer;
        private final ModeView modeView;
        private long frametimestamp = 0L;
        private Window window;

        public SharedModeUIBaseImpl(AbstractModeContainer abstractModeContainer, ModeView modeView, Window window) {
            this.abstractModeContainer = abstractModeContainer;
            this.modeView = modeView;
            this.window = window;
            this.initWindow(window);
            this.attachListeners(window);
        }

        private void initWindow(Window window) {
            ((RootPaneContainer)((Object)window)).getRootPane().putClientProperty("SeparateWindow", Boolean.TRUE);
            ZOrderManager.getInstance().attachWindow((RootPaneContainer)((Object)window));
        }

        private void attachListeners(Window window) {
            window.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    SharedModeUIBaseImpl.this.modeView.getController().userClosingMode(SharedModeUIBaseImpl.this.modeView);
                    ZOrderManager.getInstance().detachWindow((RootPaneContainer)((Object)SharedModeUIBaseImpl.this.window));
                }

                public void windowClosed(WindowEvent windowEvent) {
                    ZOrderManager.getInstance().detachWindow((RootPaneContainer)((Object)SharedModeUIBaseImpl.this.window));
                }

                public void windowActivated(WindowEvent windowEvent) {
                    if (SharedModeUIBaseImpl.this.frametimestamp != 0L && System.currentTimeMillis() > SharedModeUIBaseImpl.this.frametimestamp + 500L) {
                        SharedModeUIBaseImpl.this.modeView.getController().userActivatedModeWindow(SharedModeUIBaseImpl.this.modeView);
                    }
                    SharedModeUIBaseImpl.this.frametimestamp = System.currentTimeMillis();
                }

                public void windowOpened(WindowEvent windowEvent) {
                    SharedModeUIBaseImpl.this.frametimestamp = System.currentTimeMillis();
                }
            });
            window.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    SharedModeUIBaseImpl.this.modeView.getController().userResizedModeBounds(SharedModeUIBaseImpl.this.modeView, SharedModeUIBaseImpl.this.window.getBounds());
                }

                public void componentMoved(ComponentEvent componentEvent) {
                    SharedModeUIBaseImpl.this.modeView.getController().userResizedModeBounds(SharedModeUIBaseImpl.this.modeView, SharedModeUIBaseImpl.this.window.getBounds());
                }
            });
            this.window.addWindowStateListener(new WindowStateListener(){

                public void windowStateChanged(WindowEvent windowEvent) {
                    if (!Constants.AUTO_ICONIFY) {
                        SharedModeUIBaseImpl.this.modeView.getController().userChangedFrameStateMode(SharedModeUIBaseImpl.this.modeView, windowEvent.getNewState());
                    } else {
                        Component component = SharedModeUIBaseImpl.this.modeView.getComponent();
                        if (component instanceof Frame) {
                            long l = System.currentTimeMillis();
                            if (l > SharedModeUIBaseImpl.this.modeView.getUserStamp() + 500L && l > SharedModeUIBaseImpl.this.modeView.getMainWindowStamp() + 1000L) {
                                SharedModeUIBaseImpl.this.modeView.getController().userChangedFrameStateMode(SharedModeUIBaseImpl.this.modeView, windowEvent.getNewState());
                            } else {
                                SharedModeUIBaseImpl.this.modeView.setUserStamp(0L);
                                SharedModeUIBaseImpl.this.modeView.setMainWindowStamp(0L);
                                SharedModeUIBaseImpl.this.modeView.updateFrameState();
                            }
                            long l2 = System.currentTimeMillis();
                            SharedModeUIBaseImpl.this.modeView.setUserStamp(l2);
                        }
                    }
                }
            });
        }

        public void setVisible(boolean bl) {
            this.frametimestamp = System.currentTimeMillis();
            this.window.setVisible(bl);
        }

        public void toFront() {
            this.frametimestamp = System.currentTimeMillis();
            this.window.toFront();
        }

        public ModeView getModeView() {
            return this.abstractModeContainer.getModeView();
        }

        public int getKind() {
            return this.abstractModeContainer.getKind();
        }

        public Shape getIndicationForLocation(Point point) {
            return this.abstractModeContainer.getIndicationForLocation(point);
        }

        public Object getConstraintForLocation(Point point) {
            return this.abstractModeContainer.getConstraintForLocation(point);
        }

        public Component getDropComponent() {
            return this.abstractModeContainer.getDropComponent();
        }

        public ViewElement getDropViewElement() {
            return this.abstractModeContainer.getDropModeView();
        }

        public boolean canDrop(TopComponent topComponent, Point point) {
            return this.abstractModeContainer.canDrop(topComponent);
        }

        public boolean supportsKind(int n, TopComponent topComponent) {
            return this.abstractModeContainer.canDrop(topComponent);
        }
    }

    public static interface ModeUIBase
    extends ModeComponent,
    TopComponentDroppable {
        public void updateTitle(String var1);
    }

    public static interface SharedModeUIBase
    extends ModeComponent,
    TopComponentDroppable {
    }

    private static class ModeDialog
    extends JDialog
    implements ModeUIBase {
        private SharedModeUIBase modeBase;
        private WindowSnapper snapper;
        private boolean ignoreMovedEvents = false;

        public ModeDialog(Frame frame, AbstractModeContainer abstractModeContainer, ModeView modeView) {
            super(frame);
            this.enableEvents(16L);
            this.modeBase = new SharedModeUIBaseImpl(abstractModeContainer, modeView, this);
            try {
                this.snapper = new WindowSnapper();
            }
            catch (AWTException aWTException) {
                this.snapper = null;
                Logger.getLogger(ModeDialog.class.getName()).log(Level.INFO, null, aWTException);
            }
            this.addComponentListener(new ComponentAdapter(){

                public void componentMoved(ComponentEvent componentEvent) {
                    if (ModeDialog.this.ignoreMovedEvents || null == ModeDialog.this.snapper || !WinSysPrefs.HANDLER.getBoolean("snapping", true)) {
                        return;
                    }
                    ModeDialog.this.snapWindow();
                    ModeDialog.this.snapper.cursorMoved();
                }
            });
        }

        private void snapWindow() {
            Rectangle rectangle = this.getBounds();
            WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
            Set<? extends ModeImpl> set = windowManagerImpl.getModes();
            for (ModeImpl modeImpl : set) {
                Rectangle rectangle2;
                Window window;
                TopComponent topComponent;
                if (modeImpl.getState() != 1 || null == (topComponent = modeImpl.getSelectedTopComponent()) || (window = SwingUtilities.getWindowAncestor((Component)topComponent)) == this || !this.snapper.snapTo(rectangle, rectangle2 = window.getBounds())) continue;
                return;
            }
            if (WinSysPrefs.HANDLER.getBoolean("snapping.screenedges", true)) {
                this.snapper.snapToScreenEdges(rectangle);
            }
        }

        public ModeView getModeView() {
            return this.modeBase.getModeView();
        }

        public int getKind() {
            return this.modeBase.getKind();
        }

        public Shape getIndicationForLocation(Point point) {
            return this.modeBase.getIndicationForLocation(point);
        }

        public Object getConstraintForLocation(Point point) {
            return this.modeBase.getConstraintForLocation(point);
        }

        public Component getDropComponent() {
            return this.modeBase.getDropComponent();
        }

        public ViewElement getDropViewElement() {
            return this.modeBase.getDropViewElement();
        }

        public boolean canDrop(TopComponent topComponent, Point point) {
            return this.modeBase.canDrop(topComponent, point);
        }

        public boolean supportsKind(int n, TopComponent topComponent) {
            return this.modeBase.supportsKind(n, topComponent);
        }

        public void updateTitle(String string) {
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            this.ignoreMovedEvents = true;
            super.setBounds(n, n2, n3, n4);
            this.ignoreMovedEvents = false;
        }

        public void setBounds(Rectangle rectangle) {
            this.ignoreMovedEvents = true;
            super.setBounds(rectangle);
            this.ignoreMovedEvents = false;
        }

        public void setLocation(Point point) {
            this.ignoreMovedEvents = true;
            super.setLocation(point);
            this.ignoreMovedEvents = false;
        }

        public void setLocation(int n, int n2) {
            this.ignoreMovedEvents = true;
            super.setLocation(n, n2);
            this.ignoreMovedEvents = false;
        }
    }

    private static class ModeFrame
    extends JFrame
    implements ModeUIBase {
        private SharedModeUIBase modeBase;

        public ModeFrame(AbstractModeContainer abstractModeContainer, ModeView modeView) {
            this.enableEvents(16L);
            this.modeBase = new SharedModeUIBaseImpl(abstractModeContainer, modeView, this);
        }

        public ModeView getModeView() {
            return this.modeBase.getModeView();
        }

        public int getKind() {
            return this.modeBase.getKind();
        }

        public Shape getIndicationForLocation(Point point) {
            return this.modeBase.getIndicationForLocation(point);
        }

        public Object getConstraintForLocation(Point point) {
            return this.modeBase.getConstraintForLocation(point);
        }

        public Component getDropComponent() {
            return this.modeBase.getDropComponent();
        }

        public ViewElement getDropViewElement() {
            return this.modeBase.getDropViewElement();
        }

        public boolean canDrop(TopComponent topComponent, Point point) {
            return this.modeBase.canDrop(topComponent, point);
        }

        public boolean supportsKind(int n, TopComponent topComponent) {
            return this.modeBase.supportsKind(n, topComponent);
        }

        public void updateTitle(String string) {
            Object object;
            if (BasicHTML.isHTMLString(string)) {
                object = string.toCharArray();
                StringBuffer stringBuffer = new StringBuffer(string.length());
                boolean bl = false;
                boolean bl2 = false;
                for (int i = 0; i < ((char[])object).length; ++i) {
                    if (bl && object[i] == '>') {
                        bl = false;
                        continue;
                    }
                    if (!bl && object[i] == '<') {
                        bl = true;
                        continue;
                    }
                    if (bl) continue;
                    stringBuffer.append(object[i]);
                }
                string = Utilities.replaceString((String)stringBuffer.toString(), (String)"&nbsp;", (String)" ");
            }
            object = MessageFormat.format(NbBundle.getMessage(DefaultSeparateContainer.class, (String)"CTL_SeparateEditorTitle"), string);
            this.setTitle((String)object);
        }
    }
}

