/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProjectUtil;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfProject;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LANG;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDwarfProvider
implements DiscoveryProvider {
    private static final boolean TRACE_READ_EXCEPTIONS = Boolean.getBoolean("cnd.dwarfdiscovery.trace.read.errors");
    private static final boolean FULL_TRACE = Boolean.getBoolean("cnd.dwarfdiscovery.trace.read.source");
    public static final String RESTRICT_SOURCE_ROOT = "restrict_source_root";
    public static final String RESTRICT_COMPILE_ROOT = "restrict_compile_root";
    protected boolean isStoped = false;
    private Map<String, List<String>> grepBase = new HashMap<String, List<String>>();
    private CompilerSettings myCommpilerSettings;

    public boolean isApplicable(ProjectProxy projectProxy) {
        return true;
    }

    public void stop() {
        this.isStoped = true;
    }

    protected List<ProjectProperties> divideByLanguage(List<SourceFileProperties> list) {
        DwarfProject dwarfProject = null;
        DwarfProject dwarfProject2 = null;
        for (SourceFileProperties sourceFileProperties : list) {
            ItemProperties.LanguageKind languageKind = sourceFileProperties.getLanguageKind();
            DwarfProject dwarfProject3 = null;
            if (languageKind == ItemProperties.LanguageKind.C) {
                if (dwarfProject == null) {
                    dwarfProject = new DwarfProject(languageKind);
                }
                dwarfProject3 = dwarfProject;
            } else {
                if (dwarfProject2 == null) {
                    dwarfProject2 = new DwarfProject(languageKind);
                }
                dwarfProject3 = dwarfProject2;
            }
            dwarfProject3.update(sourceFileProperties);
        }
        ArrayList arrayList = new ArrayList();
        if (dwarfProject != null) {
            arrayList.add(dwarfProject);
        }
        if (dwarfProject2 != null) {
            arrayList.add(dwarfProject2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SourceFileProperties> getSourceFileProperties(String[] stringArray) {
        try {
            HashMap<String, SourceFileProperties> hashMap = new HashMap<String, SourceFileProperties>();
            block3: for (String string : stringArray) {
                if (this.isStoped) break;
                for (SourceFileProperties sourceFileProperties : this.getSourceFileProperties(string, hashMap)) {
                    String string2;
                    if (this.isStoped) continue block3;
                    ProviderProperty providerProperty = this.getProperty(RESTRICT_SOURCE_ROOT);
                    if (providerProperty != null && (string2 = (String)providerProperty.getValue()).length() > 0 && sourceFileProperties != null && !sourceFileProperties.getItemPath().startsWith(string2) || (providerProperty = this.getProperty(RESTRICT_COMPILE_ROOT)) != null && (string2 = (String)providerProperty.getValue()).length() > 0 && sourceFileProperties != null && !sourceFileProperties.getCompilePath().startsWith(string2)) continue;
                    string2 = sourceFileProperties.getItemPath();
                    if (new File(string2).exists()) {
                        SourceFileProperties sourceFileProperties2 = hashMap.get(string2);
                        if (sourceFileProperties2 == null) {
                            hashMap.put(string2, sourceFileProperties);
                            continue;
                        }
                        if (sourceFileProperties2.getUserInludePaths().size() >= sourceFileProperties.getUserInludePaths().size()) continue;
                        hashMap.put(string2, sourceFileProperties);
                        continue;
                    }
                    if (!FULL_TRACE) continue;
                    System.out.println("Not Exist " + string2);
                }
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(hashMap.values());
            ArrayList arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            PathCache.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int sizeComilationUnit(String string) {
        int n = 0;
        Dwarf dwarf = null;
        try {
            dwarf = new Dwarf(string);
            List list = dwarf.getCompilationUnits();
            if (list != null && list.size() > 0) {
                for (CompilationUnit compilationUnit : list) {
                    String string2;
                    if (compilationUnit.getRoot() == null || compilationUnit.getSourceFileName() == null || (string2 = compilationUnit.getSourceLanguage()) == null) continue;
                    if (LANG.DW_LANG_C.toString().equals(string2) || LANG.DW_LANG_C89.toString().equals(string2) || LANG.DW_LANG_C99.toString().equals(string2)) {
                        ++n;
                        continue;
                    }
                    if (!LANG.DW_LANG_C_plus_plus.toString().equals(string2)) continue;
                    ++n;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (WrongFileFormatException wrongFileFormatException) {
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
        }
        finally {
            if (dwarf != null) {
                dwarf.dispose();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SourceFileProperties> getSourceFileProperties(String string, Map<String, SourceFileProperties> map) {
        ArrayList<SourceFileProperties> arrayList;
        block30: {
            arrayList = new ArrayList<SourceFileProperties>();
            Dwarf dwarf = null;
            try {
                List list;
                if (FULL_TRACE) {
                    System.out.println("Process file " + string);
                }
                if ((list = (dwarf = new Dwarf(string)).getCompilationUnits()) != null && list.size() > 0) {
                    for (CompilationUnit compilationUnit : list) {
                        if (this.isStoped) {
                            break block30;
                        }
                        if (compilationUnit.getRoot() == null || compilationUnit.getSourceFileName() == null) {
                            if (!TRACE_READ_EXCEPTIONS) continue;
                            System.out.println("Compilation unit has broken name in file " + string);
                            continue;
                        }
                        String string2 = compilationUnit.getSourceLanguage();
                        if (string2 == null) {
                            if (!TRACE_READ_EXCEPTIONS) continue;
                            System.out.println("Compilation unit has unresolved language in file " + string + "for " + compilationUnit.getSourceFileName());
                            continue;
                        }
                        DwarfSource dwarfSource = null;
                        if (LANG.DW_LANG_C.toString().equals(string2) || LANG.DW_LANG_C89.toString().equals(string2) || LANG.DW_LANG_C99.toString().equals(string2)) {
                            dwarfSource = new DwarfSource(compilationUnit, false, this.getCommpilerSettings(), this.grepBase);
                        } else if (LANG.DW_LANG_C_plus_plus.toString().equals(string2)) {
                            dwarfSource = new DwarfSource(compilationUnit, true, this.getCommpilerSettings(), this.grepBase);
                        } else if (FULL_TRACE) {
                            System.out.println("Unknown language: " + string2);
                        }
                        if (dwarfSource == null) continue;
                        String string3 = dwarfSource.getItemPath();
                        SourceFileProperties sourceFileProperties = map.get(string3);
                        if (sourceFileProperties != null && sourceFileProperties.getUserInludePaths().size() > 0) {
                            if (!FULL_TRACE) continue;
                            System.out.println("Compilation unit already exist. Skip " + string3);
                            continue;
                        }
                        dwarfSource.process(compilationUnit);
                        if (dwarfSource.getCompilePath() == null) {
                            if (!TRACE_READ_EXCEPTIONS) continue;
                            System.out.println("Compilation unit has NULL compile path in file " + string);
                            continue;
                        }
                        arrayList.add(dwarfSource);
                    }
                    break block30;
                }
                if (TRACE_READ_EXCEPTIONS) {
                    System.out.println("There are no compilation units in file " + string);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (TRACE_READ_EXCEPTIONS) {
                    System.out.println("File not found " + string + ": " + fileNotFoundException.getMessage());
                }
            }
            catch (WrongFileFormatException wrongFileFormatException) {
                if (TRACE_READ_EXCEPTIONS) {
                    System.out.println("Unsuported format of file " + string + ": " + wrongFileFormatException.getMessage());
                }
            }
            catch (IOException iOException) {
                if (TRACE_READ_EXCEPTIONS) {
                    System.err.println("Exception in file " + string);
                    iOException.printStackTrace();
                }
            }
            catch (Exception exception) {
                if (TRACE_READ_EXCEPTIONS) {
                    System.err.println("Exception in file " + string);
                    exception.printStackTrace();
                }
            }
            finally {
                if (dwarf != null) {
                    dwarf.dispose();
                }
            }
        }
        return arrayList;
    }

    public CompilerSettings getCommpilerSettings() {
        return this.myCommpilerSettings;
    }

    public void setCommpilerSettings(ProjectProxy projectProxy) {
        this.myCommpilerSettings = new CompilerSettings(projectProxy);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompilerSettings {
        private List<String> systemIncludePathsC;
        private List<String> systemIncludePathsCpp;
        private Map<String, String> systemMacroDefinitionsC;
        private Map<String, String> systemMacroDefinitionsCpp;
        private Map<String, String> normalizedPaths = new HashMap<String, String>();
        private String compileFlavor;
        private String compileDirectory;

        public CompilerSettings(ProjectProxy projectProxy) {
            this.systemIncludePathsCpp = ProjectUtil.getSystemIncludePaths((ProjectProxy)projectProxy, (boolean)true);
            this.systemIncludePathsC = ProjectUtil.getSystemIncludePaths((ProjectProxy)projectProxy, (boolean)false);
            this.systemMacroDefinitionsCpp = ProjectUtil.getSystemMacroDefinitions((ProjectProxy)projectProxy, (boolean)true);
            this.systemMacroDefinitionsC = ProjectUtil.getSystemMacroDefinitions((ProjectProxy)projectProxy, (boolean)false);
            this.compileFlavor = ProjectUtil.getCompilerFlavor((ProjectProxy)projectProxy);
            this.compileDirectory = ProjectUtil.getCompilerDirectory((ProjectProxy)projectProxy);
        }

        public List<String> getSystemIncludePaths(boolean bl) {
            if (bl) {
                return this.systemIncludePathsCpp;
            }
            return this.systemIncludePathsC;
        }

        public Map<String, String> getSystemMacroDefinitions(boolean bl) {
            if (bl) {
                return this.systemMacroDefinitionsCpp;
            }
            return this.systemMacroDefinitionsC;
        }

        public String getNormalizedPath(String string) {
            String string2 = this.normalizedPaths.get(string);
            if (string2 == null) {
                string2 = this.normalizePath(string);
                this.normalizedPaths.put(string, string2);
            }
            return string2;
        }

        private String normalizePath(String string) {
            string = FileUtil.normalizeFile((File)new File(string)).getAbsolutePath();
            if (Utilities.isWindows()) {
                string = string.replace('\\', '/');
            }
            return string;
        }

        public String getCompileFlavor() {
            return this.compileFlavor;
        }

        public String getCompileDirectory() {
            return this.compileDirectory;
        }
    }
}

