/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui.undo;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.xml.xam.ui.undo.FilterUndoManager;
import org.netbeans.modules.xml.xam.ui.undo.FilterUndoableEdit;
import org.openide.awt.UndoRedo;

public class CompoundUndoManager
extends FilterUndoManager {
    private static final long serialVersionUID = 1L;
    private boolean isCompound;
    private boolean undoRedoComplete;
    private boolean undoRedoCompound;
    private boolean consumeNextEdit;
    private boolean appendEndEdit;
    private boolean openCompound;
    private boolean compoundInProgress;

    public CompoundUndoManager(UndoRedo.Manager manager) {
        super(manager);
    }

    public synchronized void beginCompound() {
        if (!this.isCompound) {
            this.isCompound = true;
            this.consumeNextEdit = true;
            this.appendEndEdit = false;
        }
    }

    public synchronized void endCompound() {
        if (this.isCompound) {
            this.isCompound = false;
            if (this.appendEndEdit) {
                this.openCompound = true;
            }
        }
    }

    public synchronized boolean isCompound() {
        return this.isCompound;
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        undoableEdit = this.processEdit(undoableEdit);
        return super.addEdit(undoableEdit);
    }

    public void discardAllEdits() {
        super.discardAllEdits();
        if (this.isCompound) {
            this.consumeNextEdit = true;
        }
        this.appendEndEdit = false;
        this.openCompound = false;
    }

    private UndoableEdit processEdit(UndoableEdit undoableEdit) {
        if (this.isCompound) {
            if (this.openCompound) {
                this.openCompound = false;
                this.appendEndEdit = true;
            } else if (!this.appendEndEdit) {
                this.appendEndEdit = true;
                if (this.consumeNextEdit) {
                    this.consumeNextEdit = false;
                    undoableEdit = new BeginCompoundEdit(undoableEdit);
                }
            }
        } else if (this.appendEndEdit) {
            this.appendEndEdit = false;
            this.openCompound = false;
            super.addEdit(new EndCompoundEdit());
        }
        return undoableEdit;
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        UndoableEdit undoableEdit = this.processEdit(undoableEditEvent.getEdit());
        undoableEditEvent = new UndoableEditEvent(undoableEditEvent.getSource(), undoableEdit);
        super.undoableEditHappened(undoableEditEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void redo() throws CannotRedoException {
        if (this.isCompound) {
            super.redo();
        } else {
            this.compoundInProgress = true;
            try {
                this.undoRedoCompound = false;
                super.redo();
                if (this.undoRedoCompound || this.openCompound) {
                    this.undoRedoComplete = false;
                    while (!this.undoRedoComplete && this.canRedo()) {
                        super.redo();
                    }
                }
            }
            finally {
                this.compoundInProgress = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void undo() throws CannotUndoException {
        if (this.isCompound) {
            super.undo();
        } else {
            this.compoundInProgress = true;
            try {
                this.undoRedoCompound = false;
                super.undo();
                if (this.undoRedoCompound || this.openCompound) {
                    this.undoRedoComplete = false;
                    while (!this.undoRedoComplete && this.canUndo()) {
                        super.undo();
                    }
                }
            }
            finally {
                this.compoundInProgress = false;
            }
        }
    }

    private class EndCompoundEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;

        private EndCompoundEdit() {
        }

        public boolean isSignificant() {
            return CompoundUndoManager.this.compoundInProgress;
        }

        public void redo() throws CannotUndoException {
            super.redo();
            CompoundUndoManager.this.undoRedoComplete = true;
            CompoundUndoManager.this.openCompound = false;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            CompoundUndoManager.this.undoRedoCompound = true;
            CompoundUndoManager.this.openCompound = true;
        }
    }

    private class BeginCompoundEdit
    extends FilterUndoableEdit {
        private static final long serialVersionUID = 1L;

        public BeginCompoundEdit(UndoableEdit undoableEdit) {
            this.delegate = undoableEdit;
        }

        public boolean isSignificant() {
            if (this.delegate != null) {
                return CompoundUndoManager.this.compoundInProgress || this.delegate.isSignificant();
            }
            return CompoundUndoManager.this.compoundInProgress;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            CompoundUndoManager.this.undoRedoCompound = true;
            CompoundUndoManager.this.openCompound = true;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            CompoundUndoManager.this.undoRedoComplete = true;
            CompoundUndoManager.this.openCompound = false;
        }
    }
}

