/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.xam.ui.search.Query;
import org.netbeans.modules.xml.xam.ui.search.SearchEvent;
import org.netbeans.modules.xml.xam.ui.search.SearchException;
import org.netbeans.modules.xml.xam.ui.search.SearchListener;
import org.netbeans.modules.xml.xam.ui.search.SearchProvider;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchFieldPanel
extends JPanel
implements ActionListener,
DocumentListener,
FocusListener,
KeyListener,
MouseListener,
PopupMenuListener {
    private static final Color MATCH_FAILED_COLOR = new Color(255, 102, 102);
    static final long serialVersionUID = 1L;
    private Map<String, SearchProvider> buttonProviderMap;
    private boolean expectingInput;
    private JCheckBoxMenuItem fromSelectedMenuItem;
    private JCheckBoxMenuItem regexMenuItem;
    private EventListenerList searchListeners = new EventListenerList();
    private String lastSearchString;
    private JTextField searchTextField;
    private ButtonGroup typeButtonGroup;
    private JButton typesButton;
    private JPopupMenu typesPopupMenu;

    public SearchFieldPanel() {
        this.initComponents();
        this.typesButton.addActionListener(this);
        this.searchTextField.addKeyListener(this);
        this.searchTextField.addActionListener(this);
        this.searchTextField.addFocusListener(this);
        this.searchTextField.addMouseListener(this);
        this.searchTextField.getDocument().addDocumentListener(this);
        this.typesPopupMenu.addPopupMenuListener(this);
        this.buttonProviderMap = new HashMap<String, SearchProvider>();
    }

    String lastSearchString() {
        return this.lastSearchString;
    }

    String currentSearchString() {
        return this.searchTextField.getText();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.typesButton) {
            this.typesPopupMenu.show(this.typesButton, 0, this.typesButton.getHeight());
        } else if (object == this.searchTextField) {
            this.newSearch();
        } else if (object instanceof JMenuItem) {
            if (!this.expectingInput) {
                this.indicateSearchType();
            } else {
                ButtonModel buttonModel = this.typeButtonGroup.getSelection();
                SearchProvider searchProvider = this.buttonProviderMap.get(buttonModel.getActionCommand());
                this.searchTextField.setToolTipText(searchProvider.getInputDescription());
            }
        }
    }

    void newSearch() {
        this.fireSearchEvent(SearchEvent.Type.COMMENCED);
        String string = this.searchTextField.getText();
        if (string.length() > 0) {
            ButtonModel buttonModel = this.typeButtonGroup.getSelection();
            SearchProvider searchProvider = this.buttonProviderMap.get(buttonModel.getActionCommand());
            boolean bl = this.fromSelectedMenuItem.isSelected();
            boolean bl2 = this.regexMenuItem.isSelected();
            Query query = new Query(string, bl, bl2);
            try {
                List<Object> list = searchProvider.search(query);
                if (list.isEmpty()) {
                    this.indicateFailure();
                } else {
                    this.clearFailure(false);
                }
                this.lastSearchString = string;
                this.fireSearchComplete(list);
            }
            catch (SearchException searchException) {
                this.fireSearchFailed(searchException);
            }
        } else {
            List<Object> list = Collections.emptyList();
            this.fireSearchComplete(list);
        }
    }

    public void addSearchListener(SearchListener searchListener) {
        this.searchListeners.add(SearchListener.class, searchListener);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void clearFailure(boolean bl) {
        Color color = UIManager.getDefaults().getColor("TextField.background");
        this.setBackground(color);
        this.searchTextField.setBackground(color);
        color = UIManager.getDefaults().getColor("TextField.foreground");
        this.searchTextField.setForeground(color);
        if (bl) {
            this.searchTextField.setText("");
        }
    }

    protected void fireSearchComplete(List<Object> list) {
        this.fireSearchEvent(new SearchEvent((Object)this, SearchEvent.Type.FINISHED, list));
    }

    private void fireSearchEvent(SearchEvent.Type type) {
        this.fireSearchEvent(new SearchEvent(this, type));
    }

    protected void fireSearchFailed(SearchException searchException) {
        this.fireSearchEvent(new SearchEvent((Object)this, SearchEvent.Type.FAILED, searchException));
    }

    private void fireSearchEvent(SearchEvent searchEvent) {
        Object[] objectArray = this.searchListeners.getListenerList();
        SearchEvent.Type type = searchEvent.getType();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SearchListener.class) continue;
            type.fireEvent(searchEvent, (SearchListener)objectArray[i + 1]);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.searchTextField && !this.expectingInput) {
            this.clearFailure(true);
            this.expectingInput = true;
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.searchTextField && this.searchTextField.getText().length() == 0) {
            this.clearFailure(false);
            this.indicateSearchType();
        }
    }

    private void indicateFailure() {
        this.setBackground(MATCH_FAILED_COLOR);
        this.searchTextField.setBackground(MATCH_FAILED_COLOR);
        this.searchTextField.setForeground(Color.white);
    }

    private void indicateSearchType() {
        this.expectingInput = false;
        ButtonModel buttonModel = this.typeButtonGroup.getSelection();
        if (buttonModel == null) {
            return;
        }
        SearchProvider searchProvider = this.buttonProviderMap.get(buttonModel.getActionCommand());
        String string = searchProvider.getDisplayName();
        Color color = UIManager.getDefaults().getColor("textInactiveText");
        this.searchTextField.setForeground(color);
        this.searchTextField.setText(string);
        this.searchTextField.setToolTipText(searchProvider.getInputDescription());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            if (!this.expectingInput) {
                this.clearFailure(true);
                this.indicateSearchType();
            }
            this.fireSearchEvent(SearchEvent.Type.DISMISSED);
            this.typesButton.requestFocusInWindow();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.expectingInput) {
            this.clearFailure(true);
            this.expectingInput = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        if (!this.expectingInput) {
            this.clearFailure(true);
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void prepareForInput(boolean bl) {
        this.clearFailure(false);
        this.searchTextField.requestFocusInWindow();
        if (bl) {
            this.searchTextField.setText("");
        } else {
            this.searchTextField.selectAll();
        }
    }

    public void removeSearchListener(SearchListener searchListener) {
        this.searchListeners.remove(SearchListener.class, searchListener);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().getLength() == 0) {
            this.clearFailure(false);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.typesButton.setEnabled(bl);
        this.searchTextField.setEnabled(bl);
        if (!this.expectingInput) {
            this.clearFailure(true);
            this.indicateSearchType();
        }
    }

    public void setProviders(Collection collection) {
        Object object2;
        if (collection.size() == 0) {
            throw new IllegalArgumentException("providers must be non-empty");
        }
        this.buttonProviderMap.clear();
        this.typesPopupMenu.removeAll();
        for (Object object2 : collection) {
            String string = object2.getDisplayName();
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
            jRadioButtonMenuItem.addActionListener((ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this, (Object)jRadioButtonMenuItem));
            jRadioButtonMenuItem.setActionCommand(string);
            jRadioButtonMenuItem.setToolTipText(object2.getShortDescription());
            this.buttonProviderMap.put(string, (SearchProvider)object2);
            this.typeButtonGroup.add(jRadioButtonMenuItem);
            this.typesPopupMenu.add(jRadioButtonMenuItem);
        }
        object2 = (AbstractButton)this.typesPopupMenu.getComponent(0);
        ((AbstractButton)object2).setSelected(true);
        if (!this.expectingInput) {
            this.clearFailure(true);
            this.indicateSearchType();
        }
        this.typesPopupMenu.add(new JSeparator());
        if (this.fromSelectedMenuItem == null) {
            this.fromSelectedMenuItem = new JCheckBoxMenuItem();
            this.fromSelectedMenuItem.addActionListener((ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this, (Object)this.fromSelectedMenuItem));
            this.fromSelectedMenuItem.setText(NbBundle.getMessage(SearchFieldPanel.class, (String)"LBL_SearchField_StartFromSelected"));
        }
        this.typesPopupMenu.add(this.fromSelectedMenuItem);
        if (this.regexMenuItem == null) {
            this.regexMenuItem = new JCheckBoxMenuItem();
            this.regexMenuItem.addActionListener((ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this, (Object)this.regexMenuItem));
            this.regexMenuItem.setText(NbBundle.getMessage(SearchFieldPanel.class, (String)"LBL_SearchField_RegularExpression"));
        }
        this.typesPopupMenu.add(this.regexMenuItem);
    }

    private void initComponents() {
        this.typesPopupMenu = new JPopupMenu();
        this.typeButtonGroup = new ButtonGroup();
        this.typesButton = new JButton();
        this.searchTextField = new JTextField();
        this.setBackground(UIManager.getDefaults().getColor("TextField.background"));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.typesButton.setBackground(UIManager.getDefaults().getColor("TextField.background"));
        this.typesButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/xml/xam/ui/search/search_types.png")));
        this.typesButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/search/Bundle").getString("HINT_SearchFieldPanel_Types"));
        this.typesButton.setBorderPainted(false);
        this.typesButton.setContentAreaFilled(false);
        this.typesButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/xml/xam/ui/search/search_types_disabled.png")));
        this.typesButton.setMargin(new Insets(0, 0, 0, 0));
        this.searchTextField.setColumns(15);
        this.searchTextField.setBorder(null);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.typesButton).addPreferredGap(0).add((Component)this.searchTextField)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.typesButton).add((Component)this.searchTextField, -1, 22, Short.MAX_VALUE));
    }
}

