/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ui.category.SearchComponent;
import org.netbeans.modules.xml.xam.ui.highlight.Highlight;
import org.netbeans.modules.xml.xam.ui.highlight.HighlightGroup;
import org.netbeans.modules.xml.xam.ui.highlight.HighlightManager;
import org.netbeans.modules.xml.xam.ui.search.SearchEvent;
import org.netbeans.modules.xml.xam.ui.search.SearchException;
import org.netbeans.modules.xml.xam.ui.search.SearchFieldPanel;
import org.netbeans.modules.xml.xam.ui.search.SearchListener;
import org.openide.util.NbBundle;

public abstract class SearchControlPanel
extends JPanel
implements ActionListener,
SearchComponent,
SearchListener {
    private static final long serialVersionUID = 1L;
    private SearchFieldPanel searchField;
    private List<Object> searchResults;
    private int searchResultIndex;
    private Action findAcion;
    private JButton closeButton;
    private JLabel fieldLabel;
    private JPanel fieldPanel;
    private JButton nextButton;
    private JButton prevButton;
    private JButton resetButton;
    private JLabel resultsLabel;

    public SearchControlPanel() {
        this.initComponents();
        this.nextButton.setEnabled(false);
        this.prevButton.setEnabled(false);
        this.closeButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.prevButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.searchField = new SearchFieldPanel();
        this.searchField.addSearchListener(this);
        this.fieldPanel.add((java.awt.Component)this.searchField, "Center");
        this.findAcion = new FindAction();
        this.nextButton.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "findNext");
        this.nextButton.getActionMap().put("findNext", this.findAcion);
        this.prevButton.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), "findPrevious");
        this.prevButton.getActionMap().put("findPrevious", this.findAcion);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.performAction(actionEvent);
    }

    private void performAction(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton) {
            this.dismissSearch();
            this.hideComponent();
        } else if (object == this.resetButton) {
            this.dismissSearch();
            this.searchField.prepareForInput(true);
        } else if (object == this.nextButton) {
            if (!this.isSameQuery()) {
                this.dismissSearch();
                this.searchField.newSearch();
            }
            ++this.searchResultIndex;
            if (this.searchResultIndex >= this.searchResults.size()) {
                this.searchResultIndex = 0;
                this.beep();
            }
            if (this.searchResults.size() > 0) {
                this.showSearchResult(this.searchResults.get(this.searchResultIndex));
            }
        } else if (object == this.prevButton) {
            if (!this.isSameQuery()) {
                this.dismissSearch();
                this.searchField.newSearch();
            }
            --this.searchResultIndex;
            if (this.searchResultIndex < 0) {
                this.searchResultIndex = this.searchResults.size() - 1;
                this.beep();
            }
            if (this.searchResults.size() > 0) {
                this.showSearchResult(this.searchResults.get(this.searchResultIndex));
            }
            this.searchField.requestFocus();
        }
    }

    private boolean isSameQuery() {
        String string = this.searchField.currentSearchString();
        String string2 = this.searchField.lastSearchString();
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return this.searchResults.isEmpty() || string.equals(string2);
    }

    private void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    private void dismissSearch() {
        this.hideResults();
        this.searchResults = null;
        this.nextButton.setEnabled(false);
        this.prevButton.setEnabled(false);
        this.resultsLabel.setText("   ");
    }

    protected void hideResults() {
        HighlightManager highlightManager = HighlightManager.getDefault();
        List<HighlightGroup> list = highlightManager.getHighlightGroups("search");
        if (list != null) {
            for (HighlightGroup highlightGroup : list) {
                highlightManager.removeHighlightGroup(highlightGroup);
            }
        }
    }

    public java.awt.Component getComponent() {
        return this;
    }

    public void hideComponent() {
        this.setVisible(false);
    }

    public void showComponent() {
        this.setVisible(true);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.searchField.prepareForInput(false);
        }
        this.revalidate();
        this.repaint();
    }

    public void searchCommenced(SearchEvent searchEvent) {
        this.dismissSearch();
    }

    public void searchDismissed(SearchEvent searchEvent) {
        this.dismissSearch();
        this.hideComponent();
    }

    public void searchFailed(SearchEvent searchEvent) {
        this.nextButton.setEnabled(false);
        this.prevButton.setEnabled(false);
        SearchException searchException = searchEvent.getException();
        String string = null;
        if (searchException != null) {
            string = searchException.getMessage();
            if (string == null || string.length() == 0) {
                string = searchException.toString();
            }
        } else {
            string = NbBundle.getMessage(SearchControlPanel.class, (String)"LBL_SearchControlPanel_Failed");
        }
        this.resultsLabel.setText(string);
    }

    public void searchFinished(SearchEvent searchEvent) {
        this.searchResults = searchEvent.getResults();
        if (this.searchResults.isEmpty()) {
            this.nextButton.setEnabled(false);
            this.prevButton.setEnabled(false);
            this.resultsLabel.setText(NbBundle.getMessage(SearchControlPanel.class, (String)"LBL_SearchControlPanel_NoResults"));
        } else {
            this.nextButton.setEnabled(true);
            this.prevButton.setEnabled(true);
            HighlightManager highlightManager = HighlightManager.getDefault();
            HighlightGroup highlightGroup = new HighlightGroup("search");
            for (Object object : this.searchResults) {
                if (!(object instanceof Component)) continue;
                Component component = (Component)object;
                SearchHighlight searchHighlight = new SearchHighlight(component, "searchResult");
                highlightGroup.addHighlight(searchHighlight);
                for (Component component2 = component.getParent(); component2 != null; component2 = component2.getParent()) {
                    searchHighlight = new SearchHighlight(component2, "searchResultParent");
                    highlightGroup.addHighlight(searchHighlight);
                }
            }
            highlightManager.addHighlightGroup(highlightGroup);
            this.searchResultIndex = 0;
            this.showSearchResult(this.searchResults.get(this.searchResultIndex));
            int n = this.searchResults.size();
            if (n == 1) {
                this.resultsLabel.setText(NbBundle.getMessage(SearchControlPanel.class, (String)"LBL_SearchControlPanel_OneResult"));
            } else {
                this.resultsLabel.setText(NbBundle.getMessage(SearchControlPanel.class, (String)"LBL_SearchControlPanel_MultipleResults", (Object)n));
            }
        }
    }

    public void setProviders(Collection collection) {
        if (collection != null && collection.size() > 0) {
            this.searchField.setProviders(collection);
            this.searchField.setEnabled(true);
        } else {
            this.searchField.setEnabled(false);
        }
    }

    protected abstract void showSearchResult(Object var1);

    private void initComponents() {
        this.closeButton = new JButton();
        this.fieldLabel = new JLabel();
        this.fieldPanel = new JPanel();
        this.nextButton = new JButton();
        this.prevButton = new JButton();
        this.resetButton = new JButton();
        this.resultsLabel = new JLabel();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(0, 0, 0)), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/xml/xam/ui/search/search_close.png")));
        this.closeButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/search/Bundle").getString("HINT_SearchControlPanel_Close"));
        this.closeButton.setBorderPainted(false);
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.setMargin(new Insets(2, 2, 2, 2));
        this.closeButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/xml/xam/ui/search/search_close_light.png")));
        this.fieldLabel.setLabelFor(this.fieldPanel);
        this.fieldLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/search/Bundle").getString("LBL_SearchControlPanel_Find"));
        this.fieldPanel.setLayout(new BorderLayout());
        this.nextButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/search/Bundle").getString("KEY_SearchControlPanel_FindNext").charAt(0));
        this.nextButton.setText(ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/search/Bundle").getString("LBL_SearchControlPanel_FindNext"));
        this.nextButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/search/Bundle").getString("HINT_SearchControlPanel_FindNext"));
        this.prevButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/search/Bundle").getString("KEY_SearchControlPanel_FindPrevious").charAt(0));
        this.prevButton.setText(ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/search/Bundle").getString("LBL_SearchControlPanel_FindPrevious"));
        this.prevButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/search/Bundle").getString("HINT_SearchControlPanel_FindPrevious"));
        this.resetButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/search/Bundle").getString("KEY_SearchControlPanel_Reset").charAt(0));
        this.resetButton.setText(ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/search/Bundle").getString("LBL_SearchControlPanel_Reset"));
        this.resetButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/search/Bundle").getString("TIP_SearchControlPanel_Reset"));
        this.resultsLabel.setText("   ");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((java.awt.Component)this.closeButton).addPreferredGap(0).add((java.awt.Component)this.fieldLabel).addPreferredGap(0).add((java.awt.Component)this.fieldPanel, -2, -1, -2).addPreferredGap(0).add((java.awt.Component)this.nextButton).addPreferredGap(0).add((java.awt.Component)this.prevButton).addPreferredGap(0).add((java.awt.Component)this.resetButton).addPreferredGap(0).add((java.awt.Component)this.resultsLabel).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((java.awt.Component)this.closeButton).add((java.awt.Component)this.fieldLabel).add((java.awt.Component)this.nextButton).add((java.awt.Component)this.prevButton).add((java.awt.Component)this.resetButton).add((java.awt.Component)this.resultsLabel)).add((java.awt.Component)this.fieldPanel, -2, -1, -2));
    }

    private static class SearchHighlight
    extends Highlight {
        public SearchHighlight(Component component, String string) {
            super(component, string);
        }
    }

    class FindAction
    extends AbstractAction {
        FindAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchControlPanel.this.performAction(actionEvent);
        }
    }
}

