/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui.highlight;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ui.highlight.DefaultHighlightManager;
import org.netbeans.modules.xml.xam.ui.highlight.Highlight;
import org.netbeans.modules.xml.xam.ui.highlight.HighlightGroup;
import org.netbeans.modules.xml.xam.ui.highlight.Highlighted;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HighlightManager {
    private static final HighlightManager defaultInstance = new DefaultHighlightManager();
    private List<Highlighted> listeners = new ArrayList<Highlighted>();
    private List<HighlightGroup> groups = new ArrayList<HighlightGroup>();
    private Map<Component, List<Highlighted>> componentListenerMap = new WeakHashMap<Component, List<Highlighted>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHighlightGroup(HighlightGroup highlightGroup) {
        List<HighlightGroup> list = this.groups;
        synchronized (list) {
            this.groups.add(highlightGroup);
        }
        this.showHighlights(highlightGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHighlighted(Highlighted highlighted) {
        Highlighted highlighted2 = (Highlighted)WeakListeners.create(Highlighted.class, (EventListener)highlighted, (Object)this);
        Object object = this.listeners;
        synchronized (object) {
            this.listeners.add(highlighted2);
        }
        object = this.componentListenerMap;
        synchronized (object) {
            Set<Component> set = highlighted2.getComponents();
            if (set != null) {
                for (Component component : set) {
                    List<Highlighted> list = this.componentListenerMap.get(component);
                    if (list == null) {
                        list = new LinkedList<Highlighted>();
                        this.componentListenerMap.put(component, list);
                    }
                    list.add(highlighted2);
                }
            }
        }
        this.highlight(highlighted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Highlighted, List<Highlight>> findListeners(HighlightGroup highlightGroup) {
        HashMap<Highlighted, List<Highlight>> hashMap = new HashMap<Highlighted, List<Highlight>>();
        Map<Component, List<Highlighted>> map = this.componentListenerMap;
        synchronized (map) {
            for (Highlight highlight : highlightGroup.highlights()) {
                Component component = highlight.getComponent();
                List<Highlighted> list = this.componentListenerMap.get(component);
                if (list == null) continue;
                for (Highlighted highlighted : list) {
                    ArrayList<Highlight> arrayList = (ArrayList<Highlight>)hashMap.get(highlighted);
                    if (arrayList == null) {
                        arrayList = new ArrayList<Highlight>();
                        hashMap.put(highlighted, arrayList);
                    }
                    arrayList.add(highlight);
                }
            }
        }
        return hashMap;
    }

    public static HighlightManager getDefault() {
        return defaultInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HighlightGroup> getHighlightGroups(String string) {
        ArrayList<HighlightGroup> arrayList = new ArrayList<HighlightGroup>();
        List<HighlightGroup> list = this.groups;
        synchronized (list) {
            if (this.groups.size() > 0) {
                for (HighlightGroup highlightGroup : this.groups) {
                    if (!highlightGroup.getType().equals(string)) continue;
                    arrayList.add(highlightGroup);
                }
            }
        }
        return arrayList;
    }

    protected abstract void hideHighlights(HighlightGroup var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void highlight(Highlighted highlighted) {
        Set<Component> set = highlighted.getComponents();
        if (set != null && !set.isEmpty()) {
            List<HighlightGroup> list = this.groups;
            synchronized (list) {
                for (HighlightGroup highlightGroup : this.groups) {
                    if (!highlightGroup.isShowing()) continue;
                    for (Highlight highlight : highlightGroup.highlights()) {
                        Component component = highlight.getComponent();
                        if (!set.contains(component)) continue;
                        highlighted.highlightAdded(highlight);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHighlightGroup(HighlightGroup highlightGroup) {
        this.hideHighlights(highlightGroup);
        List<HighlightGroup> list = this.groups;
        synchronized (list) {
            this.groups.remove(highlightGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHighlighted(Highlighted highlighted) {
        Object object = this.listeners;
        synchronized (object) {
            this.listeners.remove(highlighted);
        }
        object = this.componentListenerMap;
        synchronized (object) {
            Set<Component> set = highlighted.getComponents();
            if (set != null) {
                for (Component component : set) {
                    List<Highlighted> list = this.componentListenerMap.get(component);
                    if (list == null) continue;
                    list.remove(highlighted);
                }
            }
        }
    }

    protected abstract void showHighlights(HighlightGroup var1);
}

