/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui.column;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.Timer;

public class TimerButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Timer timer;
    private Image disabledImage;
    private Image enabledImage;
    private int count;

    public TimerButton(Action action) {
        super(action);
    }

    private Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer(400, this);
            this.timer.setRepeats(true);
        }
        return this.timer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ++this.count;
        if (this.count > 5) {
            this.timer.setDelay(75);
        } else if (this.count > 2) {
            this.timer.setDelay(200);
        }
        this.performAction();
    }

    private void performAction() {
        if (!this.isEnabled()) {
            this.stopTimer();
            return;
        }
        this.getAction().actionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
    }

    private void startTimer() {
        this.performAction();
        Timer timer = this.getTimer();
        if (timer.isRunning()) {
            return;
        }
        this.repaint();
        timer.setDelay(400);
        timer.start();
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.repaint();
        this.count = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            if (mouseEvent.getID() == 501) {
                this.startTimer();
                return;
            }
        }
        if (mouseEvent.getID() == 502) {
            this.stopTimer();
            return;
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1005) {
            this.stopTimer();
        }
    }
}

