/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.ui.cookies.GetComponentCookie;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.datatransfer.PasteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentPasteType {
    private static final int[] STANDARD_OPERATIONS = new int[]{1, 6};

    public static PasteType getPasteType(Component component, Transferable transferable, Class<? extends Component> clazz) {
        return ComponentPasteType.getPasteType(component, transferable, clazz, STANDARD_OPERATIONS, -1);
    }

    public static PasteType getDropType(Component component, Transferable transferable, Class<? extends Component> clazz, int n, int n2) {
        return ComponentPasteType.getPasteType(component, transferable, clazz, STANDARD_OPERATIONS, n2);
    }

    private static PasteType getPasteType(Component component, Transferable transferable, Class<? extends Component> clazz, int[] nArray, int n) {
        PasteTypeImpl pasteTypeImpl = null;
        for (int n2 : nArray) {
            Node[] nodeArray = NodeTransfer.nodes((Transferable)transferable, (int)n2);
            if (nodeArray == null || !ComponentPasteType.canPaste(nodeArray, component, n2, clazz)) continue;
            pasteTypeImpl = new PasteTypeImpl(Arrays.asList(nodeArray), component, n2, n);
            break;
        }
        return pasteTypeImpl;
    }

    private static boolean canPaste(Node[] nodeArray, Component component, int n, Class<? extends Component> clazz) {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (Node node : nodeArray) {
            boolean bl;
            GetComponentCookie getComponentCookie = (GetComponentCookie)node.getLookup().lookup(GetComponentCookie.class);
            if (getComponentCookie == null) continue;
            Component component2 = getComponentCookie.getComponent();
            if (clazz != null && !clazz.isAssignableFrom(getComponentCookie.getComponentType()) || component2.getModel() == null || !component.canPaste(component2)) continue;
            boolean bl2 = (n & 1) != 0;
            boolean bl3 = bl = (n & 6) != 0 && !component2.getParent().equals(component) && node.canDestroy();
            if (!bl2 && !bl) continue;
            if (bl) {
                for (Component component3 = component; component3 != null; component3 = component3.getParent()) {
                    if (!component3.equals(component2)) continue;
                    return false;
                }
            }
            hashSet.add(node);
        }
        return hashSet.size() == nodeArray.length;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PasteTypeImpl
    extends PasteType {
        private Component target;
        private List<Node> nodes;
        private int operation;
        private int index;

        private PasteTypeImpl(List<Node> list, Component component, int n, int n2) {
            this.target = component;
            this.nodes = list;
            this.operation = n;
            this.index = n2 < 0 ? 0 : n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Transferable paste() throws IOException {
            if (this.target != null && this.nodes.size() > 0) {
                Model model = this.target.getModel();
                GetComponentCookie getComponentCookie = (GetComponentCookie)this.nodes.get(0).getCookie(GetComponentCookie.class);
                if (getComponentCookie == null) {
                    return null;
                }
                Model model2 = getComponentCookie.getComponent().getModel();
                model.startTransaction();
                try {
                    for (Node node : this.nodes) {
                        getComponentCookie = (GetComponentCookie)node.getCookie(GetComponentCookie.class);
                        Component component = getComponentCookie.getComponent();
                        Component component2 = component.copy(this.target);
                        if (component2 == null) continue;
                        if ((this.operation & 6) != 0) {
                            boolean bl = model2.isIntransaction();
                            try {
                                if (!bl) {
                                    model2.startTransaction();
                                }
                                model2.removeChildComponent(component);
                            }
                            finally {
                                if (!bl) {
                                    model2.endTransaction();
                                }
                            }
                        }
                        if (component2 instanceof Nameable) {
                            String string;
                            String string2 = string = ((Nameable)component2).getName();
                            HashSet<String> hashSet = new HashSet<String>();
                            for (Object e : this.target.getChildren()) {
                                if (!(e instanceof Named)) continue;
                                hashSet.add(((Named)e).getName());
                            }
                            int n = 1;
                            while (hashSet.contains(string)) {
                                string = string2 + n;
                                ++n;
                            }
                            ((Nameable)component2).setName(string);
                        }
                        model.addChildComponent(this.target, component2, this.index);
                    }
                }
                finally {
                    model.endTransaction();
                }
            }
            return null;
        }

        public String toString() {
            return "PasteTypeImpl=[operation=" + this.operation + ",index=" + this.index + "]";
        }
    }
}

