/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.data;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.BeanProp;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.schema2beans.Version;
import org.netbeans.modules.web.monitor.data.ClientData;
import org.netbeans.modules.web.monitor.data.ContextData;
import org.netbeans.modules.web.monitor.data.CookiesData;
import org.netbeans.modules.web.monitor.data.DataRecord;
import org.netbeans.modules.web.monitor.data.Dispatches;
import org.netbeans.modules.web.monitor.data.EngineData;
import org.netbeans.modules.web.monitor.data.RequestData;
import org.netbeans.modules.web.monitor.data.ServletData;
import org.netbeans.modules.web.monitor.data.SessionData;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class MonitorData
extends BaseBean
implements DataRecord {
    private static final boolean debug = false;
    static Vector comparators = new Vector();
    public static final String CLIENTDATA = "ClientData";
    public static final String SESSIONDATA = "SessionData";
    public static final String COOKIESDATA = "CookiesData";
    public static final String REQUESTDATA = "RequestData";
    public static final String SERVLETDATA = "ServletData";
    public static final String CONTEXTDATA = "ContextData";
    public static final String ENGINEDATA = "EngineData";
    public static final String MONITORDATA = "MonitorData";
    public static final String DISPATCHES = "Dispatches";

    public MonitorData() {
        this(null, 1);
    }

    public MonitorData(Node node, int n) {
        this(2);
        if (node == null && (node = GraphManager.createRootElementNode((String)MONITORDATA)) == null) {
            throw new RuntimeException("failed to create a new DOM root!");
        }
        Node node2 = GraphManager.getElementNode((String)MONITORDATA, (Node)node);
        if (node2 == null) {
            throw new RuntimeException("doc root not found in the DOM graph!");
        }
        this.graphManager.setXmlDocument(node);
        this.createBean(node2, this.graphManager());
        this.initialize(n);
    }

    public MonitorData(int n) {
        super(comparators, new Version(1, 0, 6));
        this.graphManager = new GraphManager((BaseBean)this);
        this.createRoot(MONITORDATA, MONITORDATA, 544, MonitorData.class);
        this.createProperty(CLIENTDATA, CLIENTDATA, 66080, ClientData.class);
        this.createAttribute(CLIENTDATA, "protocol", "Protocol", 257, null, null);
        this.createAttribute(CLIENTDATA, "remoteAddress", "RemoteAddress", 257, null, null);
        this.createAttribute(CLIENTDATA, "software", "Software", 513, null, null);
        this.createAttribute(CLIENTDATA, "locale", "Locale", 513, null, null);
        this.createAttribute(CLIENTDATA, "formatsAccepted", "FormatsAccepted", 513, null, null);
        this.createAttribute(CLIENTDATA, "encodingsAccepted", "EncodingsAccepted", 513, null, null);
        this.createAttribute(CLIENTDATA, "charsetsAccepted", "CharsetsAccepted", 513, null, null);
        this.createProperty(SESSIONDATA, SESSIONDATA, 66064, SessionData.class);
        this.createAttribute(SESSIONDATA, "before", "Before", 258, new String[]{"false", "true"}, "false");
        this.createAttribute(SESSIONDATA, "after", "After", 258, new String[]{"false", "true"}, "false");
        this.createAttribute(SESSIONDATA, "id", "Id", 513, null, null);
        this.createAttribute(SESSIONDATA, "created", "Created", 513, null, null);
        this.createProperty(COOKIESDATA, COOKIESDATA, 66064, CookiesData.class);
        this.createProperty(REQUESTDATA, REQUESTDATA, 66080, RequestData.class);
        this.createAttribute(REQUESTDATA, "uri", "Uri", 257, null, null);
        this.createAttribute(REQUESTDATA, "method", "Method", 257, null, null);
        this.createAttribute(REQUESTDATA, "urlencoded", "Urlencoded", 513, null, null);
        this.createAttribute(REQUESTDATA, "queryString", "QueryString", 513, null, null);
        this.createAttribute(REQUESTDATA, "replace", "Replace", 513, null, null);
        this.createAttribute(REQUESTDATA, "protocol", "Protocol", 513, null, null);
        this.createAttribute(REQUESTDATA, "ipaddress", "Ipaddress", 513, null, null);
        this.createAttribute(REQUESTDATA, "scheme", "Scheme", 513, null, null);
        this.createAttribute(REQUESTDATA, "status", "Status", 513, null, null);
        this.createProperty(SERVLETDATA, SERVLETDATA, 66064, ServletData.class);
        this.createAttribute(SERVLETDATA, "name", "Name", 513, null, null);
        this.createAttribute(SERVLETDATA, "className", "ClassName", 513, null, null);
        this.createAttribute(SERVLETDATA, "packageName", "PackageName", 513, null, null);
        this.createAttribute(SERVLETDATA, "servletInfo", "ServletInfo", 513, null, null);
        this.createAttribute(SERVLETDATA, "relPath", "RelPath", 513, null, null);
        this.createAttribute(SERVLETDATA, "transPath", "TransPath", 513, null, null);
        this.createAttribute(SERVLETDATA, "contextName", "ContextName", 513, null, null);
        this.createAttribute(SERVLETDATA, "absPath", "AbsPath", 513, null, null);
        this.createAttribute(SERVLETDATA, "jre", "Jre", 513, null, null);
        this.createAttribute(SERVLETDATA, "platform", "Platform", 513, null, null);
        this.createAttribute(SERVLETDATA, "serverPort", "ServerPort", 515, null, null);
        this.createAttribute(SERVLETDATA, "serverName", "ServerName", 513, null, null);
        this.createAttribute(SERVLETDATA, "collected", "Collected", 513, null, null);
        this.createProperty(CONTEXTDATA, CONTEXTDATA, 66064, ContextData.class);
        this.createAttribute(CONTEXTDATA, "contextName", "ContextName", 513, null, null);
        this.createAttribute(CONTEXTDATA, "absPath", "AbsPath", 513, null, null);
        this.createProperty(ENGINEDATA, ENGINEDATA, 66064, EngineData.class);
        this.createAttribute(ENGINEDATA, "jre", "Jre", 513, null, null);
        this.createAttribute(ENGINEDATA, "platform", "Platform", 513, null, null);
        this.createAttribute(ENGINEDATA, "serverPort", "ServerPort", 515, null, null);
        this.createAttribute(ENGINEDATA, "serverName", "ServerName", 513, null, null);
        this.createAttribute("resource", "Resource", 257, null, null);
        this.createAttribute("timestamp", "Timestamp", 257, null, null);
        this.createAttribute("id", "Id", 257, null, null);
        this.createAttribute("method", "Metod", 257, null, null);
        this.createProperty(DISPATCHES, DISPATCHES, 66064, Dispatches.class);
        this.initialize(n);
    }

    void initialize(int n) {
    }

    public void setClientData(ClientData clientData) {
        this.setValue(CLIENTDATA, (Object)clientData);
    }

    public ClientData getClientData() {
        return (ClientData)((Object)this.getValue(CLIENTDATA));
    }

    public void setSessionData(SessionData sessionData) {
        this.setValue(SESSIONDATA, (Object)sessionData);
    }

    public SessionData getSessionData() {
        return (SessionData)((Object)this.getValue(SESSIONDATA));
    }

    public void setCookiesData(CookiesData cookiesData) {
        this.setValue(COOKIESDATA, (Object)cookiesData);
    }

    public CookiesData getCookiesData() {
        return (CookiesData)((Object)this.getValue(COOKIESDATA));
    }

    public void setDispatches(Dispatches dispatches) {
        this.setValue(DISPATCHES, (Object)dispatches);
    }

    public Dispatches getDispatches() {
        return (Dispatches)((Object)this.getValue(DISPATCHES));
    }

    public void setRequestData(RequestData requestData) {
        this.setValue(REQUESTDATA, (Object)requestData);
    }

    public RequestData getRequestData() {
        return (RequestData)((Object)this.getValue(REQUESTDATA));
    }

    public void setServletData(ServletData servletData) {
        this.setValue(SERVLETDATA, (Object)servletData);
    }

    public ServletData getServletData() {
        return (ServletData)((Object)this.getValue(SERVLETDATA));
    }

    public void setEngineData(EngineData engineData) {
        this.setValue(ENGINEDATA, (Object)engineData);
    }

    public EngineData getEngineData() {
        return (EngineData)((Object)this.getValue(ENGINEDATA));
    }

    public void setContextData(ContextData contextData) {
        this.setValue(CONTEXTDATA, (Object)contextData);
    }

    public ContextData getContextData() {
        return (ContextData)((Object)this.getValue(CONTEXTDATA));
    }

    public boolean verify() {
        return true;
    }

    public String getServerAndPort() {
        String string = null;
        String string2 = null;
        try {
            string = this.getEngineData().getAttributeValue("serverName");
            string2 = this.getEngineData().getAttributeValue("serverPort");
            return string.concat(":").concat(string2);
        }
        catch (NullPointerException nullPointerException) {
            string = this.getServletData().getAttributeValue("serverName");
            string2 = this.getServletData().getAttributeValue("serverPort");
            return string.concat(":").concat(string2);
        }
    }

    public String getServerName() {
        try {
            return this.getEngineData().getAttributeValue("serverName");
        }
        catch (NullPointerException nullPointerException) {
            return this.getServletData().getAttributeValue("serverName");
        }
    }

    public int getServerPort() {
        String string = null;
        try {
            string = this.getEngineData().getAttributeValue("serverPort");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string == null) {
            string = this.getServletData().getAttributeValue("serverPort");
        }
        return Integer.parseInt(string);
    }

    public String getServerPortAsString() {
        String string = null;
        try {
            string = this.getEngineData().getAttributeValue("serverPort");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string == null) {
            string = this.getServletData().getAttributeValue("serverPort");
        }
        return string;
    }

    public void setServerName(String string) {
        try {
            this.getEngineData().setAttributeValue("serverName", string);
            return;
        }
        catch (NullPointerException nullPointerException) {
            try {
                this.getServletData().getAttributeValue("serverName, server");
                return;
            }
            catch (NullPointerException nullPointerException2) {
                return;
            }
        }
    }

    public void setServerPort(int n) {
        try {
            this.getEngineData().setAttributeValue("serverPort", String.valueOf(n));
            return;
        }
        catch (NullPointerException nullPointerException) {
            try {
                this.getServletData().setAttributeValue("serverPort", String.valueOf(n));
                return;
            }
            catch (NullPointerException nullPointerException2) {
                return;
            }
        }
    }

    public void setServerPort(String string) {
        try {
            this.getEngineData().setAttributeValue("serverPort", string);
            return;
        }
        catch (NullPointerException nullPointerException) {
            try {
                this.getServletData().setAttributeValue("serverPort", string);
                return;
            }
            catch (NullPointerException nullPointerException2) {
                return;
            }
        }
    }

    public static void addComparator(BeanComparator beanComparator) {
        comparators.add(beanComparator);
    }

    public static void removeComparator(BeanComparator beanComparator) {
        comparators.remove(beanComparator);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        BeanProp beanProp = this.beanProp();
        if (beanProp != null) {
            beanProp.addPCListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        BeanProp beanProp = this.beanProp();
        if (beanProp != null) {
            beanProp.removePCListener(propertyChangeListener);
        }
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        BeanProp beanProp = this.beanProp(string);
        if (beanProp != null) {
            beanProp.addPCListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        BeanProp beanProp = this.beanProp(string);
        if (beanProp != null) {
            beanProp.removePCListener(propertyChangeListener);
        }
    }

    public static MonitorData createGraph(Node node) {
        return new MonitorData(node, 2);
    }

    public static MonitorData createGraph(Reader reader) throws IOException {
        return MonitorData.createGraph(reader, false);
    }

    public static MonitorData createGraph(Reader reader, boolean bl) throws IOException {
        try {
            InputSource inputSource = new InputSource(reader);
            inputSource.setEncoding("UTF-8");
            Document document = GraphManager.createXmlDocument((InputSource)inputSource, (boolean)bl);
            return MonitorData.createGraph(document);
        }
        catch (Throwable throwable) {
            throw new IOException();
        }
    }

    public static MonitorData createGraph() {
        return new MonitorData();
    }

    public void write(OutputStream outputStream) throws IOException {
        throw new RuntimeException("Don't do this!");
    }

    public void write(Writer writer) throws IOException {
        try {
            this.write(writer, "UTF-8");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void dump(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string);
        stringBuffer.append(CLIENTDATA);
        BaseBean baseBean = this.getClientData();
        if (baseBean != null) {
            baseBean.dump(stringBuffer, string + "\t");
        } else {
            stringBuffer.append(string + "\tnull");
        }
        this.dumpAttributes(CLIENTDATA, 0, stringBuffer, string);
        stringBuffer.append(string);
        stringBuffer.append(SESSIONDATA);
        baseBean = this.getSessionData();
        if (baseBean != null) {
            baseBean.dump(stringBuffer, string + "\t");
        } else {
            stringBuffer.append(string + "\tnull");
        }
        this.dumpAttributes(SESSIONDATA, 0, stringBuffer, string);
        stringBuffer.append(string);
        stringBuffer.append(COOKIESDATA);
        baseBean = this.getCookiesData();
        if (baseBean != null) {
            baseBean.dump(stringBuffer, string + "\t");
        } else {
            stringBuffer.append(string + "\tnull");
        }
        this.dumpAttributes(COOKIESDATA, 0, stringBuffer, string);
        stringBuffer.append(string);
        stringBuffer.append(REQUESTDATA);
        baseBean = this.getRequestData();
        if (baseBean != null) {
            baseBean.dump(stringBuffer, string + "\t");
        } else {
            stringBuffer.append(string + "\tnull");
        }
        this.dumpAttributes(REQUESTDATA, 0, stringBuffer, string);
        stringBuffer.append(string);
        stringBuffer.append(SERVLETDATA);
        baseBean = this.getServletData();
        if (baseBean != null) {
            baseBean.dump(stringBuffer, string + "\t");
        } else {
            stringBuffer.append(string + "\tnull");
        }
        this.dumpAttributes(SERVLETDATA, 0, stringBuffer, string);
        stringBuffer.append(CONTEXTDATA);
        baseBean = this.getContextData();
        if (baseBean != null) {
            baseBean.dump(stringBuffer, string + "\t");
        } else {
            stringBuffer.append(string + "\tnull");
        }
        this.dumpAttributes(CONTEXTDATA, 0, stringBuffer, string);
        stringBuffer.append(string);
        stringBuffer.append(DISPATCHES);
        baseBean = this.getDispatches();
        if (baseBean != null) {
            baseBean.dump(stringBuffer, string + "\t");
        } else {
            stringBuffer.append(string + "\tnull");
        }
        this.dumpAttributes(DISPATCHES, 0, stringBuffer, string);
    }

    public String dumpBeanNode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MonitorData\n");
        this.dump(stringBuffer, "\n  ");
        return stringBuffer.toString();
    }

    public String createTempFile(String string) {
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("java.io.tmpdir"));
        stringBuffer.append(System.getProperty("file.separator"));
        stringBuffer.append(string);
        try {
            File file = new File(stringBuffer.toString());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            this.write(printWriter);
            printWriter.close();
            fileOutputStream.close();
            return file.getAbsolutePath();
        }
        catch (Throwable throwable) {
            return "null";
        }
    }
}

