/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.libraries.support;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.project.libraries.DefaultLibraryImplementation;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public final class LibrariesSupport {
    private LibrariesSupport() {
    }

    public static LibraryImplementation createLibraryImplementation(String string, String[] stringArray) {
        return new DefaultLibraryImplementation(string, stringArray);
    }

    public static LibraryTypeProvider getLibraryTypeProvider(String string) {
        return LibraryTypeRegistry.getDefault().getLibraryTypeProvider(string);
    }

    public static LibraryTypeProvider[] getLibraryTypeProviders() {
        return LibraryTypeRegistry.getDefault().getLibraryTypeProviders();
    }

    public static URI convertFilePathToURI(String string) {
        try {
            File file = new File(string);
            if (file.isAbsolute()) {
                return file.toURI();
            }
            return new URI(null, null, string.replace('\\', '/'), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(uRISyntaxException);
            throw illegalArgumentException;
        }
    }

    public static String convertURIToFilePath(URI uRI) {
        if (uRI.isAbsolute()) {
            return new File(uRI).getPath();
        }
        return uRI.getPath().replace('/', File.separatorChar);
    }

    public static FileObject resolveLibraryEntryFileObject(URL uRL, URI uRI) {
        URI uRI2 = LibrariesSupport.resolveLibraryEntryURI(uRL, uRI);
        try {
            return URLMapper.findFileObject((URL)uRI2.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    public static URI resolveLibraryEntryURI(URL uRL, URI uRI) {
        Parameters.notNull((CharSequence)"libraryEntry", (Object)uRI);
        if (uRI.isAbsolute()) {
            return uRI;
        }
        if (uRL == null) {
            throw new IllegalArgumentException("cannot resolve relative URL without library location");
        }
        if (!"file".equals(uRL.getProtocol())) {
            throw new IllegalArgumentException("not file: protocol - " + uRL.toExternalForm());
        }
        File file = new File(URI.create(uRL.toExternalForm()));
        if (!file.getName().endsWith(".properties")) {
            throw new IllegalArgumentException("library location must be a file - " + uRL.toExternalForm());
        }
        File file2 = file.getParentFile();
        URI uRI2 = file2.toURI().resolve(uRI);
        if (uRI.getPath().contains("!/")) {
            uRI2 = URI.create("jar:" + uRI2.toString());
        }
        return uRI2;
    }

    public static URI getArchiveFile(URI uRI) {
        String string = uRI.toString();
        int n = string.indexOf("!/");
        if (n != -1) {
            try {
                return new URI(string.substring(string.startsWith("jar:") ? 4 : 0, n));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new AssertionError((Object)uRISyntaxException);
            }
        }
        return null;
    }

    public static URI getArchiveRoot(URI uRI) {
        assert (!uRI.toString().contains("!/")) : uRI;
        try {
            return new URI((uRI.isAbsolute() ? "jar:" : "") + uRI.toString() + "!/");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }
}

