/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CustomZoomPanel
extends JPanel {
    private JTextField decreaseText;
    private JLabel decreasingLabel;
    private JLabel enlargeLabel;
    private JTextField enlargeText;

    public CustomZoomPanel() {
        this.initComponents();
        this.initAccessibility();
    }

    private void initComponents() {
        this.enlargeLabel = new JLabel();
        this.enlargeText = new JTextField();
        this.decreasingLabel = new JLabel();
        this.decreaseText = new JTextField();
        this.setLayout(new GridBagLayout());
        this.enlargeLabel.setLabelFor(this.enlargeText);
        Mnemonics.setLocalizedText((JLabel)this.enlargeLabel, (String)NbBundle.getBundle((Class)CustomZoomPanel.class).getString("LBL_EnlargeFactor"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.enlargeLabel, gridBagConstraints);
        this.enlargeText.setDocument(new WholeNumberDocument());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 11, 0, 11);
        this.add((Component)this.enlargeText, gridBagConstraints);
        this.decreasingLabel.setLabelFor(this.decreaseText);
        Mnemonics.setLocalizedText((JLabel)this.decreasingLabel, (String)NbBundle.getBundle((Class)CustomZoomPanel.class).getString("LBL_DecreaseFactor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 11, 0);
        this.add((Component)this.decreasingLabel, gridBagConstraints);
        this.decreaseText.setDocument(new WholeNumberDocument());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 11, 11, 11);
        this.add((Component)this.decreaseText, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)CustomZoomPanel.class).getString("ACSD_CustomZoomPanel"));
        this.enlargeText.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)CustomZoomPanel.class).getString("ACS_EnlargeText"));
        this.decreaseText.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)CustomZoomPanel.class).getString("ACS_DecreaseText"));
    }

    public int getEnlargeFactor() {
        return Integer.parseInt(this.enlargeText.getText());
    }

    public void setEnlargeFactor(int n) {
        this.enlargeText.setText("" + n);
    }

    public int getDecreaseFactor() {
        return Integer.parseInt(this.decreaseText.getText());
    }

    public void setDecreaseFactor(int n) {
        this.decreaseText.setText("" + n);
    }

    private static class WholeNumberDocument
    extends PlainDocument {
        private WholeNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < cArray.length; ++i) {
                if (Character.isDigit(cArray[i])) {
                    stringBuffer.append(cArray[i]);
                    continue;
                }
                if (!Boolean.getBoolean("netbeans.debug.excpetions")) continue;
                System.err.println("Image: Trying insert non-digit in custom zoom action.");
            }
            if (stringBuffer.length() == 0) {
                return;
            }
            super.insertString(n, stringBuffer.toString(), attributeSet);
        }
    }
}

