/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.util;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class JavaInitializer {
    public static String toJavaInitializationString(Object obj) {
        if (obj instanceof String) {
            return JavaInitializer.toJavaInitializationString((String)obj);
        }
        if (obj instanceof Integer) {
            return JavaInitializer.toJavaInitializationString((Integer)obj);
        }
        if (obj instanceof Double) {
            return JavaInitializer.toJavaInitializationString((Double)obj);
        }
        if (obj instanceof Long) {
            return JavaInitializer.toJavaInitializationString((Long)obj);
        }
        if (obj instanceof Short) {
            return JavaInitializer.toJavaInitializationString((Short)obj);
        }
        if (obj instanceof Character) {
            return JavaInitializer.toJavaInitializationString((Character)obj);
        }
        if (obj instanceof Boolean) {
            return JavaInitializer.toJavaInitializationString((Boolean)obj);
        }
        if (obj instanceof Date) {
            return JavaInitializer.toJavaInitializationString((Date)obj);
        }
        if (obj instanceof URL) {
            return JavaInitializer.toJavaInitializationString((URL)obj);
        }
        if (obj instanceof URI) {
            return JavaInitializer.toJavaInitializationString((URI)obj);
        }
        if (obj instanceof File) {
            return JavaInitializer.toJavaInitializationString((File)obj);
        }
        if (obj instanceof Locale) {
            return JavaInitializer.toJavaInitializationString((Locale)obj);
        }
        return "null";
    }

    public static String toJavaInitializationString(String str) {
        if (str == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer(str.length() * 2);
        char[] chars = str.toCharArray();
        buf.append('\"');
        block9: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\b': {
                    buf.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c >= ' ' && c <= '\u007f') {
                        buf.append(c);
                        continue block9;
                    }
                    buf.append("\\u");
                    String hex = Integer.toHexString(c);
                    for (int j = 0; j < 4 - hex.length(); ++j) {
                        buf.append('0');
                    }
                    buf.append(hex);
                }
            }
        }
        buf.append('\"');
        return buf.toString();
    }

    public static String toJavaInitializationString(Boolean b) {
        if (Boolean.TRUE.equals(b)) {
            return "Boolean.TRUE";
        }
        return "Boolean.FALSE";
    }

    public static String toJavaInitializationString(Character c) {
        return "new Character(" + c.toString() + ")";
    }

    public static String toJavaInitializationString(Integer i) {
        return "new Integer(" + i.toString() + ")";
    }

    public static String toJavaInitializationString(Short s) {
        return "new Short(" + s.toString() + ")";
    }

    public static String toJavaInitializationString(Long l) {
        return "new Long(" + l.toString() + ")";
    }

    public static String toJavaInitializationString(Double d) {
        return "new Double(" + d.toString() + ")";
    }

    public static String toJavaInitializationString(Date d) {
        String formatedDate = DateFormat.getInstance().format(d);
        return "DateFormat.getInstance().parse(" + formatedDate + ")";
    }

    public static String toJavaInitializationString(URI uri) {
        return "new URI(" + uri.toString() + ")";
    }

    public static String toJavaInitializationString(URL url) {
        return "new URL(" + url.toString() + ")";
    }

    public static String toJavaInitializationString(File file) {
        return "new File(" + file.toString() + ")";
    }

    public static String toJavaInitializationString(Locale locale) {
        if (locale.getCountry() != null) {
            return "new Locale(\"" + locale.getLanguage() + "\", \"" + locale.getCountry() + "\")";
        }
        return "new Locale(\"" + locale.getLanguage() + "\")";
    }
}

