/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.domains;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignProject;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.propertyeditors.domains.AttachedDomain;
import com.sun.rave.propertyeditors.domains.Element;
import java.net.URI;
import java.util.TreeSet;

public class ResourceBundlesDomain
extends AttachedDomain {
    private static final String BLUE_PRINT_SOURCE_ROOT = "src/java/";
    private static final String JAKARTA_SOURCE_ROOT = "src/";
    private static final URI SOURCE_URI = URI.create("src/");
    private static final String BUNDLE_SUFFIX = ".properties";

    public Element[] getElements() {
        DesignProperty designProperty = this.getDesignProperty();
        if (designProperty == null) {
            return Element.EMPTY_ARRAY;
        }
        DesignBean bean = this.getDesignProperty().getDesignBean();
        DesignProject project = bean.getDesignContext().getProject();
        URI[] resources = project.getResources(SOURCE_URI, true);
        if (resources == null) {
            return Element.EMPTY_ARRAY;
        }
        TreeSet<Element> set = new TreeSet<Element>();
        for (int i = 0; i < resources.length; ++i) {
            String resource = resources[i].toString();
            String sourceRoot = resource.startsWith(BLUE_PRINT_SOURCE_ROOT) ? BLUE_PRINT_SOURCE_ROOT : JAKARTA_SOURCE_ROOT;
            if (!ResourceBundlesDomain.isBasePropertiesResource(resource)) continue;
            resource = resource.substring(0, resource.length() - BUNDLE_SUFFIX.length());
            resource = resource.substring(sourceRoot.length());
            String baseName = resource.replace('/', '.');
            set.add(new Element(baseName));
        }
        return set.toArray(new Element[set.size()]);
    }

    private static boolean isBasePropertiesResource(String resource) {
        if (resource.endsWith(BUNDLE_SUFFIX)) {
            int i = resource.lastIndexOf(47);
            int j = resource.lastIndexOf(95);
            if (j <= i) {
                return true;
            }
        }
        return false;
    }
}

