/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring.plugins;

import com.sun.source.tree.Tree;
import java.io.IOException;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.beans.refactoring.ModificationTransaction;
import org.netbeans.modules.spring.beans.refactoring.Modifications;
import org.netbeans.modules.spring.beans.refactoring.Occurrences;
import org.netbeans.modules.spring.beans.refactoring.SpringRefactoringElement;
import org.netbeans.modules.spring.beans.refactoring.SpringRefactorings;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class SpringRenamePlugin
implements RefactoringPlugin {
    private final RenameRefactoring refactoring;

    public SpringRenamePlugin(RenameRefactoring renameRefactoring) {
        this.refactoring = renameRefactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        SpringScope springScope;
        TreePathHandle treePathHandle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        FileObject fileObject = null;
        if (treePathHandle != null && treePathHandle.getKind() == Tree.Kind.CLASS) {
            fileObject = treePathHandle.getFileObject();
        }
        if (fileObject == null) {
            fileObject = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
        }
        boolean bl = true;
        if (fileObject == null && (springScope = (NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class)) != null) {
            bl = false;
            fileObject = springScope.getFolder();
        }
        if (fileObject == null) {
            return null;
        }
        springScope = SpringScope.getSpringScope(fileObject);
        if (springScope == null) {
            return null;
        }
        try {
            if (treePathHandle != null) {
                Object object;
                SpringRefactorings.RenamedClassName renamedClassName = null;
                if (treePathHandle != null && (object = JavaSource.forFileObject((FileObject)fileObject)) != null) {
                    renamedClassName = SpringRefactorings.getRenamedClassName(treePathHandle, object, this.refactoring.getNewName());
                }
                if (renamedClassName != null) {
                    object = renamedClassName.getOldBinaryName();
                    String string = renamedClassName.getNewBinaryName();
                    if (object != null && string != null) {
                        Modifications modifications = new Modifications();
                        for (Occurrences.Occurrence occurrence : Occurrences.getJavaClassOccurrences((String)object, springScope)) {
                            refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)SpringRefactoringElement.createJavaElementRefModification(occurrence, modifications, renamedClassName.getOldSimpleName(), string));
                        }
                        refactoringElementsBag.registerTransaction((Transaction)new ModificationTransaction(modifications));
                    }
                }
            } else if (fileObject.isFolder()) {
                String string;
                String string2 = SpringRefactorings.getPackageName(fileObject);
                String string3 = string = bl ? SpringRefactorings.getRenamedPackageName(fileObject, this.refactoring.getNewName()) : this.refactoring.getNewName();
                if (string2 != null && string != null) {
                    Modifications modifications = new Modifications();
                    for (Occurrences.Occurrence occurrence : Occurrences.getJavaPackageOccurrences(string2, bl, springScope)) {
                        refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)SpringRefactoringElement.createJavaElementRefModification(occurrence, modifications, null, string));
                    }
                    refactoringElementsBag.registerTransaction((Transaction)new ModificationTransaction(modifications));
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }
}

