/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring.plugins;

import com.sun.source.tree.Tree;
import java.io.IOException;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.beans.refactoring.Occurrences;
import org.netbeans.modules.spring.beans.refactoring.SpringRefactoringElement;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class SpringFindUsagesPlugin
implements RefactoringPlugin {
    private final WhereUsedQuery refactoring;

    SpringFindUsagesPlugin(WhereUsedQuery whereUsedQuery) {
        this.refactoring = whereUsedQuery;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (!this.refactoring.getBooleanValue((Object)"FIND_REFERENCES")) {
            return null;
        }
        final TreePathHandle treePathHandle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (treePathHandle == null || treePathHandle.getKind() != Tree.Kind.CLASS) {
            return null;
        }
        FileObject fileObject = treePathHandle.getFileObject();
        SpringScope springScope = SpringScope.getSpringScope(fileObject);
        if (springScope == null) {
            return null;
        }
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            final String[] stringArray = new String[]{null};
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    TypeElement typeElement = (TypeElement)treePathHandle.resolveElement((CompilationInfo)compilationController);
                    if (typeElement != null) {
                        stringArray[0] = ElementUtilities.getBinaryName((TypeElement)typeElement);
                    }
                }
            }, true);
            if (stringArray[0] != null) {
                for (Occurrences.Occurrence occurrence : Occurrences.getJavaClassOccurrences(stringArray[0], springScope)) {
                    refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)SpringRefactoringElement.create(occurrence));
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }
}

