/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.beans.model.SpringConfigModelController;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakSet;

public class EditorListener {
    static final int EXPUNGE_EVERY = 50;
    private static EditorListener INSTANCE;
    final Map<File, WeakSet<SpringConfigModelController>> file2Controllers = new HashMap<File, WeakSet<SpringConfigModelController>>();
    private int expungeCountDown = 50;
    private EditorRegistryListener listener;

    private EditorListener() {
    }

    public static synchronized EditorListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EditorListener();
            INSTANCE.initialize();
        }
        return INSTANCE;
    }

    private void initialize() {
        this.listener = new EditorRegistryListener();
        this.listener.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(SpringConfigModelController springConfigModelController) {
        ConfigFileGroup configFileGroup = springConfigModelController.getConfigFileGroup();
        EditorListener editorListener = this;
        synchronized (editorListener) {
            for (File file : configFileGroup.getFiles()) {
                this.register(file, springConfigModelController);
            }
            this.expungeStaleFiles();
        }
    }

    private void register(File file, SpringConfigModelController springConfigModelController) {
        assert (Thread.holdsLock(this));
        WeakSet weakSet = this.file2Controllers.get(file);
        if (weakSet == null) {
            weakSet = new WeakSet();
            this.file2Controllers.put(file, (WeakSet<SpringConfigModelController>)weakSet);
        }
        weakSet.add((Object)springConfigModelController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFileChanged(FileObject fileObject, File file) {
        EditorListener editorListener = this;
        synchronized (editorListener) {
            WeakSet<SpringConfigModelController> weakSet = this.file2Controllers.get(file);
            if (weakSet != null) {
                if (weakSet.size() == 0) {
                    this.file2Controllers.remove(file);
                } else {
                    for (SpringConfigModelController springConfigModelController : weakSet) {
                        springConfigModelController.notifyFileChanged(fileObject, file);
                    }
                }
            }
            this.expungeStaleFiles();
        }
    }

    private void expungeStaleFiles() {
        assert (Thread.holdsLock(this));
        if (this.expungeCountDown > 0) {
            --this.expungeCountDown;
            return;
        }
        this.expungeCountDown = 50;
        Iterator<Map.Entry<File, WeakSet<SpringConfigModelController>>> iterator = this.file2Controllers.entrySet().iterator();
        while (iterator.hasNext()) {
            WeakSet<SpringConfigModelController> weakSet = iterator.next().getValue();
            if (weakSet.size() != 0) continue;
            iterator.remove();
        }
    }

    private final class EditorRegistryListener
    implements PropertyChangeListener,
    DocumentListener {
        private Document currentDocument;

        public synchronized void initialize() {
            EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
            JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
            Document document = this.currentDocument = jTextComponent != null ? jTextComponent.getDocument() : null;
            if (this.currentDocument != null) {
                this.currentDocument.addDocumentListener(EditorListener.this.listener);
            }
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Document document;
            assert (SwingUtilities.isEventDispatchThread());
            JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
            Document document2 = document = jTextComponent != null ? jTextComponent.getDocument() : null;
            if (this.currentDocument == document) {
                return;
            }
            if (this.currentDocument != null) {
                this.currentDocument.removeDocumentListener(this);
            }
            this.currentDocument = document;
            if (this.currentDocument != null) {
                this.currentDocument.addDocumentListener(this);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.notify(documentEvent.getDocument());
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.notify(documentEvent.getDocument());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.notify(documentEvent.getDocument());
        }

        private void notify(Document document) {
            FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
            if (fileObject == null) {
                return;
            }
            if (!"text/x-springconfig+xml".equals(fileObject.getMIMEType())) {
                return;
            }
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file == null) {
                return;
            }
            EditorListener.this.notifyFileChanged(fileObject, file);
        }
    }
}

