/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.editor;

import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.modules.spring.beans.editor.Property;

public class PropertyFinder {
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private ElementUtilities eu;
    private TypeMirror type;
    private String propPrefix;
    private Map<String, Property> name2Prop = new HashMap<String, Property>();

    public PropertyFinder(TypeMirror typeMirror, String string, ElementUtilities elementUtilities) {
        this.type = typeMirror;
        this.propPrefix = string;
        this.eu = elementUtilities;
    }

    public Property[] findProperties() {
        this.eu.getMembers(this.type, new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element element, TypeMirror typeMirror) {
                if (element.getKind() != ElementKind.METHOD) {
                    return false;
                }
                ExecutableElement executableElement = (ExecutableElement)element;
                String string = executableElement.getSimpleName().toString();
                TypeMirror typeMirror2 = executableElement.getReturnType();
                if (executableElement.getModifiers().contains((Object)Modifier.PRIVATE) || executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
                    return false;
                }
                if (PropertyFinder.this.isGetter(string, executableElement, typeMirror2)) {
                    String string2 = PropertyFinder.this.getPropertyName(string);
                    if (!string2.startsWith(PropertyFinder.this.propPrefix)) {
                        return false;
                    }
                    PropertyFinder.this.addPropertyGetter(string2, executableElement);
                    return true;
                }
                if (PropertyFinder.this.isSetter(string, executableElement, typeMirror2)) {
                    String string3 = PropertyFinder.this.getPropertyName(string);
                    if (!string3.startsWith(PropertyFinder.this.propPrefix)) {
                        return false;
                    }
                    PropertyFinder.this.addPropertySetter(string3, executableElement);
                    return true;
                }
                return false;
            }
        });
        return this.name2Prop.values().toArray(new Property[0]);
    }

    private void addPropertySetter(String string, ExecutableElement executableElement) {
        Property property = this.getProperty(string);
        property.setSetter(executableElement);
    }

    private void addPropertyGetter(String string, ExecutableElement executableElement) {
        Property property = this.getProperty(string);
        property.setGetter(executableElement);
    }

    private Property getProperty(String string) {
        Property property = this.name2Prop.get(string);
        if (property == null) {
            property = new Property(string);
            this.name2Prop.put(string, property);
        }
        return property;
    }

    private String getPropertyName(String string) {
        if (string.startsWith(GET_PREFIX) || string.startsWith(SET_PREFIX)) {
            return this.convertToPropertyName(string.substring(3));
        }
        if (string.startsWith(IS_PREFIX)) {
            return this.convertToPropertyName(string.substring(2));
        }
        return null;
    }

    private String convertToPropertyName(String string) {
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return String.valueOf(cArray);
    }

    private boolean isGetter(String string, ExecutableElement executableElement, TypeMirror typeMirror) {
        boolean bl = string.startsWith(GET_PREFIX) && string.length() > GET_PREFIX.length() && typeMirror.getKind() != TypeKind.VOID;
        bl = bl || string.startsWith(IS_PREFIX) && string.length() > IS_PREFIX.length() && typeMirror.getKind() == TypeKind.BOOLEAN;
        return bl;
    }

    private boolean isSetter(String string, ExecutableElement executableElement, TypeMirror typeMirror) {
        return string.startsWith(SET_PREFIX) && string.length() > SET_PREFIX.length() && typeMirror.getKind() == TypeKind.VOID && executableElement.getParameters().size() == 1;
    }
}

