/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.LazyTypeCompletionItem;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.netbeans.modules.spring.beans.editor.BeanClassFinder;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.spring.beans.editor.Property;
import org.netbeans.modules.spring.beans.editor.PropertyFinder;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.Node;

public final class CompletionManager {
    private static final String BEAN_TAG = "bean";
    private static final String ALIAS_TAG = "alias";
    private static final String BEANS_TAG = "beans";
    private static final String LIST_TAG = "list";
    private static final String SET_TAG = "set";
    private static final String MAP_TAG = "map";
    private static final String PROPS_TAG = "props";
    private static final String IMPORT_TAG = "import";
    private static final String VALUE_TAG = "value";
    private static final String CONSTRUCTOR_ARG_TAG = "constructor-arg";
    private static final String REF_TAG = "ref";
    private static final String IDREF_TAG = "idref";
    private static final String ENTRY_TAG = "entry";
    private static final String PROPERTY_TAG = "property";
    private static final String LOOKUP_METHOD_TAG = "lookup-method";
    private static final String REPLACED_METHOD_TAG = "replaced-method";
    private static final String DEPENDS_ON_ATTRIB = "depends-on";
    private static final String PARENT_ATTRIB = "parent";
    private static final String FACTORY_BEAN_ATTRIB = "factory-bean";
    private static final String NAME_ATTRIB = "name";
    private static final String DEFAULT_LAZY_INIT_ATTRIB = "default-lazy-init";
    private static final String AUTOWIRE_ATTRIB = "autowire";
    private static final String DEFAULT_MERGE_ATTRIB = "default-merge";
    private static final String DEFAULT_DEPENDENCY_CHECK_ATTRIB = "default-dependency-check";
    private static final String DEFAULT_AUTOWIRE_ATTRIB = "default-autowire";
    private static final String DEPENDENCY_CHECK_ATTRIB = "dependency-check";
    private static final String LAZY_INIT_ATTRIB = "lazy-init";
    private static final String ABSTRACT_ATTRIB = "abstract";
    private static final String AUTOWIRE_CANDIDATE_ATTRIB = "autowire-candidate";
    private static final String MERGE_ATTRIB = "merge";
    private static final String RESOURCE_ATTRIB = "resource";
    private static final String INIT_METHOD_ATTRIB = "init-method";
    private static final String DESTROY_METHOD_ATTRIB = "destroy-method";
    private static final String CLASS_ATTRIB = "class";
    private static final String VALUE_TYPE_ATTRIB = "value-type";
    private static final String KEY_TYPE_ATTRIB = "key-type";
    private static final String TYPE_ATTRIB = "type";
    private static final String REF_ATTRIB = "ref";
    private static final String BEAN_ATTRIB = "bean";
    private static final String LOCAL_ATTRIB = "local";
    private static final String KEY_REF_ATTRIB = "key-ref";
    private static final String VALUE_REF_ATTRIB = "value-ref";
    private static final String REPLACER_ATTRIB = "replacer";
    private static final String FACTORY_METHOD_ATTRIB = "factory-method";
    private static Map<String, CompletorFactory> completorFactories = new HashMap<String, CompletorFactory>();
    private static CompletionManager INSTANCE = new CompletionManager();

    private CompletionManager() {
        this.setupCompletors();
    }

    private void setupCompletors() {
        String[] stringArray = new String[]{"no", NbBundle.getMessage(CompletionManager.class, (String)"DESC_autowire_no"), "byName", NbBundle.getMessage(CompletionManager.class, (String)"DESC_autowire_byName"), "byType", NbBundle.getMessage(CompletionManager.class, (String)"DESC_autowire_byType"), "constructor", NbBundle.getMessage(CompletionManager.class, (String)"DESC_autowire_constructor"), "autodetect", NbBundle.getMessage(CompletionManager.class, (String)"DESC_autowire_autodetect")};
        AttributeValueCompletorFactory attributeValueCompletorFactory = new AttributeValueCompletorFactory(stringArray);
        this.registerCompletorFactory(BEANS_TAG, DEFAULT_AUTOWIRE_ATTRIB, attributeValueCompletorFactory);
        String[] stringArray2 = new String[stringArray.length + 2];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = "default";
        stringArray2[stringArray.length + 1] = null;
        attributeValueCompletorFactory = new AttributeValueCompletorFactory(stringArray2);
        this.registerCompletorFactory("bean", AUTOWIRE_ATTRIB, attributeValueCompletorFactory);
        String[] stringArray3 = new String[]{"true", null, "false", null};
        attributeValueCompletorFactory = new AttributeValueCompletorFactory(stringArray3);
        this.registerCompletorFactory(BEANS_TAG, DEFAULT_LAZY_INIT_ATTRIB, attributeValueCompletorFactory);
        String[] stringArray4 = new String[]{stringArray3[0], stringArray3[1], stringArray3[2], stringArray3[3], "default", null};
        attributeValueCompletorFactory = new AttributeValueCompletorFactory(stringArray4);
        this.registerCompletorFactory("bean", LAZY_INIT_ATTRIB, attributeValueCompletorFactory);
        String[] stringArray5 = new String[]{"true", null, "false", null};
        attributeValueCompletorFactory = new AttributeValueCompletorFactory(stringArray5);
        this.registerCompletorFactory(BEANS_TAG, DEFAULT_MERGE_ATTRIB, attributeValueCompletorFactory);
        String[] stringArray6 = new String[]{"none", NbBundle.getMessage(CompletionManager.class, (String)"DESC_def_dep_check_none"), "simple", NbBundle.getMessage(CompletionManager.class, (String)"DESC_def_dep_check_simple"), "objects", NbBundle.getMessage(CompletionManager.class, (String)"DESC_def_dep_check_objects"), "all", NbBundle.getMessage(CompletionManager.class, (String)"DESC_def_dep_check_all")};
        attributeValueCompletorFactory = new AttributeValueCompletorFactory(stringArray6);
        this.registerCompletorFactory(BEANS_TAG, DEFAULT_DEPENDENCY_CHECK_ATTRIB, attributeValueCompletorFactory);
        String[] stringArray7 = new String[stringArray6.length + 2];
        stringArray7[stringArray6.length] = "default";
        stringArray7[stringArray6.length + 1] = null;
        attributeValueCompletorFactory = new AttributeValueCompletorFactory(stringArray7);
        this.registerCompletorFactory("bean", DEPENDENCY_CHECK_ATTRIB, attributeValueCompletorFactory);
        String[] stringArray8 = new String[]{"true", null, "false", null};
        attributeValueCompletorFactory = new AttributeValueCompletorFactory(stringArray8);
        this.registerCompletorFactory("bean", ABSTRACT_ATTRIB, attributeValueCompletorFactory);
        String[] stringArray9 = new String[]{"true", null, "false", null, "default", null};
        attributeValueCompletorFactory = new AttributeValueCompletorFactory(stringArray9);
        this.registerCompletorFactory("bean", AUTOWIRE_CANDIDATE_ATTRIB, attributeValueCompletorFactory);
        String[] stringArray10 = new String[]{"true", null, "false", null, "default", null};
        attributeValueCompletorFactory = new AttributeValueCompletorFactory(stringArray10);
        this.registerCompletorFactory(LIST_TAG, MERGE_ATTRIB, attributeValueCompletorFactory);
        this.registerCompletorFactory(SET_TAG, MERGE_ATTRIB, attributeValueCompletorFactory);
        this.registerCompletorFactory(MAP_TAG, MERGE_ATTRIB, attributeValueCompletorFactory);
        this.registerCompletorFactory(PROPS_TAG, MERGE_ATTRIB, attributeValueCompletorFactory);
        this.registerCompletorFactory(IMPORT_TAG, RESOURCE_ATTRIB, new GenericCompletorFactory(ResourceCompletor.class));
        GenericCompletorFactory genericCompletorFactory = new GenericCompletorFactory(JavaClassCompletor.class);
        this.registerCompletorFactory("bean", CLASS_ATTRIB, genericCompletorFactory);
        this.registerCompletorFactory(LIST_TAG, VALUE_TYPE_ATTRIB, genericCompletorFactory);
        this.registerCompletorFactory(MAP_TAG, VALUE_TYPE_ATTRIB, genericCompletorFactory);
        this.registerCompletorFactory(MAP_TAG, KEY_TYPE_ATTRIB, genericCompletorFactory);
        this.registerCompletorFactory(SET_TAG, VALUE_TYPE_ATTRIB, genericCompletorFactory);
        this.registerCompletorFactory(VALUE_TAG, TYPE_ATTRIB, genericCompletorFactory);
        this.registerCompletorFactory(CONSTRUCTOR_ARG_TAG, TYPE_ATTRIB, genericCompletorFactory);
        BeansRefCompletorFactory beansRefCompletorFactory = new BeansRefCompletorFactory(true);
        this.registerCompletorFactory(ALIAS_TAG, NAME_ATTRIB, beansRefCompletorFactory);
        this.registerCompletorFactory("bean", PARENT_ATTRIB, beansRefCompletorFactory);
        this.registerCompletorFactory("bean", DEPENDS_ON_ATTRIB, beansRefCompletorFactory);
        this.registerCompletorFactory("bean", FACTORY_BEAN_ATTRIB, beansRefCompletorFactory);
        this.registerCompletorFactory(CONSTRUCTOR_ARG_TAG, "ref", beansRefCompletorFactory);
        this.registerCompletorFactory("ref", "bean", beansRefCompletorFactory);
        this.registerCompletorFactory(IDREF_TAG, "bean", beansRefCompletorFactory);
        this.registerCompletorFactory(ENTRY_TAG, KEY_REF_ATTRIB, beansRefCompletorFactory);
        this.registerCompletorFactory(ENTRY_TAG, VALUE_REF_ATTRIB, beansRefCompletorFactory);
        this.registerCompletorFactory(PROPERTY_TAG, "ref", beansRefCompletorFactory);
        this.registerCompletorFactory(LOOKUP_METHOD_TAG, "bean", beansRefCompletorFactory);
        this.registerCompletorFactory(REPLACED_METHOD_TAG, REPLACER_ATTRIB, beansRefCompletorFactory);
        beansRefCompletorFactory = new BeansRefCompletorFactory(false);
        this.registerCompletorFactory("ref", LOCAL_ATTRIB, beansRefCompletorFactory);
        this.registerCompletorFactory(IDREF_TAG, LOCAL_ATTRIB, beansRefCompletorFactory);
        GenericCompletorFactory genericCompletorFactory2 = new GenericCompletorFactory(InitDestroyMethodCompletor.class);
        this.registerCompletorFactory("bean", INIT_METHOD_ATTRIB, genericCompletorFactory2);
        this.registerCompletorFactory("bean", DESTROY_METHOD_ATTRIB, genericCompletorFactory2);
        this.registerCompletorFactory(LOOKUP_METHOD_TAG, NAME_ATTRIB, genericCompletorFactory2);
        this.registerCompletorFactory(REPLACED_METHOD_TAG, NAME_ATTRIB, genericCompletorFactory2);
        genericCompletorFactory2 = new GenericCompletorFactory(FactoryMethodCompletor.class);
        this.registerCompletorFactory("bean", FACTORY_METHOD_ATTRIB, genericCompletorFactory2);
        GenericCompletorFactory genericCompletorFactory3 = new GenericCompletorFactory(PropertyCompletor.class);
        this.registerCompletorFactory(PROPERTY_TAG, NAME_ATTRIB, genericCompletorFactory3);
        GenericCompletorFactory genericCompletorFactory4 = new GenericCompletorFactory(PNamespaceBeanRefCompletor.class);
        this.registerCompletorFactory("bean", null, genericCompletorFactory4);
    }

    public static CompletionManager getDefault() {
        return INSTANCE;
    }

    public void completeAttributeValues(CompletionResultSet completionResultSet, CompletionContext completionContext) {
        TokenItem tokenItem;
        String string;
        String string2 = completionContext.getTag().getNodeName();
        CompletorFactory completorFactory = this.locateCompletorFactory(string2, string = (tokenItem = ContextUtilities.getAttributeToken(completionContext.getCurrentToken())) != null ? tokenItem.getImage() : null);
        if (completorFactory != null) {
            Completor completor = completorFactory.createCompletor();
            completionResultSet.addAllItems(completor.doCompletion(completionContext));
            if (completor.getAnchorOffset() != -1) {
                completionResultSet.setAnchorOffset(completor.getAnchorOffset());
            }
        }
    }

    public void completeAttributes(final CompletionResultSet completionResultSet, final CompletionContext completionContext) {
        String string = completionContext.getTag().getNodeName();
        if (string.equals("bean") && ContextUtilities.isPNamespaceAdded(completionContext.getDocumentContext())) {
            try {
                JavaSource javaSource = SpringXMLConfigEditorUtils.getJavaSource(completionContext.getFileObject());
                if (javaSource == null) {
                    return;
                }
                final String string2 = completionContext.getTypedPrefix();
                final String string3 = completionContext.getDocumentContext().getNamespacePrefix("http://www.springframework.org/schema/p");
                final int n = completionContext.getCaretOffset() - string2.length();
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        Property[] propertyArray;
                        String string = new BeanClassFinder(SpringXMLConfigEditorUtils.getTagAttributes(completionContext.getTag()), completionContext.getFileObject()).findImplementationClass();
                        if (string == null) {
                            return;
                        }
                        TypeElement typeElement = SpringXMLConfigEditorUtils.findClassElementByBinaryName(string, compilationController);
                        if (typeElement == null) {
                            return;
                        }
                        ElementUtilities elementUtilities = compilationController.getElementUtilities();
                        for (Property property : propertyArray = new PropertyFinder(typeElement.asType(), "", elementUtilities).findProperties()) {
                            SpringXMLConfigCompletionItem springXMLConfigCompletionItem;
                            if (property.getSetter() == null) continue;
                            String string22 = string3 + ":" + property.getName();
                            if (!completionContext.getExistingAttributes().contains(string22) && string22.startsWith(string2)) {
                                springXMLConfigCompletionItem = SpringXMLConfigCompletionItem.createPropertyAttribItem(n, string22, property);
                                completionResultSet.addItem((CompletionItem)springXMLConfigCompletionItem);
                            }
                            string22 = string22 + "-ref";
                            if (completionContext.getExistingAttributes().contains(string22) || !string22.startsWith(string2)) continue;
                            springXMLConfigCompletionItem = SpringXMLConfigCompletionItem.createPropertyAttribItem(n, string22, property);
                            completionResultSet.addItem((CompletionItem)springXMLConfigCompletionItem);
                        }
                    }
                }, true);
                completionResultSet.setAnchorOffset(n);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public void completeElements(CompletionResultSet completionResultSet, CompletionContext completionContext) {
    }

    private void registerCompletorFactory(String string, String string2, CompletorFactory completorFactory) {
        completorFactories.put(CompletionManager.createRegisteredName(string, string2), completorFactory);
    }

    private static String createRegisteredName(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.hasText(string)) {
            stringBuilder.append("/nodeName=");
            stringBuilder.append(string);
        } else {
            stringBuilder.append("/nodeName=");
            stringBuilder.append("*");
        }
        if (StringUtils.hasText(string2)) {
            stringBuilder.append("/attribute=");
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private CompletorFactory locateCompletorFactory(String string, String string2) {
        String string3 = CompletionManager.createRegisteredName(string, string2);
        if (completorFactories.containsKey(string3)) {
            return completorFactories.get(string3);
        }
        string3 = CompletionManager.createRegisteredName(string, null);
        if (completorFactories.containsKey(string3)) {
            return completorFactories.get(string3);
        }
        string3 = CompletionManager.createRegisteredName("*", string2);
        if (completorFactories.containsKey(string3)) {
            return completorFactories.get(string3);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceCompletor
    extends Completor {
        @Override
        public List<SpringXMLConfigCompletionItem> doCompletion(CompletionContext completionContext) {
            Object object;
            Object object2;
            ArrayList<SpringXMLConfigCompletionItem> arrayList = new ArrayList<SpringXMLConfigCompletionItem>();
            FileObject fileObject = completionContext.getFileObject().getParent();
            String string = completionContext.getTypedPrefix();
            int n = string.lastIndexOf("/");
            String string2 = string;
            if (n != -1) {
                object2 = string.substring(0, string.lastIndexOf("/"));
                fileObject = fileObject.getFileObject((String)object2);
                string2 = n != string.length() - 1 ? string.substring(Math.min(string.lastIndexOf("/") + 1, string.length() - 1)) : "";
            }
            if (fileObject == null) {
                return Collections.emptyList();
            }
            if (string2 == null) {
                string2 = "";
            }
            object2 = fileObject.getFolders(false);
            while (object2.hasMoreElements()) {
                object = (FileObject)object2.nextElement();
                if (!object.getName().startsWith(string2)) continue;
                arrayList.add(SpringXMLConfigCompletionItem.createFolderItem(completionContext.getCaretOffset() - string2.length(), (FileObject)object));
            }
            object = fileObject.getData(false);
            while (object.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)object.nextElement();
                if (!fileObject2.getName().startsWith(string2) || !"text/x-springconfig+xml".equals(fileObject2.getMIMEType())) continue;
                arrayList.add(SpringXMLConfigCompletionItem.createSpringXMLFileItem(completionContext.getCaretOffset() - string2.length(), fileObject2));
            }
            this.setAnchorOffset(completionContext.getCaretOffset() - string2.length());
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PNamespaceBeanRefCompletor
    extends Completor {
        @Override
        public List<SpringXMLConfigCompletionItem> doCompletion(CompletionContext completionContext) {
            TokenItem tokenItem = ContextUtilities.getAttributeToken(completionContext.getCurrentToken());
            if (tokenItem == null) {
                return Collections.emptyList();
            }
            String string = tokenItem.getImage();
            if (!ContextUtilities.isPNamespaceName(completionContext.getDocumentContext(), string)) {
                return Collections.emptyList();
            }
            if (!string.endsWith("-ref")) {
                return Collections.emptyList();
            }
            BeansRefCompletor beansRefCompletor = new BeansRefCompletor(true);
            return beansRefCompletor.doCompletion(completionContext);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyCompletor
    extends Completor {
        @Override
        public List<SpringXMLConfigCompletionItem> doCompletion(final CompletionContext completionContext) {
            final ArrayList<SpringXMLConfigCompletionItem> arrayList = new ArrayList<SpringXMLConfigCompletionItem>();
            final String string = completionContext.getTypedPrefix();
            JavaSource javaSource = SpringXMLConfigEditorUtils.getJavaSource(completionContext.getFileObject());
            if (javaSource == null) {
                return Collections.emptyList();
            }
            try {
                final int n = string.lastIndexOf(".");
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        Property[] propertyArray;
                        String string4;
                        Tag tag = (Tag)SpringXMLConfigEditorUtils.getBean(completionContext.getTag());
                        String string2 = new BeanClassFinder(SpringXMLConfigEditorUtils.getTagAttributes((Node)tag), completionContext.getFileObject()).findImplementationClass();
                        if (string2 == null) {
                            return;
                        }
                        TypeElement typeElement = SpringXMLConfigEditorUtils.findClassElementByBinaryName(string2, compilationController);
                        if (typeElement == null) {
                            return;
                        }
                        TypeMirror typeMirror = typeElement.asType();
                        ElementUtilities elementUtilities = compilationController.getElementUtilities();
                        if (n != -1) {
                            string4 = string.substring(0, n);
                            propertyArray = new StringTokenizer(string4, ".");
                            while (propertyArray.hasMoreTokens() && typeMirror != null) {
                                String string3 = propertyArray.nextToken();
                                Property[] propertyArray2 = new PropertyFinder(typeMirror, string3, elementUtilities).findProperties();
                                if (propertyArray2.length == 0 || propertyArray2[0].getGetter() == null) {
                                    typeMirror = null;
                                    break;
                                }
                                TypeMirror typeMirror2 = propertyArray2[0].getGetter().getReturnType();
                                if (typeMirror2.getKind() == TypeKind.DECLARED) {
                                    typeMirror = typeMirror2;
                                    continue;
                                }
                                typeMirror = null;
                            }
                        }
                        if (typeMirror == null) {
                            return;
                        }
                        string4 = "";
                        if (n != string.length() - 1) {
                            string4 = string.substring(n + 1);
                        }
                        propertyArray = new PropertyFinder(typeMirror, string4, elementUtilities).findProperties();
                        int n2 = completionContext.getCurrentToken().getOffset() + 1;
                        if (n != -1) {
                            n2 += n + 1;
                        }
                        for (Property property : propertyArray) {
                            if (property.getSetter() == null) continue;
                            arrayList.add(SpringXMLConfigCompletionItem.createPropertyItem(n2, property));
                        }
                        PropertyCompletor.this.setAnchorOffset(n2);
                    }
                }, false);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FactoryMethodCompletor
    extends JavaMethodCompletor {
        private SpringXMLConfigEditorUtils.Static staticFlag = SpringXMLConfigEditorUtils.Static.YES;

        @Override
        protected SpringXMLConfigEditorUtils.Public getPublicFlag(CompletionContext completionContext) {
            return SpringXMLConfigEditorUtils.Public.DONT_CARE;
        }

        @Override
        protected SpringXMLConfigEditorUtils.Static getStaticFlag(CompletionContext completionContext) {
            return this.staticFlag;
        }

        @Override
        protected int getArgCount(CompletionContext completionContext) {
            return -1;
        }

        @Override
        protected String getTypeName(CompletionContext completionContext) {
            Node node = completionContext.getTag();
            SpringBean springBean = SpringXMLConfigEditorUtils.getMergedBean(SpringXMLConfigEditorUtils.getTagAttributes(node), completionContext.getFileObject());
            if (springBean == null) {
                return null;
            }
            final String[] stringArray = new String[]{springBean.getClassName()};
            if (springBean.getFactoryBean() != null) {
                final String string = springBean.getFactoryBean();
                FileObject fileObject = completionContext.getFileObject();
                SpringConfigModel springConfigModel = SpringConfigModel.forFileObject(fileObject);
                try {
                    springConfigModel.runReadAction(new Action<SpringBeans>(){

                        @Override
                        public void run(SpringBeans springBeans) {
                            SpringBean springBean = springBeans.findBean(string);
                            if (springBean == null) {
                                stringArray[0] = null;
                                return;
                            }
                            stringArray[0] = springBean.getClassName();
                        }
                    });
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    stringArray[0] = null;
                }
                this.staticFlag = SpringXMLConfigEditorUtils.Static.NO;
            }
            return stringArray[0];
        }

        @Override
        protected Iterable<? extends Element> filter(Iterable<? extends Element> iterable) {
            ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
            for (Element element : iterable) {
                ExecutableElement executableElement = (ExecutableElement)element;
                if (executableElement.getReturnType().getKind() == TypeKind.VOID) continue;
                arrayList.add(executableElement);
            }
            return arrayList;
        }
    }

    private static class InitDestroyMethodCompletor
    extends JavaMethodCompletor {
        protected SpringXMLConfigEditorUtils.Public getPublicFlag(CompletionContext completionContext) {
            return SpringXMLConfigEditorUtils.Public.DONT_CARE;
        }

        protected SpringXMLConfigEditorUtils.Static getStaticFlag(CompletionContext completionContext) {
            return SpringXMLConfigEditorUtils.Static.NO;
        }

        protected int getArgCount(CompletionContext completionContext) {
            return 0;
        }

        protected String getTypeName(CompletionContext completionContext) {
            Node node = SpringXMLConfigEditorUtils.getBean(completionContext.getTag());
            return new BeanClassFinder(SpringXMLConfigEditorUtils.getTagAttributes(node), completionContext.getFileObject()).findImplementationClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class JavaMethodCompletor
    extends Completor {
        private JavaMethodCompletor() {
        }

        @Override
        public List<SpringXMLConfigCompletionItem> doCompletion(final CompletionContext completionContext) {
            final ArrayList<SpringXMLConfigCompletionItem> arrayList = new ArrayList<SpringXMLConfigCompletionItem>();
            try {
                final String string = this.getTypeName(completionContext);
                final SpringXMLConfigEditorUtils.Public public_ = this.getPublicFlag(completionContext);
                final SpringXMLConfigEditorUtils.Static static_ = this.getStaticFlag(completionContext);
                final int n = this.getArgCount(completionContext);
                if (string == null || string.equals("")) {
                    return Collections.emptyList();
                }
                JavaSource javaSource = SpringXMLConfigEditorUtils.getJavaSource(completionContext.getFileObject());
                if (javaSource == null) {
                    return Collections.emptyList();
                }
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement typeElement = SpringXMLConfigEditorUtils.findClassElementByBinaryName(string, compilationController);
                        if (typeElement == null) {
                            return;
                        }
                        ElementUtilities elementUtilities = compilationController.getElementUtilities();
                        ElementUtilities.ElementAcceptor elementAcceptor = new ElementUtilities.ElementAcceptor(){

                            public boolean accept(Element element, TypeMirror typeMirror) {
                                if (element.getKind() == ElementKind.METHOD) {
                                    boolean bl;
                                    TypeElement typeElement = (TypeElement)element.getEnclosingElement();
                                    if (typeElement.getQualifiedName().contentEquals("java.lang.Object")) {
                                        return false;
                                    }
                                    if (!element.getSimpleName().toString().startsWith(completionContext.getTypedPrefix())) {
                                        return false;
                                    }
                                    ExecutableElement executableElement = (ExecutableElement)element;
                                    if (n != -1 && executableElement.getParameters().size() != n) {
                                        return false;
                                    }
                                    if (static_ != SpringXMLConfigEditorUtils.Static.DONT_CARE && ((bl = executableElement.getModifiers().contains((Object)Modifier.STATIC)) && static_ == SpringXMLConfigEditorUtils.Static.NO || !bl && static_ == SpringXMLConfigEditorUtils.Static.YES)) {
                                        return false;
                                    }
                                    return public_ == SpringXMLConfigEditorUtils.Public.DONT_CARE || (!(bl = executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) || public_ != SpringXMLConfigEditorUtils.Public.NO) && (bl || public_ != SpringXMLConfigEditorUtils.Public.YES);
                                }
                                return false;
                            }
                        };
                        int n2 = completionContext.getCurrentToken().getOffset() + 1;
                        Iterable<? extends Element> iterable = elementUtilities.getMembers(typeElement.asType(), elementAcceptor);
                        iterable = JavaMethodCompletor.this.filter(iterable);
                        for (Element element : iterable) {
                            SpringXMLConfigCompletionItem springXMLConfigCompletionItem = SpringXMLConfigCompletionItem.createMethodItem(n2, (ExecutableElement)element, element.getEnclosingElement() != typeElement, compilationController.getElements().isDeprecated(element));
                            arrayList.add(springXMLConfigCompletionItem);
                        }
                        JavaMethodCompletor.this.setAnchorOffset(n2);
                    }
                }, false);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return arrayList;
        }

        protected abstract SpringXMLConfigEditorUtils.Public getPublicFlag(CompletionContext var1);

        protected abstract SpringXMLConfigEditorUtils.Static getStaticFlag(CompletionContext var1);

        protected abstract int getArgCount(CompletionContext var1);

        protected abstract String getTypeName(CompletionContext var1);

        protected Iterable<? extends Element> filter(Iterable<? extends Element> iterable) {
            return iterable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaClassCompletor
    extends Completor {
        @Override
        public List<SpringXMLConfigCompletionItem> doCompletion(CompletionContext completionContext) {
            ArrayList<SpringXMLConfigCompletionItem> arrayList = new ArrayList<SpringXMLConfigCompletionItem>();
            try {
                String string = completionContext.getTypedPrefix();
                JavaSource javaSource = SpringXMLConfigEditorUtils.getJavaSource(completionContext.getFileObject());
                if (javaSource == null) {
                    return Collections.emptyList();
                }
                if (string.contains(".") || string.equals("")) {
                    this.doNormalJavaCompletion(javaSource, arrayList, string, completionContext.getCurrentToken().getOffset() + 1);
                } else {
                    this.doSmartJavaCompletion(javaSource, arrayList, string, completionContext.getCurrentToken().getOffset() + 1);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return arrayList;
        }

        private void doNormalJavaCompletion(JavaSource javaSource, final List<SpringXMLConfigCompletionItem> list, final String string, final int n) throws IOException {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ClassIndex classIndex = compilationController.getJavaSource().getClasspathInfo().getClassIndex();
                    int n3 = n;
                    String string2 = string;
                    int n2 = string.lastIndexOf(46);
                    if (n2 != -1) {
                        n3 += n2 + 1;
                        string2 = string.substring(0, n2);
                    }
                    JavaClassCompletor.this.addPackages(classIndex, list, string, n3);
                    PackageElement packageElement = compilationController.getElements().getPackageElement(string2);
                    if (packageElement == null) {
                        return;
                    }
                    List list2 = (List)new TypeScanner().scan(packageElement);
                    for (TypeElement typeElement : list2) {
                        if (!ElementUtilities.getBinaryName((TypeElement)typeElement).startsWith(string)) continue;
                        SpringXMLConfigCompletionItem springXMLConfigCompletionItem = SpringXMLConfigCompletionItem.createTypeItem(n, typeElement, (ElementHandle<TypeElement>)ElementHandle.create((Element)typeElement), compilationController.getElements().isDeprecated(typeElement), false);
                        list.add(springXMLConfigCompletionItem);
                    }
                    JavaClassCompletor.this.setAnchorOffset(n3);
                }
            }, true);
        }

        private void doSmartJavaCompletion(final JavaSource javaSource, final List<SpringXMLConfigCompletionItem> list, final String string, final int n) throws IOException {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ClassIndex classIndex = compilationController.getJavaSource().getClasspathInfo().getClassIndex();
                    JavaClassCompletor.this.addPackages(classIndex, list, string, n);
                    Set set = classIndex.getDeclaredTypes(string, ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX, EnumSet.allOf(ClassIndex.SearchScope.class));
                    for (ElementHandle elementHandle : set) {
                        if (elementHandle.getKind() != ElementKind.CLASS) continue;
                        LazyTypeCompletionItem lazyTypeCompletionItem = LazyTypeCompletionItem.create(n, (ElementHandle<TypeElement>)elementHandle, javaSource);
                        list.add(lazyTypeCompletionItem);
                    }
                }
            }, true);
            this.setAnchorOffset(n);
        }

        private static boolean isAccessibleClass(TypeElement typeElement) {
            NestingKind nestingKind = typeElement.getNestingKind();
            return nestingKind == NestingKind.TOP_LEVEL || nestingKind == NestingKind.MEMBER && typeElement.getModifiers().contains((Object)Modifier.STATIC);
        }

        private void addPackages(ClassIndex classIndex, List<SpringXMLConfigCompletionItem> list, String string, int n) {
            Set set = classIndex.getPackageNames(string, true, EnumSet.allOf(ClassIndex.SearchScope.class));
            for (String string2 : set) {
                if (string2.length() <= 0) continue;
                SpringXMLConfigCompletionItem springXMLConfigCompletionItem = SpringXMLConfigCompletionItem.createPackageItem(n, string2, false);
                list.add(springXMLConfigCompletionItem);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class TypeScanner
        extends ElementScanner6<List<TypeElement>, Void> {
            public TypeScanner() {
                super(new ArrayList());
            }

            @Override
            public List<TypeElement> visitType(TypeElement typeElement, Void void_) {
                if (typeElement.getKind() == ElementKind.CLASS && JavaClassCompletor.isAccessibleClass(typeElement)) {
                    ((List)this.DEFAULT_VALUE).add(typeElement);
                }
                return (List)super.visitType(typeElement, void_);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeansRefCompletor
    extends Completor {
        private final boolean includeGlobal;

        public BeansRefCompletor(boolean bl) {
            this.includeGlobal = bl;
        }

        @Override
        public List<SpringXMLConfigCompletionItem> doCompletion(final CompletionContext completionContext) {
            Object object;
            final FileObject fileObject = completionContext.getFileObject();
            SpringConfigModel springConfigModel = SpringConfigModel.forFileObject(fileObject);
            if (springConfigModel == null) {
                return Collections.emptyList();
            }
            final ArrayList<SpringXMLConfigCompletionItem> arrayList = new ArrayList<SpringXMLConfigCompletionItem>();
            final String string = completionContext.getTypedPrefix();
            final ArrayList<String> arrayList2 = new ArrayList<String>();
            String string2 = completionContext.getTag().getNodeName();
            if (string2.equals("bean") && SpringXMLConfigEditorUtils.hasAttribute(completionContext.getTag(), "id")) {
                object = SpringXMLConfigEditorUtils.getAttribute(completionContext.getTag(), "id");
                arrayList2.add((String)object);
            }
            if (string2.equals("bean") && SpringXMLConfigEditorUtils.hasAttribute(completionContext.getTag(), CompletionManager.NAME_ATTRIB)) {
                object = StringUtils.tokenize(SpringXMLConfigEditorUtils.getAttribute(completionContext.getTag(), CompletionManager.NAME_ATTRIB), ",; ");
                arrayList2.addAll((Collection<String>)object);
            }
            try {
                springConfigModel.runReadAction(new Action<SpringBeans>(){

                    @Override
                    public void run(SpringBeans springBeans) {
                        List<SpringBean> list = BeansRefCompletor.this.includeGlobal ? springBeans.getBeans() : springBeans.getBeans(FileUtil.toFile((FileObject)fileObject));
                        Map<String, SpringBean> map = this.getName2Beans(list, BeansRefCompletor.this.includeGlobal);
                        for (String string2 : map.keySet()) {
                            if (!string2.startsWith(string) || arrayList2.contains(string2)) continue;
                            SpringBean springBean = map.get(string2);
                            SpringXMLConfigCompletionItem springXMLConfigCompletionItem = SpringXMLConfigCompletionItem.createBeanRefItem(completionContext.getCurrentToken().getOffset() + 1, string2, springBean, fileObject);
                            arrayList.add(springXMLConfigCompletionItem);
                        }
                    }

                    private Map<String, SpringBean> getName2Beans(List<SpringBean> list, boolean bl) {
                        HashMap<String, SpringBean> hashMap = new HashMap<String, SpringBean>();
                        for (SpringBean springBean : list) {
                            String string3 = springBean.getId();
                            if (string3 != null) {
                                hashMap.put(string3, springBean);
                            }
                            if (!bl) continue;
                            List<String> list2 = springBean.getNames();
                            for (String string2 : list2) {
                                hashMap.put(string2, springBean);
                            }
                        }
                        return hashMap;
                    }
                });
                this.setAnchorOffset(completionContext.getCurrentToken().getOffset() + 1);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributeValueCompletor
    extends Completor {
        private String[] itemTextAndDocs;

        public AttributeValueCompletor(String[] stringArray) {
            this.itemTextAndDocs = stringArray;
        }

        @Override
        public List<SpringXMLConfigCompletionItem> doCompletion(CompletionContext completionContext) {
            ArrayList<SpringXMLConfigCompletionItem> arrayList = new ArrayList<SpringXMLConfigCompletionItem>();
            int n = completionContext.getCaretOffset();
            String string = completionContext.getTypedPrefix();
            for (int i = 0; i < this.itemTextAndDocs.length; i += 2) {
                if (!this.itemTextAndDocs[i].startsWith(string)) continue;
                SpringXMLConfigCompletionItem springXMLConfigCompletionItem = SpringXMLConfigCompletionItem.createAttribValueItem(n - string.length(), this.itemTextAndDocs[i], this.itemTextAndDocs[i + 1]);
                arrayList.add(springXMLConfigCompletionItem);
            }
            this.setAnchorOffset(completionContext.getCurrentToken().getOffset() + 1);
            return arrayList;
        }
    }

    private static class BeansRefCompletorFactory
    implements CompletorFactory {
        private boolean includeGlobal;

        public BeansRefCompletorFactory(boolean bl) {
            this.includeGlobal = bl;
        }

        public Completor createCompletor() {
            return new BeansRefCompletor(this.includeGlobal);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GenericCompletorFactory
    implements CompletorFactory {
        private Class<? extends Completor> clazz;

        public GenericCompletorFactory(Class<? extends Completor> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Completor createCompletor() {
            try {
                return this.clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                Exceptions.printStackTrace((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Exceptions.printStackTrace((Throwable)illegalAccessException);
            }
            return null;
        }
    }

    private static class AttributeValueCompletorFactory
    implements CompletorFactory {
        private String[] itemTextAndDocs;

        public AttributeValueCompletorFactory(String[] stringArray) {
            this.itemTextAndDocs = stringArray;
        }

        public Completor createCompletor() {
            return new AttributeValueCompletor(this.itemTextAndDocs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Completor {
        private int anchorOffset = -1;

        private Completor() {
        }

        public abstract List<SpringXMLConfigCompletionItem> doCompletion(CompletionContext var1);

        protected void setAnchorOffset(int n) {
            this.anchorOffset = n;
        }

        public int getAnchorOffset() {
            return this.anchorOffset;
        }
    }

    private static interface CompletorFactory {
        public Completor createCompletor();
    }
}

