/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.ExceptionStr;
import org.netbeans.modules.cnd.modelutil.ParamStr;

public abstract class CsmPaintComponent
extends JPanel {
    protected DrawState drawState = new DrawState();
    protected Font drawFont;
    private static final int ICON_WIDTH = 16;
    private static final int ICON_TEXT_GAP = 5;
    private int fontHeight;
    private int ascent;
    private Map widths;
    private FontMetrics fontMetrics;
    protected boolean isSelected;
    private ArrayList<PostfixString> postfixes;
    private static final String THROWS = " throws ";
    private static final String[] frequentWords = new String[]{"", " ", "[]", "(", ")", ", ", "String", " throws "};
    private static final Color KEYWORD_COLOR = Color.darkGray;
    private static final Color TYPE_COLOR = Color.black;
    private static final Color POSTFIX_COLOR = Color.gray;
    private Icon icon;
    protected int modifiers = 0;
    private static Border BORDER = BorderFactory.createEmptyBorder(0, 3, 0, 3);
    private static LayoutManager layout = new FlowLayout();

    public CsmPaintComponent() {
        super(layout, true);
        this.setBorder(BORDER);
        this.postfixes = new ArrayList();
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    protected boolean isSelected() {
        return this.isSelected;
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        Rectangle rectangle = graphics.getClipBounds();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.draw(graphics);
        if (!this.postfixes.isEmpty()) {
            this.drawString(graphics, (CharSequence)" (", POSTFIX_COLOR);
            Iterator<PostfixString> iterator = this.postfixes.iterator();
            while (iterator.hasNext()) {
                iterator.next().Draw(graphics);
                if (!iterator.hasNext()) continue;
                this.drawString(graphics, (CharSequence)",  ", POSTFIX_COLOR);
            }
            this.drawString(graphics, (CharSequence)")", POSTFIX_COLOR);
        }
    }

    public void appendPostfix(String string, Color color, int n) {
        this.postfixes.add(new PostfixString(string, color, n));
    }

    public void removePostfixes() {
        this.postfixes.clear();
    }

    public boolean hasPostfixes() {
        return !this.postfixes.isEmpty();
    }

    protected abstract void draw(Graphics var1);

    public abstract String toString();

    protected void setIcon(Icon icon) {
        this.icon = icon;
    }

    protected Icon getIcon() {
        return this.icon;
    }

    protected void drawIcon(Graphics graphics, Icon icon) {
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawState.drawX = insets.left;
            this.drawState.drawY = insets.top;
        } else {
            this.drawState.drawX = 0;
            this.drawState.drawY = 0;
        }
        if (icon != null) {
            if (graphics != null) {
                icon.paintIcon(this, graphics, this.drawState.drawX, this.drawState.drawY);
            }
            this.drawState.drawHeight = Math.max(this.fontHeight, icon.getIconHeight());
        } else {
            this.drawState.drawHeight = this.fontHeight;
        }
        this.drawState.drawX += 21;
        if (insets != null) {
            this.drawState.drawHeight += insets.bottom;
        }
        this.drawState.drawHeight += this.drawState.drawY;
        this.drawState.drawY += this.ascent;
    }

    protected void drawString(Graphics graphics, CharSequence charSequence) {
        this.drawString(graphics, charSequence, false);
    }

    protected void drawString(Graphics graphics, CharSequence charSequence, boolean bl) {
        if (graphics != null) {
            graphics.setColor(this.getForeground());
        }
        this.drawStringToGraphics(graphics, charSequence, null, bl);
    }

    protected void drawString(Graphics graphics, CharSequence charSequence, Color color) {
        if (graphics != null) {
            graphics.setColor(this.getColor(charSequence, color));
        }
        this.drawStringToGraphics(graphics, charSequence);
    }

    protected void drawString(Graphics graphics, CharSequence charSequence, Color color, Font font, boolean bl) {
        if (graphics != null) {
            graphics.setColor(this.getColor(charSequence, color));
            graphics.setFont(font);
        }
        this.drawStringToGraphics(graphics, charSequence, font, bl);
        if (graphics != null) {
            graphics.setFont(this.drawFont);
        }
    }

    protected void drawTypeName(Graphics graphics, String string, Color color) {
        if (graphics == null) {
            this.drawString(graphics, "   ");
            this.drawString(graphics, (CharSequence)string, color);
        } else {
            int n;
            int n2 = this.getWidth() - this.getWidth(string) - this.drawState.drawX;
            if (n2 > (n = this.getWidth(" ")) * 2) {
                this.drawState.drawX = this.getWidth() - 2 * n - this.getWidth(string);
            } else {
                this.drawState.drawX = this.getWidth() - 2 * n - this.getWidth(string) - this.getWidth("...   ");
                graphics.setColor(this.getBackground());
                graphics.fillRect(this.drawState.drawX, 0, this.getWidth() - this.drawState.drawX, this.getHeight());
                this.drawString(graphics, (CharSequence)"...   ", color);
            }
            this.drawString(graphics, (CharSequence)string, color);
        }
    }

    protected void drawStringToGraphics(Graphics graphics, CharSequence charSequence) {
        this.drawStringToGraphics(graphics, charSequence, null, false);
    }

    protected void drawStringToGraphics(Graphics graphics, CharSequence charSequence, Font font, boolean bl) {
        String string;
        String string2 = string = charSequence != null ? ((Object)charSequence).toString() : "";
        if (graphics != null) {
            if (!bl) {
                graphics.drawString(string, this.drawState.drawX, this.drawState.drawY);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics;
                AttributedString attributedString = new AttributedString(string);
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                attributedString.addAttribute(TextAttribute.FONT, graphics.getFont());
                graphics2D.drawString(attributedString.getIterator(), this.drawState.drawX, this.drawState.drawY);
            }
        }
        this.drawState.drawX += this.getWidth(string, font);
    }

    protected int getWidth(String string) {
        Integer n = (Integer)this.widths.get(string);
        if (n != null) {
            return n;
        }
        return this.fontMetrics.stringWidth(string);
    }

    protected int getWidth(String string, Font font) {
        if (font == null) {
            return this.getWidth(string);
        }
        return this.getFontMetrics(font).stringWidth(string);
    }

    protected Color getColor(CharSequence charSequence, Color color) {
        return this.isSelected ? this.getForeground() : color;
    }

    private void storeWidth(String string) {
        this.fontMetrics.stringWidth(string);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        if (this.widths != null) {
            this.widths.clear();
        } else {
            this.widths = new HashMap();
        }
        for (int i = 0; i < frequentWords.length; ++i) {
            this.storeWidth(frequentWords[i]);
        }
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    protected Color getTypeColor(String string) {
        return CsmUtilities.isPrimitiveClassName(string) ? KEYWORD_COLOR : TYPE_COLOR;
    }

    public Dimension getPreferredSize() {
        this.draw(null);
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawState.drawX += insets.right;
        }
        if (this.drawState.drawX > this.getMaximumSize().width) {
            this.drawState.drawX = this.getMaximumSize().width;
        }
        return new Dimension(this.drawState.drawX, this.drawState.drawHeight);
    }

    public void setModifiers(int n) {
        this.modifiers = n;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    DrawState getDrawState() {
        return this.drawState;
    }

    void setDrawState(DrawState drawState) {
        this.drawState = drawState;
    }

    public static class StringPaintComponent
    extends CsmPaintComponent {
        private String str;

        public void setString(String string) {
            this.str = string;
        }

        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, null);
            this.drawString(graphics, (CharSequence)this.str, TYPE_COLOR);
        }

        public String toString() {
            return this.str;
        }
    }

    public static class CsmPaintComponentWrapper
    extends CsmPaintComponent {
        private CsmPaintComponent comp;
        private boolean drawTypeAsPrefix = true;

        public void setCsmComponent(CsmPaintComponent csmPaintComponent) {
            this.comp = csmPaintComponent;
        }

        protected void draw(Graphics graphics) {
            if (this.comp != null) {
                if (this.drawTypeAsPrefix) {
                    if (this.comp instanceof FieldPaintComponent) {
                        ((FieldPaintComponent)this.comp).setDrawTypeAsPrefix(true);
                    } else if (this.comp instanceof MethodPaintComponent) {
                        ((MethodPaintComponent)this.comp).setDrawTypeAsPrefix(true);
                    }
                }
                this.comp.draw(graphics);
                if (this.drawTypeAsPrefix) {
                    if (this.comp instanceof FieldPaintComponent) {
                        ((FieldPaintComponent)this.comp).setDrawTypeAsPrefix(false);
                    } else if (this.comp instanceof MethodPaintComponent) {
                        ((MethodPaintComponent)this.comp).setDrawTypeAsPrefix(false);
                    }
                }
                this.setDrawState(this.comp.getDrawState());
            }
        }

        public void setFont(Font font) {
            super.setFont(font);
            if (this.comp != null) {
                this.comp.setFont(font);
            }
        }

        public String toString() {
            if (this.comp != null) {
                return this.comp.toString();
            }
            return "";
        }
    }

    public static class GlobalFunctionPaintComponent
    extends MethodPaintComponent {
        private Color FUN_COLOR = Color.red.darker().darker();

        public Color getNameColor() {
            return this.FUN_COLOR;
        }
    }

    public static class FileLocalFunctionPaintComponent
    extends MethodPaintComponent {
        private Color FUN_COLOR = Color.red.darker().darker();

        public Color getNameColor() {
            return this.FUN_COLOR;
        }
    }

    public static class MethodPaintComponent
    extends ConstructorPaintComponent {
        private Color PARAMETER_NAME_COLOR = Color.magenta.darker();
        private Color METHOD_COLOR = Color.red.darker().darker();
        private String typeName;
        private Color typeColor;
        private boolean drawTypeAsPrefix = false;

        public Color getNameColor() {
            return this.METHOD_COLOR;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }

        public void setTypeName(String string) {
            this.typeName = string;
        }

        public void setTypeColor(Color color) {
            this.typeColor = color;
        }

        public void setDrawTypeAsPrefix(boolean bl) {
            this.drawTypeAsPrefix = bl;
        }

        protected void draw(Graphics graphics) {
            boolean bl = false;
            int n = CsmUtilities.getLevel(this.getModifiers());
            this.drawIcon(graphics, this.getIcon());
            if (this.drawTypeAsPrefix) {
                this.drawString(graphics, this.getTypeName(), this.getTypeColor(), null, bl);
                this.drawString(graphics, (CharSequence)" ", bl);
            }
            if ((this.getModifiers() & 0x100) != 0) {
                this.drawString(graphics, this.getName(), this.getNameColor(), new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), bl);
            } else {
                this.drawString(graphics, this.getName(), this.getNameColor(), null, bl);
            }
            this.drawParameterList(graphics, this.getParamList(), bl);
            if (!this.drawTypeAsPrefix) {
                this.drawTypeName(graphics, this.getTypeName(), this.getTypeColor());
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.drawTypeAsPrefix) {
                stringBuilder.append(this.getTypeName());
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.getName());
            stringBuilder.append(this.toStringParameterList(this.getParamList()));
            if (!this.drawTypeAsPrefix) {
                stringBuilder.append(' ');
                stringBuilder.append(this.getTypeName());
            }
            return stringBuilder.toString();
        }
    }

    public static class ConstructorPaintComponent
    extends CsmPaintComponent {
        private Color CONSTRUCTOR_COLOR = Color.orange.darker().darker();
        private Color PARAMETER_NAME_COLOR = Color.magenta.darker();
        private List params = new ArrayList();
        private List excs = new ArrayList();
        private String name;

        public int getMethodModifiers() {
            return this.modifiers;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setParams(List list) {
            this.params = list;
        }

        public void setExceptions(List list) {
            this.excs = list;
        }

        protected List getParamList() {
            return this.params;
        }

        protected List getExceptionList() {
            return this.excs;
        }

        protected void drawParameter(Graphics graphics, ParamStr paramStr) {
            this.drawParameter(graphics, paramStr, false);
        }

        protected void drawParameter(Graphics graphics, ParamStr paramStr, boolean bl) {
            this.drawString(graphics, paramStr.getSimpleTypeName(), paramStr.getTypeColor(), null, bl);
            String string = paramStr.getName();
            if (string != null && string.length() > 0) {
                this.drawString(graphics, (CharSequence)" ", bl);
                this.drawString(graphics, paramStr.getName(), this.PARAMETER_NAME_COLOR, null, bl);
            }
        }

        protected void drawParameterList(Graphics graphics, List list) {
            this.drawParameterList(graphics, list, false);
        }

        protected void drawParameterList(Graphics graphics, List list, boolean bl) {
            this.drawString(graphics, (CharSequence)"(", bl);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.drawParameter(graphics, (ParamStr)iterator.next(), bl);
                if (!iterator.hasNext()) continue;
                this.drawString(graphics, (CharSequence)", ", bl);
            }
            this.drawString(graphics, (CharSequence)")", bl);
        }

        protected void drawExceptions(Graphics graphics, List list, boolean bl) {
            if (list.size() > 0) {
                this.drawString(graphics, CsmPaintComponent.THROWS, KEYWORD_COLOR, null, bl);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ExceptionStr exceptionStr = (ExceptionStr)iterator.next();
                    this.drawString(graphics, exceptionStr.getName(), exceptionStr.getTypeColor(), null, bl);
                    if (!iterator.hasNext()) continue;
                    this.drawString(graphics, (CharSequence)", ", bl);
                }
            }
        }

        protected void draw(Graphics graphics) {
            boolean bl = false;
            int n = CsmUtilities.getLevel(this.getModifiers());
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, this.getName(), this.CONSTRUCTOR_COLOR, null, bl);
            this.drawParameterList(graphics, this.getParamList(), bl);
            this.drawExceptions(graphics, this.getExceptionList(), bl);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getName());
            stringBuilder.append(this.toStringParameterList(this.getParamList()));
            stringBuilder.append(this.toStringExceptions(this.getExceptionList()));
            return stringBuilder.toString();
        }

        protected String toStringParameter(ParamStr paramStr) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(paramStr.getSimpleTypeName());
            String string = paramStr.getName();
            if (string != null && string.length() > 0) {
                stringBuilder.append(' ');
                stringBuilder.append(paramStr.getName());
            }
            return stringBuilder.toString();
        }

        protected String toStringParameterList(List list) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('(');
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(this.toStringParameter((ParamStr)iterator.next()));
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }

        protected String toStringExceptions(List list) {
            StringBuilder stringBuilder = new StringBuilder();
            if (list.size() > 0) {
                stringBuilder.append(CsmPaintComponent.THROWS);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ExceptionStr exceptionStr = (ExceptionStr)iterator.next();
                    stringBuilder.append(exceptionStr.getName());
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
            }
            return stringBuilder.toString();
        }
    }

    public static class MacroPaintComponent
    extends CsmPaintComponent {
        private Color MACRO_NAME_COLOR = Color.green.darker().darker();
        private Color MACRO_PARAMETER_NAME_COLOR = Color.magenta.darker();
        private List params = null;
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setParams(List list) {
            this.params = list;
        }

        protected List getParamList() {
            return this.params;
        }

        protected void draw(Graphics graphics) {
            boolean bl = false;
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, this.getName(), this.MACRO_NAME_COLOR, null, bl);
            this.drawParameterList(graphics, this.getParamList(), bl);
        }

        protected void drawParameterList(Graphics graphics, List list, boolean bl) {
            if (list == null || list.size() == 0) {
                return;
            }
            this.drawString(graphics, (CharSequence)"(", bl);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.drawString(graphics, (CharSequence)iterator.next(), this.MACRO_PARAMETER_NAME_COLOR, null, bl);
                if (!iterator.hasNext()) continue;
                this.drawString(graphics, (CharSequence)", ", bl);
            }
            this.drawString(graphics, (CharSequence)")", bl);
        }

        protected String toStringParameterList(List list) {
            if (list == null || list.size() == 0) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('(');
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getName());
            stringBuilder.append(this.toStringParameterList(this.getParamList()));
            return stringBuilder.toString();
        }
    }

    public static class GlobalVariablePaintComponent
    extends FieldPaintComponent {
        private Color VARIABLE_COLOR = Color.blue.darker().darker().darker();

        public Color getNameColor() {
            return this.VARIABLE_COLOR;
        }
    }

    public static class FileLocalVariablePaintComponent
    extends FieldPaintComponent {
        private Color VARIABLE_COLOR = Color.blue.darker().darker().darker();

        public Color getNameColor() {
            return this.VARIABLE_COLOR;
        }
    }

    public static class LocalVariablePaintComponent
    extends FieldPaintComponent {
        private Color VARIABLE_COLOR = Color.red.darker().darker().darker();

        public LocalVariablePaintComponent() {
            this.modifiers |= 0x100 | this.modifiers;
        }

        public Color getNameColor() {
            return this.VARIABLE_COLOR;
        }

        public void setModifiers(int n) {
            super.setModifiers(n | 0x100);
        }
    }

    public static class FieldPaintComponent
    extends CsmPaintComponent {
        private Color FIELD_COLOR = Color.blue.darker();
        protected String typeName;
        protected Color typeColor;
        protected String fldName;
        private boolean drawTypeAsPrefix = false;

        public Color getNameColor() {
            return this.FIELD_COLOR;
        }

        public void setName(String string) {
            this.fldName = string;
        }

        public void setTypeColor(Color color) {
            this.typeColor = color;
        }

        public void setTypeName(String string) {
            this.typeName = string;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setDrawTypeAsPrefix(boolean bl) {
            this.drawTypeAsPrefix = bl;
        }

        protected void draw(Graphics graphics) {
            boolean bl = false;
            int n = CsmUtilities.getLevel(this.modifiers);
            this.drawIcon(graphics, this.getIcon());
            if (this.drawTypeAsPrefix) {
                this.drawString(graphics, this.getTypeName(), this.getTypeColor(), null, bl);
                this.drawString(graphics, (CharSequence)" ", bl);
            }
            if ((this.modifiers & 0x100) != 0) {
                this.drawString(graphics, this.fldName, this.getNameColor(), new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), bl);
            } else {
                this.drawString(graphics, this.fldName, this.getNameColor(), null, bl);
            }
            if (!this.drawTypeAsPrefix) {
                this.drawTypeName(graphics, this.getTypeName(), this.getTypeColor());
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.drawTypeAsPrefix) {
                stringBuilder.append(this.typeName);
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.fldName);
            if (!this.drawTypeAsPrefix) {
                stringBuilder.append(' ');
                stringBuilder.append(this.typeName);
            }
            return stringBuilder.toString();
        }
    }

    public static class UnionPaintComponent
    extends ClassPaintComponent {
        private Color UNION_COLOR = Color.red.darker();

        protected Color getColor() {
            return this.UNION_COLOR;
        }
    }

    public static class StructPaintComponent
    extends ClassPaintComponent {
        private Color STRUCT_COLOR = Color.red.darker().darker();

        protected Color getColor() {
            return this.STRUCT_COLOR;
        }
    }

    public static class TypedefPaintComponent
    extends CsmPaintComponent {
        String formatTypedefName;
        private Color TYPEDEF_COLOR = Color.blue.darker().darker().darker();
        private boolean displayFQN;

        public void setFormatTypedefName(String string) {
            this.formatTypedefName = string;
        }

        protected Color getColor() {
            return this.TYPEDEF_COLOR;
        }

        protected void draw(Graphics graphics) {
            boolean bl = false;
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, this.formatTypedefName, this.getColor(), null, bl);
        }

        public String toString() {
            return this.formatTypedefName;
        }
    }

    public static class ClassPaintComponent
    extends CsmPaintComponent {
        String formatClassName;
        private Color CLASS_COLOR = Color.red.darker().darker().darker();
        private boolean displayFQN;

        public void setFormatClassName(String string) {
            this.formatClassName = string;
        }

        protected Color getColor() {
            return this.CLASS_COLOR;
        }

        protected void draw(Graphics graphics) {
            boolean bl = false;
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, this.formatClassName, this.getColor(), null, bl);
        }

        public String toString() {
            return this.formatClassName;
        }
    }

    public static class EnumeratorPaintComponent
    extends CsmPaintComponent {
        String formatEnumeratorName;
        private Color ENUMERATOR_COLOR = Color.blue.darker().darker().darker().darker();
        private boolean displayFQN;

        public void EnumeratorPaintComponent(String string) {
            this.formatEnumeratorName = string;
        }

        protected Color getColor() {
            return this.ENUMERATOR_COLOR;
        }

        protected void draw(Graphics graphics) {
            boolean bl = false;
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, this.formatEnumeratorName, this.getColor(), null, bl);
        }

        public void setFormatEnumeratorName(String string) {
            assert (string != null);
            this.formatEnumeratorName = string;
        }

        public String toString() {
            return this.formatEnumeratorName;
        }
    }

    public static class EnumPaintComponent
    extends CsmPaintComponent {
        String formatEnumName;
        private Color ENUM_COLOR = Color.red.darker().darker().darker().darker();
        private boolean displayFQN;

        public void EnumPaintComponent(String string) {
            this.formatEnumName = string;
        }

        protected Color getColor() {
            return this.ENUM_COLOR;
        }

        protected void draw(Graphics graphics) {
            boolean bl = false;
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, this.formatEnumName, this.getColor(), null, bl);
        }

        public void setFormatEnumName(String string) {
            this.formatEnumName = string;
        }

        public String toString() {
            return this.formatEnumName;
        }
    }

    public static class NamespaceAliasPaintComponent
    extends CsmPaintComponent {
        private String aliasName;
        private Color NAMESPACE_COLOR = Color.green.darker().darker().darker();

        public void setAliasName(String string) {
            this.aliasName = string;
        }

        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, (CharSequence)this.aliasName, this.NAMESPACE_COLOR);
        }

        public String toString() {
            return this.aliasName;
        }
    }

    public static class NamespacePaintComponent
    extends CsmPaintComponent {
        private String pkgName;
        private boolean displayFullNamespacePath;
        private Color NAMESPACE_COLOR = Color.green.darker().darker().darker();

        public void setNamespaceName(String string) {
            this.pkgName = string;
        }

        public void setDisplayFullNamespacePath(boolean bl) {
            this.displayFullNamespacePath = bl;
        }

        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, this.getIcon());
            String string = this.pkgName;
            if (!this.displayFullNamespacePath) {
                string = string.substring(string.lastIndexOf(46) + 1);
            }
            this.drawString(graphics, (CharSequence)string, this.NAMESPACE_COLOR);
        }

        public String toString() {
            return this.pkgName;
        }
    }

    private class DrawState {
        int drawX = 0;
        int drawY = 0;
        int drawHeight = 0;
    }

    private class PostfixString {
        private String text;
        private Color c;
        private int fontStyle;

        public PostfixString(String string, Color color, int n) {
            this.text = string;
            this.c = color;
            this.fontStyle = n;
        }

        public PostfixString(String string, int n) {
            this(string, POSTFIX_COLOR, n);
        }

        void Draw(Graphics graphics) {
            CsmPaintComponent.this.drawString(graphics, this.text, this.c, new Font(CsmPaintComponent.this.getDrawFont().getName(), CsmPaintComponent.this.getDrawFont().getStyle() | this.fontStyle, CsmPaintComponent.this.getDrawFont().getSize()), false);
        }
    }
}

