/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmImageName;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.util.Utilities;

public class CsmImageLoader
implements CsmImageName {
    private static Map<String, ImageIcon> map = new HashMap<String, ImageIcon>();

    private CsmImageLoader() {
    }

    public static Image getImage(CsmObject csmObject) {
        String string = CsmImageLoader.getImagePath(csmObject);
        return Utilities.loadImage((String)string);
    }

    public static Image getFriendFunctionImage(CsmFriend csmFriend) {
        int n;
        String string = CsmKindUtilities.isFriendClass((CsmObject)csmFriend) ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/friend_class.png" : (((n = CsmUtilities.getModifiers((CsmObject)csmFriend)) & 0x40000) == 262144 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/friend_operator.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/friend_method.png");
        return Utilities.loadImage((String)string);
    }

    public static ImageIcon getProjectIcon(CsmProject csmProject, boolean bl) {
        String string = CsmImageLoader.getProjectPath(csmProject.isArtificial(), bl);
        return CsmImageLoader.getCachedImageIcon(string);
    }

    public static Image getProjectImage(boolean bl, boolean bl2) {
        String string = CsmImageLoader.getProjectPath(bl, bl2);
        return Utilities.loadImage((String)string);
    }

    private static String getProjectPath(boolean bl, boolean bl2) {
        String string = bl ? (bl2 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/libraries.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/libraries.png") : (bl2 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/project_open.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/project.png");
        return string;
    }

    public static ImageIcon getIcon(CsmObject csmObject) {
        String string = CsmImageLoader.getImagePath(csmObject);
        return CsmImageLoader.getCachedImageIcon(string);
    }

    public static ImageIcon getIcon(CsmDeclaration.Kind kind, int n) {
        String string = CsmImageLoader.getImagePath(kind, n);
        return CsmImageLoader.getCachedImageIcon(string);
    }

    public static ImageIcon getIncludeImageIcon(boolean bl, boolean bl2) {
        String string = bl2 ? (bl ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/include_sys_folder_16.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/include_usr_folder_16.png") : (bl ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/include_sys_16.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/include_user_16.png");
        return CsmImageLoader.getCachedImageIcon(string);
    }

    public static String getImagePath(CsmObject csmObject) {
        CsmDeclaration.Kind kind = CsmDeclaration.Kind.BUILT_IN;
        int n = CsmUtilities.getModifiers(csmObject);
        if (CsmKindUtilities.isEnumerator((CsmObject)csmObject)) {
            kind = CsmDeclaration.Kind.ENUM;
            n |= 0x400;
        } else {
            if (CsmKindUtilities.isUsingDirective((CsmObject)csmObject)) {
                return "org/netbeans/modules/cnd/modelutil/resources/types16x16/using_namespace_16.png";
            }
            if (CsmKindUtilities.isUsingDeclaration((CsmObject)csmObject)) {
                return "org/netbeans/modules/cnd/modelutil/resources/types16x16/using_declaration_16.png";
            }
            if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)csmObject)) {
                CsmClass csmClass = ((CsmClassForwardDeclaration)csmObject).getCsmClass();
                if (csmClass != null && csmClass.getKind() == CsmDeclaration.Kind.CLASS) {
                    return "org/netbeans/modules/cnd/modelutil/resources/types16x16/class_forward_decl.png";
                }
                return "org/netbeans/modules/cnd/modelutil/resources/types16x16/struct_forward_decl.png";
            }
            if (CsmKindUtilities.isDeclaration((CsmObject)csmObject)) {
                kind = ((CsmDeclaration)csmObject).getKind();
            } else if (CsmKindUtilities.isNamespace((CsmObject)csmObject)) {
                kind = CsmDeclaration.Kind.NAMESPACE_DEFINITION;
            } else if (CsmKindUtilities.isNamespaceAlias((CsmObject)csmObject)) {
                kind = CsmDeclaration.Kind.NAMESPACE_ALIAS;
            } else {
                if (CsmKindUtilities.isMacro((CsmObject)csmObject)) {
                    return "org/netbeans/modules/cnd/modelutil/resources/types16x16/code_macro_16.png";
                }
                if (CsmKindUtilities.isInclude((CsmObject)csmObject)) {
                    if (((CsmInclude)csmObject).isSystem()) {
                        return "org/netbeans/modules/cnd/modelutil/resources/types16x16/include_sys_16.png";
                    }
                    return "org/netbeans/modules/cnd/modelutil/resources/types16x16/include_user_16.png";
                }
                if (CsmKindUtilities.isProject((Object)csmObject)) {
                    return CsmImageLoader.getProjectPath(((CsmProject)csmObject).isArtificial(), false);
                }
            }
        }
        return CsmImageLoader.getImagePath(kind, n);
    }

    static String getImagePath(CsmDeclaration.Kind kind, int n) {
        String string = "org/openide/resources/defaultNode.gif";
        if (kind == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
            string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/namespace_16.png";
        } else if (kind == CsmDeclaration.Kind.NAMESPACE_ALIAS) {
            string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/namespace_alias.png";
        } else if (kind == CsmDeclaration.Kind.ENUM) {
            string = (n & 0x400) == 0 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/enumeration_16.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/enumeration_item_16.png";
        } else if (kind == CsmDeclaration.Kind.MACRO) {
            string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/code_macro_16.png";
        } else if (kind == CsmDeclaration.Kind.CLASS) {
            string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/class_16.png";
        } else if (kind == CsmDeclaration.Kind.STRUCT) {
            string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/struct_16.png";
        } else if (kind == CsmDeclaration.Kind.UNION) {
            string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/union_16.png";
        } else if (kind == CsmDeclaration.Kind.TYPEDEF) {
            string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/typedef_16.png";
        } else if (kind == CsmDeclaration.Kind.CLASS_FRIEND_DECLARATION) {
            string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/friend_class.png";
        } else if (kind == CsmDeclaration.Kind.VARIABLE || kind == CsmDeclaration.Kind.VARIABLE_DEFINITION) {
            boolean bl;
            boolean bl2 = (n & 0x2000) != 0;
            boolean bl3 = (n & 0x4000) != 0;
            boolean bl4 = !(bl2 | bl3);
            boolean bl5 = (n & 0x8000) != 0;
            boolean bl6 = (n & 8) != 0;
            boolean bl7 = (n & 0x200) != 0;
            boolean bl8 = bl = (n & 0x80000) != 0;
            if (bl4) {
                string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_variable.png";
                string = bl6 ? (bl7 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_constant.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_variable.png") : (bl7 ? (bl ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/extern_variable_16.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_constant.png") : (bl ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/extern_variable_16.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_variable.png"));
            }
            if (bl2) {
                string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/local_variable.png";
                string = bl6 ? (bl7 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/local_constant.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/local_variable.png") : (bl7 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/local_constant.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/local_variable.png");
            }
            if (bl3) {
                string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/local_variable.png";
                string = bl6 ? (bl7 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_constant.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_variable.png") : (bl7 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_constant.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_variable.png");
            }
            if (bl5) {
                int n2 = CsmUtilities.getLevel(n);
                string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/fields.png";
                if (bl6) {
                    switch (n2) {
                        case 0: {
                            string = bl7 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/const_static_private.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/fields_static_private.png";
                            break;
                        }
                        case 1: {
                            string = bl7 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/const_static_protected.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/fields_static_protected.png";
                            break;
                        }
                        case 2: {
                            string = bl7 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/const_static_public.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/fields_static.png";
                        }
                    }
                } else {
                    switch (n2) {
                        case 0: {
                            string = bl7 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/const_private.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/fields_private.png";
                            break;
                        }
                        case 1: {
                            string = bl7 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/const_protected.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/fields_protected.png";
                            break;
                        }
                        case 2: {
                            string = bl7 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/const_public.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/fields.png";
                        }
                    }
                }
            }
        } else if (kind == CsmDeclaration.Kind.FUNCTION || kind == CsmDeclaration.Kind.FUNCTION_DEFINITION) {
            boolean bl = (n & 0x8000) != 0;
            boolean bl9 = !bl;
            boolean bl10 = (n & 0x800) != 0;
            boolean bl11 = (n & 0x20000) != 0;
            boolean bl12 = (n & 0x40000) != 0;
            boolean bl13 = (n & 8) != 0;
            int n3 = CsmUtilities.getLevel(n);
            if (bl9) {
                string = bl12 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_operator.png" : (kind == CsmDeclaration.Kind.FUNCTION ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_function_decl.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_function.png");
                if (bl13) {
                    string = bl12 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_operator_static.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_function.png";
                }
            }
            if (bl) {
                string = bl12 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/operator_public.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/methods.png";
                if (bl13) {
                    switch (n3) {
                        case 0: {
                            if (bl12) {
                                string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/operator_static_privat.png";
                                break;
                            }
                            string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/methods_static_private.png";
                            break;
                        }
                        case 1: {
                            if (bl12) {
                                string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/operator_static_protected.png";
                                break;
                            }
                            string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/methods_static_protected.png";
                            break;
                        }
                        case 2: {
                            string = bl12 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/operator_static.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/methods_static.png";
                        }
                    }
                } else {
                    switch (n3) {
                        case 0: {
                            if (bl12) {
                                string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/operator_privat.png";
                                break;
                            }
                            string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/methods_private.png";
                            break;
                        }
                        case 1: {
                            if (bl12) {
                                string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/operator_protected.png";
                                break;
                            }
                            string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/methods_protected.png";
                            break;
                        }
                        case 2: {
                            string = bl12 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/operator_public.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/methods.png";
                        }
                    }
                }
            }
            if (bl10) {
                string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/constructors.png";
                switch (n3) {
                    case 0: {
                        string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/constructors_private.png";
                        break;
                    }
                    case 1: {
                        string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/constructors_protected.png";
                        break;
                    }
                    case 2: {
                        string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/constructors.png";
                    }
                }
            }
            if (bl11) {
                string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/deconstructors.png";
                switch (n3) {
                    case 0: {
                        string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/deconstructors_private.png";
                        break;
                    }
                    case 1: {
                        string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/deconstructors_protected.png";
                        break;
                    }
                    case 2: {
                        string = "org/netbeans/modules/cnd/modelutil/resources/types16x16/deconstructors.png";
                    }
                }
            }
        }
        return string;
    }

    private static ImageIcon getCachedImageIcon(String string) {
        ImageIcon imageIcon = map.get(string);
        if (imageIcon == null) {
            imageIcon = new ImageIcon(Utilities.loadImage((String)string));
            map.put(string, imageIcon);
        }
        return imageIcon;
    }
}

