/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.e2e.wsdl.wsdl2java;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.IndentEngine;

public class OutputFileFormatter {
    private FileObject fileObject;
    private DataObject dataObject;
    private StyledDocument styledDocument;
    private IndentEngine indentEngine;
    private Writer writer;
    private StringWriter stringWriter;

    public OutputFileFormatter(FileObject fileObject) throws Exception {
        this.fileObject = fileObject;
        this.dataObject = DataObject.find((FileObject)fileObject);
        EditorCookie editorCookie = (EditorCookie)this.dataObject.getCookie(EditorCookie.class);
        this.styledDocument = editorCookie.openDocument();
        this.styledDocument.remove(0, this.styledDocument.getLength());
        this.indentEngine = IndentEngine.find((Document)this.styledDocument);
        this.stringWriter = new StringWriter(4096);
        this.writer = this.indentEngine.createWriter((Document)this.styledDocument, 0, (Writer)this.stringWriter);
    }

    public void write(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
        }
    }

    public void close() {
        try {
            this.writer.flush();
            this.writer.close();
            this.styledDocument.insertString(0, this.stringWriter.getBuffer().toString(), null);
            SaveCookie saveCookie = (SaveCookie)this.dataObject.getCookie(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.SEVERE, exception.getMessage(), exception);
        }
    }
}

