/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.debugger.DebuggerManager;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class Properties {
    private static Properties defaultProperties;

    public static synchronized Properties getDefault() {
        if (defaultProperties == null) {
            defaultProperties = new PropertiesImpl();
        }
        return defaultProperties;
    }

    public abstract String getString(String var1, String var2);

    public abstract void setString(String var1, String var2);

    public abstract int getInt(String var1, int var2);

    public abstract void setInt(String var1, int var2);

    public abstract char getChar(String var1, char var2);

    public abstract void setChar(String var1, char var2);

    public abstract float getFloat(String var1, float var2);

    public abstract void setFloat(String var1, float var2);

    public abstract long getLong(String var1, long var2);

    public abstract void setLong(String var1, long var2);

    public abstract double getDouble(String var1, double var2);

    public abstract void setDouble(String var1, double var2);

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract void setBoolean(String var1, boolean var2);

    public abstract byte getByte(String var1, byte var2);

    public abstract void setByte(String var1, byte var2);

    public abstract short getShort(String var1, short var2);

    public abstract void setShort(String var1, short var2);

    public abstract Object getObject(String var1, Object var2);

    public abstract void setObject(String var1, Object var2);

    public abstract Object[] getArray(String var1, Object[] var2);

    public abstract void setArray(String var1, Object[] var2);

    public abstract Collection getCollection(String var1, Collection var2);

    public abstract void setCollection(String var1, Collection var2);

    public abstract Map getMap(String var1, Map var2);

    public abstract void setMap(String var1, Map var2);

    public abstract Properties getProperties(String var1);

    private static class DelegatingProperties
    extends Properties {
        private Properties delegatingProperties;
        private String root;

        DelegatingProperties(Properties properties, String string) {
            this.delegatingProperties = properties;
            this.root = string;
        }

        public String getString(String string, String string2) {
            return this.delegatingProperties.getString(this.root + '.' + string, string2);
        }

        public void setString(String string, String string2) {
            this.delegatingProperties.setString(this.root + '.' + string, string2);
        }

        public int getInt(String string, int n) {
            return this.delegatingProperties.getInt(this.root + '.' + string, n);
        }

        public void setInt(String string, int n) {
            this.delegatingProperties.setInt(this.root + '.' + string, n);
        }

        public byte getByte(String string, byte by) {
            return this.delegatingProperties.getByte(this.root + '.' + string, by);
        }

        public void setByte(String string, byte by) {
            this.delegatingProperties.setByte(this.root + '.' + string, by);
        }

        public char getChar(String string, char c) {
            return this.delegatingProperties.getChar(this.root + '.' + string, c);
        }

        public void setChar(String string, char c) {
            this.delegatingProperties.setChar(this.root + '.' + string, c);
        }

        public boolean getBoolean(String string, boolean bl) {
            return this.delegatingProperties.getBoolean(this.root + '.' + string, bl);
        }

        public void setBoolean(String string, boolean bl) {
            this.delegatingProperties.setBoolean(this.root + '.' + string, bl);
        }

        public short getShort(String string, short s) {
            return this.delegatingProperties.getShort(this.root + '.' + string, s);
        }

        public void setShort(String string, short s) {
            this.delegatingProperties.setShort(this.root + '.' + string, s);
        }

        public long getLong(String string, long l) {
            return this.delegatingProperties.getLong(this.root + '.' + string, l);
        }

        public void setLong(String string, long l) {
            this.delegatingProperties.setLong(this.root + '.' + string, l);
        }

        public double getDouble(String string, double d) {
            return this.delegatingProperties.getDouble(this.root + '.' + string, d);
        }

        public void setDouble(String string, double d) {
            this.delegatingProperties.setDouble(this.root + '.' + string, d);
        }

        public float getFloat(String string, float f) {
            return this.delegatingProperties.getFloat(this.root + '.' + string, f);
        }

        public void setFloat(String string, float f) {
            this.delegatingProperties.setFloat(this.root + '.' + string, f);
        }

        public Object getObject(String string, Object object) {
            return this.delegatingProperties.getObject(this.root + '.' + string, object);
        }

        public void setObject(String string, Object object) {
            this.delegatingProperties.setObject(this.root + '.' + string, object);
        }

        public Object[] getArray(String string, Object[] objectArray) {
            return this.delegatingProperties.getArray(this.root + '.' + string, objectArray);
        }

        public void setArray(String string, Object[] objectArray) {
            this.delegatingProperties.setArray(this.root + '.' + string, objectArray);
        }

        public Collection getCollection(String string, Collection collection) {
            return this.delegatingProperties.getCollection(this.root + '.' + string, collection);
        }

        public void setCollection(String string, Collection collection) {
            this.delegatingProperties.setCollection(this.root + '.' + string, collection);
        }

        public Map getMap(String string, Map map) {
            return this.delegatingProperties.getMap(this.root + '.' + string, map);
        }

        public void setMap(String string, Map map) {
            this.delegatingProperties.setMap(this.root + '.' + string, map);
        }

        public Properties getProperties(String string) {
            return new DelegatingProperties(this.delegatingProperties, this.root + '.' + string);
        }
    }

    static class PropertiesImpl
    extends Properties {
        private static final Object BAD_OBJECT = new Object();
        private static final String BAD_STRING = "";
        private static final Map BAD_MAP = new HashMap();
        private static final Collection BAD_COLLECTION = new ArrayList();
        private static final Object[] BAD_ARRAY = new Object[0];
        private List<? extends Reader> readersList;
        private HashMap<String, Reader> register;
        private PrimitiveRegister impl = new PrimitiveRegister();
        private static ClassLoader classLoader;

        PropertiesImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initReaders() {
            this.register = new HashMap();
            List<? extends Reader> list = this.readersList = DebuggerManager.getDebuggerManager().lookup(null, Reader.class);
            synchronized (list) {
                for (Reader reader : this.readersList) {
                    this.registerReader(reader);
                }
            }
            ((Customizer)((Object)this.readersList)).addPropertyChangeListener(new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PropertiesImpl propertiesImpl = PropertiesImpl.this;
                    synchronized (propertiesImpl) {
                        HashSet hashSet = new HashSet(PropertiesImpl.this.register.values());
                        List list = PropertiesImpl.this.readersList;
                        synchronized (list) {
                            for (Reader reader : PropertiesImpl.this.readersList) {
                                if (hashSet.remove(reader)) continue;
                                PropertiesImpl.this.registerReader(reader);
                            }
                        }
                        for (Object object : hashSet) {
                            PropertiesImpl.this.unregisterReader((Reader)object);
                        }
                    }
                }
            });
            ((Customizer)((Object)this.readersList)).setObject("load first");
            ((Customizer)((Object)this.readersList)).setObject("unload last");
        }

        private void registerReader(Reader reader) {
            String[] stringArray = reader.getSupportedClassNames();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.register.put(stringArray[i], reader);
            }
        }

        private void unregisterReader(Reader reader) {
            String[] stringArray = reader.getSupportedClassNames();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.register.remove(stringArray[i]);
            }
        }

        synchronized void addReader(Reader reader) {
            if (this.register == null) {
                this.initReaders();
            }
            this.registerReader(reader);
        }

        private synchronized Reader findReader(String string) {
            Reader reader;
            if (this.register == null) {
                this.initReaders();
            }
            if ((reader = this.register.get(string)) != null) {
                return reader;
            }
            Class<?> clazz = null;
            try {
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)classNotFoundException);
                return null;
            }
            for (clazz = PropertiesImpl.getClassLoader().loadClass(string); clazz != null && this.register.get(clazz.getName()) == null; clazz = clazz.getSuperclass()) {
            }
            if (clazz != null) {
                reader = this.register.get(clazz.getName());
            }
            return reader;
        }

        public String getString(String string, String string2) {
            String string3 = this.impl.getProperty(string, null);
            if (string3 == null) {
                return string2;
            }
            if (!string3.startsWith("\"")) {
                ErrorManager.getDefault().log("Can not read string " + string3 + ".");
                return string2;
            }
            return string3.substring(1, string3.length() - 1);
        }

        public void setString(String string, String string2) {
            if (string2 != null) {
                this.impl.setProperty(string, "\"" + string2 + "\"");
            } else {
                this.impl.setProperty(string, string2);
            }
        }

        public int getInt(String string, int n) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return n;
            }
            try {
                int n2 = Integer.parseInt(string2);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }

        public void setInt(String string, int n) {
            this.impl.setProperty(string, Integer.toString(n));
        }

        public char getChar(String string, char c) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return c;
            }
            char c2 = string2.charAt(0);
            return c2;
        }

        public void setChar(String string, char c) {
            this.impl.setProperty(string, Character.toString(c));
        }

        public float getFloat(String string, float f) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return f;
            }
            try {
                float f2 = Float.parseFloat(string2);
                return f2;
            }
            catch (NumberFormatException numberFormatException) {
                return f;
            }
        }

        public void setFloat(String string, float f) {
            this.impl.setProperty(string, Float.toString(f));
        }

        public long getLong(String string, long l) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return l;
            }
            try {
                long l2 = Long.parseLong(string2);
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                return l;
            }
        }

        public void setLong(String string, long l) {
            this.impl.setProperty(string, Long.toString(l));
        }

        public double getDouble(String string, double d) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return d;
            }
            try {
                double d2 = Double.parseDouble(string2);
                return d2;
            }
            catch (NumberFormatException numberFormatException) {
                return d;
            }
        }

        public void setDouble(String string, double d) {
            this.impl.setProperty(string, Double.toString(d));
        }

        public boolean getBoolean(String string, boolean bl) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return bl;
            }
            boolean bl2 = string2.equals("true");
            return bl2;
        }

        public void setBoolean(String string, boolean bl) {
            this.impl.setProperty(string, bl ? "true" : "false");
        }

        public byte getByte(String string, byte by) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return by;
            }
            try {
                byte by2 = Byte.parseByte(string2);
                return by2;
            }
            catch (NumberFormatException numberFormatException) {
                return by;
            }
        }

        public void setByte(String string, byte by) {
            this.impl.setProperty(string, Byte.toString(by));
        }

        public short getShort(String string, short s) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return s;
            }
            try {
                short s2 = Short.parseShort(string2);
                return s2;
            }
            catch (NumberFormatException numberFormatException) {
                return s;
            }
        }

        public void setShort(String string, short s) {
            this.impl.setProperty(string, Short.toString(s));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObject(String string, Object object) {
            PrimitiveRegister primitiveRegister = this.impl;
            synchronized (primitiveRegister) {
                Reader reader;
                String string2 = this.impl.getProperty(string, null);
                if (string2 == null) {
                    return object;
                }
                if (string2.equals("# null")) {
                    return null;
                }
                if (!string2.startsWith("# ")) {
                    if (string2.startsWith("\"")) {
                        String string3 = this.getString(string, BAD_STRING);
                        if (string3 == BAD_STRING) {
                            return object;
                        }
                        return string3;
                    }
                    ErrorManager.getDefault().log("Can not read object " + string2 + ". No reader registered for type " + string2 + ".");
                    return object;
                }
                string2 = string2.substring(2);
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz != null) {
                    if (Map.class.isAssignableFrom(clazz)) {
                        Map map = this.getMap(string, BAD_MAP);
                        if (map == BAD_MAP) {
                            return object;
                        }
                        return map;
                    }
                    if (Object[].class.isAssignableFrom(clazz)) {
                        Object[] objectArray = this.getArray(string, BAD_ARRAY);
                        if (objectArray == BAD_ARRAY) {
                            return object;
                        }
                        return objectArray;
                    }
                    if (Collection.class.isAssignableFrom(clazz)) {
                        Collection collection = this.getCollection(string, BAD_COLLECTION);
                        if (collection == BAD_COLLECTION) {
                            return object;
                        }
                        return collection;
                    }
                }
                if ((reader = this.findReader(string2)) == null) {
                    ErrorManager.getDefault().log("Can not read object. No reader registered for type " + string2 + ".");
                    return object;
                }
                return reader.read(string2, this.getProperties(string));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setObject(String string, Object object) {
            PrimitiveRegister primitiveRegister = this.impl;
            synchronized (primitiveRegister) {
                if (object == null) {
                    this.impl.setProperty(string, "# null");
                    return;
                }
                if (object instanceof String) {
                    this.setString(string, (String)object);
                    return;
                }
                if (object instanceof Map) {
                    this.setMap(string, (Map)object);
                    return;
                }
                if (object instanceof Collection) {
                    this.setCollection(string, (Collection)object);
                    return;
                }
                if (object instanceof Object[]) {
                    this.setArray(string, (Object[])object);
                    return;
                }
                Reader reader = this.findReader(object.getClass().getName());
                if (reader == null) {
                    ErrorManager.getDefault().log("Can not write object " + object);
                    return;
                }
                reader.write(object, this.getProperties(string));
                this.impl.setProperty(string, "# " + object.getClass().getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getArray(String string, Object[] objectArray) {
            PrimitiveRegister primitiveRegister = this.impl;
            synchronized (primitiveRegister) {
                String string2 = this.impl.getProperty(string + ".array_type", null);
                if (string2 == null) {
                    ErrorManager.getDefault().log("Unknown array type for " + string);
                    return objectArray;
                }
                Properties properties = this.getProperties(string);
                int n = properties.getInt("length", -1);
                if (n < 0) {
                    return objectArray;
                }
                Object[] objectArray2 = null;
                try {
                    objectArray2 = (Object[])Array.newInstance(PropertiesImpl.getClassLoader().loadClass(string2), n);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager.getDefault().notify((Throwable)classNotFoundException);
                    objectArray2 = new Object[n];
                }
                for (int i = 0; i < n; ++i) {
                    Object object = properties.getObject(BAD_STRING + i, BAD_OBJECT);
                    if (object == BAD_OBJECT) {
                        return objectArray;
                    }
                    objectArray2[i] = object;
                }
                return objectArray2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setArray(String string, Object[] objectArray) {
            PrimitiveRegister primitiveRegister = this.impl;
            synchronized (primitiveRegister) {
                this.impl.setProperty(string, "# array");
                this.impl.setProperty(string + ".array_type", objectArray.getClass().getComponentType().getName());
                Properties properties = this.getProperties(string);
                int n = objectArray.length;
                properties.setInt("length", n);
                for (int i = 0; i < n; ++i) {
                    properties.setObject(BAD_STRING + i, objectArray[i]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getCollection(String string, Collection collection) {
            PrimitiveRegister primitiveRegister = this.impl;
            synchronized (primitiveRegister) {
                String string2 = this.impl.getProperty(string, null);
                if (string2 == null) {
                    return collection;
                }
                if (!string2.startsWith("# ")) {
                    return collection;
                }
                Collection collection2 = null;
                try {
                    collection2 = (Collection)Class.forName(string2.substring(2)).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println(classNotFoundException.getLocalizedMessage());
                    ErrorManager.getDefault().log(classNotFoundException.getLocalizedMessage());
                    ErrorManager.getDefault().notify((Throwable)classNotFoundException);
                    return collection;
                }
                catch (InstantiationException instantiationException) {
                    System.err.println(instantiationException.getLocalizedMessage());
                    ErrorManager.getDefault().log(instantiationException.getLocalizedMessage());
                    ErrorManager.getDefault().notify((Throwable)instantiationException);
                    return collection;
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println(illegalAccessException.getLocalizedMessage());
                    ErrorManager.getDefault().log(illegalAccessException.getLocalizedMessage());
                    ErrorManager.getDefault().notify((Throwable)illegalAccessException);
                    return collection;
                }
                Properties properties = this.getProperties(string);
                int n = properties.getInt("length", 0);
                for (int i = 0; i < n; ++i) {
                    Object object = properties.getObject(BAD_STRING + i, BAD_OBJECT);
                    if (object == BAD_OBJECT) {
                        return collection;
                    }
                    collection2.add(object);
                }
                return collection2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCollection(String string, Collection collection) {
            PrimitiveRegister primitiveRegister = this.impl;
            synchronized (primitiveRegister) {
                if (collection == null) {
                    this.impl.setProperty(string, null);
                }
                this.impl.setProperty(string, "# " + collection.getClass().getName());
                Properties properties = this.getProperties(string);
                Iterator iterator = collection.iterator();
                int n = 0;
                properties.setInt("length", collection.size());
                while (iterator.hasNext()) {
                    properties.setObject(BAD_STRING + n, iterator.next());
                    ++n;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map getMap(String string, Map map) {
            PrimitiveRegister primitiveRegister = this.impl;
            synchronized (primitiveRegister) {
                String string2 = this.impl.getProperty(string, null);
                if (string2 == null) {
                    return map;
                }
                if (!string2.startsWith("# ")) {
                    return map;
                }
                Map map2 = null;
                try {
                    map2 = (Map)Class.forName(string2.substring(2)).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager.getDefault().log(classNotFoundException.getLocalizedMessage());
                    return map;
                }
                catch (InstantiationException instantiationException) {
                    ErrorManager.getDefault().log(instantiationException.getLocalizedMessage());
                    return map;
                }
                catch (IllegalAccessException illegalAccessException) {
                    ErrorManager.getDefault().log(illegalAccessException.getLocalizedMessage());
                    return map;
                }
                Properties properties = this.getProperties(string);
                int n = properties.getInt("length", 0);
                for (int i = 0; i < n; ++i) {
                    Object object = properties.getObject(BAD_STRING + i + "-key", BAD_OBJECT);
                    if (object == BAD_OBJECT) {
                        return map;
                    }
                    Object object2 = properties.getObject(BAD_STRING + i + "-value", BAD_OBJECT);
                    if (object2 == BAD_OBJECT) {
                        return map;
                    }
                    map2.put(object, object2);
                }
                return map2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMap(String string, Map map) {
            PrimitiveRegister primitiveRegister = this.impl;
            synchronized (primitiveRegister) {
                if (map == null) {
                    this.impl.setProperty(string, null);
                }
                this.impl.setProperty(string, "# " + map.getClass().getName());
                Properties properties = this.getProperties(string);
                Iterator iterator = map.keySet().iterator();
                int n = 0;
                properties.setInt("length", map.size());
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    properties.setObject(BAD_STRING + n + "-key", k);
                    properties.setObject(BAD_STRING + n + "-value", map.get(k));
                    ++n;
                }
            }
        }

        public Properties getProperties(String string) {
            return new DelegatingProperties(this, string);
        }

        private static ClassLoader getClassLoader() {
            if (classLoader == null) {
                classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            }
            return classLoader;
        }
    }

    private static final class PrimitiveRegister {
        private HashMap properties = new HashMap();
        private boolean isInitialized = false;
        private RequestProcessor.Task task;

        private PrimitiveRegister() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getProperty(String string, String string2) {
            PrimitiveRegister primitiveRegister = this;
            synchronized (primitiveRegister) {
                String string3;
                if (!this.isInitialized) {
                    this.load();
                    this.isInitialized = true;
                }
                if ((string3 = (String)this.properties.get(string)) != null) {
                    return string3;
                }
            }
            return string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setProperty(String string, String string2) {
            PrimitiveRegister primitiveRegister = this;
            synchronized (primitiveRegister) {
                if (!this.isInitialized) {
                    this.load();
                    this.isInitialized = true;
                }
                this.properties.put(string, string2);
            }
            this.save();
        }

        private synchronized void load() {
            BufferedReader bufferedReader = null;
            try {
                FileObject fileObject = PrimitiveRegister.findSettings();
                InputStream inputStream = fileObject.getInputStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                while (string != null) {
                    int n = string.indexOf(58);
                    if (n > 0) {
                        this.properties.put(string.substring(0, n), string.substring(n + 1));
                    }
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }

        private synchronized void save() {
            if (this.task == null) {
                this.task = new RequestProcessor("Debugger Properties Save RP", 1).create(new Runnable(){

                    public void run() {
                        PrimitiveRegister.this.saveIn();
                    }
                });
            }
            this.task.schedule(4000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void saveIn() {
            PrintWriter printWriter = null;
            FileLock fileLock = null;
            try {
                FileObject fileObject = PrimitiveRegister.findSettings();
                fileLock = fileObject.lock();
                OutputStream outputStream = fileObject.getOutputStream(fileLock);
                printWriter = new PrintWriter(outputStream);
                Set set = this.properties.keySet();
                ArrayList arrayList = new ArrayList(set);
                Collections.sort(arrayList);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    String string = (String)arrayList.get(i);
                    Object v = this.properties.get(string);
                    if (v == null) continue;
                    printWriter.println("" + string + ":" + v);
                }
                printWriter.flush();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)iOException, "Can not save debugger settings."));
            }
            finally {
                try {
                    if (printWriter != null) {
                        printWriter.close();
                    }
                }
                finally {
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        }

        private static FileObject findSettings() throws IOException {
            FileObject fileObject;
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject2 = fileSystem.findResource("Services");
            if (fileObject2 == null) {
                fileObject2 = fileSystem.getRoot().createFolder("Services");
            }
            if ((fileObject = fileObject2.getFileObject("org-netbeans-modules-debugger-Settings", "properties")) == null) {
                fileObject = fileObject2.createData("org-netbeans-modules-debugger-Settings", "properties");
            }
            return fileObject;
        }
    }

    public static interface Reader {
        public String[] getSupportedClassNames();

        public Object read(String var1, Properties var2);

        public void write(Object var1, Properties var2);
    }
}

