/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.freeform;

import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.netbeans.api.project.Project;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Util {
    private static final String PARSE_ERROR_MSG = NbBundle.getMessage((Class)Util.class, (String)"Util_ParseErrorMsg");
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.profiler.freeform");

    private Util() {
    }

    public static String getAntScriptName(FileObject fileObject) {
        AntProjectCookie antProjectCookie = Util.getAntProjectCookie(fileObject);
        if (antProjectCookie == null) {
            return null;
        }
        Element element = antProjectCookie.getProjectElement();
        if (element == null) {
            return null;
        }
        String string = element.getAttribute("name");
        return string.length() > 0 ? string : null;
    }

    public static Element getAntScriptTarget(FileObject fileObject, String string) {
        Set set;
        if (fileObject == null) {
            throw new IllegalArgumentException("Cannot call Util.getAntScriptTargetNames with null");
        }
        AntProjectCookie antProjectCookie = Util.getAntProjectCookie(fileObject);
        if (antProjectCookie == null) {
            return null;
        }
        try {
            set = TargetLister.getTargets((AntProjectCookie)antProjectCookie);
        }
        catch (IOException iOException) {
            err.notify(1, (Throwable)iOException);
            return null;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TargetLister.Target target = (TargetLister.Target)iterator.next();
            if (target.isOverridden() || target.isInternal() || !string.equals(target.getName())) continue;
            return target.getElement();
        }
        return null;
    }

    public static List getAntScriptTargetNames(FileObject fileObject) {
        List list = Util.getAntScriptTargets(fileObject);
        TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            treeSet.add(((TargetLister.Target)iterator.next()).getName());
        }
        return new ArrayList<Object>(treeSet);
    }

    public static List getAntScriptTargets(FileObject fileObject) {
        Set set;
        if (fileObject == null) {
            throw new IllegalArgumentException("Cannot call Util.getAntScriptTargetNames with null");
        }
        AntProjectCookie antProjectCookie = Util.getAntProjectCookie(fileObject);
        if (antProjectCookie == null) {
            return null;
        }
        try {
            set = TargetLister.getTargets((AntProjectCookie)antProjectCookie);
        }
        catch (IOException iOException) {
            err.notify(1, (Throwable)iOException);
            return null;
        }
        ArrayList<TargetLister.Target> arrayList = new ArrayList<TargetLister.Target>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TargetLister.Target target = (TargetLister.Target)iterator.next();
            if (target.isOverridden() || target.isInternal()) continue;
            arrayList.add(target);
        }
        return arrayList;
    }

    public static FileObject getProjectBuildScript(Project project) {
        return org.netbeans.modules.ant.freeform.spi.support.Util.getDefaultAntScript((Project)project);
    }

    private static AntProjectCookie getAntProjectCookie(FileObject fileObject) {
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            err.notify(1, (Throwable)dataObjectNotFoundException);
            return null;
        }
        AntProjectCookie antProjectCookie = (AntProjectCookie)dataObject.getCookie(AntProjectCookie.class);
        if (antProjectCookie == null && fileObject.getMIMEType().equals("text/xml")) {
            try {
                antProjectCookie = Util.forceParse(fileObject);
            }
            catch (IOException iOException) {
                err.notify(1, (Throwable)iOException);
            }
            catch (SAXException sAXException) {
                err.log(MessageFormat.format(PARSE_ERROR_MSG, fileObject, sAXException));
            }
        }
        return antProjectCookie;
    }

    private static AntProjectCookie forceParse(FileObject fileObject) throws IOException, SAXException {
        Document document = XMLUtil.parse((InputSource)new InputSource(fileObject.getURL().toExternalForm()), (boolean)false, (boolean)true, (ErrorHandler)new ErrH(), null);
        return new TrivialAntProjectCookie(fileObject, document);
    }

    private static final class TrivialAntProjectCookie
    implements AntProjectCookie.ParseStatus {
        private final Document doc;
        private final FileObject fo;

        public TrivialAntProjectCookie(FileObject fileObject, Document document) {
            this.fo = fileObject;
            this.doc = document;
        }

        public Document getDocument() {
            return this.doc;
        }

        public File getFile() {
            return FileUtil.toFile((FileObject)this.fo);
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public Throwable getParseException() {
            return null;
        }

        public boolean isParsed() {
            return true;
        }

        public Element getProjectElement() {
            return this.doc.getDocumentElement();
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    private static final class ErrH
    implements ErrorHandler {
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }
    }
}

