/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.guards;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.java.guards.GuardTag;
import org.netbeans.modules.java.guards.JavaGuardedSectionsProvider;
import org.netbeans.modules.java.guards.SectionDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JavaGuardedReader {
    static final String MAGIC_PREFIX = "//GEN-";
    Pattern magicsAsRE;
    private static final int LONGEST_ITEM = 10;
    private final LinkedList<SectionDescriptor> list = new LinkedList();
    private final JavaGuardedSectionsProvider provider;

    public JavaGuardedReader(JavaGuardedSectionsProvider javaGuardedSectionsProvider) {
        this.provider = javaGuardedSectionsProvider;
    }

    public List<GuardedSection> getGuardedSections() {
        return this.fillSections(this.list);
    }

    public char[] translateToCharBuff(char[] cArray) {
        Object object;
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        int n2 = cArray.length - 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = MAGIC_PREFIX.length();
        while (n3 < n2) {
            int n7;
            CharBuffer charBuffer;
            char c = cArray[n3];
            if (c == '\n') {
                n4 = n;
            }
            cArray2[n++] = cArray[n3++];
            switch (n5) {
                case 0: {
                    if (c == '/') {
                        ++n5;
                        break;
                    }
                    n5 = 0;
                    break;
                }
                case 1: {
                    if (c == '/') {
                        ++n5;
                        break;
                    }
                    n5 = 0;
                    break;
                }
                case 2: {
                    if (c == 'G') {
                        ++n5;
                        break;
                    }
                    if (c == '/') {
                        n5 = 2;
                        break;
                    }
                    n5 = 0;
                    break;
                }
                case 3: {
                    if (c == 'E') {
                        ++n5;
                        break;
                    }
                    n5 = 0;
                    break;
                }
                case 4: {
                    if (c == 'N') {
                        ++n5;
                        break;
                    }
                    n5 = 0;
                    break;
                }
                case 5: {
                    if (c == '-') {
                        ++n5;
                        break;
                    }
                    n5 = 0;
                    break;
                }
                default: {
                    n5 = 0;
                }
            }
            if (n5 != n6) continue;
            n5 = 0;
            object = this.getMagicsAsRE();
            Matcher matcher = ((Pattern)object).matcher(charBuffer = CharBuffer.wrap(cArray, n3, n7 = Math.min(10, cArray.length - n3)));
            if (!matcher.find()) continue;
            String string = matcher.group();
            int n8 = JavaGuardedReader.toNewLine(n3 += string.length(), cArray);
            int n9 = n6 + string.length() + n8;
            SectionDescriptor sectionDescriptor = new SectionDescriptor(GuardTag.valueOf(string.substring(0, string.length() - 1)), String.valueOf(cArray, n3, n8), n4 + 1, (n -= n6) + n9);
            this.list.add(sectionDescriptor);
            n3 += n8;
            Arrays.fill(cArray2, n, n + n9, ' ');
            n += n9;
        }
        if (n3 == n2) {
            cArray2[n++] = cArray[n3++];
        }
        if (this.list.size() > 0 && ((SectionDescriptor)(object = this.list.getLast())).getEnd() > n) {
            ((SectionDescriptor)object).setEnd(n);
        }
        if (n != cArray2.length) {
            object = new char[n];
            System.arraycopy(cArray2, 0, object, 0, n);
        } else {
            object = cArray2;
        }
        return cArray2;
    }

    final Pattern getMagicsAsRE() {
        if (this.magicsAsRE == null) {
            this.magicsAsRE = Pattern.compile(this.makeOrRegexp());
        }
        return this.magicsAsRE;
    }

    final String makeOrRegexp() {
        StringBuilder stringBuilder = new StringBuilder(100);
        for (GuardTag guardTag : GuardTag.values()) {
            stringBuilder.append(guardTag.name() + ':');
            stringBuilder.append('|');
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    static int toNewLine(int n, char[] cArray) {
        int n2 = n;
        int n3 = cArray.length;
        while (n2 < n3) {
            char c;
            if ((c = cArray[n2++]) != '\r' && c != '\n') continue;
            --n2;
            break;
        }
        return n2 - n;
    }

    List<GuardedSection> fillSections(List<SectionDescriptor> list) {
        SectionDescriptor sectionDescriptor = null;
        ArrayList<GuardedSection> arrayList = new ArrayList<GuardedSection>(list.size());
        for (SectionDescriptor sectionDescriptor2 : list) {
            try {
                SimpleSection simpleSection = null;
                switch (sectionDescriptor2.getType()) {
                    case LINE: {
                        simpleSection = this.provider.createSimpleSection(sectionDescriptor2.getName(), sectionDescriptor2.getBegin(), sectionDescriptor2.getEnd());
                        break;
                    }
                    case BEGIN: 
                    case HEADER: 
                    case FIRST: {
                        sectionDescriptor = sectionDescriptor2;
                        break;
                    }
                    case HEADEREND: {
                        if (sectionDescriptor != null && (sectionDescriptor.getType() == GuardTag.HEADER || sectionDescriptor.getType() == GuardTag.FIRST) && sectionDescriptor2.getName().equals(sectionDescriptor.getName())) {
                            sectionDescriptor.setEnd(sectionDescriptor2.getEnd());
                            break;
                        }
                        sectionDescriptor = null;
                        break;
                    }
                    case END: 
                    case LAST: {
                        if (sectionDescriptor != null && sectionDescriptor.getName().equals(sectionDescriptor2.getName())) {
                            if (sectionDescriptor.getType() == GuardTag.BEGIN && sectionDescriptor2.getType() == GuardTag.END) {
                                simpleSection = this.provider.createSimpleSection(sectionDescriptor2.getName(), sectionDescriptor.getBegin(), sectionDescriptor2.getEnd());
                                break;
                            }
                            if (sectionDescriptor.getType() == GuardTag.FIRST && sectionDescriptor2.getType() == GuardTag.LAST || sectionDescriptor.getType() == GuardTag.HEADER && sectionDescriptor2.getType() == GuardTag.END) {
                                simpleSection = this.provider.createInteriorSection(sectionDescriptor2.getName(), sectionDescriptor.getBegin(), sectionDescriptor.getEnd(), sectionDescriptor2.getBegin(), sectionDescriptor2.getEnd());
                                break;
                            }
                        }
                        sectionDescriptor = null;
                    }
                }
                if (simpleSection == null) continue;
                arrayList.add((GuardedSection)simpleSection);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(JavaGuardedReader.class.getName()).log(Level.SEVERE, badLocationException.getLocalizedMessage(), badLocationException);
            }
        }
        return arrayList;
    }
}

