/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jruby.util.ByteList;
import org.jvyamlb.Scanner;
import org.jvyamlb.ScannerException;
import org.jvyamlb.SimpleKey;
import org.jvyamlb.YAMLException;
import org.jvyamlb.tokens.AliasToken;
import org.jvyamlb.tokens.AnchorToken;
import org.jvyamlb.tokens.DirectiveToken;
import org.jvyamlb.tokens.ScalarToken;
import org.jvyamlb.tokens.TagToken;
import org.jvyamlb.tokens.Token;

public class ScannerImpl
implements Scanner {
    private static final byte[] EMPTY;
    private static final byte[] NN;
    private static final ByteList BANG;
    private static final ByteList SPACE;
    private static final boolean[] ALL_FALSE;
    private static final boolean[] ALL_TRUE;
    private static final boolean[] LINEBR;
    private static final boolean[] NULL_BL_LINEBR;
    private static final boolean[] NULL_BL_T_LINEBR;
    private static final boolean[] NULL_OR_LINEBR;
    private static final boolean[] FULL_LINEBR;
    private static final boolean[] BLANK_OR_LINEBR;
    private static final boolean[] S4;
    private static final boolean[] ALPHA;
    private static final boolean[] DIGIT;
    private static final boolean[] HEXA;
    private static final boolean[] STRANGE_CHAR;
    private static final int[] RN;
    private static final boolean[] BLANK_T;
    private static final boolean[] SPACES_AND_STUFF;
    private static final boolean[] DOUBLE_ESC;
    private static final boolean[] NON_ALPHA_OR_NUM;
    private static final boolean[] NON_PRINTABLE;
    private static final boolean[] STUPID_CHAR;
    private static final boolean[] R_FLOWZERO;
    private static final boolean[] R_FLOWZERO1;
    private static final boolean[] R_FLOWNONZERO;
    private static final byte[] ESCAPE_REPLACEMENTS;
    private static final boolean[] IS_ESCAPE_REPLACEMENT;
    private static final Map ESCAPE_CODES;
    private static final boolean[] CHOMPING;
    private boolean done = false;
    private int flowLevel = 0;
    private int tokensTaken = 0;
    private int indent = -1;
    private boolean allowSimpleKey = true;
    private boolean eof = true;
    private int column = 0;
    private int pointer = 0;
    private ByteList buffer;
    private InputStream stream;
    private List tokens;
    private List indents;
    private Map possibleSimpleKeys;
    private boolean docStart = false;
    private static final byte[] HEXA_VALUES;

    public ScannerImpl(InputStream inputStream) {
        this.stream = inputStream;
        this.eof = false;
        this.buffer = new ByteList(100);
        this.tokens = new LinkedList();
        this.indents = new LinkedList();
        this.possibleSimpleKeys = new HashMap();
        this.fetchStreamStart();
    }

    public ScannerImpl(ByteList byteList) {
        this.buffer = new ByteList(byteList.bytes, byteList.begin, byteList.realSize);
        this.stream = null;
        this.tokens = new LinkedList();
        this.indents = new LinkedList();
        this.possibleSimpleKeys = new HashMap();
        this.fetchStreamStart();
    }

    public ScannerImpl(String string) {
        try {
            this.buffer = new ByteList(ByteList.plain(string), false);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        this.stream = null;
        this.tokens = new LinkedList();
        this.indents = new LinkedList();
        this.possibleSimpleKeys = new HashMap();
        this.fetchStreamStart();
    }

    private void update(int n, boolean bl) {
        if (!this.eof && bl) {
            this.buffer.delete(0, this.pointer);
            this.pointer = 0;
        }
        while (this.buffer.realSize < this.pointer + n) {
            byte[] byArray = ByteList.NULL_ARRAY;
            int n2 = -2;
            if (!this.eof) {
                byte[] byArray2 = new byte[1024];
                try {
                    n2 = this.stream.read(byArray2);
                }
                catch (IOException iOException) {
                    throw new YAMLException(iOException);
                }
                if (n2 == -1) {
                    this.eof = true;
                } else {
                    byArray = byArray2;
                }
            }
            if (this.eof) {
                this.buffer.append(0);
                break;
            }
            this.checkPrintable(byArray, n2);
            this.buffer.append(byArray, 0, n2);
        }
    }

    private void checkPrintable(byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (!NON_PRINTABLE[byArray[i] & 0xFF]) continue;
            int n2 = this.buffer.length() - this.pointer + i;
            throw new YAMLException("At " + n2 + " we found: " + (char)(byArray[i] & 0xFF) + ". Special characters are not allowed");
        }
    }

    private boolean ensure(int n, boolean bl) {
        if (this.pointer + n >= this.buffer.realSize) {
            this.update(n, bl);
        }
        return true;
    }

    private char peek() {
        this.ensure(1, false);
        return (char)((char)this.buffer.bytes[this.pointer] & 0xFF);
    }

    private char peek(int n) {
        this.ensure(n + 1, false);
        return (char)((char)this.buffer.bytes[this.pointer + n] & 0xFF);
    }

    private void forward() {
        this.ensure(2, true);
        char c = (char)(this.buffer.bytes[this.pointer++] & 0xFF);
        if (c == '\n' || c == '\r' && (this.buffer.bytes[this.pointer] & 0xFF) != 10) {
            this.possibleSimpleKeys.clear();
            this.column = 0;
        } else {
            ++this.column;
        }
    }

    private void forward(int n) {
        this.ensure(n + 1, true);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = this.buffer.bytes[this.pointer] & 0xFF;
            ++this.pointer;
            if (LINEBR[n2] || n2 == 13 && (this.buffer.bytes[this.pointer] & 0xFF) != 10) {
                this.possibleSimpleKeys.clear();
                this.column = 0;
                continue;
            }
            ++this.column;
        }
    }

    public boolean checkToken(Class[] classArray) {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            if (classArray.length == 0) {
                return true;
            }
            Object e = this.tokens.get(0);
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                if (!classArray[i].isInstance(e)) continue;
                return true;
            }
        }
        return false;
    }

    public Token peekToken(int n) {
        while (this.needMoreTokens(n + 1)) {
            this.fetchMoreTokens();
        }
        return this.tokens.size() < n + 1 ? null : this.tokens.get(n);
    }

    public Token peekToken() {
        return this.peekToken(0);
    }

    public Token getToken() {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            ++this.tokensTaken;
            return (Token)this.tokens.remove(0);
        }
        return null;
    }

    public Iterator eachToken() {
        return new TokenIterator();
    }

    public Iterator iterator() {
        return this.eachToken();
    }

    private boolean needMoreTokens() {
        return this.needMoreTokens(1);
    }

    private boolean needMoreTokens(int n) {
        if (this.done) {
            return false;
        }
        return this.tokens.size() < n || this.nextPossibleSimpleKey() == this.tokensTaken;
    }

    private boolean isEnding() {
        this.ensure(4, false);
        return (this.buffer.bytes[this.pointer] & 0xFF) == 45 && (this.buffer.bytes[this.pointer + 1] & 0xFF) == 45 && (this.buffer.bytes[this.pointer + 2] & 0xFF) == 45 && this.buffer.bytes[this.pointer + 3] != 0 && this.buffer.realSize > this.pointer + 4 && (this.buffer.bytes[this.pointer + 3] != 10 || this.buffer.bytes[this.pointer + 4] != 0) && NULL_BL_T_LINEBR[this.buffer.bytes[this.pointer + 3]];
    }

    private boolean isStart() {
        this.ensure(4, false);
        return (this.buffer.bytes[this.pointer] & 0xFF) == 46 && (this.buffer.bytes[this.pointer + 1] & 0xFF) == 46 && (this.buffer.bytes[this.pointer + 2] & 0xFF) == 46 && NULL_BL_T_LINEBR[this.buffer.bytes[this.pointer + 3]];
    }

    private boolean isEndOrStart() {
        this.ensure(4, false);
        return ((this.buffer.bytes[this.pointer] & 0xFF) == 45 && (this.buffer.bytes[this.pointer + 1] & 0xFF) == 45 && (this.buffer.bytes[this.pointer + 2] & 0xFF) == 45 || (this.buffer.bytes[this.pointer] & 0xFF) == 46 && (this.buffer.bytes[this.pointer + 1] & 0xFF) == 46 && (this.buffer.bytes[this.pointer + 2] & 0xFF) == 46) && NULL_BL_T_LINEBR[this.buffer.bytes[this.pointer + 3]];
    }

    private Token fetchMoreTokens() {
        this.scanToNextToken();
        this.unwindIndent(this.column);
        char c = this.peek();
        boolean bl = this.column == 0;
        switch (c) {
            case '\u0000': {
                return this.fetchStreamEnd();
            }
            case '\'': {
                return this.fetchSingle();
            }
            case '\"': {
                return this.fetchDouble();
            }
            case '?': {
                if (this.flowLevel == 0 && !NULL_BL_T_LINEBR[this.peek(1)]) break;
                return this.fetchKey();
            }
            case ':': {
                if (this.flowLevel == 0 && !NULL_BL_T_LINEBR[this.peek(1)]) break;
                return this.fetchValue();
            }
            case '%': {
                if (!bl) break;
                return this.fetchDirective();
            }
            case '-': {
                if ((bl || this.docStart) && this.isEnding()) {
                    return this.fetchDocumentStart();
                }
                if (!NULL_BL_T_LINEBR[this.peek(1)]) break;
                return this.fetchBlockEntry();
            }
            case '.': {
                if (!bl || !this.isStart()) break;
                return this.fetchDocumentEnd();
            }
            case '[': {
                return this.fetchFlowSequenceStart();
            }
            case '{': {
                return this.fetchFlowMappingStart();
            }
            case ']': {
                return this.fetchFlowSequenceEnd();
            }
            case '}': {
                return this.fetchFlowMappingEnd();
            }
            case ',': {
                if (this.flowLevel == 0) break;
                return this.fetchFlowEntry();
            }
            case '*': {
                return this.fetchAlias();
            }
            case '&': {
                return this.fetchAnchor();
            }
            case '!': {
                return this.fetchTag();
            }
            case '|': {
                if (this.flowLevel != 0 || !CHOMPING[this.peek(1)]) break;
                return this.fetchLiteral();
            }
            case '>': {
                if (this.flowLevel != 0 || !CHOMPING[this.peek(1)]) break;
                return this.fetchFolded();
            }
        }
        if (STUPID_CHAR[this.buffer.bytes[this.pointer] & 0xFF] || this.ensure(1, false) && (this.buffer.bytes[this.pointer] == 45 || this.buffer.bytes[this.pointer] == 63 || this.buffer.bytes[this.pointer] == 58) && !NULL_BL_T_LINEBR[this.buffer.bytes[this.pointer + 1] & 0xFF]) {
            return this.fetchPlain();
        }
        throw new ScannerException("while scanning for the next token", "found character " + c + "(" + c + ") that cannot start any token", null);
    }

    private Token fetchStreamStart() {
        this.docStart = true;
        this.tokens.add(Token.STREAM_START);
        return Token.STREAM_START;
    }

    private Token fetchStreamEnd() {
        this.unwindIndent(-1);
        this.allowSimpleKey = false;
        this.possibleSimpleKeys = new HashMap();
        this.tokens.add(Token.STREAM_END);
        this.done = true;
        this.docStart = false;
        return Token.STREAM_END;
    }

    private void scanToNextToken() {
        while (true) {
            char c;
            if ((c = this.peek()) == ' ' || c == '\t') {
                this.forward();
                continue;
            }
            if (c == '#') {
                this.forward();
                while (!NULL_OR_LINEBR[this.peek()]) {
                    this.forward();
                }
            }
            if (this.scanLineBreak().length == 0) break;
            if (this.flowLevel != 0) continue;
            this.allowSimpleKey = true;
        }
    }

    private byte[] scanLineBreak() {
        char c = this.peek();
        if (FULL_LINEBR[c]) {
            this.ensure(2, false);
            if (RN[0] == this.buffer.bytes[this.pointer] && RN[1] == this.buffer.bytes[this.pointer + 1]) {
                this.forward(2);
            } else {
                this.forward();
            }
            return NN;
        }
        return EMPTY;
    }

    private void unwindIndent(int n) {
        if (this.flowLevel != 0) {
            return;
        }
        while (this.indent > n) {
            this.indent = (Integer)this.indents.remove(0);
            this.tokens.add(Token.BLOCK_END);
        }
    }

    private Token fetchDocumentStart() {
        this.docStart = false;
        return this.fetchDocumentIndicator(Token.DOCUMENT_START);
    }

    private Token fetchDocumentIndicator(Token token) {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        this.forward(3);
        this.tokens.add(token);
        return token;
    }

    private Token fetchBlockEntry() {
        this.docStart = false;
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                throw new ScannerException(null, "sequence entries are not allowed here", null);
            }
            if (this.addIndent(this.column)) {
                this.tokens.add(Token.BLOCK_SEQUENCE_START);
            }
        }
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        this.forward();
        this.tokens.add(Token.BLOCK_ENTRY);
        return Token.BLOCK_ENTRY;
    }

    private boolean addIndent(int n) {
        if (this.indent < n) {
            this.indents.add(0, new Integer(this.indent));
            this.indent = n;
            return true;
        }
        return false;
    }

    private Token fetchTag() {
        this.docStart = false;
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanTag();
        this.tokens.add(token);
        return token;
    }

    private void removePossibleSimpleKey() {
        SimpleKey simpleKey = (SimpleKey)this.possibleSimpleKeys.remove(new Integer(this.flowLevel));
        if (simpleKey != null && simpleKey.isRequired()) {
            throw new ScannerException("while scanning a simple key", "could not find expected ':'", null);
        }
    }

    private void savePossibleSimpleKey() {
        if (this.allowSimpleKey) {
            this.removePossibleSimpleKey();
            this.possibleSimpleKeys.put(new Integer(this.flowLevel), new SimpleKey(this.tokensTaken + this.tokens.size(), this.flowLevel == 0 && this.indent == this.column, -1, -1, this.column));
        }
    }

    private Token scanTag() {
        char c = this.peek(1);
        ByteList byteList = null;
        ByteList byteList2 = null;
        if (c == '<') {
            this.forward(2);
            byteList2 = this.scanTagUri("tag");
            if (this.peek() != '>') {
                throw new ScannerException("while scanning a tag", "expected '>', but found " + this.peek() + "(" + this.peek() + ")", null);
            }
            this.forward();
        } else if (NULL_BL_T_LINEBR[c]) {
            byteList2 = BANG;
            this.forward();
        } else {
            int n = 1;
            boolean bl = false;
            while (!NULL_BL_T_LINEBR[c]) {
                if (c == '!') {
                    bl = true;
                    break;
                }
                c = this.peek(++n);
            }
            byteList = BANG;
            if (bl) {
                byteList = this.scanTagHandle("tag");
            } else {
                byteList = BANG;
                this.forward();
            }
            byteList2 = this.scanTagUri("tag");
        }
        if (!NULL_BL_LINEBR[this.peek()]) {
            throw new ScannerException("while scanning a tag", "expected ' ', but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return new TagToken(new ByteList[]{byteList, byteList2});
    }

    private ByteList scanTagUri(String string) {
        ByteList byteList = new ByteList(10);
        int n = 0;
        char c = this.peek(n);
        while (STRANGE_CHAR[c]) {
            if ('%' == c) {
                this.ensure(n, false);
                byteList.append(this.buffer.bytes, this.pointer, n);
                n = 0;
                byteList.append(this.scanUriEscapes(string));
            } else {
                ++n;
            }
            c = this.peek(n);
        }
        if (n != 0) {
            this.ensure(n, false);
            byteList.append(this.buffer.bytes, this.pointer, n);
            this.forward(n);
        }
        if (byteList.length() == 0) {
            throw new ScannerException("while scanning a " + string, "expected URI, but found " + c + "(" + c + ")", null);
        }
        return byteList;
    }

    private ByteList scanTagHandle(String string) {
        char c = this.peek();
        if (c != '!') {
            throw new ScannerException("while scanning a " + string, "expected '!', but found " + c + "(" + c + ")", null);
        }
        int n = 1;
        c = this.peek(n);
        if (c != ' ') {
            while (ALPHA[c]) {
                c = this.peek(++n);
            }
            if ('!' != c) {
                this.forward(n);
                throw new ScannerException("while scanning a " + string, "expected '!', but found " + c + "(" + c + ")", null);
            }
            ++n;
        }
        this.ensure(n, false);
        ByteList byteList = new ByteList(this.buffer.bytes, this.pointer, n, false);
        this.forward(n);
        return byteList;
    }

    private ByteList scanUriEscapes(String string) {
        ByteList byteList = new ByteList();
        while (this.peek() == '%') {
            this.forward();
            try {
                this.ensure(2, false);
                byteList.append(Integer.parseInt(new String(ByteList.plain(this.buffer.bytes, this.pointer, 2)), 16));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ScannerException("while scanning a " + string, "expected URI escape sequence of 2 hexadecimal numbers, but found " + this.peek(1) + "(" + this.peek(1) + ") and " + this.peek(2) + "(" + this.peek(2) + ")", null);
            }
            this.forward(2);
        }
        return byteList;
    }

    private Token fetchPlain() {
        this.docStart = false;
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanPlain();
        this.tokens.add(token);
        return token;
    }

    private Token scanPlain() {
        ByteList byteList = new ByteList(7);
        int n = this.indent + 1;
        ByteList byteList2 = new ByteList(0);
        boolean bl = true;
        boolean[] blArray = R_FLOWNONZERO;
        boolean[] blArray2 = ALL_FALSE;
        boolean[] blArray3 = ALL_FALSE;
        if (this.flowLevel == 0) {
            bl = false;
            blArray = R_FLOWZERO;
            blArray2 = R_FLOWZERO1;
            blArray3 = R_FLOWZERO;
        }
        while (this.peek() != '#') {
            int n2 = 0;
            int n3 = 0;
            while (true) {
                this.ensure(n3 + 2, false);
                if (blArray[this.buffer.bytes[this.pointer + n3] & 0xFF] || blArray2[this.buffer.bytes[this.pointer + n3] & 0xFF] && blArray3[this.buffer.bytes[this.pointer + n3 + 1] & 0xFF]) {
                    n2 = n3;
                    char c = this.peek(n2);
                    if (!bl || c != ':' || S4[this.peek(n2 + 1)]) break;
                }
                ++n3;
            }
            if (n2 == 0) break;
            this.allowSimpleKey = false;
            byteList.append(byteList2);
            this.ensure(n2, false);
            byteList.append(this.buffer.bytes, this.pointer, n2);
            this.forward(n2);
            byteList2 = this.scanPlainSpaces(n);
            if (byteList2 != null && (this.flowLevel != 0 || this.column >= n)) continue;
            break;
        }
        return new ScalarToken(byteList, true);
    }

    private int nextPossibleSimpleKey() {
        for (SimpleKey simpleKey : this.possibleSimpleKeys.values()) {
            if (simpleKey.getTokenNumber() <= 0) continue;
            return simpleKey.getTokenNumber();
        }
        return -1;
    }

    private ByteList scanPlainSpaces(int n) {
        ByteList byteList = new ByteList();
        int n2 = 0;
        while (this.peek(n2) == ' ') {
            ++n2;
        }
        byte[] byArray = new byte[n2];
        Arrays.fill(byArray, (byte)32);
        this.forward(n2);
        char c = this.peek();
        if (FULL_LINEBR[c]) {
            byte[] byArray2 = this.scanLineBreak();
            this.allowSimpleKey = true;
            if (this.isEndOrStart()) {
                return new ByteList(0);
            }
            ByteList byteList2 = new ByteList();
            while (BLANK_OR_LINEBR[this.peek()]) {
                if (' ' == this.peek()) {
                    this.forward();
                    continue;
                }
                byteList2.append(this.scanLineBreak());
                if (!this.isEndOrStart()) continue;
                return new ByteList(0);
            }
            if (byArray2.length != 1 || byArray2[0] != 10) {
                byteList.append(byArray2);
            } else if (byteList2 == null || byteList2.realSize == 0) {
                byteList.append(SPACE);
            }
            byteList.append(byteList2);
        } else {
            byteList.append(byArray);
        }
        return byteList;
    }

    private Token fetchSingle() {
        return this.fetchFlowScalar('\'');
    }

    private Token fetchDouble() {
        return this.fetchFlowScalar('\"');
    }

    private Token fetchFlowScalar(char c) {
        this.docStart = false;
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanFlowScalar(c);
        this.tokens.add(token);
        return token;
    }

    private Token scanFlowScalar(char c) {
        boolean bl = c == '\"';
        ByteList byteList = new ByteList();
        char c2 = this.peek();
        this.forward();
        byteList.append(this.scanFlowScalarNonSpaces(bl));
        while (this.peek() != c2) {
            byteList.append(this.scanFlowScalarSpaces());
            byteList.append(this.scanFlowScalarNonSpaces(bl));
        }
        this.forward();
        return new ScalarToken(byteList, false, c);
    }

    private ByteList parseHexa(int n) {
        this.ensure(n, false);
        ByteList byteList = new ByteList(n / 2);
        for (int i = 0; i < n; i += 2) {
            byte by = HEXA_VALUES[this.buffer.bytes[this.pointer + i] & 0xFF];
            if (by == -1) {
                throw new ScannerException("while scanning a double-quoted scalar", "expected escape sequence of " + n + " hexadecimal numbers, but found something else: " + (char)(this.buffer.bytes[this.pointer + i] & 0xFF), null);
            }
            if (i + 1 < n) {
                by = (byte)(by << 4);
                byte by2 = HEXA_VALUES[this.buffer.bytes[this.pointer + i + 1] & 0xFF];
                if (by2 == -1) {
                    throw new ScannerException("while scanning a double-quoted scalar", "expected escape sequence of " + n + " hexadecimal numbers, but found something else: " + (char)(this.buffer.bytes[this.pointer + i + 1] & 0xFF), null);
                }
                by = (byte)(by + by2);
            }
            byteList.append(by);
        }
        this.forward(n);
        return byteList;
    }

    private ByteList scanFlowScalarNonSpaces(boolean bl) {
        ByteList byteList = new ByteList();
        while (true) {
            int n = 0;
            while (!SPACES_AND_STUFF[this.peek(n)]) {
                ++n;
            }
            if (n != 0) {
                this.ensure(n, false);
                byteList.append(this.buffer.bytes, this.pointer, n);
                this.forward(n);
            }
            char c = this.peek();
            if (!bl && c == '\'' && this.peek(1) == '\'') {
                byteList.append(39);
                this.forward(2);
                continue;
            }
            if (bl && c == '\'' || !bl && DOUBLE_ESC[c]) {
                byteList.append(c);
                this.forward();
                continue;
            }
            if (!bl || c != '\\') break;
            this.forward();
            c = this.peek();
            if (IS_ESCAPE_REPLACEMENT[c]) {
                byteList.append(ESCAPE_REPLACEMENTS[c]);
                this.forward();
                continue;
            }
            if (ESCAPE_CODES.containsKey(new Character(c))) {
                n = (Integer)ESCAPE_CODES.get(new Character(c));
                this.forward();
                byteList.append(this.parseHexa(n));
                continue;
            }
            if (FULL_LINEBR[c]) {
                this.scanLineBreak();
                ByteList byteList2 = this.scanFlowScalarBreaks();
                byteList.append(byteList2);
                continue;
            }
            byteList.append(92);
        }
        return byteList;
    }

    private ByteList scanFlowScalarSpaces() {
        ByteList byteList = new ByteList();
        int n = 0;
        while (BLANK_T[this.peek(n)]) {
            ++n;
        }
        this.ensure(n, false);
        ByteList byteList2 = new ByteList(this.buffer, this.pointer, n);
        this.forward(n);
        char c = this.peek();
        if (c == '\u0000') {
            throw new ScannerException("while scanning a quoted scalar", "found unexpected end of stream", null);
        }
        if (FULL_LINEBR[c]) {
            byte[] byArray = this.scanLineBreak();
            ByteList byteList3 = this.scanFlowScalarBreaks();
            if (byArray.length != 1 || byArray[0] != 10) {
                byteList.append(byArray);
            } else if (byteList3.length() == 0) {
                byteList.append(SPACE);
            }
            byteList.append(byteList3);
        } else {
            byteList.append(byteList2);
        }
        return byteList;
    }

    private ByteList scanFlowScalarBreaks() {
        ByteList byteList = new ByteList();
        boolean bl = true;
        while (true) {
            if (bl && this.isEndOrStart()) {
                throw new ScannerException("while scanning a quoted scalar", "found unexpected document separator", null);
            }
            while (BLANK_T[this.peek()]) {
                this.forward();
            }
            if (FULL_LINEBR[this.peek()]) {
                byteList.append(this.scanLineBreak());
                bl = true;
                continue;
            }
            if ('\\' != this.peek() || !BLANK_T[this.peek(1)]) break;
            this.forward();
            byteList.append(this.scanFlowScalarSpaces());
            bl = false;
        }
        return byteList;
    }

    private Token fetchValue() {
        this.docStart = false;
        SimpleKey simpleKey = (SimpleKey)this.possibleSimpleKeys.get(new Integer(this.flowLevel));
        if (null == simpleKey) {
            if (this.flowLevel == 0 && !this.allowSimpleKey) {
                throw new ScannerException(null, "mapping values are not allowed here", null);
            }
            this.allowSimpleKey = this.flowLevel == 0;
            this.removePossibleSimpleKey();
        } else {
            this.possibleSimpleKeys.remove(new Integer(this.flowLevel));
            this.tokens.add(simpleKey.getTokenNumber() - this.tokensTaken, Token.KEY);
            if (this.flowLevel == 0 && this.addIndent(simpleKey.getColumn())) {
                this.tokens.add(simpleKey.getTokenNumber() - this.tokensTaken, Token.BLOCK_MAPPING_START);
            }
            this.allowSimpleKey = false;
        }
        this.forward();
        this.tokens.add(Token.VALUE);
        return Token.VALUE;
    }

    private Token fetchFlowSequenceStart() {
        return this.fetchFlowCollectionStart(Token.FLOW_SEQUENCE_START);
    }

    private Token fetchFlowMappingStart() {
        return this.fetchFlowCollectionStart(Token.FLOW_MAPPING_START);
    }

    private Token fetchFlowCollectionStart(Token token) {
        this.docStart = false;
        this.savePossibleSimpleKey();
        ++this.flowLevel;
        this.allowSimpleKey = true;
        this.forward(1);
        this.tokens.add(token);
        return token;
    }

    private Token fetchDocumentEnd() {
        return this.fetchDocumentIndicator(Token.DOCUMENT_END);
    }

    private Token fetchFlowSequenceEnd() {
        return this.fetchFlowCollectionEnd(Token.FLOW_SEQUENCE_END);
    }

    private Token fetchFlowMappingEnd() {
        return this.fetchFlowCollectionEnd(Token.FLOW_MAPPING_END);
    }

    private Token fetchFlowCollectionEnd(Token token) {
        this.removePossibleSimpleKey();
        --this.flowLevel;
        this.allowSimpleKey = false;
        this.forward(1);
        this.tokens.add(token);
        return token;
    }

    private Token fetchFlowEntry() {
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        this.forward(1);
        this.tokens.add(Token.FLOW_ENTRY);
        return Token.FLOW_ENTRY;
    }

    private Token fetchLiteral() {
        return this.fetchBlockScalar('|');
    }

    private Token fetchFolded() {
        return this.fetchBlockScalar('>');
    }

    private Token fetchBlockScalar(char c) {
        this.docStart = false;
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        Token token = this.scanBlockScalar(c);
        this.tokens.add(token);
        return token;
    }

    private Token scanBlockScalar(char c) {
        int n;
        boolean bl = c == '>';
        ByteList byteList = new ByteList();
        this.forward();
        Object[] objectArray = this.scanBlockScalarIndicators();
        Boolean bl2 = (Boolean)objectArray[0];
        int n2 = (Integer)objectArray[1];
        boolean bl3 = this.scanBlockScalarIgnoredLine();
        int n3 = this.indent + 1;
        if (n3 < 0) {
            n3 = 0;
        }
        ByteList byteList2 = null;
        int n4 = 0;
        int n5 = 0;
        if (bl3) {
            boolean bl4 = !BLANK_T[this.peek()];
            n = 0;
            while (!NULL_OR_LINEBR[this.peek(n)]) {
                ++n;
            }
            this.ensure(n, false);
            byteList.append(this.buffer.bytes, this.pointer, n);
            this.forward(n);
        }
        if (n2 == -1) {
            Object[] objectArray2 = this.scanBlockScalarIndentation();
            byteList2 = (ByteList)objectArray2[0];
            n4 = (Integer)objectArray2[1];
            n5 = n3 > n4 ? n3 : n4;
        } else {
            n5 = n3 + n2 - 1;
            byteList2 = this.scanBlockScalarBreaks(n5);
        }
        byte[] byArray = ByteList.NULL_ARRAY;
        while (this.column == n5 && this.peek() != '\u0000') {
            byteList.append(byteList2);
            n = !BLANK_T[this.peek()] ? 1 : 0;
            int n6 = 0;
            while (!NULL_OR_LINEBR[this.peek(n6)]) {
                ++n6;
            }
            this.ensure(n6, false);
            byteList.append(this.buffer.bytes, this.pointer, n6);
            this.forward(n6);
            byArray = this.scanLineBreak();
            byteList2 = this.scanBlockScalarBreaks(n5);
            if (this.column != n5 || this.peek() == '\u0000') break;
            if (bl && byArray.length == 1 && byArray[0] == 10 && n != 0 && !BLANK_T[this.peek()]) {
                if (byteList2.length() != 0) continue;
                byteList.append(SPACE);
                continue;
            }
            byteList.append(byArray);
        }
        if (bl2 != Boolean.FALSE) {
            byteList.append(byArray);
        }
        if (bl2 == Boolean.TRUE) {
            byteList.append(byteList2);
        }
        return new ScalarToken(byteList, false, c);
    }

    private ByteList scanBlockScalarBreaks(int n) {
        ByteList byteList = new ByteList();
        while (this.column < n && this.peek() == ' ') {
            this.forward();
        }
        while (FULL_LINEBR[this.peek()]) {
            byteList.append(this.scanLineBreak());
            while (this.column < n && this.peek() == ' ') {
                this.forward();
            }
        }
        return byteList;
    }

    private Object[] scanBlockScalarIndentation() {
        ByteList byteList = new ByteList();
        int n = 0;
        while (BLANK_OR_LINEBR[this.peek()]) {
            if (this.peek() != ' ') {
                byteList.append(this.scanLineBreak());
                continue;
            }
            this.forward();
            if (this.column <= n) continue;
            n = this.column;
        }
        return new Object[]{byteList, new Integer(n)};
    }

    private Object[] scanBlockScalarIndicators() {
        Boolean bl = null;
        int n = -1;
        char c = this.peek();
        if (c == '-' || c == '+') {
            bl = c == '+' ? Boolean.TRUE : Boolean.FALSE;
            this.forward();
            c = this.peek();
            if (DIGIT[c]) {
                n = c - 48;
                if (n == 0) {
                    throw new ScannerException("while scanning a block scalar", "expected indentation indicator in the range 1-9, but found 0", null);
                }
                this.forward();
            }
        } else if (DIGIT[c]) {
            n = c - 48;
            if (n == 0) {
                throw new ScannerException("while scanning a block scalar", "expected indentation indicator in the range 1-9, but found 0", null);
            }
            this.forward();
            c = this.peek();
            if (c == '-' || c == '+') {
                bl = c == '+' ? Boolean.TRUE : Boolean.FALSE;
                this.forward();
            }
        }
        if (!NULL_BL_LINEBR[this.peek()]) {
            throw new ScannerException("while scanning a block scalar", "expected chomping or indentation indicators, but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return new Object[]{bl, new Integer(n)};
    }

    private boolean scanBlockScalarIgnoredLine() {
        boolean bl = true;
        while (this.peek() == ' ') {
            this.forward();
        }
        if (this.peek() == '#') {
            while (!NULL_OR_LINEBR[this.peek()]) {
                this.forward();
            }
            bl = false;
        }
        if (NULL_OR_LINEBR[this.peek()]) {
            this.scanLineBreak();
            return false;
        }
        return bl;
    }

    private Token fetchDirective() {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanDirective();
        this.tokens.add(token);
        return token;
    }

    private Token fetchKey() {
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                throw new ScannerException(null, "mapping keys are not allowed here", null);
            }
            if (this.addIndent(this.column)) {
                this.tokens.add(Token.BLOCK_MAPPING_START);
            }
        }
        this.allowSimpleKey = this.flowLevel == 0;
        this.removePossibleSimpleKey();
        this.forward();
        this.tokens.add(Token.KEY);
        return Token.KEY;
    }

    private Token fetchAlias() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanAnchor(new AliasToken());
        this.tokens.add(token);
        return token;
    }

    private Token fetchAnchor() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanAnchor(new AnchorToken());
        this.tokens.add(token);
        return token;
    }

    private Token scanDirective() {
        this.forward();
        String string = this.scanDirectiveName();
        String[] stringArray = null;
        if (string.equals("YAML")) {
            stringArray = this.scanYamlDirectiveValue();
        } else if (string.equals("TAG")) {
            stringArray = this.scanTagDirectiveValue();
        } else {
            while (!NULL_OR_LINEBR[this.peek()]) {
                this.forward();
            }
        }
        this.scanDirectiveIgnoredLine();
        return new DirectiveToken(string, stringArray);
    }

    private String scanDirectiveName() {
        int n = 0;
        char c = this.peek(n);
        boolean bl = true;
        while (ALPHA[c]) {
            bl = false;
            c = this.peek(++n);
        }
        if (bl) {
            throw new ScannerException("while scanning a directive", "expected alphabetic or numeric character, but found " + c + "(" + c + ")", null);
        }
        String string = null;
        try {
            this.ensure(n, false);
            string = new String(this.buffer.bytes, this.pointer, n, "ISO8859-1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.forward(n);
        if (!NULL_BL_LINEBR[this.peek()]) {
            throw new ScannerException("while scanning a directive", "expected alphabetic or numeric character, but found " + c + "(" + c + ")", null);
        }
        return string;
    }

    private byte[] scanDirectiveIgnoredLine() {
        char c;
        while (this.peek() == ' ') {
            this.forward();
        }
        if (this.peek() == '\"') {
            while (!NULL_OR_LINEBR[this.peek()]) {
                this.forward();
            }
        }
        if (!NULL_OR_LINEBR[c = this.peek()]) {
            throw new ScannerException("while scanning a directive", "expected a comment or a line break, but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return this.scanLineBreak();
    }

    private Token scanAnchor(Token token) {
        char c = this.peek();
        String string = c == '*' ? "alias" : "anchor";
        this.forward();
        int n = 0;
        while (ALPHA[this.peek(n)]) {
            ++n;
        }
        if (n == 0) {
            throw new ScannerException("while scanning an " + string, "expected alphabetic or numeric character, but found something else...", null);
        }
        String string2 = null;
        try {
            this.ensure(n, false);
            string2 = new String(this.buffer.bytes, this.pointer, n, "ISO8859-1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.forward(n);
        if (!NON_ALPHA_OR_NUM[this.peek()]) {
            throw new ScannerException("while scanning an " + string, "expected alphabetic or numeric character, but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        token.setValue(string2);
        return token;
    }

    private String[] scanYamlDirectiveValue() {
        while (this.peek() == ' ') {
            this.forward();
        }
        String string = this.scanYamlDirectiveNumber();
        if (this.peek() != '.') {
            throw new ScannerException("while scanning a directive", "expected a digit or '.', but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        this.forward();
        String string2 = this.scanYamlDirectiveNumber();
        if (!NULL_BL_LINEBR[this.peek()]) {
            throw new ScannerException("while scanning a directive", "expected a digit or ' ', but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return new String[]{string, string2};
    }

    private String scanYamlDirectiveNumber() {
        char c = this.peek();
        if (!Character.isDigit(c)) {
            throw new ScannerException("while scanning a directive", "expected a digit, but found " + c + "(" + c + ")", null);
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (Character.isDigit(this.peek(n))) {
            stringBuffer.append(this.peek(n));
            ++n;
        }
        this.forward(n);
        return stringBuffer.toString();
    }

    public static String into(ByteList byteList) {
        try {
            return new String(byteList.bytes, 0, byteList.realSize, "ISO8859-1");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String[] scanTagDirectiveValue() {
        while (this.peek() == ' ') {
            this.forward();
        }
        String string = ScannerImpl.into(this.scanTagDirectiveHandle());
        while (this.peek() == ' ') {
            this.forward();
        }
        String string2 = ScannerImpl.into(this.scanTagDirectivePrefix());
        return new String[]{string, string2};
    }

    private ByteList scanTagDirectiveHandle() {
        ByteList byteList = this.scanTagHandle("directive");
        if (this.peek() != ' ') {
            throw new ScannerException("while scanning a directive", "expected ' ', but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return byteList;
    }

    private ByteList scanTagDirectivePrefix() {
        ByteList byteList = this.scanTagUri("directive");
        if (!NULL_BL_LINEBR[this.peek()]) {
            throw new ScannerException("while scanning a directive", "expected ' ', but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return byteList;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        System.out.println("Reading of file: \"" + string + "\"");
        ByteList byteList = new ByteList(1024);
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[1024];
        int n = 0;
        do {
            n = ((InputStream)fileInputStream).read(byArray);
            byteList.append(byArray, 0, n);
        } while (n >= 1024);
        ((InputStream)fileInputStream).close();
        long l = System.currentTimeMillis();
        int n2 = 0;
        for (int i = 0; i < 1; ++i) {
            ScannerImpl scannerImpl = new ScannerImpl(byteList);
            Iterator iterator = scannerImpl.eachToken();
            while (iterator.hasNext()) {
                ++n2;
                System.out.println(iterator.next());
            }
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        double d = (double)(l2 - l) / 1000.0;
        System.out.println("Walking through the " + n2 + " tokens took " + l3 + "ms, or " + d + " seconds");
    }

    public static void tmain(String[] stringArray) throws Exception {
        String string = stringArray[0];
        System.out.println("Reading of file: \"" + string + "\"");
        FileInputStream fileInputStream = new FileInputStream(string);
        long l = System.currentTimeMillis();
        int n = 0;
        for (int i = 0; i < 1; ++i) {
            ScannerImpl scannerImpl = new ScannerImpl(fileInputStream);
            Iterator iterator = scannerImpl.eachToken();
            while (iterator.hasNext()) {
                ++n;
                iterator.next();
            }
        }
        ((InputStream)fileInputStream).close();
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        double d = (double)(l2 - l) / 1000.0;
        System.out.println("Walking through the " + n + " tokens took " + l3 + "ms, or " + d + " seconds");
    }

    static {
        int n;
        EMPTY = new byte[0];
        NN = new byte[]{10};
        BANG = new ByteList(new byte[]{33}, false);
        SPACE = new ByteList(new byte[]{32}, false);
        ALL_FALSE = new boolean[256];
        ALL_TRUE = new boolean[256];
        LINEBR = new boolean[256];
        NULL_BL_LINEBR = new boolean[256];
        NULL_BL_T_LINEBR = new boolean[256];
        NULL_OR_LINEBR = new boolean[256];
        FULL_LINEBR = new boolean[256];
        BLANK_OR_LINEBR = new boolean[256];
        S4 = new boolean[256];
        ALPHA = new boolean[256];
        DIGIT = new boolean[256];
        HEXA = new boolean[256];
        STRANGE_CHAR = new boolean[256];
        RN = new int[]{13, 10};
        BLANK_T = new boolean[256];
        SPACES_AND_STUFF = new boolean[256];
        DOUBLE_ESC = new boolean[256];
        NON_ALPHA_OR_NUM = new boolean[256];
        NON_PRINTABLE = new boolean[256];
        STUPID_CHAR = new boolean[256];
        R_FLOWZERO = NULL_BL_T_LINEBR;
        R_FLOWZERO1 = new boolean[256];
        R_FLOWNONZERO = new boolean[256];
        ESCAPE_REPLACEMENTS = new byte[256];
        IS_ESCAPE_REPLACEMENT = new boolean[256];
        ESCAPE_CODES = new HashMap();
        CHOMPING = new boolean[256];
        ScannerImpl.CHOMPING[43] = true;
        ScannerImpl.CHOMPING[45] = true;
        ScannerImpl.CHOMPING[10] = true;
        ScannerImpl.CHOMPING[13] = true;
        ScannerImpl.CHOMPING[48] = true;
        ScannerImpl.CHOMPING[49] = true;
        ScannerImpl.CHOMPING[50] = true;
        ScannerImpl.CHOMPING[51] = true;
        ScannerImpl.CHOMPING[52] = true;
        ScannerImpl.CHOMPING[53] = true;
        ScannerImpl.CHOMPING[54] = true;
        ScannerImpl.CHOMPING[55] = true;
        ScannerImpl.CHOMPING[56] = true;
        ScannerImpl.CHOMPING[57] = true;
        ScannerImpl.CHOMPING[35] = true;
        ScannerImpl.CHOMPING[32] = true;
        Arrays.fill(ALL_TRUE, true);
        ScannerImpl.LINEBR[10] = true;
        ScannerImpl.NULL_BL_LINEBR[0] = true;
        ScannerImpl.NULL_BL_LINEBR[32] = true;
        ScannerImpl.NULL_BL_LINEBR[13] = true;
        ScannerImpl.NULL_BL_LINEBR[10] = true;
        ScannerImpl.NULL_BL_T_LINEBR[0] = true;
        ScannerImpl.NULL_BL_T_LINEBR[32] = true;
        ScannerImpl.NULL_BL_T_LINEBR[9] = true;
        ScannerImpl.NULL_BL_T_LINEBR[13] = true;
        ScannerImpl.NULL_BL_T_LINEBR[10] = true;
        ScannerImpl.NULL_OR_LINEBR[0] = true;
        ScannerImpl.NULL_OR_LINEBR[13] = true;
        ScannerImpl.NULL_OR_LINEBR[10] = true;
        ScannerImpl.FULL_LINEBR[13] = true;
        ScannerImpl.FULL_LINEBR[10] = true;
        ScannerImpl.BLANK_OR_LINEBR[32] = true;
        ScannerImpl.BLANK_OR_LINEBR[13] = true;
        ScannerImpl.BLANK_OR_LINEBR[10] = true;
        ScannerImpl.S4[0] = true;
        ScannerImpl.S4[32] = true;
        ScannerImpl.S4[9] = true;
        ScannerImpl.S4[13] = true;
        ScannerImpl.S4[10] = true;
        ScannerImpl.S4[91] = true;
        ScannerImpl.S4[93] = true;
        ScannerImpl.S4[123] = true;
        ScannerImpl.S4[125] = true;
        for (n = 97; n <= 122; n = (int)((char)(n + 1))) {
            ScannerImpl.ALPHA[n] = true;
            ScannerImpl.STRANGE_CHAR[n] = true;
        }
        for (n = 65; n <= 90; n = (int)((char)(n + 1))) {
            ScannerImpl.ALPHA[n] = true;
            ScannerImpl.STRANGE_CHAR[n] = true;
        }
        for (n = 48; n <= 57; n = (int)((char)(n + 1))) {
            ScannerImpl.ALPHA[n] = true;
            ScannerImpl.STRANGE_CHAR[n] = true;
            ScannerImpl.HEXA[n] = true;
            ScannerImpl.DIGIT[n] = true;
        }
        for (n = 97; n <= 102; n = (int)((char)(n + 1))) {
            ScannerImpl.HEXA[n] = true;
        }
        for (n = 65; n <= 70; n = (int)((char)(n + 1))) {
            ScannerImpl.HEXA[n] = true;
        }
        ScannerImpl.ALPHA[45] = true;
        ScannerImpl.ALPHA[95] = true;
        ScannerImpl.STRANGE_CHAR[45] = true;
        ScannerImpl.STRANGE_CHAR[95] = true;
        ScannerImpl.STRANGE_CHAR[91] = true;
        ScannerImpl.STRANGE_CHAR[93] = true;
        ScannerImpl.STRANGE_CHAR[40] = true;
        ScannerImpl.STRANGE_CHAR[41] = true;
        ScannerImpl.STRANGE_CHAR[39] = true;
        ScannerImpl.STRANGE_CHAR[59] = true;
        ScannerImpl.STRANGE_CHAR[47] = true;
        ScannerImpl.STRANGE_CHAR[63] = true;
        ScannerImpl.STRANGE_CHAR[58] = true;
        ScannerImpl.STRANGE_CHAR[64] = true;
        ScannerImpl.STRANGE_CHAR[38] = true;
        ScannerImpl.STRANGE_CHAR[61] = true;
        ScannerImpl.STRANGE_CHAR[43] = true;
        ScannerImpl.STRANGE_CHAR[36] = true;
        ScannerImpl.STRANGE_CHAR[44] = true;
        ScannerImpl.STRANGE_CHAR[46] = true;
        ScannerImpl.STRANGE_CHAR[33] = true;
        ScannerImpl.STRANGE_CHAR[126] = true;
        ScannerImpl.STRANGE_CHAR[42] = true;
        ScannerImpl.STRANGE_CHAR[37] = true;
        ScannerImpl.STRANGE_CHAR[94] = true;
        ScannerImpl.STRANGE_CHAR[35] = true;
        ScannerImpl.BLANK_T[32] = true;
        ScannerImpl.BLANK_T[9] = true;
        ScannerImpl.SPACES_AND_STUFF[0] = true;
        ScannerImpl.SPACES_AND_STUFF[32] = true;
        ScannerImpl.SPACES_AND_STUFF[9] = true;
        ScannerImpl.SPACES_AND_STUFF[13] = true;
        ScannerImpl.SPACES_AND_STUFF[10] = true;
        ScannerImpl.SPACES_AND_STUFF[92] = true;
        ScannerImpl.SPACES_AND_STUFF[39] = true;
        ScannerImpl.SPACES_AND_STUFF[34] = true;
        ScannerImpl.DOUBLE_ESC[92] = true;
        ScannerImpl.DOUBLE_ESC[34] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[0] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[32] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[9] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[13] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[10] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[63] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[58] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[44] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[93] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[125] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[37] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[64] = true;
        ScannerImpl.NON_ALPHA_OR_NUM[96] = true;
        Arrays.fill(ESCAPE_REPLACEMENTS, (byte)0);
        ScannerImpl.ESCAPE_REPLACEMENTS[48] = 0;
        ScannerImpl.ESCAPE_REPLACEMENTS[97] = 7;
        ScannerImpl.ESCAPE_REPLACEMENTS[98] = 8;
        ScannerImpl.ESCAPE_REPLACEMENTS[116] = 9;
        ScannerImpl.ESCAPE_REPLACEMENTS[9] = 9;
        ScannerImpl.ESCAPE_REPLACEMENTS[110] = 10;
        ScannerImpl.ESCAPE_REPLACEMENTS[118] = 11;
        ScannerImpl.ESCAPE_REPLACEMENTS[102] = 12;
        ScannerImpl.ESCAPE_REPLACEMENTS[114] = 13;
        ScannerImpl.ESCAPE_REPLACEMENTS[101] = 27;
        ScannerImpl.ESCAPE_REPLACEMENTS[34] = 34;
        ScannerImpl.ESCAPE_REPLACEMENTS[92] = 92;
        ScannerImpl.ESCAPE_REPLACEMENTS[78] = -123;
        ScannerImpl.ESCAPE_REPLACEMENTS[95] = -96;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[48] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[97] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[98] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[116] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[9] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[110] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[118] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[102] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[114] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[101] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[34] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[92] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[78] = true;
        ScannerImpl.IS_ESCAPE_REPLACEMENT[95] = true;
        ESCAPE_CODES.put(new Character('x'), new Integer(2));
        ESCAPE_CODES.put(new Character('u'), new Integer(4));
        ESCAPE_CODES.put(new Character('U'), new Integer(8));
        Arrays.fill(STUPID_CHAR, true);
        ScannerImpl.STUPID_CHAR[0] = false;
        ScannerImpl.STUPID_CHAR[32] = false;
        ScannerImpl.STUPID_CHAR[9] = false;
        ScannerImpl.STUPID_CHAR[13] = false;
        ScannerImpl.STUPID_CHAR[10] = false;
        ScannerImpl.STUPID_CHAR[45] = false;
        ScannerImpl.STUPID_CHAR[63] = false;
        ScannerImpl.STUPID_CHAR[58] = false;
        ScannerImpl.STUPID_CHAR[91] = false;
        ScannerImpl.STUPID_CHAR[93] = false;
        ScannerImpl.STUPID_CHAR[123] = false;
        ScannerImpl.STUPID_CHAR[35] = false;
        ScannerImpl.STUPID_CHAR[38] = false;
        ScannerImpl.STUPID_CHAR[42] = false;
        ScannerImpl.STUPID_CHAR[33] = false;
        ScannerImpl.STUPID_CHAR[124] = false;
        ScannerImpl.STUPID_CHAR[39] = false;
        ScannerImpl.STUPID_CHAR[34] = false;
        ScannerImpl.STUPID_CHAR[64] = false;
        ScannerImpl.R_FLOWZERO1[58] = true;
        ScannerImpl.R_FLOWNONZERO[0] = true;
        ScannerImpl.R_FLOWNONZERO[32] = true;
        ScannerImpl.R_FLOWNONZERO[9] = true;
        ScannerImpl.R_FLOWNONZERO[13] = true;
        ScannerImpl.R_FLOWNONZERO[10] = true;
        ScannerImpl.R_FLOWNONZERO[91] = true;
        ScannerImpl.R_FLOWNONZERO[93] = true;
        ScannerImpl.R_FLOWNONZERO[123] = true;
        ScannerImpl.R_FLOWNONZERO[125] = true;
        ScannerImpl.R_FLOWNONZERO[44] = true;
        ScannerImpl.R_FLOWNONZERO[58] = true;
        ScannerImpl.R_FLOWNONZERO[63] = true;
        HEXA_VALUES = new byte[256];
        Arrays.fill(HEXA_VALUES, (byte)-1);
        ScannerImpl.HEXA_VALUES[48] = 0;
        ScannerImpl.HEXA_VALUES[49] = 1;
        ScannerImpl.HEXA_VALUES[50] = 2;
        ScannerImpl.HEXA_VALUES[51] = 3;
        ScannerImpl.HEXA_VALUES[52] = 4;
        ScannerImpl.HEXA_VALUES[53] = 5;
        ScannerImpl.HEXA_VALUES[54] = 6;
        ScannerImpl.HEXA_VALUES[55] = 7;
        ScannerImpl.HEXA_VALUES[56] = 8;
        ScannerImpl.HEXA_VALUES[57] = 9;
        ScannerImpl.HEXA_VALUES[65] = 10;
        ScannerImpl.HEXA_VALUES[66] = 11;
        ScannerImpl.HEXA_VALUES[67] = 12;
        ScannerImpl.HEXA_VALUES[68] = 13;
        ScannerImpl.HEXA_VALUES[69] = 14;
        ScannerImpl.HEXA_VALUES[70] = 15;
        ScannerImpl.HEXA_VALUES[97] = 10;
        ScannerImpl.HEXA_VALUES[98] = 11;
        ScannerImpl.HEXA_VALUES[99] = 12;
        ScannerImpl.HEXA_VALUES[100] = 13;
        ScannerImpl.HEXA_VALUES[101] = 14;
        ScannerImpl.HEXA_VALUES[102] = 15;
    }

    private class TokenIterator
    implements Iterator {
        private TokenIterator() {
        }

        public boolean hasNext() {
            return null != ScannerImpl.this.peekToken();
        }

        public Object next() {
            return ScannerImpl.this.getToken();
        }

        public void remove() {
        }
    }
}

