/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.jruby.util.ByteList;
import org.jvyamlb.BaseConstructorImpl;
import org.jvyamlb.Composer;
import org.jvyamlb.ComposerImpl;
import org.jvyamlb.Constructor;
import org.jvyamlb.ConstructorException;
import org.jvyamlb.ParserImpl;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.YAMLException;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.util.Base64Coder;

public class SafeConstructorImpl
extends BaseConstructorImpl {
    private static final Map yamlConstructors = new HashMap();
    private static final Map yamlMultiConstructors = new HashMap();
    private static final Map yamlMultiRegexps = new HashMap();
    private static final Map BOOL_VALUES = new HashMap();
    private static final Pattern TIMESTAMP_REGEXP;
    public static final Pattern YMD_REGEXP;
    private static final Double INF_VALUE_POS;
    private static final Double INF_VALUE_NEG;
    private static final Double NAN_VALUE;

    public Constructor.YamlConstructor getYamlConstructor(Object object) {
        Constructor.YamlConstructor yamlConstructor = (Constructor.YamlConstructor)yamlConstructors.get(object);
        if (yamlConstructor == null) {
            yamlConstructor = super.getYamlConstructor(object);
        }
        return yamlConstructor;
    }

    public Constructor.YamlMultiConstructor getYamlMultiConstructor(Object object) {
        Constructor.YamlMultiConstructor yamlMultiConstructor = (Constructor.YamlMultiConstructor)yamlMultiConstructors.get(object);
        if (yamlMultiConstructor == null) {
            yamlMultiConstructor = super.getYamlMultiConstructor(object);
        }
        return yamlMultiConstructor;
    }

    public Pattern getYamlMultiRegexp(Object object) {
        Pattern pattern = (Pattern)yamlMultiRegexps.get(object);
        if (pattern == null) {
            pattern = super.getYamlMultiRegexp(object);
        }
        return pattern;
    }

    public Set getYamlMultiRegexps() {
        HashSet hashSet = new HashSet(super.getYamlMultiRegexps());
        hashSet.addAll(yamlMultiRegexps.keySet());
        return hashSet;
    }

    public static void addConstructor(String string, Constructor.YamlConstructor yamlConstructor) {
        yamlConstructors.put(string, yamlConstructor);
    }

    public static void addMultiConstructor(String string, Constructor.YamlMultiConstructor yamlMultiConstructor) {
        yamlMultiConstructors.put(string, yamlMultiConstructor);
        yamlMultiRegexps.put(string, Pattern.compile("^" + string));
    }

    public SafeConstructorImpl(Composer composer) {
        super(composer);
    }

    private static ByteList into(String string) {
        return new ByteList(string.getBytes(), false);
    }

    public static Object constructYamlNull(Constructor constructor, Node node) {
        return null;
    }

    public static Object constructYamlBool(Constructor constructor, Node node) {
        Object object = constructor.constructScalar(node);
        return BOOL_VALUES.get(object);
    }

    public static Object constructYamlOmap(Constructor constructor, Node node) {
        return constructor.constructPairs(node);
    }

    public static Object constructYamlPairs(Constructor constructor, Node node) {
        return SafeConstructorImpl.constructYamlOmap(constructor, node);
    }

    public static Object constructYamlSet(Constructor constructor, Node node) {
        return ((Map)constructor.constructMapping(node)).keySet();
    }

    public static Object constructYamlStr(Constructor constructor, Node node) {
        ByteList byteList = (ByteList)constructor.constructScalar(node);
        return byteList.length() == 0 ? (ByteList)null : byteList;
    }

    public static Object constructYamlSeq(Constructor constructor, Node node) {
        return constructor.constructSequence(node);
    }

    public static Object constructYamlMap(Constructor constructor, Node node) {
        return constructor.constructMapping(node);
    }

    public static Object constructUndefined(Constructor constructor, Node node) {
        throw new ConstructorException(null, "could not determine a constructor for the tag " + node.getTag(), null);
    }

    public static Object constructYamlTimestamp(Constructor constructor, Node node) {
        Matcher matcher = YMD_REGEXP.matcher(node.getValue().toString());
        if (matcher.matches()) {
            String string = matcher.group(1);
            String string2 = matcher.group(2);
            String string3 = matcher.group(3);
            DateTime dateTime = new DateTime(0, 1, 1, 0, 0, 0, 0);
            if (string != null) {
                dateTime = dateTime.withYear(Integer.parseInt(string));
            }
            if (string2 != null) {
                dateTime = dateTime.withMonthOfYear(Integer.parseInt(string2));
            }
            if (string3 != null) {
                dateTime = dateTime.withDayOfMonth(Integer.parseInt(string3));
            }
            return new Object[]{dateTime};
        }
        matcher = TIMESTAMP_REGEXP.matcher(node.getValue().toString());
        if (!matcher.matches()) {
            return new Object[]{constructor.constructPrivateType(node)};
        }
        String string = matcher.group(1);
        String string4 = matcher.group(2);
        String string5 = matcher.group(3);
        String string6 = matcher.group(4);
        String string7 = matcher.group(5);
        String string8 = matcher.group(6);
        String string9 = matcher.group(7);
        String string10 = matcher.group(8);
        String string11 = matcher.group(9);
        String string12 = matcher.group(10);
        int n = 0;
        if (string9 != null && (n = Integer.parseInt(string9)) != 0) {
            while (10 * n < 1000) {
                n *= 10;
            }
        }
        DateTime dateTime = new DateTime(0, 1, 1, 0, 0, 0, 0);
        if ("Z".equalsIgnoreCase(string10)) {
            dateTime = dateTime.withZone(DateTimeZone.forID((String)"Etc/GMT"));
        } else if (string11 != null || string12 != null) {
            int n2 = 0;
            int n3 = 1;
            if (string11 != null) {
                if (string11.startsWith("-")) {
                    n3 = -1;
                }
                n2 += Integer.parseInt(string11.substring(1)) * 3600000;
            }
            if (string12 != null) {
                n2 += Integer.parseInt(string12) * 60000;
            }
            dateTime = dateTime.withZone(DateTimeZone.forOffsetMillis((int)(n3 * n2)));
        }
        if (string != null) {
            dateTime = dateTime.withYear(Integer.parseInt(string));
        }
        if (string4 != null) {
            dateTime = dateTime.withMonthOfYear(Integer.parseInt(string4));
        }
        if (string5 != null) {
            dateTime = dateTime.withDayOfMonth(Integer.parseInt(string5));
        }
        if (string6 != null) {
            dateTime = dateTime.withHourOfDay(Integer.parseInt(string6));
        }
        if (string7 != null) {
            dateTime = dateTime.withMinuteOfHour(Integer.parseInt(string7));
        }
        if (string8 != null) {
            dateTime = dateTime.withSecondOfMinute(Integer.parseInt(string8));
        }
        dateTime = dateTime.withMillisOfSecond(n / 1000);
        return new Object[]{dateTime, new Integer(n % 1000)};
    }

    public static Object constructYamlInt(Constructor constructor, Node node) {
        String string = constructor.constructScalar(node).toString().replaceAll("_", "").replaceAll(",", "");
        int n = 1;
        char c = string.charAt(0);
        if (c == '-') {
            n = -1;
            string = string.substring(1);
        } else if (c == '+') {
            string = string.substring(1);
        }
        int n2 = 10;
        if (string.equals("0")) {
            return new Long(0L);
        }
        if (string.startsWith("0b")) {
            string = string.substring(2);
            n2 = 2;
        } else if (string.startsWith("0x")) {
            string = string.substring(2);
            n2 = 16;
        } else if (string.startsWith("0")) {
            string = string.substring(1);
            n2 = 8;
        } else {
            if (string.indexOf(58) != -1) {
                String[] stringArray = string.split(":");
                int n3 = 1;
                int n4 = 0;
                int n5 = stringArray.length;
                for (int i = 0; i < n5; ++i) {
                    n4 = (int)((long)n4 + Long.parseLong(stringArray[n5 - i - 1]) * (long)n3);
                    n3 *= 60;
                }
                return new Integer(n * n4);
            }
            try {
                return new Long((long)n * Long.parseLong(string));
            }
            catch (Exception exception) {
                if (n < 0) {
                    return new BigInteger(string).negate();
                }
                return new BigInteger(string);
            }
        }
        try {
            return new Long((long)n * Long.parseLong(string, n2));
        }
        catch (Exception exception) {
            if (n < 0) {
                return new BigInteger(string, n2).negate();
            }
            return new BigInteger(string, n2);
        }
    }

    public static Object constructYamlFloat(Constructor constructor, Node node) {
        String string = constructor.constructScalar(node).toString().replaceAll("_", "").replaceAll(",", "");
        int n = 1;
        char c = string.charAt(0);
        if (c == '-') {
            n = -1;
            string = string.substring(1);
        } else if (c == '+') {
            string = string.substring(1);
        }
        String string2 = string.toLowerCase();
        if (string2.equals(".inf")) {
            return n == -1 ? INF_VALUE_NEG : INF_VALUE_POS;
        }
        if (string2.equals(".nan")) {
            return NAN_VALUE;
        }
        if (string.indexOf(58) != -1) {
            String[] stringArray = string.split(":");
            int n2 = 1;
            double d = 0.0;
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                d += Double.parseDouble(stringArray[n3 - i - 1]) * (double)n2;
                n2 *= 60;
            }
            return new Double((double)n * d);
        }
        return new Double((double)n * Double.parseDouble(string));
    }

    public static Object constructYamlBinary(Constructor constructor, Node node) {
        String[] stringArray = constructor.constructScalar(node).toString().split("\n|(?:\r[^\n])");
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(stringArray[i].trim());
        }
        return Base64Coder.decode(ByteList.plain(stringBuffer));
    }

    public static Object constructSpecializedSequence(Constructor constructor, String string, Node node) {
        List list = null;
        try {
            Class<?> clazz = Class.forName(string);
            list = (List)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new YAMLException("Can't construct a sequence from class " + string + ": " + exception.toString());
        }
        list.addAll((List)constructor.constructSequence(node));
        return list;
    }

    public static Object constructSpecializedMap(Constructor constructor, String string, Node node) {
        Map map = null;
        try {
            Class<?> clazz = Class.forName(string);
            map = (Map)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new YAMLException("Can't construct a mapping from class " + string + ": " + exception.toString());
        }
        map.putAll((Map)constructor.constructMapping(node));
        return map;
    }

    private static Object fixValue(Object object, Class clazz) {
        if (object == null) {
            return null;
        }
        Class<?> clazz2 = object.getClass();
        if (clazz.isAssignableFrom(clazz2)) {
            return object;
        }
        if (clazz2 == Long.class && (clazz == Integer.class || clazz == Integer.TYPE)) {
            return new Integer(((Long)object).intValue());
        }
        if (clazz2 == Long.class && (clazz == Short.class || clazz == Short.TYPE)) {
            return new Short((short)((Long)object).intValue());
        }
        if (clazz2 == Long.class && (clazz == Character.class || clazz == Character.TYPE)) {
            return new Character((char)((Long)object).intValue());
        }
        if (clazz2 == Double.class && (clazz == Float.class || clazz == Float.TYPE)) {
            return new Float(((Double)object).floatValue());
        }
        return object;
    }

    public static Object constructJava(Constructor constructor, String string, Node node) {
        Object var3_3 = null;
        try {
            Class<?> clazz = Class.forName(string);
            var3_3 = clazz.newInstance();
            Map map = (Map)constructor.constructMapping(node);
            Method[] methodArray = clazz.getMethods();
            block2: for (Object k : map.keySet()) {
                Object v = map.get(k);
                String string2 = k.toString();
                String string3 = "set" + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
                int n = methodArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!methodArray[i].getName().equals(string3) || methodArray[i].getParameterTypes().length != 1) continue;
                    methodArray[i].invoke(var3_3, SafeConstructorImpl.fixValue(v, methodArray[i].getParameterTypes()[0]));
                    continue block2;
                }
            }
        }
        catch (Exception exception) {
            throw new YAMLException("Can't construct a java object from class " + string + ": " + exception.toString());
        }
        return var3_3;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        System.out.println("Reading of file: \"" + string + "\"");
        ByteList byteList = new ByteList(1024);
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[1024];
        int n = 0;
        do {
            n = ((InputStream)fileInputStream).read(byArray);
            byteList.append(byArray, 0, n);
        } while (n >= 1024);
        ((InputStream)fileInputStream).close();
        long l = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            SafeConstructorImpl safeConstructorImpl = new SafeConstructorImpl(new ComposerImpl(new ParserImpl(new ScannerImpl(byteList)), new ResolverImpl()));
            Iterator iterator = safeConstructorImpl.eachDocument();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        double d = (double)(l2 - l) / 1000.0;
        System.out.println("Walking through the nodes for the file: " + string + " took " + l3 + "ms, or " + d + " seconds");
    }

    static {
        BOOL_VALUES.put(SafeConstructorImpl.into("yes"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("Yes"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("YES"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("no"), Boolean.FALSE);
        BOOL_VALUES.put(SafeConstructorImpl.into("No"), Boolean.FALSE);
        BOOL_VALUES.put(SafeConstructorImpl.into("NO"), Boolean.FALSE);
        BOOL_VALUES.put(SafeConstructorImpl.into("true"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("True"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("TRUE"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("false"), Boolean.FALSE);
        BOOL_VALUES.put(SafeConstructorImpl.into("False"), Boolean.FALSE);
        BOOL_VALUES.put(SafeConstructorImpl.into("FALSE"), Boolean.FALSE);
        BOOL_VALUES.put(SafeConstructorImpl.into("on"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("On"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("ON"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("off"), Boolean.FALSE);
        BOOL_VALUES.put(SafeConstructorImpl.into("Off"), Boolean.FALSE);
        BOOL_VALUES.put(SafeConstructorImpl.into("OFF"), Boolean.FALSE);
        TIMESTAMP_REGEXP = Pattern.compile("^(-?[0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:(?:[Tt]|[ \t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \t]*(Z|([-+][0-9][0-9]?)(?::([0-9][0-9])?)?)))?$");
        YMD_REGEXP = Pattern.compile("^(-?[0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)$");
        INF_VALUE_POS = new Double(Double.POSITIVE_INFINITY);
        INF_VALUE_NEG = new Double(Double.NEGATIVE_INFINITY);
        NAN_VALUE = new Double(Double.NaN);
        BaseConstructorImpl.addConstructor("tag:yaml.org,2002:null", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return SafeConstructorImpl.constructYamlNull(constructor, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:bool", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return SafeConstructorImpl.constructYamlBool(constructor, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:omap", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return SafeConstructorImpl.constructYamlOmap(constructor, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:pairs", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return SafeConstructorImpl.constructYamlPairs(constructor, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:set", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return SafeConstructorImpl.constructYamlSet(constructor, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:int", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return SafeConstructorImpl.constructYamlInt(constructor, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:float", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return SafeConstructorImpl.constructYamlFloat(constructor, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:timestamp", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return ((Object[])SafeConstructorImpl.constructYamlTimestamp(constructor, node))[0];
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:timestamp#ymd", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return ((Object[])SafeConstructorImpl.constructYamlTimestamp(constructor, node))[0];
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:str", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return SafeConstructorImpl.constructYamlStr(constructor, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:binary", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return SafeConstructorImpl.constructYamlBinary(constructor, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:seq", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return SafeConstructorImpl.constructYamlSeq(constructor, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:map", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return SafeConstructorImpl.constructYamlMap(constructor, node);
            }
        });
        SafeConstructorImpl.addConstructor(null, new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return constructor.constructPrivateType(node);
            }
        });
        SafeConstructorImpl.addMultiConstructor("tag:yaml.org,2002:seq:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return SafeConstructorImpl.constructSpecializedSequence(constructor, string, node);
            }
        });
        SafeConstructorImpl.addMultiConstructor("tag:yaml.org,2002:map:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return SafeConstructorImpl.constructSpecializedMap(constructor, string, node);
            }
        });
        SafeConstructorImpl.addMultiConstructor("!java/object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return SafeConstructorImpl.constructJava(constructor, string, node);
            }
        });
        SafeConstructorImpl.addMultiConstructor("tag:java.yaml.org,2002:object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return SafeConstructorImpl.constructJava(constructor, string, node);
            }
        });
    }
}

