/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jruby.util.ByteList;
import org.jvyamlb.Resolver;
import org.jvyamlb.ResolverException;
import org.jvyamlb.ResolverScanner;
import org.jvyamlb.nodes.MappingNode;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.ScalarNode;
import org.jvyamlb.nodes.SequenceNode;

public class ResolverImpl
implements Resolver {
    private static final Map yamlPathResolvers = new HashMap();
    private static final ResolverScanner SCANNER = new ResolverScanner();
    private List resolverExactPaths = new LinkedList();
    private List resolverPrefixPaths = new LinkedList();

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addPathResolver(String string, List list, Class clazz) {
        ArrayList<Serializable> arrayList;
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        Object var4_4 = null;
        Boolean bl = null;
        for (Object e : list) {
            void var4_14;
            void var4_10;
            if (e instanceof List) {
                arrayList = (ArrayList<Serializable>)e;
                if (arrayList.size() == 2) {
                    Object e2 = arrayList.get(0);
                    bl = (Boolean)arrayList.get(1);
                } else {
                    if (arrayList.size() != 1) throw new ResolverException("Invalid path element: " + e);
                    Object e3 = arrayList.get(0);
                    bl = Boolean.TRUE;
                }
            } else {
                Object var4_9 = null;
                bl = (Boolean)e;
            }
            if (var4_10 instanceof String || var4_10 instanceof ByteList) {
                Class<ScalarNode> clazz2 = ScalarNode.class;
            } else if (var4_10 instanceof List) {
                Class<SequenceNode> clazz3 = SequenceNode.class;
            } else if (var4_10 instanceof Map) {
                Class<MappingNode> clazz4 = MappingNode.class;
            } else if (!(null == var4_10 || ScalarNode.class.equals((Object)var4_10) || SequenceNode.class.equals((Object)var4_10) || MappingNode.class.equals((Object)var4_10))) {
                throw new ResolverException("Invalid node checker: " + var4_10);
            }
            if (!(bl instanceof String || var4_14 instanceof ByteList || bl instanceof Integer || null == bl)) {
                throw new ResolverException("Invalid index checker: " + bl);
            }
            linkedList.add(new Object[]{var4_14, bl});
        }
        Class clazz5 = null;
        if (String.class.equals((Object)clazz) || ByteList.class.equals((Object)clazz)) {
            clazz5 = ScalarNode.class;
        } else if (List.class.equals((Object)clazz)) {
            clazz5 = SequenceNode.class;
        } else if (Map.class.equals((Object)clazz)) {
            clazz5 = MappingNode.class;
        } else {
            if (!(clazz == null || ScalarNode.class.equals((Object)clazz) || SequenceNode.class.equals((Object)clazz) || MappingNode.class.equals((Object)clazz))) {
                throw new ResolverException("Invalid node kind: " + clazz);
            }
            clazz5 = clazz;
        }
        ArrayList<LinkedList<Object[]>> arrayList2 = new ArrayList<LinkedList<Object[]>>(1);
        arrayList2.add(linkedList);
        arrayList = new ArrayList<Serializable>(2);
        arrayList.add(arrayList2);
        arrayList.add(clazz);
        yamlPathResolvers.put(arrayList, string);
    }

    public void descendResolver(Node node, Object object) {
        HashMap hashMap = new HashMap();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (null != node) {
            int n = this.resolverPrefixPaths.size();
            for (Object[] objectArray : (List)this.resolverPrefixPaths.get(0)) {
                List list = (List)objectArray[0];
                if (!this.checkResolverPrefix(n, list, (Class)objectArray[1], node, object)) continue;
                if (list.size() > n) {
                    linkedList.add(new Object[]{list, objectArray[1]});
                    continue;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>(2);
                arrayList.add(list);
                arrayList.add(objectArray[1]);
                hashMap.put(objectArray[1], yamlPathResolvers.get(arrayList));
            }
        } else {
            for (List list : yamlPathResolvers.keySet()) {
                List list2 = (List)list.get(0);
                Class clazz = (Class)list.get(1);
                if (null == list2) {
                    hashMap.put(clazz, yamlPathResolvers.get(list));
                    continue;
                }
                linkedList.add(list);
            }
        }
        this.resolverExactPaths.add(0, hashMap);
        this.resolverPrefixPaths.add(0, linkedList);
    }

    public void ascendResolver() {
        this.resolverExactPaths.remove(0);
        this.resolverPrefixPaths.remove(0);
    }

    public boolean checkResolverPrefix(int n, List list, Class clazz, Node node, Object object) {
        Object[] objectArray = (Object[])list.get(n - 1);
        Object object2 = objectArray[0];
        Object object3 = objectArray[1];
        if (object2 instanceof String ? !node.getTag().equals(object2) : null != object2 && !((Class)object2).isInstance(node)) {
            return false;
        }
        if (object3 == Boolean.TRUE && object != null) {
            return false;
        }
        if (object3 == Boolean.FALSE && object == null) {
            return false;
        }
        return !(object3 instanceof String ? !(object instanceof ScalarNode) || !object3.equals(((ScalarNode)object).getValue()) : (object3 instanceof ByteList ? !(object instanceof ScalarNode) || !object3.equals(((ScalarNode)object).getValue()) : object3 instanceof Integer && !object.equals(object3)));
    }

    public String resolve(Class clazz, ByteList byteList, boolean[] blArray) {
        Object object;
        Object var4_4 = null;
        if (clazz.equals(ScalarNode.class) && blArray[0] && (object = SCANNER.recognize(byteList)) != null) {
            return object;
        }
        object = (Map)this.resolverExactPaths.get(0);
        if (object.containsKey(clazz)) {
            return (String)object.get(clazz);
        }
        if (object.containsKey(null)) {
            return (String)object.get(null);
        }
        if (clazz.equals(ScalarNode.class)) {
            return "tag:yaml.org,2002:str";
        }
        if (clazz.equals(SequenceNode.class)) {
            return "tag:yaml.org,2002:seq";
        }
        if (clazz.equals(MappingNode.class)) {
            return "tag:yaml.org,2002:map";
        }
        return null;
    }

    private static ByteList s(String string) {
        return new ByteList(string.getBytes());
    }

    public static void main(String[] stringArray) {
        ByteList[] byteListArray = new ByteList[]{ResolverImpl.s("yes"), ResolverImpl.s("NO"), ResolverImpl.s("booooooooooooooooooooooooooooooooooooooooooooooool"), ResolverImpl.s("false"), ResolverImpl.s(""), ResolverImpl.s("~"), ResolverImpl.s("~a"), ResolverImpl.s("<<"), ResolverImpl.s("10.1"), ResolverImpl.s("10000000000003435345.2324E+13"), ResolverImpl.s(".23"), ResolverImpl.s(".nan"), ResolverImpl.s("null"), ResolverImpl.s("124233333333333333"), ResolverImpl.s("0b030323"), ResolverImpl.s("+0b0111111011010101"), ResolverImpl.s("0xaafffdf"), ResolverImpl.s("2005-05-03"), ResolverImpl.s("2005-05-03a"), ResolverImpl.s(".nana"), ResolverImpl.s("2005-03-05T05:23:22"), ResolverImpl.s("="), ResolverImpl.s("= "), ResolverImpl.s("=a")};
        boolean[] blArray = new boolean[]{true, true};
        ResolverImpl resolverImpl = new ResolverImpl();
        resolverImpl.descendResolver(null, null);
        Class<ScalarNode> clazz = ScalarNode.class;
        long l = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            for (int j = 0; j < byteListArray.length; ++j) {
                resolverImpl.resolve(clazz, byteListArray[j % byteListArray.length], blArray);
            }
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        double d = (double)(l2 - l) / 1000.0;
        System.out.println("Resolving " + 100000 * byteListArray.length + " nodes took " + l3 + "ms, or " + d + " seconds");
    }
}

