/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.RubyHash;
import org.jruby.util.ByteList;
import org.jvyamlb.EmitterImpl;
import org.jvyamlb.Representer;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.Serializer;
import org.jvyamlb.SerializerImpl;
import org.jvyamlb.YAML;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.YAMLNodeCreator;
import org.jvyamlb.nodes.LinkNode;
import org.jvyamlb.nodes.MappingNode;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.ScalarNode;
import org.jvyamlb.nodes.SequenceNode;

public class RepresenterImpl
implements Representer {
    private final Serializer serializer;
    private final char defaultStyle;
    private final Map representedObjects;
    private final Map links;

    public RepresenterImpl(Serializer serializer, YAMLConfig yAMLConfig) {
        this.serializer = serializer;
        this.defaultStyle = (char)(yAMLConfig.useDouble() ? 34 : (yAMLConfig.useSingle() ? 39 : 0));
        this.representedObjects = new IdentityHashMap();
        this.links = new IdentityHashMap();
    }

    private Node representData(Object object) throws IOException {
        Node node = null;
        boolean bl = this.ignoreAliases(object);
        if (!bl) {
            if (this.representedObjects.containsKey(object)) {
                node = (Node)this.representedObjects.get(object);
                if (null == node) {
                    node = new LinkNode();
                    ArrayList<Node> arrayList = (ArrayList<Node>)this.links.get(object);
                    if (arrayList == null) {
                        arrayList = new ArrayList<Node>();
                        this.links.put(object, arrayList);
                    }
                    arrayList.add(node);
                }
                return node;
            }
            this.representedObjects.put(object, null);
        }
        node = this.getNodeCreatorFor(object).toYamlNode(this);
        if (!bl) {
            this.representedObjects.put(object, node);
            List list = (List)this.links.remove(object);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ((LinkNode)iterator.next()).setAnchor(node);
                }
            }
        }
        return node;
    }

    public Node scalar(String string, ByteList byteList, char c) throws IOException {
        return this.representScalar(string, byteList, c);
    }

    public Node representScalar(String string, ByteList byteList, char c) throws IOException {
        char c2 = c == '\u0000' ? this.defaultStyle : c;
        return new ScalarNode(string, byteList, c);
    }

    public Node seq(String string, List list, boolean bl) throws IOException {
        return this.representSequence(string, list, bl);
    }

    public Node representSequence(String string, List list, boolean bl) throws IOException {
        ArrayList<Node> arrayList = new ArrayList<Node>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.representData(iterator.next()));
        }
        return new SequenceNode(string, arrayList, bl);
    }

    public Node map(String string, Map map, boolean bl) throws IOException {
        return this.representMapping(string, map, bl);
    }

    public Node representMapping(String string, Map map, boolean bl) throws IOException {
        Iterator iterator;
        HashMap<Node, Node> hashMap = new HashMap<Node, Node>();
        Iterator iterator2 = iterator = map instanceof RubyHash ? ((RubyHash)map).directEntrySet().iterator() : map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            hashMap.put(this.representData(entry.getKey()), this.representData(entry.getValue()));
        }
        return new MappingNode(string, hashMap, bl);
    }

    public void represent(Object object) throws IOException {
        Node node = this.representData(object);
        this.serializer.serialize(node);
        this.representedObjects.clear();
    }

    protected boolean ignoreAliases(Object object) {
        return false;
    }

    protected YAMLNodeCreator getNodeCreatorFor(Object object) {
        if (object instanceof YAMLNodeCreator) {
            return (YAMLNodeCreator)object;
        }
        if (object instanceof Map) {
            return new MappingYAMLNodeCreator(object);
        }
        if (object instanceof List) {
            return new SequenceYAMLNodeCreator(object);
        }
        if (object instanceof Set) {
            return new SetYAMLNodeCreator(object);
        }
        if (object instanceof Date) {
            return new DateYAMLNodeCreator(object);
        }
        if (object instanceof String) {
            return new StringYAMLNodeCreator(object);
        }
        if (object instanceof ByteList) {
            return new ByteListYAMLNodeCreator(object);
        }
        if (object instanceof Number) {
            return new NumberYAMLNodeCreator(object);
        }
        if (object instanceof Boolean) {
            return new ScalarYAMLNodeCreator("tag:yaml.org,2002:bool", object);
        }
        if (object == null) {
            return new ScalarYAMLNodeCreator("tag:yaml.org,2002:null", "");
        }
        if (object.getClass().isArray()) {
            return new ArrayYAMLNodeCreator(object);
        }
        return new JavaBeanYAMLNodeCreator(object);
    }

    public static void main(String[] stringArray) throws IOException {
        YAMLConfig yAMLConfig = YAML.config();
        SerializerImpl serializerImpl = new SerializerImpl(new EmitterImpl(System.out, yAMLConfig), new ResolverImpl(), yAMLConfig);
        serializerImpl.open();
        RepresenterImpl representerImpl = new RepresenterImpl(serializerImpl, yAMLConfig);
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add("hello");
        linkedList.add(Boolean.TRUE);
        linkedList.add(new Integer(31337));
        hashMap.put("val1", linkedList);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("hello");
        arrayList.add(Boolean.FALSE);
        arrayList.add(new Integer(31337));
        hashMap.put("val2", arrayList);
        hashMap.put("afsdf", "hmm");
        TestJavaBean testJavaBean = new TestJavaBean();
        testJavaBean.setName("Ola");
        testJavaBean.setSurName("Bini");
        testJavaBean.setAge(24);
        hashMap.put(new Integer(25), testJavaBean);
        representerImpl.represent(hashMap);
        serializerImpl.close();
    }

    private static class TestJavaBean
    implements Serializable {
        private String val1;
        private String val2;
        private int val3;

        public void setName(String string) {
            this.val1 = string;
        }

        public String getName() {
            return this.val1;
        }

        public void setSurName(String string) {
            this.val2 = string;
        }

        public String getSurName() {
            return this.val2;
        }

        public void setAge(int n) {
            this.val3 = n;
        }

        public int getAge() {
            return this.val3;
        }
    }

    public static class JavaBeanYAMLNodeCreator
    implements YAMLNodeCreator {
        private final Object data;

        public JavaBeanYAMLNodeCreator(Object object) {
            this.data = object;
        }

        public String taguri() {
            return "!java/object:" + this.data.getClass().getName();
        }

        public Node toYamlNode(Representer representer) throws IOException {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Method[] methodArray = this.data.getClass().getMethods();
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                String string;
                if (methodArray[i].getParameterTypes().length != 0 || (string = methodArray[i].getName()).equals("getClass")) continue;
                String string2 = null;
                if (string.startsWith("get")) {
                    string2 = "" + Character.toLowerCase(string.charAt(3)) + string.substring(4);
                } else if (string.startsWith("is")) {
                    string2 = "" + Character.toLowerCase(string.charAt(2)) + string.substring(3);
                }
                if (null == string2) continue;
                try {
                    hashMap.put(string2, methodArray[i].invoke(this.data, new Object[0]));
                    continue;
                }
                catch (Exception exception) {
                    hashMap.put(string2, null);
                }
            }
            return representer.map(this.taguri(), hashMap, false);
        }
    }

    public static class MappingYAMLNodeCreator
    implements YAMLNodeCreator {
        private final Map data;

        public MappingYAMLNodeCreator(Object object) {
            this.data = (Map)object;
        }

        public String taguri() {
            if (this.data instanceof HashMap) {
                return "tag:yaml.org,2002:map";
            }
            return "tag:yaml.org,2002:map:" + this.data.getClass().getName();
        }

        public Node toYamlNode(Representer representer) throws IOException {
            return representer.map(this.taguri(), this.data, false);
        }
    }

    public static class SequenceYAMLNodeCreator
    implements YAMLNodeCreator {
        private final List data;

        public SequenceYAMLNodeCreator(Object object) {
            this.data = (List)object;
        }

        public String taguri() {
            if (this.data instanceof ArrayList) {
                return "tag:yaml.org,2002:seq";
            }
            return "tag:yaml.org,2002:seq:" + this.data.getClass().getName();
        }

        public Node toYamlNode(Representer representer) throws IOException {
            return representer.seq(this.taguri(), this.data, false);
        }
    }

    public static class ByteListYAMLNodeCreator
    implements YAMLNodeCreator {
        private final Object data;

        public ByteListYAMLNodeCreator(Object object) {
            this.data = object;
        }

        public String taguri() {
            return "tag:yaml.org,2002:str";
        }

        public Node toYamlNode(Representer representer) throws IOException {
            return representer.scalar(this.taguri(), (ByteList)this.data, '\u0000');
        }
    }

    public static class StringYAMLNodeCreator
    implements YAMLNodeCreator {
        private final Object data;

        public StringYAMLNodeCreator(Object object) {
            this.data = object;
        }

        public String taguri() {
            if (this.data instanceof String) {
                return "tag:yaml.org,2002:str";
            }
            return "tag:yaml.org,2002:str:" + this.data.getClass().getName();
        }

        public Node toYamlNode(Representer representer) throws IOException {
            return representer.scalar(this.taguri(), ByteList.create(this.data.toString()), '\u0000');
        }
    }

    public static class ScalarYAMLNodeCreator
    implements YAMLNodeCreator {
        private final String tag;
        private final Object data;

        public ScalarYAMLNodeCreator(String string, Object object) {
            this.tag = string;
            this.data = object;
        }

        public String taguri() {
            return this.tag;
        }

        public Node toYamlNode(Representer representer) throws IOException {
            return representer.scalar(this.taguri(), ByteList.create(this.data.toString()), '\u0000');
        }
    }

    public static class NumberYAMLNodeCreator
    implements YAMLNodeCreator {
        private final Number data;

        public NumberYAMLNodeCreator(Object object) {
            this.data = (Number)object;
        }

        public String taguri() {
            if (this.data instanceof Float || this.data instanceof Double || this.data instanceof BigDecimal) {
                return "tag:yaml.org,2002:float";
            }
            return "tag:yaml.org,2002:int";
        }

        public Node toYamlNode(Representer representer) throws IOException {
            String string = this.data.toString();
            if (string.equals("Infinity")) {
                string = ".inf";
            } else if (string.equals("-Infinity")) {
                string = "-.inf";
            } else if (string.equals("NaN")) {
                string = ".nan";
            }
            return representer.scalar(this.taguri(), ByteList.create(string), '\u0000');
        }
    }

    public static class ArrayYAMLNodeCreator
    implements YAMLNodeCreator {
        private final Object data;

        public ArrayYAMLNodeCreator(Object object) {
            this.data = object;
        }

        public String taguri() {
            return "tag:yaml.org,2002:seq";
        }

        public Node toYamlNode(Representer representer) throws IOException {
            int n = Array.getLength(this.data);
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(Array.get(this.data, i));
            }
            return representer.seq(this.taguri(), arrayList, false);
        }
    }

    public static class SetYAMLNodeCreator
    implements YAMLNodeCreator {
        private final Set data;

        public SetYAMLNodeCreator(Object object) {
            this.data = (Set)object;
        }

        public String taguri() {
            return "tag:yaml.org,2002:set";
        }

        public Node toYamlNode(Representer representer) throws IOException {
            HashMap hashMap = new HashMap();
            Iterator iterator = this.data.iterator();
            while (iterator.hasNext()) {
                hashMap.put(iterator.next(), null);
            }
            return representer.map(this.taguri(), hashMap, false);
        }
    }

    public static class DateYAMLNodeCreator
    implements YAMLNodeCreator {
        private final Date data;
        private static DateFormat dateOutput = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        private static DateFormat dateOutputUsec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");

        public DateYAMLNodeCreator(Object object) {
            this.data = (Date)object;
        }

        public String taguri() {
            return "tag:yaml.org,2002:timestamp";
        }

        public Node toYamlNode(Representer representer) throws IOException {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.data);
            String string = null;
            string = calendar.get(14) != 0 ? dateOutputUsec.format(this.data) : dateOutput.format(this.data);
            string = string.substring(0, 23) + ":" + string.substring(23);
            return representer.scalar(this.taguri(), ByteList.create(string), '\u0000');
        }
    }
}

