/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jruby.util.ByteList;
import org.jvyamlb.Emitter;
import org.jvyamlb.EmitterException;
import org.jvyamlb.ParserImpl;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.YAML;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.events.AliasEvent;
import org.jvyamlb.events.CollectionEndEvent;
import org.jvyamlb.events.CollectionStartEvent;
import org.jvyamlb.events.DocumentEndEvent;
import org.jvyamlb.events.DocumentStartEvent;
import org.jvyamlb.events.Event;
import org.jvyamlb.events.MappingEndEvent;
import org.jvyamlb.events.MappingStartEvent;
import org.jvyamlb.events.NodeEvent;
import org.jvyamlb.events.ScalarEvent;
import org.jvyamlb.events.SequenceEndEvent;
import org.jvyamlb.events.SequenceStartEvent;
import org.jvyamlb.events.StreamEndEvent;
import org.jvyamlb.events.StreamStartEvent;

public class EmitterImpl
implements Emitter {
    private static final int STREAM_START = 0;
    private static final int FIRST_DOCUMENT_START = 1;
    private static final int DOCUMENT_ROOT = 2;
    private static final int NOTHING = 3;
    private static final int DOCUMENT_START = 4;
    private static final int DOCUMENT_END = 5;
    private static final int FIRST_FLOW_SEQUENCE_ITEM = 6;
    private static final int FLOW_SEQUENCE_ITEM = 7;
    private static final int FIRST_FLOW_MAPPING_KEY = 8;
    private static final int FLOW_MAPPING_SIMPLE_VALUE = 9;
    private static final int FLOW_MAPPING_VALUE = 10;
    private static final int FLOW_MAPPING_KEY = 11;
    private static final int BLOCK_SEQUENCE_ITEM = 12;
    private static final int FIRST_BLOCK_MAPPING_KEY = 13;
    private static final int BLOCK_MAPPING_SIMPLE_VALUE = 14;
    private static final int BLOCK_MAPPING_VALUE = 15;
    private static final int BLOCK_MAPPING_KEY = 16;
    private static final int FIRST_BLOCK_SEQUENCE_ITEM = 17;
    private static final EmitterState[] STATES = new EmitterState[18];
    private static final Map DEFAULT_TAG_PREFIXES_1_0;
    private static final Map DEFAULT_TAG_PREFIXES_1_1;
    private OutputStream stream;
    private YAMLConfig options;
    private EmitterEnvironment env;
    private static final Pattern HANDLE_FORMAT;
    private static final Pattern ANCHOR_FORMAT;
    private static final Pattern DOC_INDIC;
    private static final Pattern FIRST_SPACE;
    private static final String NULL_BL_T_LINEBR = "\u0000 \t\r\n";
    private static final String SPECIAL_INDIC = "#,[]{}#&*!|>'\"%@`";
    private static final String FLOW_INDIC = ",?[]{}";

    public EmitterImpl(OutputStream outputStream, YAMLConfig yAMLConfig) {
        int n;
        this.stream = outputStream;
        this.options = yAMLConfig;
        this.env = new EmitterEnvironment();
        this.env.emitter = this;
        this.env.canonical = this.options.canonical();
        int n2 = this.options.indent();
        if (n2 >= 2 && n2 < 10) {
            this.env.bestIndent = n2;
        }
        if ((n = this.options.bestWidth()) != 0 && n > this.env.bestIndent * 2) {
            this.env.bestWidth = n;
        }
    }

    public YAMLConfig getOptions() {
        return this.options;
    }

    public void emit(Event event) throws IOException {
        this.env.events.add(event);
        while (!this.env.needMoreEvents()) {
            this.env.event = (Event)this.env.events.remove(0);
            STATES[this.env.state].expect(this.env);
            this.env.event = null;
        }
    }

    void writeStreamStart() {
    }

    void writeStreamEnd() throws IOException {
        this.flushStream();
    }

    void writeIndicator(ByteList byteList, boolean bl, boolean bl2, boolean bl3) throws IOException {
        ByteList byteList2 = byteList;
        if (!this.env.whitespace && bl) {
            byteList2.prepend((byte)32);
        }
        this.env.whitespace = bl2;
        this.env.indentation = this.env.indentation && bl3;
        this.env.column += byteList2.length();
        this.stream.write(byteList2.bytes, 0, byteList2.realSize);
    }

    void writeIndent() throws IOException {
        int n = 0;
        if (this.env.indent != -1) {
            n = this.env.indent;
        }
        if (!this.env.indentation || this.env.column > n || this.env.column == n && !this.env.whitespace) {
            this.writeLineBreak(null);
        }
        if (this.env.column < n) {
            this.env.whitespace = true;
            ByteList byteList = new ByteList();
            int n2 = n - this.env.column;
            for (int i = 0; i < n2; ++i) {
                byteList.append((byte)32);
            }
            this.env.column = n;
            this.stream.write(byteList.bytes, 0, byteList.realSize);
        }
    }

    void writeVersionDirective(String string) throws IOException {
        this.stream.write(("%YAML " + string).getBytes());
        this.writeLineBreak(null);
    }

    void writeTagDirective(String string, String string2) throws IOException {
        this.stream.write(("%TAG " + string + " " + string2).getBytes());
        this.writeLineBreak(null);
    }

    void writeDoubleQuoted(ByteList byteList, boolean bl) throws IOException {
        this.writeIndicator(ByteList.create("\""), true, false, false);
        int n = 0;
        ByteList byteList2 = null;
        for (int i = 0; i <= byteList.length(); ++i) {
            char c = '\u0000';
            if (i < byteList.length()) {
                c = byteList.charAt(i);
            }
            if (c == '\u0000' || "\"\\".indexOf(c) != -1 || ' ' > c || c > '~') {
                if (n < i) {
                    byteList2 = (ByteList)byteList.subSequence(n, i);
                    this.env.column += byteList2.length();
                    this.stream.write(byteList2.bytes, 0, byteList2.realSize);
                    n = i;
                }
                if (c != '\u0000') {
                    if (YAML.ESCAPE_REPLACEMENTS.containsKey(new Character(c))) {
                        byteList2 = ByteList.create("\\" + YAML.ESCAPE_REPLACEMENTS.get(new Character(c)));
                    } else if (c <= '\u00ff') {
                        String string = Integer.toString(c, 16);
                        if (string.length() == 1) {
                            string = "0" + string;
                        }
                        byteList2 = ByteList.create("\\x" + string);
                    }
                    this.env.column += byteList2.length();
                    this.stream.write(byteList2.bytes, 0, byteList2.realSize);
                    n = i + 1;
                }
            }
            if (0 >= i || i >= byteList.length() - 1 || c != ' ' && n < i || this.env.column + (i - n) <= this.env.bestWidth || !bl) continue;
            if (n < i) {
                byteList2 = (ByteList)byteList.subSequence(n, i);
                byteList2.append(32);
                byteList2.append(92);
                n = i + 1;
            } else {
                byteList2 = ByteList.create("\\");
            }
            this.env.column += byteList2.length();
            this.stream.write(byteList2.bytes, 0, byteList2.realSize);
            this.writeIndent();
            this.env.whitespace = false;
            this.env.indentation = false;
            if (n >= byteList.length() + 1 || byteList.charAt(n) != ' ') continue;
            byteList2 = ByteList.create("\\");
            this.stream.write(byteList2.bytes, 0, byteList2.realSize);
        }
        this.writeIndicator(ByteList.create("\""), false, false, false);
    }

    void writeSingleQuoted(ByteList byteList, boolean bl) throws IOException {
        this.writeIndicator(ByteList.create("'"), true, false, false);
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        char c = '\u0000';
        ByteList byteList2 = null;
        for (int i = 0; i <= byteList.length(); ++i) {
            c = '\u0000';
            if (i < byteList.length()) {
                c = byteList.charAt(i);
            }
            if (bl2) {
                if (c == '\u0000' || c != ' ') {
                    if (n + 1 == i && this.env.column > this.env.bestWidth && bl && n != 0 && i != byteList.length()) {
                        this.writeIndent();
                    } else {
                        byteList2 = (ByteList)byteList.subSequence(n, i);
                        this.env.column += byteList2.length();
                        this.stream.write(byteList2.bytes, 0, byteList2.realSize);
                    }
                    n = i;
                }
            } else if (bl3) {
                if (c == '\u0000' || '\n' != c) {
                    byteList2 = (ByteList)byteList.subSequence(n, i);
                    int n2 = byteList2.length();
                    for (int j = 0; j < n2; ++j) {
                        char c2 = byteList2.charAt(j);
                        if ('\n' == c2) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(ByteList.create("" + c2));
                    }
                    this.writeIndent();
                    n = i;
                }
            } else if ((c == '\u0000' || '\n' != c) && n < i) {
                byteList2 = (ByteList)byteList.subSequence(n, i);
                this.env.column += byteList2.length();
                this.stream.write(byteList2.bytes, 0, byteList2.realSize);
                n = i;
            }
            if (c == '\'') {
                byteList2 = ByteList.create("''");
                this.env.column += 2;
                this.stream.write(byteList2.bytes, 0, byteList2.realSize);
                n = i + 1;
            }
            if (c == '\u0000') continue;
            bl2 = c == ' ';
            bl3 = c == '\n';
        }
        this.writeIndicator(ByteList.create("'"), false, false, false);
    }

    void writeFolded(ByteList byteList) throws IOException {
        String string = EmitterImpl.determineChomp(byteList);
        this.writeIndicator(ByteList.create(">" + string), true, false, false);
        this.writeIndent();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        ByteList byteList2 = null;
        for (int i = 0; i <= byteList.length(); ++i) {
            char c = '\u0000';
            if (i < byteList.length()) {
                c = byteList.charAt(i);
            }
            if (bl3) {
                if (c == '\u0000' || '\n' != c) {
                    if (!bl && c != '\u0000' && c != ' ' && byteList.charAt(n) == '\n') {
                        this.writeLineBreak(null);
                    }
                    bl = c == ' ';
                    byteList2 = (ByteList)byteList.subSequence(n, i);
                    int n2 = byteList2.length();
                    for (int j = 0; j < n2; ++j) {
                        char c2 = byteList2.charAt(j);
                        if ('\n' == c2) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(ByteList.create("" + c2));
                    }
                    if (c != '\u0000') {
                        this.writeIndent();
                    }
                    n = i;
                }
            } else if (bl2) {
                if (c != ' ') {
                    if (n + 1 == i && this.env.column > this.env.bestWidth) {
                        this.writeIndent();
                    } else {
                        byteList2 = (ByteList)byteList.subSequence(n, i);
                        this.env.column += byteList2.length();
                        this.stream.write(byteList2.bytes, 0, byteList2.realSize);
                    }
                    n = i;
                }
            } else if (c == '\u0000' || ' ' == c || '\n' == c) {
                byteList2 = (ByteList)byteList.subSequence(n, i);
                this.stream.write(byteList2.bytes, 0, byteList2.realSize);
                if (c == '\u0000') {
                    this.writeLineBreak(null);
                }
                n = i;
            }
            if (c == '\u0000') continue;
            bl3 = '\n' == c;
            bl2 = c == ' ';
        }
    }

    void writeLiteral(ByteList byteList) throws IOException {
        String string = EmitterImpl.determineChomp(byteList);
        this.writeIndicator(ByteList.create("|" + string), true, false, false);
        this.writeIndent();
        boolean bl = false;
        int n = 0;
        ByteList byteList2 = null;
        for (int i = 0; i <= byteList.length(); ++i) {
            char c = '\u0000';
            if (i < byteList.length()) {
                c = byteList.charAt(i);
            }
            if (bl) {
                if (c == '\u0000' || '\n' != c) {
                    byteList2 = (ByteList)byteList.subSequence(n, i);
                    int n2 = byteList2.length();
                    for (int j = 0; j < n2; ++j) {
                        char c2 = byteList2.charAt(j);
                        if ('\n' == c2) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(ByteList.create("" + c2));
                    }
                    if (c != '\u0000') {
                        this.writeIndent();
                    }
                    n = i;
                }
            } else if (c == '\u0000' || '\n' == c) {
                byteList2 = (ByteList)byteList.subSequence(n, i);
                this.stream.write(byteList2.bytes, 0, byteList2.realSize);
                if (c == '\u0000') {
                    this.writeLineBreak(null);
                }
                n = i;
            }
            if (c == '\u0000') continue;
            bl = '\n' == c;
        }
    }

    void writePlain(ByteList byteList, boolean bl) throws IOException {
        if (byteList == null || byteList.realSize == 0) {
            return;
        }
        ByteList byteList2 = null;
        if (!this.env.whitespace) {
            ++this.env.column;
            this.stream.write(32);
        }
        this.env.whitespace = false;
        this.env.indentation = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        for (int i = 0; i <= byteList.length(); ++i) {
            int n2 = 0;
            if (i < byteList.length()) {
                n2 = (char)(byteList.bytes[byteList.begin + i] & 0xFF);
            }
            if (bl2) {
                if (n2 != 32) {
                    if (n + 1 == i && this.env.column > this.env.bestWidth && bl) {
                        this.writeIndent();
                        this.env.whitespace = false;
                        this.env.indentation = false;
                    } else {
                        byteList2 = new ByteList(byteList, n, i - n);
                        this.env.column += byteList2.length();
                        this.stream.write(byteList2.bytes, 0, byteList2.realSize);
                    }
                    n = i;
                }
            } else if (bl3) {
                if (n2 != 10) {
                    if ((byteList.bytes[n] & 0xFF) == 10) {
                        this.writeLineBreak(null);
                    }
                    byteList2 = new ByteList(byteList, n, i - n);
                    int n3 = byteList2.length();
                    for (int j = 0; j < n3; ++j) {
                        char c = (char)(byteList2.bytes[byteList2.begin + j] & 0xFF);
                        if ('\n' == c) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(ByteList.create("" + c));
                    }
                    this.writeIndent();
                    this.env.whitespace = false;
                    this.env.indentation = false;
                    n = i;
                }
            } else if (n2 == 0 || 32 == n2 || 10 == n2) {
                byteList2 = new ByteList(byteList, n, i - n);
                this.env.column += byteList2.length();
                this.stream.write(byteList2.bytes, 0, byteList2.realSize);
                n = i;
            }
            if (n2 == 0) continue;
            bl2 = n2 == 32;
            bl3 = n2 == 10;
        }
    }

    void writeLineBreak(ByteList byteList) throws IOException {
        ByteList byteList2 = byteList;
        if (byteList2 == null) {
            byteList2 = this.env.bestLinebreak;
        }
        this.env.whitespace = true;
        this.env.indentation = true;
        ++this.env.line;
        this.env.column = 0;
        this.stream.write(byteList2.bytes, 0, byteList2.realSize);
    }

    void flushStream() throws IOException {
        this.stream.flush();
    }

    static String prepareVersion(int[] nArray) {
        if (nArray[0] != 1) {
            throw new EmitterException("unsupported YAML version: " + nArray[0] + "." + nArray[1]);
        }
        return "" + nArray[0] + "." + nArray[1];
    }

    static String prepareTagHandle(String string) {
        if (string == null || "".equals(string)) {
            throw new EmitterException("tag handle must not be empty");
        }
        if (string.charAt(0) != '!' || string.charAt(string.length() - 1) != '!') {
            throw new EmitterException("tag handle must start and end with '!': " + string);
        }
        if (!"!".equals(string) && !HANDLE_FORMAT.matcher(string).matches()) {
            throw new EmitterException("invalid syntax for tag handle: " + string);
        }
        return string;
    }

    static String prepareTagPrefix(String string) {
        if (string == null || "".equals(string)) {
            throw new EmitterException("tag prefix must not be empty");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        if (string.charAt(0) == '!') {
            n2 = 1;
        }
        while (n2 < string.length()) {
            ++n2;
        }
        if (n < n2) {
            stringBuffer.append(string.substring(n, n2));
        }
        return stringBuffer.toString();
    }

    static String prepareAnchor(String string) {
        if (string == null || "".equals(string)) {
            throw new EmitterException("anchor must not be empty");
        }
        if (!ANCHOR_FORMAT.matcher(string).matches()) {
            throw new EmitterException("invalid syntax for anchor: " + string);
        }
        return string;
    }

    String prepareTag(String string) {
        int n;
        if (string == null || "".equals(string)) {
            throw new EmitterException("tag must not be empty");
        }
        if (string.equals("!")) {
            return string;
        }
        String string2 = null;
        String string3 = string;
        for (String string4 : this.env.tagPrefixes.keySet()) {
            if (!Pattern.matches("^" + string4 + ".+$", string) || !string4.equals("!") && string4.length() >= string.length()) continue;
            string2 = (String)this.env.tagPrefixes.get(string4);
            string3 = string.substring(string4.length());
        }
        if (string2 == null && string.startsWith("tag:") && string.indexOf(58, 4) != -1) {
            String string4;
            int n2 = string.indexOf(46, 4);
            string4 = string.substring(4, n2);
            String string5 = string.substring(string.indexOf(58, 4) + 1);
            string2 = "!" + string4 + "/";
            string3 = string5;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        for (n = 0; n < string3.length(); ++n) {
        }
        if (n3 < n) {
            stringBuffer.append(string3.substring(n3, n));
        }
        String string6 = stringBuffer.toString();
        if (string.charAt(0) == '!' && this.env.isVersion10) {
            return string;
        }
        if (string2 != null) {
            return string2 + string6;
        }
        return "!<" + string6 + ">";
    }

    static ScalarAnalysis analyzeScalar(ByteList byteList) {
        boolean bl;
        if (byteList == null || byteList.realSize == 0) {
            return new ScalarAnalysis(byteList, true, false, false, true, true, true, false, false);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        if (DOC_INDIC.matcher(byteList).matches()) {
            bl2 = true;
            bl3 = true;
        }
        boolean bl14 = true;
        boolean bl15 = byteList.length() == 1 || NULL_BL_T_LINEBR.indexOf(byteList.charAt(1)) != -1;
        boolean bl16 = false;
        boolean bl17 = false;
        boolean bl18 = false;
        boolean bl19 = false;
        int n = 0;
        while (n < byteList.length()) {
            char bl20 = byteList.charAt(n);
            if (n == 0) {
                if (SPECIAL_INDIC.indexOf(bl20) != -1) {
                    bl3 = true;
                    bl2 = true;
                }
                if (bl20 == '?' || bl20 == ':') {
                    bl3 = true;
                    if (bl15) {
                        bl2 = true;
                    }
                }
                if (bl20 == '-' && bl15) {
                    bl3 = true;
                    bl2 = true;
                }
            } else {
                if (FLOW_INDIC.indexOf(bl20) != -1) {
                    bl3 = true;
                }
                if (bl20 == ':') {
                    bl3 = true;
                    if (bl15) {
                        bl2 = true;
                    }
                }
                if (bl20 == '#' && bl14) {
                    bl3 = true;
                    bl2 = true;
                }
            }
            if (bl20 == '\n') {
                bl4 = true;
            }
            if (bl20 != '\n' && (' ' > bl20 || bl20 > '~')) {
                bl5 = true;
            }
            if (' ' == bl20 || '\n' == bl20) {
                if (bl16 && bl17) {
                    if (bl20 != ' ') {
                        bl18 = true;
                    }
                } else if (bl16) {
                    if (bl20 != ' ') {
                        bl17 = true;
                        bl18 = true;
                    }
                } else if (bl17) {
                    if (bl20 == ' ') {
                        bl16 = true;
                    }
                } else {
                    boolean bl21 = bl19 = n == 0;
                    if (bl20 == ' ') {
                        bl16 = true;
                    } else {
                        bl17 = true;
                    }
                }
            } else if (bl16 || bl17) {
                if (bl19) {
                    if (bl16 && bl17) {
                        bl13 = true;
                    } else if (bl16) {
                        bl8 = true;
                    } else if (bl17) {
                        bl9 = true;
                    }
                } else if (bl18) {
                    bl13 = true;
                } else if (bl16 && bl17) {
                    bl12 = true;
                } else if (bl16) {
                    bl6 = true;
                } else if (bl17) {
                    bl7 = true;
                }
                bl19 = false;
                bl18 = false;
                bl17 = false;
                bl16 = false;
            }
            if ((bl16 || bl17) && n == byteList.length() - 1) {
                if (bl16 && bl17) {
                    bl13 = true;
                } else if (bl16) {
                    bl10 = true;
                    if (bl19) {
                        bl8 = true;
                    }
                } else if (bl17) {
                    bl11 = true;
                    if (bl19) {
                        bl9 = true;
                    }
                }
                bl19 = false;
                bl18 = false;
                bl17 = false;
                bl16 = false;
            }
            bl14 = NULL_BL_T_LINEBR.indexOf(bl20) != -1;
            bl15 = ++n + 1 >= byteList.length() || NULL_BL_T_LINEBR.indexOf(byteList.charAt(n + 1)) != -1;
        }
        boolean bl22 = true;
        boolean bl23 = true;
        boolean bl24 = true;
        boolean bl25 = true;
        boolean bl26 = true;
        if (bl8 || bl9 || bl10) {
            bl24 = false;
            bl26 = false;
            bl23 = false;
            boolean bl27 = false;
        }
        if (bl11) {
            bl23 = false;
            boolean bl28 = false;
        }
        if (bl12) {
            bl24 = false;
            bl23 = false;
            boolean bl29 = false;
        }
        if (bl13 || bl5) {
            bl26 = false;
            bl24 = false;
            bl23 = false;
            boolean bl30 = false;
        }
        if (bl7) {
            bl24 = false;
            bl23 = false;
            boolean bl31 = false;
        }
        if (bl11) {
            bl24 = false;
        }
        if (bl4) {
            bl23 = false;
            boolean bl32 = false;
        }
        if (bl3) {
            bl = false;
        }
        if (bl2) {
            bl23 = false;
        }
        return new ScalarAnalysis(byteList, false, bl4, bl, bl23, bl24, bl25, bl26, bl5);
    }

    static String determineChomp(ByteList byteList) {
        int n = 32;
        int n2 = 32;
        if (byteList.realSize > 0) {
            n = (char)(byteList.bytes[byteList.realSize - 1] & 0xFF);
            if (byteList.realSize > 1) {
                n2 = (char)(byteList.bytes[byteList.realSize - 2] & 0xFF);
            }
        }
        return n == 10 ? (n2 == 10 ? "+" : "") : "-";
    }

    public static void main(String[] stringArray) throws IOException {
        String string = stringArray[0];
        System.out.println("File contents:");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        int n = -1;
        while ((n = bufferedInputStream.read()) != -1) {
            System.out.print((char)n);
        }
        bufferedInputStream.close();
        System.out.println("--------------------------------");
        EmitterImpl emitterImpl = new EmitterImpl(System.out, YAML.config());
        ParserImpl parserImpl = new ParserImpl(new ScannerImpl(new FileInputStream(string)));
        Iterator iterator = parserImpl.eachEvent();
        while (iterator.hasNext()) {
            emitterImpl.emit((Event)iterator.next());
        }
    }

    static {
        EmitterImpl.STATES[0] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) {
                emitterEnvironment.expectStreamStart();
            }
        };
        EmitterImpl.STATES[1] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) throws IOException {
                emitterEnvironment.expectDocumentStart(true);
            }
        };
        EmitterImpl.STATES[2] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) throws IOException {
                emitterEnvironment.expectDocumentRoot();
            }
        };
        EmitterImpl.STATES[3] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) {
                emitterEnvironment.expectNothing();
            }
        };
        EmitterImpl.STATES[4] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) throws IOException {
                emitterEnvironment.expectDocumentStart(false);
            }
        };
        EmitterImpl.STATES[5] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) throws IOException {
                emitterEnvironment.expectDocumentEnd();
            }
        };
        EmitterImpl.STATES[6] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) throws IOException {
                emitterEnvironment.expectFirstFlowSequenceItem();
            }
        };
        EmitterImpl.STATES[7] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) throws IOException {
                emitterEnvironment.expectFlowSequenceItem();
            }
        };
        EmitterImpl.STATES[8] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) throws IOException {
                emitterEnvironment.expectFirstFlowMappingKey();
            }
        };
        EmitterImpl.STATES[9] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) throws IOException {
                emitterEnvironment.expectFlowMappingSimpleValue();
            }
        };
        EmitterImpl.STATES[10] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) throws IOException {
                emitterEnvironment.expectFlowMappingValue();
            }
        };
        EmitterImpl.STATES[11] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) throws IOException {
                emitterEnvironment.expectFlowMappingKey();
            }
        };
        EmitterImpl.STATES[12] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) throws IOException {
                emitterEnvironment.expectBlockSequenceItem(false);
            }
        };
        EmitterImpl.STATES[13] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) throws IOException {
                emitterEnvironment.expectFirstBlockMappingKey();
            }
        };
        EmitterImpl.STATES[14] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) throws IOException {
                emitterEnvironment.expectBlockMappingSimpleValue();
            }
        };
        EmitterImpl.STATES[15] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) throws IOException {
                emitterEnvironment.expectBlockMappingValue();
            }
        };
        EmitterImpl.STATES[16] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) throws IOException {
                emitterEnvironment.expectBlockMappingKey(false);
            }
        };
        EmitterImpl.STATES[17] = new EmitterState(){

            public void expect(EmitterEnvironment emitterEnvironment) throws IOException {
                emitterEnvironment.expectBlockSequenceItem(true);
            }
        };
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("tag:yaml.org,2002:", "!");
        DEFAULT_TAG_PREFIXES_1_0 = Collections.unmodifiableMap(hashMap);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("!", "!");
        hashMap2.put("tag:yaml.org,2002:", "!!");
        DEFAULT_TAG_PREFIXES_1_1 = Collections.unmodifiableMap(hashMap2);
        HANDLE_FORMAT = Pattern.compile("^![-\\w]*!$");
        ANCHOR_FORMAT = Pattern.compile("^[-\\w]*$");
        DOC_INDIC = Pattern.compile("^(---|\\.\\.\\.)");
        FIRST_SPACE = Pattern.compile("(^|\n) ");
    }

    private static class EmitterEnvironment {
        public List states = new ArrayList();
        public int state = 0;
        public List events = new ArrayList();
        public Event event;
        public int flowLevel = 0;
        public List indents = new ArrayList();
        public int indent = -1;
        public boolean rootContext = false;
        public boolean sequenceContext = false;
        public boolean mappingContext = false;
        public boolean simpleKeyContext = false;
        public int line = 0;
        public int column = 0;
        public boolean whitespace = true;
        public boolean indentation = true;
        public boolean canonical = false;
        public int bestIndent = 2;
        public int bestWidth = 80;
        public ByteList bestLinebreak = ByteList.create("\n");
        public Map tagPrefixes;
        public String preparedAnchor;
        public String preparedTag;
        public ScalarAnalysis analysis;
        public char style = '\u0000';
        public EmitterImpl emitter;
        public boolean isVersion10 = false;

        private EmitterEnvironment() {
        }

        public boolean needMoreEvents() {
            if (this.events.isEmpty()) {
                return true;
            }
            this.event = (Event)this.events.get(0);
            if (this.event instanceof DocumentStartEvent) {
                return this.needEvents(1);
            }
            if (this.event instanceof SequenceStartEvent) {
                return this.needEvents(2);
            }
            if (this.event instanceof MappingStartEvent) {
                return this.needEvents(3);
            }
            return false;
        }

        private boolean needEvents(int n) {
            int n2 = 0;
            Iterator iterator = this.events.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof DocumentStartEvent || e instanceof CollectionStartEvent) {
                    ++n2;
                } else if (e instanceof DocumentEndEvent || e instanceof CollectionEndEvent) {
                    --n2;
                } else if (e instanceof StreamEndEvent) {
                    n2 = -1;
                }
                if (n2 >= 0) continue;
                return false;
            }
            return this.events.size() < n + 1;
        }

        private void increaseIndent(boolean bl, boolean bl2) {
            this.indents.add(0, new Integer(this.indent));
            if (this.indent == -1) {
                this.indent = bl ? this.bestIndent : 0;
            } else if (!bl2) {
                this.indent += this.bestIndent;
            }
        }

        public void expectStreamStart() {
            if (!(this.event instanceof StreamStartEvent)) {
                throw new EmitterException("expected StreamStartEvent, but got " + this.event);
            }
            this.emitter.writeStreamStart();
            this.state = 1;
        }

        public void expectNothing() {
            throw new EmitterException("expecting nothing, but got " + this.event);
        }

        public void expectDocumentStart(boolean bl) throws IOException {
            if (this.event instanceof DocumentStartEvent) {
                boolean bl2;
                DocumentStartEvent documentStartEvent = (DocumentStartEvent)this.event;
                if (bl) {
                    if (null != documentStartEvent.getVersion()) {
                        this.emitter.writeVersionDirective(EmitterImpl.prepareVersion(documentStartEvent.getVersion()));
                    }
                    if (null != documentStartEvent.getVersion() && documentStartEvent.getVersion()[1] == 0 || this.emitter.getOptions().version().equals("1.0")) {
                        this.isVersion10 = true;
                        this.tagPrefixes = new HashMap(DEFAULT_TAG_PREFIXES_1_0);
                    } else {
                        this.tagPrefixes = new HashMap(DEFAULT_TAG_PREFIXES_1_1);
                    }
                    if (null != documentStartEvent.getTags()) {
                        TreeSet treeSet = new TreeSet();
                        treeSet.addAll(documentStartEvent.getTags().keySet());
                        for (String string : treeSet) {
                            String string2 = (String)documentStartEvent.getTags().get(string);
                            this.tagPrefixes.put(string2, string);
                            String string3 = EmitterImpl.prepareTagHandle(string);
                            String string4 = EmitterImpl.prepareTagPrefix(string2);
                            this.emitter.writeTagDirective(string3, string4);
                        }
                    }
                }
                boolean bl3 = bl2 = bl && !documentStartEvent.getExplicit() && !this.canonical && documentStartEvent.getVersion() == null && documentStartEvent.getTags() == null && !this.checkEmptyDocument();
                if (!bl2) {
                    this.emitter.writeIndent();
                    this.emitter.writeIndicator(ByteList.create("--- "), true, true, false);
                    if (this.canonical) {
                        this.emitter.writeIndent();
                    }
                }
                this.state = 2;
            } else if (this.event instanceof StreamEndEvent) {
                this.emitter.writeStreamEnd();
                this.state = 3;
            } else {
                throw new EmitterException("expected DocumentStartEvent, but got " + this.event);
            }
        }

        public void expectDocumentRoot() throws IOException {
            this.states.add(0, new Integer(5));
            this.expectNode(true, false, false, false);
        }

        public void expectDocumentEnd() throws IOException {
            if (this.event instanceof DocumentEndEvent) {
                this.emitter.writeIndent();
                if (((DocumentEndEvent)this.event).getExplicit()) {
                    this.emitter.writeIndicator(ByteList.create("..."), true, false, false);
                    this.emitter.writeIndent();
                }
            } else {
                throw new EmitterException("expected DocumentEndEvent, but got " + this.event);
            }
            this.emitter.flushStream();
            this.state = 4;
        }

        public void expectFirstFlowSequenceItem() throws IOException {
            if (this.event instanceof SequenceEndEvent) {
                this.indent = (Integer)this.indents.remove(0);
                --this.flowLevel;
                this.emitter.writeIndicator(ByteList.create("]"), false, false, false);
                this.state = (Integer)this.states.remove(0);
            } else {
                if (this.canonical || this.column > this.bestWidth) {
                    this.emitter.writeIndent();
                }
                this.states.add(0, new Integer(7));
                this.expectNode(false, true, false, false);
            }
        }

        public void expectFlowSequenceItem() throws IOException {
            if (this.event instanceof SequenceEndEvent) {
                this.indent = (Integer)this.indents.remove(0);
                --this.flowLevel;
                if (this.canonical) {
                    this.emitter.writeIndicator(ByteList.create(","), false, false, false);
                    this.emitter.writeIndent();
                }
                this.emitter.writeIndicator(ByteList.create("]"), false, false, false);
                this.state = (Integer)this.states.remove(0);
            } else {
                this.emitter.writeIndicator(ByteList.create(","), false, false, false);
                if (this.canonical || this.column > this.bestWidth) {
                    this.emitter.writeIndent();
                }
                this.states.add(0, new Integer(7));
                this.expectNode(false, true, false, false);
            }
        }

        public void expectFirstFlowMappingKey() throws IOException {
            if (this.event instanceof MappingEndEvent) {
                this.indent = (Integer)this.indents.remove(0);
                --this.flowLevel;
                this.emitter.writeIndicator(ByteList.create("}"), false, false, false);
                this.state = (Integer)this.states.remove(0);
            } else {
                if (this.canonical || this.column > this.bestWidth) {
                    this.emitter.writeIndent();
                }
                if (!this.canonical && this.checkSimpleKey()) {
                    this.states.add(0, new Integer(9));
                    this.expectNode(false, false, true, true);
                } else {
                    this.emitter.writeIndicator(ByteList.create("?"), true, false, false);
                    this.states.add(0, new Integer(10));
                    this.expectNode(false, false, true, false);
                }
            }
        }

        public void expectFlowMappingSimpleValue() throws IOException {
            this.emitter.writeIndicator(ByteList.create(": "), false, true, false);
            this.states.add(0, new Integer(11));
            this.expectNode(false, false, true, false);
        }

        public void expectFlowMappingValue() throws IOException {
            if (this.canonical || this.column > this.bestWidth) {
                this.emitter.writeIndent();
            }
            this.emitter.writeIndicator(ByteList.create(": "), false, true, false);
            this.states.add(0, new Integer(11));
            this.expectNode(false, false, true, false);
        }

        public void expectFlowMappingKey() throws IOException {
            if (this.event instanceof MappingEndEvent) {
                this.indent = (Integer)this.indents.remove(0);
                --this.flowLevel;
                if (this.canonical) {
                    this.emitter.writeIndicator(ByteList.create(","), false, false, false);
                    this.emitter.writeIndent();
                }
                this.emitter.writeIndicator(ByteList.create("}"), false, false, false);
                this.state = (Integer)this.states.remove(0);
            } else {
                this.emitter.writeIndicator(ByteList.create(","), false, false, false);
                if (this.canonical || this.column > this.bestWidth) {
                    this.emitter.writeIndent();
                }
                if (!this.canonical && this.checkSimpleKey()) {
                    this.states.add(0, new Integer(9));
                    this.expectNode(false, false, true, true);
                } else {
                    this.emitter.writeIndicator(ByteList.create("?"), true, false, false);
                    this.states.add(0, new Integer(10));
                    this.expectNode(false, false, true, false);
                }
            }
        }

        public void expectBlockSequenceItem(boolean bl) throws IOException {
            if (!bl && this.event instanceof SequenceEndEvent) {
                this.indent = (Integer)this.indents.remove(0);
                this.state = (Integer)this.states.remove(0);
            } else {
                this.emitter.writeIndent();
                this.emitter.writeIndicator(ByteList.create("-"), true, false, true);
                this.states.add(0, new Integer(12));
                this.expectNode(false, true, false, false);
            }
        }

        public void expectFirstBlockMappingKey() throws IOException {
            this.expectBlockMappingKey(true);
        }

        public void expectBlockMappingSimpleValue() throws IOException {
            this.emitter.writeIndicator(ByteList.create(": "), false, true, false);
            this.states.add(0, new Integer(16));
            this.expectNode(false, false, true, false);
        }

        public void expectBlockMappingValue() throws IOException {
            this.emitter.writeIndent();
            this.emitter.writeIndicator(ByteList.create(": "), true, true, true);
            this.states.add(0, new Integer(16));
            this.expectNode(false, false, true, false);
        }

        public void expectBlockMappingKey(boolean bl) throws IOException {
            if (!bl && this.event instanceof MappingEndEvent) {
                this.indent = (Integer)this.indents.remove(0);
                this.state = (Integer)this.states.remove(0);
            } else {
                this.emitter.writeIndent();
                if (this.checkSimpleKey()) {
                    this.states.add(0, new Integer(14));
                    this.expectNode(false, false, true, true);
                } else {
                    this.emitter.writeIndicator(ByteList.create("?"), true, false, true);
                    this.states.add(0, new Integer(15));
                    this.expectNode(false, false, true, false);
                }
            }
        }

        private void expectNode(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
            this.rootContext = bl;
            this.sequenceContext = bl2;
            this.mappingContext = bl3;
            this.simpleKeyContext = bl4;
            if (this.event instanceof AliasEvent) {
                this.expectAlias();
            } else if (this.event instanceof ScalarEvent || this.event instanceof CollectionStartEvent) {
                this.processAnchor(ByteList.create("&"));
                this.processTag();
                if (this.event instanceof ScalarEvent) {
                    this.expectScalar();
                } else if (this.event instanceof SequenceStartEvent) {
                    if (this.flowLevel != 0 || this.canonical || ((SequenceStartEvent)this.event).getFlowStyle() || this.checkEmptySequence()) {
                        this.expectFlowSequence();
                    } else {
                        this.expectBlockSequence();
                    }
                } else if (this.event instanceof MappingStartEvent) {
                    if (this.flowLevel != 0 || this.canonical || ((MappingStartEvent)this.event).getFlowStyle() || this.checkEmptyMapping()) {
                        this.expectFlowMapping();
                    } else {
                        this.expectBlockMapping();
                    }
                }
            } else {
                throw new EmitterException("expected NodeEvent, but got " + this.event);
            }
        }

        private void expectAlias() throws IOException {
            if (((NodeEvent)this.event).getAnchor() == null) {
                throw new EmitterException("anchor is not specified for alias");
            }
            this.processAnchor(ByteList.create("*"));
            this.state = (Integer)this.states.remove(0);
        }

        private void expectScalar() throws IOException {
            this.increaseIndent(true, false);
            this.processScalar();
            this.indent = (Integer)this.indents.remove(0);
            this.state = (Integer)this.states.remove(0);
        }

        private void expectFlowSequence() throws IOException {
            this.emitter.writeIndicator(ByteList.create("["), true, true, false);
            ++this.flowLevel;
            this.increaseIndent(true, false);
            this.state = 6;
        }

        private void expectBlockSequence() throws IOException {
            this.increaseIndent(false, this.mappingContext && !this.indentation);
            this.state = 17;
        }

        private void expectFlowMapping() throws IOException {
            this.emitter.writeIndicator(ByteList.create("{"), true, true, false);
            ++this.flowLevel;
            this.increaseIndent(true, false);
            this.state = 8;
        }

        private void expectBlockMapping() throws IOException {
            this.increaseIndent(false, false);
            this.state = 13;
        }

        private boolean checkEmptySequence() {
            return this.event instanceof SequenceStartEvent && !this.events.isEmpty() && this.events.get(0) instanceof SequenceEndEvent;
        }

        private boolean checkEmptyMapping() {
            return this.event instanceof MappingStartEvent && !this.events.isEmpty() && this.events.get(0) instanceof MappingEndEvent;
        }

        private boolean checkEmptyDocument() {
            if (!(this.event instanceof DocumentStartEvent) || this.events.isEmpty()) {
                return false;
            }
            Event event = (Event)this.events.get(0);
            return event instanceof ScalarEvent && ((ScalarEvent)event).getAnchor() == null && ((ScalarEvent)event).getTag() == null && ((ScalarEvent)event).getImplicit() != null && ((ScalarEvent)event).getValue().realSize == 0;
        }

        private boolean checkSimpleKey() {
            int n = 0;
            if (this.event instanceof NodeEvent && null != ((NodeEvent)this.event).getAnchor()) {
                if (null == this.preparedAnchor) {
                    this.preparedAnchor = EmitterImpl.prepareAnchor(((NodeEvent)this.event).getAnchor());
                }
                n += this.preparedAnchor.length();
            }
            String string = null;
            if (this.event instanceof ScalarEvent) {
                string = ((ScalarEvent)this.event).getTag();
            } else if (this.event instanceof CollectionStartEvent) {
                string = ((CollectionStartEvent)this.event).getTag();
            }
            if (string != null) {
                if (null == this.preparedTag) {
                    this.preparedTag = this.emitter.prepareTag(string);
                }
                n += this.preparedTag.length();
            }
            if (this.event instanceof ScalarEvent && null == this.analysis) {
                this.analysis = EmitterImpl.analyzeScalar(((ScalarEvent)this.event).getValue());
                n += this.analysis.scalar.length();
            }
            return n < 128 && (this.event instanceof AliasEvent || this.event instanceof ScalarEvent && !this.analysis.multiline || this.checkEmptySequence() || this.checkEmptyMapping());
        }

        private void processAnchor(ByteList byteList) throws IOException {
            NodeEvent nodeEvent = (NodeEvent)this.event;
            if (null == nodeEvent.getAnchor()) {
                this.preparedAnchor = null;
                return;
            }
            if (null == this.preparedAnchor) {
                this.preparedAnchor = EmitterImpl.prepareAnchor(nodeEvent.getAnchor());
            }
            if (this.preparedAnchor != null && !"".equals(this.preparedAnchor)) {
                byteList.append(this.preparedAnchor.getBytes());
                if (nodeEvent instanceof CollectionStartEvent) {
                    this.indentation = true;
                }
                this.emitter.writeIndicator(byteList, true, false, true);
            }
            this.preparedAnchor = null;
        }

        private void processTag() throws IOException {
            String string = null;
            if (this.event instanceof ScalarEvent) {
                ScalarEvent scalarEvent = (ScalarEvent)this.event;
                string = scalarEvent.getTag();
                if (this.style == '\u0000') {
                    this.style = this.chooseScalarStyle();
                }
                if ((!this.canonical || string == null) && ('\u0000' == this.style && scalarEvent.getImplicit()[0] || '\u0000' != this.style && scalarEvent.getImplicit()[1])) {
                    this.preparedTag = null;
                    return;
                }
                if (scalarEvent.getImplicit()[0] && null == string) {
                    string = "!";
                    this.preparedTag = null;
                }
            } else {
                CollectionStartEvent collectionStartEvent = (CollectionStartEvent)this.event;
                string = collectionStartEvent.getTag();
                if ((!this.canonical || string == null) && collectionStartEvent.getImplicit()) {
                    this.preparedTag = null;
                    return;
                }
                this.indentation = true;
            }
            if (string == null) {
                throw new EmitterException("tag is not specified");
            }
            if (null == this.preparedTag) {
                this.preparedTag = this.emitter.prepareTag(string);
            }
            if (this.preparedTag != null && !"".equals(this.preparedTag)) {
                this.emitter.writeIndicator(ByteList.create(this.preparedTag), true, false, true);
            }
            this.preparedTag = null;
        }

        private char chooseScalarStyle() {
            ScalarEvent scalarEvent = (ScalarEvent)this.event;
            if (null == this.analysis) {
                this.analysis = EmitterImpl.analyzeScalar(scalarEvent.getValue());
            }
            if (scalarEvent.getStyle() == '\"' || this.canonical || this.analysis.empty && scalarEvent.getTag().equals("tag:yaml.org,2002:str")) {
                return '\"';
            }
            if (scalarEvent.getStyle() == '\u0000' && (!this.simpleKeyContext || !this.analysis.empty && !this.analysis.multiline) && (this.flowLevel != 0 && this.analysis.allowFlowPlain || this.flowLevel == 0 && this.analysis.allowBlockPlain)) {
                return '\u0000';
            }
            if (scalarEvent.getStyle() == '\u0000' && scalarEvent.getImplicit()[0] && (!this.simpleKeyContext || !this.analysis.empty && !this.analysis.multiline) && (this.flowLevel != 0 && this.analysis.allowFlowPlain || this.flowLevel == 0 && this.analysis.allowBlockPlain)) {
                return '\u0000';
            }
            if ((scalarEvent.getStyle() == '|' || scalarEvent.getStyle() == '>') && this.flowLevel == 0 && this.analysis.allowBlock) {
                return '\'';
            }
            if (!(scalarEvent.getStyle() != '\u0000' && scalarEvent.getStyle() != '\'' || !this.analysis.allowSingleQuoted || this.simpleKeyContext && this.analysis.multiline)) {
                return '\'';
            }
            if (this.analysis.multiline && !FIRST_SPACE.matcher(scalarEvent.getValue()).find() && !this.analysis.specialCharacters) {
                return '|';
            }
            return '\"';
        }

        private void processScalar() throws IOException {
            boolean bl;
            ScalarEvent scalarEvent = (ScalarEvent)this.event;
            if (null == this.analysis) {
                this.analysis = EmitterImpl.analyzeScalar(scalarEvent.getValue());
            }
            if ('\u0000' == this.style) {
                this.style = this.chooseScalarStyle();
            }
            boolean bl2 = bl = !this.simpleKeyContext;
            if (this.style == '\"') {
                this.emitter.writeDoubleQuoted(this.analysis.scalar, bl);
            } else if (this.style == '\'') {
                this.emitter.writeSingleQuoted(this.analysis.scalar, bl);
            } else if (this.style == '>') {
                this.emitter.writeFolded(this.analysis.scalar);
            } else if (this.style == '|') {
                this.emitter.writeLiteral(this.analysis.scalar);
            } else {
                this.emitter.writePlain(this.analysis.scalar, bl);
            }
            this.analysis = null;
            this.style = '\u0000';
        }
    }

    private static interface EmitterState {
        public void expect(EmitterEnvironment var1) throws IOException;
    }

    private static class ScalarAnalysis {
        public ByteList scalar;
        public boolean empty;
        public boolean multiline;
        public boolean allowFlowPlain;
        public boolean allowBlockPlain;
        public boolean allowSingleQuoted;
        public boolean allowDoubleQuoted;
        public boolean allowBlock;
        public boolean specialCharacters;

        public ScalarAnalysis(ByteList byteList, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
            this.scalar = byteList;
            this.empty = bl;
            this.multiline = bl2;
            this.allowFlowPlain = bl3;
            this.allowBlockPlain = bl4;
            this.allowSingleQuoted = bl5;
            this.allowDoubleQuoted = bl6;
            this.allowBlock = bl7;
            this.specialCharacters = bl8;
        }
    }
}

