/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jruby.util.ByteList;
import org.jvyamlb.Composer;
import org.jvyamlb.ComposerImpl;
import org.jvyamlb.Constructor;
import org.jvyamlb.ConstructorException;
import org.jvyamlb.ParserImpl;
import org.jvyamlb.PrivateType;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.nodes.LinkNode;
import org.jvyamlb.nodes.MappingNode;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.ScalarNode;
import org.jvyamlb.nodes.SequenceNode;

public class BaseConstructorImpl
implements Constructor {
    private static final Map yamlConstructors = new HashMap();
    private static final Map yamlMultiConstructors = new HashMap();
    private static final Map yamlMultiRegexps = new HashMap();
    private Composer composer;
    private Map recursiveObjects = new HashMap();
    public static final Constructor.YamlConstructor CONSTRUCT_PRIMITIVE = new Constructor.YamlConstructor(){

        public Object call(Constructor constructor, Node node) {
            return constructor.constructPrimitive(node);
        }
    };
    public static final Constructor.YamlConstructor CONSTRUCT_SCALAR = new Constructor.YamlConstructor(){

        public Object call(Constructor constructor, Node node) {
            return constructor.constructScalar(node);
        }
    };
    public static final Constructor.YamlConstructor CONSTRUCT_PRIVATE = new Constructor.YamlConstructor(){

        public Object call(Constructor constructor, Node node) {
            return constructor.constructPrivateType(node);
        }
    };
    public static final Constructor.YamlConstructor CONSTRUCT_SEQUENCE = new Constructor.YamlConstructor(){

        public Object call(Constructor constructor, Node node) {
            return constructor.constructSequence(node);
        }
    };
    public static final Constructor.YamlConstructor CONSTRUCT_MAPPING = new Constructor.YamlConstructor(){

        public Object call(Constructor constructor, Node node) {
            return constructor.constructMapping(node);
        }
    };

    public Constructor.YamlConstructor getYamlConstructor(Object object) {
        return (Constructor.YamlConstructor)yamlConstructors.get(object);
    }

    public Constructor.YamlMultiConstructor getYamlMultiConstructor(Object object) {
        return (Constructor.YamlMultiConstructor)yamlMultiConstructors.get(object);
    }

    public Pattern getYamlMultiRegexp(Object object) {
        return (Pattern)yamlMultiRegexps.get(object);
    }

    public Set getYamlMultiRegexps() {
        return yamlMultiRegexps.keySet();
    }

    public static void addConstructor(String string, Constructor.YamlConstructor yamlConstructor) {
        yamlConstructors.put(string, yamlConstructor);
    }

    public static void addMultiConstructor(String string, Constructor.YamlMultiConstructor yamlMultiConstructor) {
        yamlMultiConstructors.put(string, yamlMultiConstructor);
        yamlMultiRegexps.put(string, Pattern.compile("^" + string));
    }

    public BaseConstructorImpl(Composer composer) {
        this.composer = composer;
    }

    public boolean checkData() {
        return this.composer.checkNode();
    }

    public Object getData() {
        Node node;
        if (this.composer.checkNode() && null != (node = this.composer.getNode())) {
            return this.constructDocument(node);
        }
        return null;
    }

    public Iterator eachDocument() {
        return new DocumentIterator();
    }

    public Iterator iterator() {
        return this.eachDocument();
    }

    public Object constructDocument(Node node) {
        Object object = this.constructObject(node);
        this.recursiveObjects.clear();
        return object;
    }

    public Node getNullNode() {
        return new ScalarNode("tag:yaml.org,2002:null", null, '\u0000');
    }

    public Object constructObject(Node node) {
        if (node == null) {
            node = this.getNullNode();
        }
        if (this.recursiveObjects.containsKey(node)) {
            LinkNode linkNode = new LinkNode();
            linkNode.setValue(node);
            return linkNode;
        }
        this.recursiveObjects.put(node, new ArrayList());
        Constructor.YamlConstructor yamlConstructor = this.getYamlConstructor(node.getTag());
        if (yamlConstructor == null) {
            boolean bl = true;
            for (String string : this.getYamlMultiRegexps()) {
                Pattern pattern = this.getYamlMultiRegexp(string);
                if (!pattern.matcher(node.getTag()).find()) continue;
                String string2 = node.getTag().substring(string.length());
                yamlConstructor = new YamlMultiAdapter(this.getYamlMultiConstructor(string), string2);
                bl = false;
                break;
            }
            if (bl) {
                Constructor.YamlMultiConstructor yamlMultiConstructor = this.getYamlMultiConstructor(null);
                if (null != yamlMultiConstructor) {
                    yamlConstructor = new YamlMultiAdapter(yamlMultiConstructor, node.getTag());
                } else {
                    yamlConstructor = this.getYamlConstructor(null);
                    if (yamlConstructor == null) {
                        yamlConstructor = CONSTRUCT_PRIMITIVE;
                    }
                }
            }
        }
        Object object = yamlConstructor.call(this, node);
        this.doRecursionFix(node, object);
        return object;
    }

    public void doRecursionFix(Node node, Object object) {
        List list = (List)this.recursiveObjects.remove(node);
        if (null != list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((Constructor.RecursiveFixer)iterator.next()).replace(node, object);
            }
        }
    }

    public Object constructPrimitive(Node node) {
        if (node instanceof ScalarNode) {
            return this.constructScalar(node);
        }
        if (node instanceof SequenceNode) {
            return this.constructSequence(node);
        }
        if (node instanceof MappingNode) {
            return this.constructMapping(node);
        }
        System.err.println(node.getTag());
        return null;
    }

    public Object constructScalar(Node node) {
        if (!(node instanceof ScalarNode)) {
            if (node instanceof MappingNode) {
                Map map = (Map)node.getValue();
                for (Node node2 : map.keySet()) {
                    if (!"tag:yaml.org,2002:value".equals(node2.getTag())) continue;
                    return this.constructScalar((Node)map.get(node2));
                }
            }
            throw new ConstructorException(null, "expected a scalar node, but found " + node.getClass().getName(), null);
        }
        return node.getValue();
    }

    public Object constructPrivateType(Node node) {
        Object object = null;
        object = node.getValue() instanceof Map ? this.constructMapping(node) : (node.getValue() instanceof List ? this.constructSequence(node) : node.getValue().toString());
        return new PrivateType(node.getTag(), object);
    }

    public Object constructSequence(Node node) {
        if (!(node instanceof SequenceNode)) {
            throw new ConstructorException(null, "expected a sequence node, but found " + node.getClass().getName(), null);
        }
        List list = (List)node.getValue();
        final ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = this.constructObject((Node)iterator.next());
            if (object instanceof LinkNode) {
                final int n = arrayList.size();
                this.addFixer((Node)((LinkNode)object).getValue(), new Constructor.RecursiveFixer(){

                    public void replace(Node node, Object object) {
                        arrayList.set(n, object);
                    }
                });
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    public Object constructMapping(Node node) {
        if (!(node instanceof MappingNode)) {
            throw new ConstructorException(null, "expected a mapping node, but found " + node.getClass().getName(), null);
        }
        final Map[] mapArray = new Map[]{new HashMap()};
        LinkedList<Map> linkedList = null;
        Map map = (Map)node.getValue();
        for (Node node2 : map.keySet()) {
            Iterator iterator;
            Object object;
            Node node3 = (Node)map.get(node2);
            if (node2.getTag().equals("tag:yaml.org,2002:merge")) {
                if (linkedList != null) {
                    throw new ConstructorException("while constructing a mapping", "found duplicate merge key", null);
                }
                if (node3 instanceof MappingNode) {
                    linkedList = new LinkedList<Map>();
                    linkedList.add((Map)this.constructMapping(node3));
                    continue;
                }
                if (node3 instanceof SequenceNode) {
                    linkedList = new LinkedList();
                    object = (List)node3.getValue();
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Node node4 = (Node)iterator.next();
                        if (!(node4 instanceof MappingNode)) {
                            throw new ConstructorException("while constructing a mapping", "expected a mapping for merging, but found " + node4.getClass().getName(), null);
                        }
                        linkedList.add(0, (Map)this.constructMapping(node4));
                    }
                    continue;
                }
                throw new ConstructorException("while constructing a mapping", "expected a mapping or list of mappings for merging, but found " + node3.getClass().getName(), null);
            }
            if (node2.getTag().equals("tag:yaml.org,2002:value")) {
                if (mapArray[0].containsKey("=")) {
                    throw new ConstructorException("while construction a mapping", "found duplicate value key", null);
                }
                mapArray[0].put("=", this.constructObject(node3));
                continue;
            }
            object = this.constructObject(node2);
            iterator = this.constructObject(node3);
            if (iterator instanceof LinkNode) {
                this.addFixer((Node)((LinkNode)((Object)iterator)).getValue(), new Constructor.RecursiveFixer(){

                    public void replace(Node node, Object object2) {
                        mapArray[0].put(object, object2);
                    }
                });
            }
            mapArray[0].put(object, iterator);
        }
        if (null != linkedList) {
            linkedList.add(mapArray[0]);
            mapArray[0] = new HashMap();
            Iterator<Object> iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                mapArray[0].putAll((Map)iterator.next());
            }
        }
        return mapArray[0];
    }

    public void addFixer(Node node, Constructor.RecursiveFixer recursiveFixer) {
        ArrayList<Constructor.RecursiveFixer> arrayList = (ArrayList<Constructor.RecursiveFixer>)this.recursiveObjects.get(node);
        if (arrayList == null) {
            arrayList = new ArrayList<Constructor.RecursiveFixer>();
            this.recursiveObjects.put(node, arrayList);
        }
        arrayList.add(recursiveFixer);
    }

    public Object constructPairs(Node node) {
        if (!(node instanceof MappingNode)) {
            throw new ConstructorException(null, "expected a mapping node, but found " + node.getClass().getName(), null);
        }
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        Map map = (Map)node.getValue();
        for (Node node2 : map.keySet()) {
            Node node3 = (Node)map.get(node2);
            linkedList.add(new Object[]{this.constructObject(node2), this.constructObject(node3)});
        }
        return linkedList;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        System.out.println("Reading of file: \"" + string + "\"");
        ByteList byteList = new ByteList(1024);
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[1024];
        int n = 0;
        do {
            n = ((InputStream)fileInputStream).read(byArray);
            byteList.append(byArray, 0, n);
        } while (n >= 1024);
        ((InputStream)fileInputStream).close();
        long l = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            BaseConstructorImpl baseConstructorImpl = new BaseConstructorImpl(new ComposerImpl(new ParserImpl(new ScannerImpl(byteList)), new ResolverImpl()));
            Iterator iterator = baseConstructorImpl.eachDocument();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        double d = (double)(l2 - l) / 1000.0;
        System.out.println("Walking through the nodes for the file: " + string + " took " + l3 + "ms, or " + d + " seconds");
    }

    public static class YamlMultiAdapter
    implements Constructor.YamlConstructor {
        private Constructor.YamlMultiConstructor ctor;
        private String prefix;

        public YamlMultiAdapter(Constructor.YamlMultiConstructor yamlMultiConstructor, String string) {
            this.ctor = yamlMultiConstructor;
            this.prefix = string;
        }

        public Object call(Constructor constructor, Node node) {
            return this.ctor.call(constructor, this.prefix, node);
        }
    }

    private class DocumentIterator
    implements Iterator {
        private DocumentIterator() {
        }

        public boolean hasNext() {
            return BaseConstructorImpl.this.checkData();
        }

        public Object next() {
            return BaseConstructorImpl.this.getData();
        }

        public void remove() {
        }
    }
}

