/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

public class SafePropertyAccessor {
    public static boolean getBoolean(String string) {
        try {
            return Boolean.getBoolean(string);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static boolean getBoolean(String string, boolean bl) {
        try {
            if (System.getProperty(string) != null) {
                return Boolean.getBoolean(string);
            }
            return bl;
        }
        catch (SecurityException securityException) {
            return bl;
        }
    }

    public static String getProperty(String string) {
        return SafePropertyAccessor.getProperty(string, null);
    }

    public static String getProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    public static int getInt(String string) {
        return SafePropertyAccessor.getInt(string, 0);
    }

    public static int getInt(String string, int n) {
        try {
            return Integer.parseInt(System.getProperty(string, String.valueOf(n)));
        }
        catch (SecurityException securityException) {
            return n;
        }
    }

    public static boolean isSecurityProtected(String string) {
        try {
            System.getProperty(string);
            return false;
        }
        catch (SecurityException securityException) {
            return true;
        }
    }
}

