/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Pattern;
import org.jruby.util.JRubyFile;

public class JavaNameMangler {
    public static final Pattern PATH_SPLIT = Pattern.compile("[/\\\\]");

    public static String mangledFilenameForStartupClasspath(String string) {
        if (string.equals("-e")) {
            return "__dash_e__";
        }
        return JavaNameMangler.mangleFilenameForClasspath(string, null, "ruby");
    }

    public static String mangleFilenameForClasspath(String string) {
        return JavaNameMangler.mangleFilenameForClasspath(string, null, "ruby");
    }

    public static String mangleFilenameForClasspath(String string, String string2, String string3) {
        try {
            Object object;
            String string4 = "";
            if (string.indexOf("!") != -1) {
                object = string.substring(6, string.indexOf("!"));
                string4 = new JRubyFile((String)object + string.substring(string.indexOf("!") + 1)).getCanonicalPath().toString();
            } else {
                try {
                    string4 = new JRubyFile(string).getCanonicalPath().toString();
                }
                catch (IOException iOException) {
                    string4 = string;
                }
            }
            if (string2 != null && string2.length() > 0) {
                try {
                    object = new JRubyFile(string2).getCanonicalPath().toString();
                }
                catch (IOException iOException) {
                    object = string2;
                }
                if (!string4.startsWith((String)object)) {
                    throw new FileNotFoundException("File path " + string4 + " does not start with parent path " + (String)object);
                }
                int n = ((String)object).length();
                string4 = string4.substring(n);
            }
            object = PATH_SPLIT.split(string4);
            StringBuffer stringBuffer = new StringBuffer(string3);
            for (String string5 : object) {
                if (string5.length() <= 0) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("/");
                }
                if (!Character.isJavaIdentifierStart(string5.charAt(0))) {
                    stringBuffer.append("$");
                }
                stringBuffer.append(JavaNameMangler.mangleStringForCleanJavaIdentifier(string5));
            }
            int n = stringBuffer.indexOf("_dot_rb");
            if (n != -1 && n == stringBuffer.length() - 7) {
                stringBuffer.delete(n, n + 7);
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    public static String mangleStringForCleanJavaIdentifier(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        block15: for (int i = 0; i < cArray.length; ++i) {
            if (i == 0 && Character.isJavaIdentifierStart(cArray[i]) || Character.isJavaIdentifierPart(cArray[i])) {
                stringBuffer.append(cArray[i]);
                bl = false;
                continue;
            }
            if (!bl) {
                stringBuffer.append("_");
            }
            bl = true;
            switch (cArray[i]) {
                case '?': {
                    stringBuffer.append("p_");
                    continue block15;
                }
                case '!': {
                    stringBuffer.append("b_");
                    continue block15;
                }
                case '<': {
                    stringBuffer.append("lt_");
                    continue block15;
                }
                case '>': {
                    stringBuffer.append("gt_");
                    continue block15;
                }
                case '=': {
                    stringBuffer.append("equal_");
                    continue block15;
                }
                case '[': {
                    if (i + 1 < cArray.length && cArray[i + 1] == ']') {
                        stringBuffer.append("aref_");
                        ++i;
                        continue block15;
                    }
                    stringBuffer.append("lbracket_");
                    continue block15;
                }
                case ']': {
                    stringBuffer.append("rbracket_");
                    continue block15;
                }
                case '+': {
                    stringBuffer.append("plus_");
                    continue block15;
                }
                case '-': {
                    stringBuffer.append("minus_");
                    continue block15;
                }
                case '*': {
                    stringBuffer.append("times_");
                    continue block15;
                }
                case '/': {
                    stringBuffer.append("div_");
                    continue block15;
                }
                case '&': {
                    stringBuffer.append("and_");
                    continue block15;
                }
                case '.': {
                    stringBuffer.append("dot_");
                    continue block15;
                }
                default: {
                    stringBuffer.append(Integer.toHexString(cArray[i])).append("_");
                }
            }
        }
        return stringBuffer.toString();
    }
}

