/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.InputStream;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyString;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOInputStream
extends InputStream {
    private IRubyObject io;
    private InputStream in;
    private final IRubyObject numOne;
    private CallSite readAdapter = new CallSite.InlineCachingCallSite("read", CallType.FUNCTIONAL);

    public IOInputStream(IRubyObject iRubyObject) {
        if (!iRubyObject.respondsTo("read")) {
            throw new IllegalArgumentException("Object: " + iRubyObject + " is not a legal argument to this wrapper, cause it doesn't respond to \"read\".");
        }
        this.io = iRubyObject;
        if (iRubyObject instanceof RubyIO) {
            this.in = ((RubyIO)iRubyObject).getInStream();
        }
        this.numOne = RubyFixnum.one(this.io.getRuntime());
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    public int available() throws IOException {
        if (this.in != null) {
            return this.in.available();
        }
        return 0;
    }

    public int read() throws IOException {
        IRubyObject iRubyObject = this.readAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.numOne);
        int n = -1;
        if (!iRubyObject.isNil()) {
            n = iRubyObject.toString().charAt(0);
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        IRubyObject iRubyObject = this.readAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io.getRuntime().newFixnum(byArray.length));
        int n = -1;
        if (!iRubyObject.isNil()) {
            ByteList byteList = ((RubyString)iRubyObject).getByteList();
            System.arraycopy(byteList.bytes, byteList.begin, byArray, 0, byteList.realSize);
            n = byteList.realSize;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        IRubyObject iRubyObject = this.readAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io.getRuntime().newFixnum(n2));
        int n3 = -1;
        if (!iRubyObject.isNil()) {
            ByteList byteList = ((RubyString)iRubyObject).getByteList();
            System.arraycopy(byteList.bytes, byteList.begin, byArray, n, byteList.realSize);
            n3 = byteList.realSize;
        }
        return n3;
    }
}

