/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class ByteList
implements Comparable,
CharSequence,
Serializable {
    private static final long serialVersionUID = -1286166947275543731L;
    public static final byte[] NULL_ARRAY = new byte[0];
    public static final ByteList EMPTY_BYTELIST = new ByteList(0);
    public byte[] bytes;
    public int begin;
    public int realSize;
    int hash;
    boolean validHash = false;
    String stringValue;
    private static final int DEFAULT_SIZE = 4;
    private static final double FACTOR = 1.5;
    private static final char[] caseTable = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};

    public ByteList() {
        this(4);
    }

    public ByteList(int n) {
        this.bytes = new byte[n];
        this.realSize = 0;
    }

    public ByteList(byte[] byArray) {
        this(byArray, true);
    }

    public ByteList(byte[] byArray, boolean bl) {
        if (byArray == null) {
            throw new NullPointerException("Invalid argument: constructing with null array");
        }
        this.bytes = bl ? (byte[])byArray.clone() : byArray;
        this.realSize = byArray.length;
    }

    public ByteList(ByteList byteList) {
        this(byteList.bytes, byteList.begin, byteList.realSize);
    }

    public ByteList(ByteList byteList, boolean bl) {
        this(byteList.bytes, byteList.begin, byteList.realSize, false);
    }

    public ByteList(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, true);
    }

    public ByteList(byte[] byArray, int n, int n2, boolean bl) {
        if (byArray == null) {
            throw new NullPointerException("Invalid argument: constructing with null array");
        }
        if (bl || n != 0) {
            this.bytes = new byte[n2];
            System.arraycopy(byArray, n, this.bytes, 0, n2);
        } else {
            this.bytes = byArray;
        }
        this.realSize = n2;
    }

    public ByteList(ByteList byteList, int n, int n2) {
        this(byteList.bytes, byteList.begin + n, n2);
    }

    private ByteList(boolean bl) {
    }

    public void delete(int n, int n2) {
        this.realSize -= n2;
        System.arraycopy(this.bytes, n + n2, this.bytes, n, this.realSize);
    }

    public ByteList append(byte by) {
        this.grow(1);
        this.bytes[this.realSize++] = by;
        return this;
    }

    public ByteList append(int n) {
        this.append((byte)n);
        return this;
    }

    public ByteList append(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3;
        this.grow(n);
        for (n2 = 0; n2 < n; n2 += n3) {
            n3 = inputStream.read(this.bytes, this.begin + n2, n - n2);
            if (n3 != -1) continue;
            if (n2 != 0) break;
            throw new EOFException();
        }
        this.realSize += n2;
        return this;
    }

    public void append(ByteBuffer byteBuffer, int n) {
        this.grow(n);
        byteBuffer.get(this.bytes, this.realSize, n);
        this.realSize += n;
    }

    public Object clone() {
        return this.dup();
    }

    public ByteList dup() {
        ByteList byteList = this.dup(this.realSize);
        byteList.validHash = this.validHash;
        byteList.hash = this.hash;
        byteList.stringValue = this.stringValue;
        return byteList;
    }

    public ByteList dup(int n) {
        ByteList byteList = new ByteList(false);
        byteList.bytes = new byte[n];
        int n2 = Math.min(n, this.realSize);
        System.arraycopy(this.bytes, this.begin, byteList.bytes, 0, n2);
        byteList.realSize = n2;
        byteList.begin = 0;
        return byteList;
    }

    public void ensure(int n) {
        if (n >= this.bytes.length) {
            byte[] byArray = new byte[n + (n >>> 1)];
            System.arraycopy(this.bytes, this.begin, byArray, 0, this.realSize);
            this.bytes = byArray;
        }
    }

    public ByteList makeShared(int n, int n2) {
        ByteList byteList = new ByteList(false);
        byteList.bytes = this.bytes;
        byteList.realSize = n2;
        byteList.begin = this.begin + n;
        return byteList;
    }

    public void view(int n, int n2) {
        this.realSize = n2;
        this.begin += n;
    }

    public void unshare() {
        this.unshare(this.realSize);
    }

    public void unshare(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.bytes, this.begin, byArray, 0, this.realSize);
        this.bytes = byArray;
        this.begin = 0;
    }

    public void invalidate() {
        this.validHash = false;
        this.stringValue = null;
    }

    public void prepend(byte by) {
        this.grow(1);
        System.arraycopy(this.bytes, 0, this.bytes, 1, this.realSize);
        this.bytes[0] = by;
        ++this.realSize;
    }

    public void append(byte[] byArray) {
        this.grow(byArray.length);
        System.arraycopy(byArray, 0, this.bytes, this.realSize, byArray.length);
        this.realSize += byArray.length;
    }

    public void append(ByteList byteList) {
        this.append(byteList.bytes, byteList.begin, byteList.realSize);
    }

    public void append(ByteList byteList, int n, int n2) {
        this.append(byteList.bytes, byteList.begin + n, n2);
    }

    public void append(byte[] byArray, int n, int n2) {
        this.grow(n2);
        System.arraycopy(byArray, n, this.bytes, this.realSize, n2);
        this.realSize += n2;
    }

    public void realloc(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.bytes, 0, byArray, 0, this.realSize);
        this.bytes = byArray;
    }

    public int length() {
        return this.realSize;
    }

    public void length(int n) {
        this.grow(n - this.realSize);
        this.realSize = n;
    }

    public int get(int n) {
        if (n >= this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes[this.begin + n];
    }

    public void set(int n, int n2) {
        if (n >= this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        this.bytes[this.begin + n] = (byte)n2;
    }

    public void replace(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Invalid argument: replacing with null array");
        }
        this.bytes = byArray;
        this.realSize = byArray.length;
    }

    public void unsafeReplace(int n, int n2, ByteList byteList) {
        this.unsafeReplace(n, n2, byteList.bytes, byteList.begin, byteList.realSize);
    }

    public void unsafeReplace(int n, int n2, byte[] byArray) {
        this.unsafeReplace(n, n2, byArray, 0, byArray.length);
    }

    public void unsafeReplace(int n, int n2, byte[] byArray, int n3, int n4) {
        this.grow(n4 - n2);
        int n5 = this.realSize + n4 - n2;
        System.arraycopy(this.bytes, n + n2, this.bytes, n + n4, this.realSize - (n2 + n));
        System.arraycopy(byArray, n3, this.bytes, n, n4);
        this.realSize = n5;
    }

    public void replace(int n, int n2, ByteList byteList) {
        this.replace(n, n2, byteList.bytes, byteList.begin, byteList.realSize);
    }

    public void replace(int n, int n2, byte[] byArray) {
        this.replace(n, n2, byArray, 0, byArray.length);
    }

    public void replace(int n, int n2, byte[] byArray, int n3, int n4) {
        if (n2 - n > this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        this.unsafeReplace(n, n2, byArray, n3, n4);
    }

    public void insert(int n, int n2) {
        if (n >= this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        this.grow(1);
        System.arraycopy(this.bytes, n, this.bytes, n + 1, this.realSize - n);
        this.bytes[n] = (byte)n2;
        ++this.realSize;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        if (n > 255) {
            return -1;
        }
        byte by = (byte)(n & 0xFF);
        int n3 = this.begin + this.realSize;
        byte[] byArray = this.bytes;
        n2 += this.begin;
        while (n2 < n3 && byArray[n2] != by) {
            ++n2;
        }
        return n2 < n3 ? n2 - this.begin : -1;
    }

    public int indexOf(ByteList byteList) {
        return this.indexOf(byteList, 0);
    }

    public int indexOf(ByteList byteList, int n) {
        return ByteList.indexOf(this.bytes, this.begin, this.realSize, byteList.bytes, byteList.begin, byteList.realSize, n);
    }

    static int indexOf(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5) {
        if (n5 >= n2) {
            return n4 == 0 ? n2 : -1;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 == 0) {
            return n5;
        }
        byte by = byArray2[n3];
        int n6 = n + (n2 - n4);
        for (int i = n + n5; i <= n6; ++i) {
            if (byArray[i] != by) {
                while (++i <= n6 && byArray[i] != by) {
                }
            }
            if (i > n6) continue;
            int n7 = i + 1;
            int n8 = n7 + n4 - 1;
            int n9 = n3 + 1;
            while (n7 < n8 && byArray[n7] == byArray2[n9]) {
                ++n7;
                ++n9;
            }
            if (n7 != n8) continue;
            return i - n;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.realSize - 1);
    }

    public int lastIndexOf(int n, int n2) {
        if (n > 255) {
            return -1;
        }
        byte by = (byte)(n & 0xFF);
        int n3 = this.begin + this.realSize;
        byte[] byArray = this.bytes;
        n2 = (n2 += this.begin) >= n3 ? n3 : ++n2;
        while (--n2 >= this.begin && byArray[n2] != by) {
        }
        return n2 - this.begin;
    }

    public int lastIndexOf(ByteList byteList) {
        return this.lastIndexOf(byteList, this.realSize);
    }

    public int lastIndexOf(ByteList byteList, int n) {
        return ByteList.lastIndexOf(this.bytes, this.begin, this.realSize, byteList.bytes, byteList.begin, byteList.realSize, n);
    }

    static int lastIndexOf(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5) {
        int n6;
        int n7 = n2 - n4;
        if (n5 < 0) {
            return -1;
        }
        if (n5 > n7) {
            n5 = n7;
        }
        if (n4 == 0) {
            return n5;
        }
        int n8 = n3 + n4 - 1;
        byte by = byArray2[n8];
        int n9 = n + n4 - 1;
        int n10 = n9 + n5;
        block0: while (true) {
            if (n10 >= n9 && byArray[n10] != by) {
                --n10;
                continue;
            }
            if (n10 < n9) {
                return -1;
            }
            int n11 = n10 - 1;
            n6 = n11 - (n4 - 1);
            int n12 = n8 - 1;
            while (n11 > n6) {
                if (byArray[n11--] == byArray2[n12--]) continue;
                --n10;
                continue block0;
            }
            break;
        }
        return n6 - n + 1;
    }

    public boolean startsWith(ByteList byteList, int n) {
        byte[] byArray = this.bytes;
        int n2 = this.begin + n;
        byte[] byArray2 = byteList.bytes;
        int n3 = byteList.begin;
        int n4 = byteList.realSize;
        while (--n4 >= 0) {
            if (byArray[n2++] == byArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(ByteList byteList) {
        return this.startsWith(byteList, 0);
    }

    public boolean endsWith(ByteList byteList) {
        return this.startsWith(byteList, this.realSize - byteList.realSize);
    }

    public boolean equals(Object object) {
        if (object instanceof ByteList) {
            return this.equal((ByteList)object);
        }
        return false;
    }

    public boolean equal(ByteList byteList) {
        if (byteList == this) {
            return true;
        }
        if (this.validHash && byteList.validHash && this.hash != byteList.hash) {
            return false;
        }
        int n = this.realSize;
        if (n == byteList.realSize) {
            byte[] byArray = this.bytes;
            int n2 = -1;
            while (--n > n2 && byArray[this.begin + n] == byteList.bytes[byteList.begin + n] && ++n2 < n && byArray[this.begin + n2] == byteList.bytes[byteList.begin + n2]) {
            }
            return n2 >= n;
        }
        return false;
    }

    public boolean sample_equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ByteList) {
            ByteList byteList = (ByteList)object;
            int n = this.realSize;
            if (n == byteList.realSize) {
                byte[] byArray = this.bytes;
                int n2 = -1;
                int n3 = n + 1 & 0xFFFFFFFE;
                while ((n3 -= 2) >= 0 && byArray[this.begin + n3] == byteList.bytes[byteList.begin + n3] && (n2 += 2) < n && byArray[this.begin + n2] == byteList.bytes[byteList.begin + n2]) {
                }
                return n3 < 0 || n2 == n;
            }
        }
        return false;
    }

    public int compareTo(Object object) {
        return this.cmp((ByteList)object);
    }

    public int cmp(ByteList byteList) {
        if (byteList == this) {
            return 0;
        }
        int n = this.realSize;
        int n2 = Math.min(n, byteList.realSize);
        int n3 = -1;
        while (++n3 < n2 && this.bytes[this.begin + n3] == byteList.bytes[byteList.begin + n3]) {
        }
        if (n3 < n2) {
            return (this.bytes[this.begin + n3] & 0xFF) > (byteList.bytes[byteList.begin + n3] & 0xFF) ? 1 : -1;
        }
        return n == byteList.realSize ? 0 : (n == n2 ? -1 : 1);
    }

    public int caseInsensitiveCmp(ByteList byteList) {
        if (byteList == this) {
            return 0;
        }
        int n = this.realSize;
        int n2 = Math.min(n, byteList.realSize);
        int n3 = byteList.begin;
        byte[] byArray = byteList.bytes;
        int n4 = -1;
        while (++n4 < n2) {
            char c = caseTable[this.bytes[this.begin + n4] & 0xFF];
            char c2 = caseTable[byArray[n3 + n4] & 0xFF];
            if (c < c2) {
                return -1;
            }
            if (c <= c2) continue;
            return 1;
        }
        return n == byteList.realSize ? 0 : (n == n2 ? -1 : 1);
    }

    public byte[] unsafeBytes() {
        return this.bytes;
    }

    public byte[] bytes() {
        byte[] byArray = new byte[this.realSize];
        System.arraycopy(this.bytes, this.begin, byArray, 0, this.realSize);
        return byArray;
    }

    public int begin() {
        return this.begin;
    }

    private void grow(int n) {
        if (n < 0) {
            return;
        }
        int n2 = this.realSize + n;
        if (this.bytes.length < n2) {
            byte[] byArray = new byte[(int)((double)n2 * 1.5)];
            if (this.bytes.length != 0) {
                System.arraycopy(this.bytes, 0, byArray, 0, this.realSize);
            }
            this.bytes = byArray;
        }
    }

    public int hashCode() {
        if (this.validHash) {
            return this.hash;
        }
        int n = 0;
        int n2 = this.begin;
        int n3 = this.begin + this.realSize;
        while (n2 < n3) {
            n = (n << 16) + (n << 6) - n + this.bytes[n2++];
        }
        n += n >> 5;
        this.validHash = true;
        this.hash = n;
        return this.hash;
    }

    public String toString() {
        try {
            if (this.stringValue == null) {
                this.stringValue = new String(this.bytes, this.begin, this.realSize, "ISO-8859-1");
            }
            return this.stringValue;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("ISO-8859-1 encoding should never fail; report this at www.jruby.org");
        }
    }

    public static ByteList create(CharSequence charSequence) {
        return new ByteList(ByteList.plain(charSequence), false);
    }

    public static byte[] plain(CharSequence charSequence) {
        if (charSequence instanceof String) {
            try {
                return ((String)charSequence).getBytes("ISO8859-1");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        byte[] byArray = new byte[charSequence.length()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)charSequence.charAt(i);
        }
        return byArray;
    }

    public static byte[] plain(char[] cArray) {
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    public static char[] plain(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = (char)(byArray[n + i] & 0xFF);
        }
        return cArray;
    }

    public static char[] plain(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return cArray;
    }

    public char charAt(int n) {
        return (char)(this.bytes[this.begin + n] & 0xFF);
    }

    public CharSequence subSequence(int n, int n2) {
        return new ByteList(this, n, n2 - n);
    }

    public static int memcmp(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (byArray == byArray2) {
            return 0;
        }
        int n5 = Math.min(n2, n4);
        int n6 = -1;
        while (++n6 < n5 && byArray[n + n6] == byArray2[n3 + n6]) {
        }
        if (n6 < n5) {
            return (byArray[n + n6] & 0xFF) > (byArray2[n3 + n6] & 0xFF) ? 1 : -1;
        }
        return n2 == n4 ? 0 : (n2 == n5 ? -1 : 1);
    }

    public static int memcmp(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray == byArray2) {
            return 0;
        }
        int n4 = -1;
        while (++n4 < n3 && byArray[n + n4] == byArray2[n2 + n4]) {
        }
        if (n4 < n3) {
            return (byArray[n + n4] & 0xFF) > (byArray2[n2 + n4] & 0xFF) ? 1 : -1;
        }
        return 0;
    }
}

